/* Freebirth
 * Copyright (C) 1999 topher lafata <topher@topher.com>,
 *		      Jake Donham <jake@bitmechanic.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program (see COPYING); if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#define __ENV_H

#ifndef __SAMPLE_PRODUCER_H
  #include "sample_producer.h"
#endif



typedef struct env{
  sample *(* get_buffer)(struct env *); /* sample producer interface */
  void (*next_buffer)(struct env *);
  sample_producer **(*get_children)(struct env *);
  char **(*get_header)(struct env *);
  char **(*get_code)(struct env *);
  char **(*get_footer)(struct env *);
  void (* schedule)(sample_producer *sp, event *e, int offset);
  void (* trigger) (sample_producer *this);
  event **events;
  sample *buffer;
  sample_producer *sp;                  /* env affects this stream */
  sample_producer *unused; /* dummy to terminate list */

  int next;
  int    attack;
  int    release;
  int    current_index;
  int   start;
}env;


env *env_new(int attack, int release,sample_producer *sp);
sample *env_get_buffer(env *this);
void env_next_buffer(env *this);
void env_trigger(env *this);
void env_set_release(env *this,int release);
void env_set_attack(env *this,int attack);
void env_delete(env *this);



/*
  Local Variables:
  mode: font-lock
  End:
*/




