#!/usr/bin/env python3
# -*- coding: utf-8 -*-
#
# Copyright (C) 2021 Jerry Casiano
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.
#
# If not, see <http://www.gnu.org/licenses/gpl-3.0.txt>.

# See https://en.wikipedia.org/wiki/Regional_indicator_symbol for details

# Valid country codes
CC = [
    'AC',
    'AD',
    'AE',
    'AF',
    'AG',
    'AI',
    'AL',
    'AM',
    'AO',
    'AQ',
    'AR',
    'AS',
    'AT',
    'AU',
    'AW',
    'AX',
    'AZ',
    'BA',
    'BB',
    'BD',
    'BE',
    'BF',
    'BG',
    'BH',
    'BI',
    'BJ',
    'BL',
    'BM',
    'BN',
    'BO',
    'BQ',
    'BR',
    'BS',
    'BT',
    'BV',
    'BW',
    'BY',
    'BZ',
    'CA',
    'CC',
    'CD',
    'CF',
    'CG',
    'CH',
    'CI',
    'CK',
    'CL',
    'CM',
    'CN',
    'CO',
    'CP',
    'CR',
    'CU',
    'CV',
    'CW',
    'CX',
    'CY',
    'CZ',
    'DE',
    'DG',
    'DJ',
    'DK',
    'DM',
    'DO',
    'DZ',
    'EA',
    'EC',
    'EE',
    'EG',
    'EH',
    'ER',
    'ES',
    'ET',
    'EU',
    'FI',
    'FJ',
    'FK',
    'FM',
    'FO',
    'FR',
    'GA',
    'GB',
    'GD',
    'GE',
    'GF',
    'GG',
    'GH',
    'GI',
    'GL',
    'GM',
    'GN',
    'GP',
    'GQ',
    'GR',
    'GS',
    'GT',
    'GU',
    'GW',
    'GY',
    'HK',
    'HM',
    'HN',
    'HR',
    'HT',
    'HU',
    'IC',
    'ID',
    'IE',
    'IL',
    'IM',
    'IN',
    'IO',
    'IQ',
    'IR',
    'IS',
    'IT',
    'JE',
    'JM',
    'JO',
    'JP',
    'KE',
    'KG',
    'KH',
    'KI',
    'KM',
    'KN',
    'KP',
    'KR',
    'KW',
    'KY',
    'KZ',
    'LA',
    'LB',
    'LC',
    'LI',
    'LK',
    'LR',
    'LS',
    'LT',
    'LU',
    'LV',
    'LY',
    'MA',
    'MC',
    'MD',
    'ME',
    'MF',
    'MG',
    'MH',
    'MK',
    'ML',
    'MM',
    'MN',
    'MO',
    'MP',
    'MQ',
    'MR',
    'MS',
    'MT',
    'MU',
    'MV',
    'MW',
    'MX',
    'MY',
    'MZ',
    'NA',
    'NC',
    'NE',
    'NF',
    'NG',
    'NI',
    'NL',
    'NO',
    'NP',
    'NR',
    'NU',
    'NZ',
    'OM',
    'PA',
    'PE',
    'PF',
    'PG',
    'PH',
    'PK',
    'PL',
    'PM',
    'PN',
    'PR',
    'PS',
    'PT',
    'PW',
    'PY',
    'QA',
    'RE',
    'RO',
    'RS',
    'RU',
    'RW',
    'SA',
    'SB',
    'SC',
    'SD',
    'SE',
    'SG',
    'SH',
    'SI',
    'SJ',
    'SK',
    'SL',
    'SM',
    'SN',
    'SO',
    'SR',
    'SS',
    'ST',
    'SV',
    'SX',
    'SY',
    'SZ',
    'TA',
    'TC',
    'TD',
    'TF',
    'TG',
    'TH',
    'TJ',
    'TK',
    'TL',
    'TM',
    'TN',
    'TO',
    'TR',
    'TT',
    'TV',
    'TW',
    'TZ',
    'UA',
    'UG',
    'UM',
    'UN',
    'US',
    'UY',
    'UZ',
    'VA',
    'VC',
    'VE',
    'VG',
    'VI',
    'VN',
    'VU',
    'WF',
    'WS',
    'XK',
    'YE',
    'YT',
    'ZA',
    'ZM',
    'ZW'
]

# Regional Indicator Symbols
RIS = {
    'A' : 127462,
    'B' : 127463,
    'C' : 127464,
    'D' : 127465,
    'E' : 127466,
    'F' : 127467,
    'G' : 127468,
    'H' : 127469,
    'I' : 127470,
    'J' : 127471,
    'K' : 127472,
    'L' : 127473,
    'M' : 127474,
    'N' : 127475,
    'O' : 127476,
    'P' : 127477,
    'Q' : 127478,
    'R' : 127479,
    'S' : 127480,
    'T' : 127481,
    'U' : 127482,
    'V' : 127483,
    'W' : 127484,
    'X' : 127485,
    'Y' : 127486,
    'Z' : 127487
}

# Regions
FLAGS = {
    'AC' : 'Ascension Island',
    'AD' : 'Andorra',
    'AE' : 'United Arab Emirates',
    'AF' : 'Afghanistan',
    'AG' : 'Antigua & Barbuda',
    'AI' : 'Anguilla',
    'AL' : 'Albania',
    'AM' : 'Armenia',
    'AO' : 'Angola',
    'AQ' : 'Antarctica',
    'AR' : 'Argentina',
    'AS' : 'American Samoa',
    'AT' : 'Austria',
    'AU' : 'Australia',
    'AW' : 'Aruba',
    'AX' : 'Åland Islands',
    'AZ' : 'Azerbaijan',
    'BA' : 'Bosnia & Herzegovina',
    'BB' : 'Barbados',
    'BD' : 'Bangladesh',
    'BE' : 'Belgium',
    'BF' : 'Burkina Faso',
    'BG' : 'Bulgaria',
    'BH' : 'Bahrain',
    'BI' : 'Burundi',
    'BJ' : 'Benin',
    'BL' : 'St. Barthélemy',
    'BM' : 'Bermuda',
    'BN' : 'Brunei',
    'BO' : 'Bolivia',
    'BQ' : 'Caribbean Netherlands',
    'BR' : 'Brazil',
    'BS' : 'Bahamas',
    'BT' : 'Bhutan',
    'BV' : 'Bouvet Island',
    'BW' : 'Botswana',
    'BY' : 'Belarus',
    'BZ' : 'Belize',
    'CA' : 'Canada',
    'CC' : 'Cocos (Keeling) Islands',
    'CD' : 'Congo - Kinshasa',
    'CF' : 'Central African Republic',
    'CG' : 'Congo - Brazzaville',
    'CH' : 'Switzerland',
    'CI' : 'Côte d\'Ivoire',
    'CK' : 'Cook Islands',
    'CL' : 'Chile',
    'CM' : 'Cameroon',
    'CN' : 'China',
    'CO' : 'Colombia',
    'CP' : 'Clipperton Island',
    'CR' : 'Costa Rica',
    'CU' : 'Cuba',
    'CV' : 'Cape Verde',
    'CW' : 'Curaçao',
    'CX' : 'Christmas Island',
    'CY' : 'Cyprus',
    'CZ' : 'Czechia',
    'DE' : 'Germany',
    'DG' : 'Diego Garcia',
    'DJ' : 'Djibouti',
    'DK' : 'Denmark',
    'DM' : 'Dominica',
    'DO' : 'Dominican Republic',
    'DZ' : 'Algeria',
    'EA' : 'Ceuta & Melilla',
    'EC' : 'Ecuador',
    'EE' : 'Estonia',
    'EG' : 'Egypt',
    'EH' : 'Western Sahara',
    'ER' : 'Eritrea',
    'ES' : 'Spain',
    'ET' : 'Ethiopia',
    'EU' : 'European Union',
    'FI' : 'Finland',
    'FJ' : 'Fiji',
    'FK' : 'Falkland Islands',
    'FM' : 'Micronesia',
    'FO' : 'Faroe Islands',
    'FR' : 'France',
    'GA' : 'Gabon',
    'GB' : 'United Kingdom',
    'GD' : 'Grenada',
    'GE' : 'Georgia',
    'GF' : 'French Guiana',
    'GG' : 'Guernsey',
    'GH' : 'Ghana',
    'GI' : 'Gibraltar',
    'GL' : 'Greenland',
    'GM' : 'Gambia',
    'GN' : 'Guinea',
    'GP' : 'Guadeloupe',
    'GQ' : 'Equatorial Guinea',
    'GR' : 'Greece',
    'GS' : 'South Georgia & South Sandwich Islands',
    'GT' : 'Guatemala',
    'GU' : 'Guam',
    'GW' : 'Guinea-Bissau',
    'GY' : 'Guyana',
    'HK' : 'Hong Kong SAR China',
    'HM' : 'Heard & McDonald Islands',
    'HN' : 'Honduras',
    'HR' : 'Croatia',
    'HT' : 'Haiti',
    'HU' : 'Hungary',
    'IC' : 'Canary Islands',
    'ID' : 'Indonesia',
    'IE' : 'Ireland',
    'IL' : 'Israel',
    'IM' : 'Isle of Man',
    'IN' : 'India',
    'IO' : 'British Indian Ocean Territory',
    'IQ' : 'Iraq',
    'IR' : 'Iran',
    'IS' : 'Iceland',
    'IT' : 'Italy',
    'JE' : 'Jersey',
    'JM' : 'Jamaica',
    'JO' : 'Jordan',
    'JP' : 'Japan',
    'KE' : 'Kenya',
    'KG' : 'Kyrgyzstan',
    'KH' : 'Cambodia',
    'KI' : 'Kiribati',
    'KM' : 'Comoros',
    'KN' : 'St. Kitts & Nevis',
    'KP' : 'North Korea',
    'KR' : 'South Korea',
    'KW' : 'Kuwait',
    'KY' : 'Cayman Islands',
    'KZ' : 'Kazakhstan',
    'LA' : 'Laos',
    'LB' : 'Lebanon',
    'LC' : 'St. Lucia',
    'LI' : 'Liechtenstein',
    'LK' : 'Sri Lanka',
    'LR' : 'Liberia',
    'LS' : 'Lesotho',
    'LT' : 'Lithuania',
    'LU' : 'Luxembourg',
    'LV' : 'Latvia',
    'LY' : 'Libya',
    'MA' : 'Morocco',
    'MC' : 'Monaco',
    'MD' : 'Moldova',
    'ME' : 'Montenegro',
    'MF' : 'St. Martin',
    'MG' : 'Madagascar',
    'MH' : 'Marshall Islands',
    'MK' : 'North Macedonia',
    'ML' : 'Mali',
    'MM' : 'Myanmar (Burma)',
    'MN' : 'Mongolia',
    'MO' : 'Macao SAR China',
    'MP' : 'Northern Mariana Islands',
    'MQ' : 'Martinique',
    'MR' : 'Mauritania',
    'MS' : 'Montserrat',
    'MT' : 'Malta',
    'MU' : 'Mauritius',
    'MV' : 'Maldives',
    'MW' : 'Malawi',
    'MX' : 'Mexico',
    'MY' : 'Malaysia',
    'MZ' : 'Mozambique',
    'NA' : 'Namibia',
    'NC' : 'New Caledonia',
    'NE' : 'Niger',
    'NF' : 'Norfolk Island',
    'NG' : 'Nigeria',
    'NI' : 'Nicaragua',
    'NL' : 'Netherlands',
    'NO' : 'Norway',
    'NP' : 'Nepal',
    'NR' : 'Nauru',
    'NU' : 'Niue',
    'NZ' : 'New Zealand',
    'OM' : 'Oman',
    'PA' : 'Panama',
    'PE' : 'Peru',
    'PF' : 'French Polynesia',
    'PG' : 'Papua New Guinea',
    'PH' : 'Philippines',
    'PK' : 'Pakistan',
    'PL' : 'Poland',
    'PM' : 'St. Pierre & Miquelon',
    'PN' : 'Pitcairn Islands',
    'PR' : 'Puerto Rico',
    'PS' : 'Palestinian Territories',
    'PT' : 'Portugal',
    'PW' : 'Palau',
    'PY' : 'Paraguay',
    'QA' : 'Qatar',
    'RE' : 'Réunion',
    'RO' : 'Romania',
    'RS' : 'Serbia',
    'RU' : 'Russia',
    'RW' : 'Rwanda',
    'SA' : 'Saudi Arabia',
    'SB' : 'Solomon Islands',
    'SC' : 'Seychelles',
    'SD' : 'Sudan',
    'SE' : 'Sweden',
    'SG' : 'Singapore',
    'SH' : 'St. Helena',
    'SI' : 'Slovenia',
    'SJ' : 'Svalbard & Jan Mayen',
    'SK' : 'Slovakia',
    'SL' : 'Sierra Leone',
    'SM' : 'San Marino',
    'SN' : 'Senegal',
    'SO' : 'Somalia',
    'SR' : 'Suriname',
    'SS' : 'South Sudan',
    'ST' : 'São Tomé & Príncipe',
    'SV' : 'El Salvador',
    'SX' : 'Sint Maarten',
    'SY' : 'Syria',
    'SZ' : 'Eswatini',
    'TA' : 'Tristan da Cunha',
    'TC' : 'Turks & Caicos Islands',
    'TD' : 'Chad',
    'TF' : 'French Southern Territories',
    'TG' : 'Togo',
    'TH' : 'Thailand',
    'TJ' : 'Tajikistan',
    'TK' : 'Tokelau',
    'TL' : 'Timor-Leste',
    'TM' : 'Turkmenistan',
    'TN' : 'Tunisia',
    'TO' : 'Tonga',
    'TR' : 'Turkey',
    'TT' : 'Trinidad & Tobago',
    'TV' : 'Tuvalu',
    'TW' : 'Taiwan',
    'TZ' : 'Tanzania',
    'UA' : 'Ukraine',
    'UG' : 'Uganda',
    'UM' : 'U.S. Outlying Islands',
    'UN' : 'United Nations',
    'US' : 'United States',
    'UY' : 'Uruguay',
    'UZ' : 'Uzbekistan',
    'VA' : 'Vatican City',
    'VC' : 'St. Vincent & Grenadines',
    'VE' : 'Venezuela',
    'VG' : 'British Virgin Islands',
    'VI' : 'U.S. Virgin Islands',
    'VN' : 'Vietnam',
    'VU' : 'Vanuatu',
    'WF' : 'Wallis & Futuna',
    'WS' : 'Samoa',
    'XK' : 'Kosovo',
    'YE' : 'Yemen',
    'YT' : 'Mayotte',
    'ZA' : 'South Africa',
    'ZM' : 'Zambia',
    'ZW' : 'Zimbabwe'
}

for i in CC:
    print('    {{ {0}, {1}, "{2} ‐ {3}" }},'.format(RIS[i[0]], RIS[i[1]], i, FLAGS[i]))
