;;;;;;;;;;;;;;;;;;;;;;;;;;;;;<--IFD-->;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                                                                        ;;
;;                Istituto di Fonetica e Dialettologia                    ;;
;;                 Consiglio Nazionale delle Ricerche                     ;;
;;                            Padova Italy                                ;;
;;                        Copyright (c) 2000                              ;;
;;                                                                        ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;<--IFD-->;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;									  ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;<--IRST-->;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                        						  ;;
;;           Centro per la ricerca scientifica e tecnologica              ;;
;;         	             Povo (TN) - Italy				  ;;
;;			    Copyright (c) 2000                            ;;
;;									  ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;<--IRST-->;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; 
;;; Definizione del lessico per l'italiano 
;;; e alcune regole di pre-tokenizzazione.
;;; 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Pre-Lessico per mappare tutti i caratteri in quelli giusti; 
;;; in pi tratta le parole con l'apostrofo, unendo la sillabazione ma mantenendo la trascrizione delle singole parole.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(lex.create "otherlex")
(lex.set.phoneset "italian")
(lex.set.lts.method "pre_lex_function")

(define (pre_lex_function word feats)
"(pre_lex_function word feats): Funzione di Pre-lessico per mappare tutti i caratteri in quelli giusti, in pi tratta le parole con l'apostrofo, unendo la sillabazione ma mantenendo la trascrizione delle singole parole."
(if (string-matches word ".* -T.*")
   (let ()
	(set! true_word_str (string-before word " -T")) 
	(set! trasc_word_str (string-after word " -T ")) 
	(set! tl (read-from-string (string-append "(" trasc_word_str ")"))) ;aggiunge una parentesi
	(set! entry (list true_word_str 'N tl))
	;(print entry)
	;(item.set_name w true_word_str)
	;(item.set_feat w "TRA_NUM" trasc_word_str)
	)
   (let ((me (lex.select "italian")))
      ;(format t "intercept function %l %l\n" word feats)
      (set! down_word (apply string-append (lts.apply word 'italian_downcase)))
      ;(format t "intercept function %l %l\n" down_word feats)
      
      (if (string-matches down_word ".+'.+") ;caso parole con apostrofi
      	(let ()
      	;(print"APOSTROFO")
      	(set! e1 (lex.lookup (string-append (string-before down_word "'") "'")) feats)
      	(set! e2 (lex.lookup (string-after down_word "'")) feats)
      	(set! pos2 (car (cdr e2)))
      	(set! T (append (car (cdr (cdr e1))) (car (cdr (cdr e2)))))
      	(set! ps 1) ;flag per la prima sillaba
      	(while T
      		(set! s1 (car (car T)))
      		(set! Ok 0)
      		(while s1
      			(set! ph (car s1))
      			(if (string-equal (phone_feature ph 'vc) "+")
      				(set! Ok 1))
			(set! s1 (cdr s1)))	
		(if (and (eq? Ok 0) (cdr T)) 
		  (let ()
			(set! sillaba_tra (append (car (car T)) (car (car (cdr T))))) 
			(set! stress (car (cdr (car (cdr T)))))
			(set! sillaba (list sillaba_tra stress))
			(if (eq? ps 1)
			(set! nT  (append (list sillaba)))
			(set! nT (append  nT (list sillaba))))
			(set! T (cdr T)))
		  (let ()
			(if (eq? ps 1)
			(set! nT  (list (car T)))
			(set! nT (append  nT (list (car T)))))))
		(set! ps 0)
		(set! T (cdr T)))
		(set! ne (list down_word pos2 nT))
		
      	(set! entry ne))
	
	;;no apostrofo case
	(set! entry (lex.lookup down_word feats)))

	;(let ()
	;IRST lookup
	;(set! entry (irst_lookup down_word))
	;Old lookup 
;	(if (not entry) 
	 ;   (set! entry (lex.lookup down_word feats)))))

     
      
;(print entry)
      (lex.select me)
      ))
      
      entry )

;;;;;;;;;;;;;;;;;;;;;DA GUARDARE SE  FATTIBILE O COSA  MEGLIO .cosa devo ancora fare qui?
(setq italian_pos_map
      '(
	(( V-P3_IP vb vbn vbz vbp vbg ) V)
	(( A-MS nn nnp nns nnps fw sym ls ) A)
	(( A ) A-MS)
	(( punc fpunc ) punc)
	(( in ) in)
	(( jj jjr jjs 1 2 ) j)
	(( prp ) prp)
	(( D-NNFab ) D-NN)
	(( rb rp rbr rbs ) r)
	(( cc ) cc)
	(( of ) of)
	(( to ) to)
	(( cd ) cd)
	(( md ) md)
	(( pos ) pos)
	(( wdt ) wdt)
	(( wp ) wp)
	(( wrb ) wrb)
	(( ex ) ex)
	(( uh ) uh)
	(( pdt ) pdt)
	))



;;; Lexicon
(lex.create "italian")
(lex.set.phoneset "italian")
(lex.set.pos.map italian_pos_map)
(defvar ifdlexdir (path-append lexdir "ifd"))
(lex.set.compile.file (path-append ifdlexdir "lex.out"))
(lex.set.lts.method "italian_lts") 

;(lex.set.lts.ruleset "italian")

;PER ANNULARE I POSTLEX:
(set! postlex_rules_hooks nil)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; LESSICO ADDENDA (pochi termini)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; convenzione 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; VOCALI ACCENTATE codifica ANSI
;;

(lex.add.entry '("" nn (((a1 ) 1))))
(lex.add.entry '("" nn (((a1 ) 1))))
(lex.add.entry '("" nn (((e1 ) 1))))
(lex.add.entry '("" nn (((E1 ) 1))))
(lex.add.entry '("" nn (((i1 ) 1))))
(lex.add.entry '("" nn (((i1 ) 1))))
(lex.add.entry '("" nn (((o1 ) 1))))
(lex.add.entry '("" nn (((O1 ) 1))))
(lex.add.entry '("" nn (((u1 ) 1))))
(lex.add.entry '("" nn (((u1 ) 1))))

;; VOCALI ACCENTATE codifica OEM (per l'imput da tastiera)
;;the OEM character set (usually DOS generated text files) to the ANSI (Windows).
;; NON dovrebbero servire perch viene innanzi tutto fatta 
;; la mappatura dei caratteri con italian downcase quindi sono gi
;; in codifica ANSI  

;(lex.add.entry '("" nn (((a1 ) 1))))
;(lex.add.entry '("" nn (((E1 ) 1))))
;(lex.add.entry '("" nn (((e1 ) 1))))
;(lex.add.entry '("" nn (((O1 ) 1))))
;(lex.add.entry '("" nn (((u1 ) 1))))
;(lex.add.entry '("" nn (((i1 ) 1))))
;;
(lex.add.entry '("a" nn (((a1) 1))))
(lex.add.entry '("b" nn (((b i1) 1))))
(lex.add.entry '("c" nn (((tS i1) 1))))
(lex.add.entry '("d" nn (((d i1) 1))))
(lex.add.entry '("e" nn (((e1) 1))))     ;;; ATT: penso sia meglio lasciare la e1 (cos trascrive giusta la congiunz.)
(lex.add.entry '("f" nn (((E1 f) 1) ((f e) 0))))
(lex.add.entry '("g" nn (((dZ i1) 0))))
(lex.add.entry '("h" nn (((a1 k) 1) ((k a) 0))))
(lex.add.entry '("i" nn (((i1) 1))))
(lex.add.entry '("j" nn (((i) 0) ((l u1 n) 1) ((g a) 0))))
(lex.add.entry '("k" nn (((k a1 p) 1) ((p a) 0))))
(lex.add.entry '("l" nn (((E1 l) 1) ((l e) 0))))
(lex.add.entry '("m" nn (((E1 m) 1) ((m e) 0))))
(lex.add.entry '("n" nn (((E1 n) 1) ((n e) 0))))
(lex.add.entry '("o" nn (((o1) 1))))     ;;; ATT: penso sia meglio lasciare la o1 (cos trascrive giusta la congiunz.) 
(lex.add.entry '("p" nn (((p i1) 1))))
(lex.add.entry '("q" nn (((k u1) 1))))
(lex.add.entry '("r" nn (((E1 r) 1) ((r e) 0))))
(lex.add.entry '("s" nn (((E1 s) 1) ((s e) 0))))
(lex.add.entry '("t" nn (((t i1) 0))))
(lex.add.entry '("u" nn (((u1) 1))))
(lex.add.entry '("v" nn (((v u1) 0))))
(lex.add.entry '("w" nn (((v u1) 0) ((d o1 p) 1) ((p i a) 0))))   ;; o vu doppia?
(lex.add.entry '("x" nn (((i1) 1) ((k s) 0))))
(lex.add.entry '("y" nn (((i1) 1) ((p s i) 0) ((l o n) 0))))   ;; penso sia piu' usato
(lex.add.entry '("z" nn (((dz e1) 1) ((t a) 0))))
 
;;;ALTRI ATOMI 
(lex.add.entry '("c'" nn (((tS ) 0))));;per trattare il caso di c' c'era etc.
(lex.add.entry '("diec'" N (((d j E1) 1) ((tS) 0))))

;;ALTRI
(lex.add.entry '("si" B (((s i1) 1))))
(lex.add.entry '("no" B (((n O1) 1))))
(lex.add.entry '("posta" S (((p O1) 1) ((s t a) 0))))
(lex.add.entry '("celsius" S (((tS E l) 0) ((s j u1 s) 1))))
(lex.add.entry '("uomini" nil (((w o1) 1) ((m i) 0) ((n i) 0))))
(lex.add.entry '("riempite" nil (((r j E m) 0) ((p i1) 1) ((t e) 0))))
(lex.add.entry '("conoscerla" nil (((k o1) 1) ((n o S) 0) ((S e r) 0) ((l a) 0))))
(lex.add.entry '("tesser" CGN (((t e s) 0) ((s E1 r) 1))))
(lex.add.entry '("televideo" S (((t e) 0) ((l e) 0) ((v i1) 1) ((d e) 0) ((o) 0))))
;per sillabe Carini_soleml
(lex.add.entry '("dai" B (((d a1 i) 1))))
(lex.add.entry '("ventidue" N (((v e n) 0) ((t i) 0) ((d u1 e) 1))))
(lex.add.entry '("pi" A (((p j u1) 1))))
(lex.add.entry '("sontuosa" A-FS (((s o n) 0) ((t w o1) 1) ((s a) 0))))
(lex.add.entry '("viaggio" S-MS (((v j a1 dZ) 1) ((dZ o) 0))))
(lex.add.entry '("dormiamo" V-P1_IP (((d o r) 0) ((m j a1) 1) ((m o) 0))))

;;MPIRO LEXICON

(lex.add.entry '("1" N (((u1) 1) ((n o) 0))))
(lex.add.entry '("1.94" N (((u1) 1) ((n o) 0) ((v i1 r) 1) ((g o) 0) ((l a) 0) ((n o) 0) ((v a n) 0) ((t a) 0) ((k w a1 t) 1) ((t r o) 0))))
(lex.add.entry '("100" N (((tS E1 n) 1) ((t o) 0))))
(lex.add.entry '("106" N (((tS E n) 0) ((t o) 0) ((s E1) 1) ((i) 0))))
(lex.add.entry '("107" N (((tS E n) 0) ((t o) 0) ((s E1 t) 1) ((t e) 0))))
(lex.add.entry '("108" N (((tS E n) 0) ((t o) 0) ((O1 t) 1) ((t o) 0))))
(lex.add.entry '("12" N (((d o1) 1) ((d i) 0) ((tS i) 0))))
(lex.add.entry '("17" N (((d i) 0) ((tS a s) 0) ((s E1 t) 1) ((t e) 0))))
(lex.add.entry '("177" N (((tS E n) 0) ((t o) 0) ((s e t) 0) ((t a n) 0) ((t a) 0) ((s E1 t) 1) ((t e) 0))))
(lex.add.entry '("189" N (((tS E n) 0) ((t o) 0) ((o t) 0) ((t a n) 0) ((t a) 0) ((n O1) 1) ((v e) 0))))
(lex.add.entry '("192" N (((tS E n) 0) ((t o) 0) ((n o) 0) ((v a n) 0) ((t a) 0) ((d u1) 1) ((e) 0))))
(lex.add.entry '("1937" N (((m i l) 0) ((l e) 0) ((n O1) 1) ((v e) 0) ((tS E n) 0) ((t o) 0) ((t r e n) 0) ((t a) 0) ((s E1 t) 1) ((t e) 0))))
(lex.add.entry '("1975" N (((m i l) 0) ((l e) 0) ((n O1) 1) ((v e) 0) ((tS E n) 0) ((t o) 0) ((s e t) 0) ((t a n) 0) ((t a) 0) ((tS i1 ng) 1) ((k w e) 0))))
(lex.add.entry '("1978" N (((m i l) 0) ((l e) 0) ((n O1) 1) ((v e) 0) ((tS E n) 0) ((t o) 0) ((s e t) 0) ((t a n) 0) ((t O1 t) 1) ((t o) 0))))
(lex.add.entry '("1996" N (((m i l) 0) ((l e) 0) ((n O1) 1) ((v e) 0) ((tS E n) 0) ((t o) 0) ((n o) 0) ((v a n) 0) ((t a) 0) ((s E1) 1) ((i) 0))))
(lex.add.entry '("1997" N (((m i l) 0) ((l e) 0) ((n O1) 1) ((v e) 0) ((tS E n) 0) ((t o) 0) ((n o) 0) ((v a n) 0) ((t a) 0) ((s E1 t) 1) ((t e) 0))))
(lex.add.entry '("2" N (((d u1) 1) ((e) 0))))
(lex.add.entry '("2.12" N (((d u1) 1) ((e) 0) ((v i1 r) 1) ((g o) 0) ((l a) 0) ((d o1) 1) ((d i) 0) ((tS i) 0))))
(lex.add.entry '("200" N (((d u1) 1) ((e) 0) ((tS E1 n) 1) ((t o) 0))))
(lex.add.entry '("220" N (((d u1) 1) ((e) 0) ((tS E n) 0) ((t o) 0) ((v e1 n) 1) ((t i) 0))))
(lex.add.entry '("230" N (((d u1) 1) ((e) 0) ((tS E n) 0) ((t o) 0) ((t r e1 n) 1) ((t a) 0))))
(lex.add.entry '("3" N (((t r E1) 1))))
(lex.add.entry '("31" N (((t r e n) 0) ((t u1) 1) ((n o) 0))))
(lex.add.entry '("312" N (((t r E) 0) ((tS E n) 0) ((t o) 0) ((d o1) 1) ((d i) 0) ((tS i) 0))))
(lex.add.entry '("313" N (((t r E) 0) ((tS E n) 0) ((t o) 0) ((t r e1) 1) ((d i) 0) ((tS i) 0))))
(lex.add.entry '("320" N (((t r E) 0) ((tS E n) 0) ((t o) 0) ((v e1 n) 1) ((t i) 0))))
(lex.add.entry '("323" N (((t r E) 0) ((tS E1 n) 0) ((t o) 0) ((v E n) 0) ((t i) 0) ((t r e1) 1))))
(lex.add.entry '("330" N (((t r E) 0) ((tS E n) 0) ((t o) 0) ((t r e1 n) 1) ((t a) 0))))
(lex.add.entry '("336" N (((t r E) 0) ((tS E n) 0) ((t o) 0) ((t r e n) 0) ((t a) 0) ((s E1) 1) ((i) 0))))
(lex.add.entry '("34" N (((t r e n) 0) ((t a) 0) ((k w a1 t) 1) ((t r o) 0))))
(lex.add.entry '("397" N (((t r E) 0) ((tS E n) 0) ((t o) 0) ((n o) 0) ((v a n) 0) ((t a) 0) ((s E1 t) 1) ((t e) 0))))
(lex.add.entry '("398" N (((t r E) 0) ((tS E n) 0) ((t o) 0) ((n o) 0) ((v a n) 0) ((t O1 t) 1) ((t o) 0))))
(lex.add.entry '("4" N (((k w a1 t) 1) ((t r o) 0))))
(lex.add.entry '("410" N (((k w a1 t) 1) ((t r o) 0) ((tS E n) 0) ((t o) 0) ((d j E1) 1) ((tS i) 0))))
(lex.add.entry '("420" N (((k w a1 t) 1) ((t r o) 0) ((tS E n) 0) ((t o) 0) ((v e1 n) 1) ((t i) 0))))
(lex.add.entry '("440" N (((k w a1 t) 1) ((t r o) 0) ((tS E n) 0) ((t o) 0) ((k w a) 0) ((r a1 n) 1) ((t a) 0))))
(lex.add.entry '("460" N (((k w a1 t) 1) ((t r o) 0) ((tS E n) 0) ((t o) 0) ((s e s) 0) ((s a1 n) 1) ((t a) 0))))
(lex.add.entry '("470" N (((k w a1 t) 1) ((t r o) 0) ((tS E n) 0) ((t o) 0) ((s e t) 0) ((t a1 n) 1) ((t a) 0))))
(lex.add.entry '("475" N (((k w a1 t) 1) ((t r o) 0) ((tS E n) 0) ((t o) 0) ((s e t) 0) ((t a n) 0) ((t a) 0) ((tS i1 ng) 1) ((k w e) 0))))
(lex.add.entry '("480" N (((k w a t) 0) ((t r o) 0) ((tS E n) 0) ((t o) 0) ((o t) 0) ((t a1 n) 1) ((t a) 0))))
(lex.add.entry '("490" N (((k w a t) 0) ((t r o) 0) ((tS E n) 0) ((t o) 0) ((n o) 0) ((v a1 n) 1) ((t a) 0))))
(lex.add.entry '("5" N (((tS i1 ng) 1) ((k w e) 0))))
(lex.add.entry '("500" N (((tS i ng) 0) ((k w e) 0) ((tS E n) 0) ((t o) 0))))
(lex.add.entry '("510" N (((tS i ng) 0) ((k w e) 0) ((tS E n) 0) ((t o) 0) ((d j E1) 1) ((tS i) 0))))
(lex.add.entry '("520" N (((tS i ng) 0) ((k w e) 0) ((tS E n) 0) ((t o) 0) ((v e1 n) 1) ((t i) 0))))
(lex.add.entry '("530" N (((tS i ng) 0) ((k w e) 0) ((tS E n) 0) ((t o) 0) ((t r e1 n) 1) ((t a) 0))))
(lex.add.entry '("550" N (((tS i ng) 0) ((k w e) 0) ((tS E n) 0) ((t o) 0) ((tS i ng) 0) ((k w a1 n) 1) ((t a) 0))))
(lex.add.entry '("7" N (((s E1 t) 1) ((t e) 0))))
(lex.add.entry '("700" N (((s E t) 0) ((t e) 0) ((tS E1 n) 1) ((t o) 0))))
(lex.add.entry '("750" N (((s E t) 0) ((t e) 0) ((tS E n) 0) ((t o) 0) ((tS i ng) 0) ((k w a1 n) 1) ((t a) 0))))
(lex.add.entry '("9" N (((n O1) 1) ((v e) 0))))
(lex.add.entry '("96" N (((n o) 0) ((v a n) 0) ((t a) 0) ((s E1) 1) ((i) 0))))
(lex.add.entry '("a.C." ACR (((a) 0) ((v a1 n) 1) ((t i) 0) ((k r i1) 1) ((s t o) 0))))
(lex.add.entry '("actium" EN (((a1 k t j u m) 1))))
(lex.add.entry '("aetolia" IT (((e) 0) ((t O1) 1) ((l j a) 0))))
(lex.add.entry '("aetoliani" EN (((e) 0) ((t o) 0) ((l j a1) 1) ((n i) 0))))
(lex.add.entry '("agora" S (((a) 0) ((g O1) 1) ((r a) 0))))
(lex.add.entry '("all" nil (((o1 l) 1) ((l) 0))))
(lex.add.entry '("amasis" GR (((a) 0) ((m a1) 1) ((s i) 0) ((s) 0))))
(lex.add.entry '("american" EN (((a) 0) ((m E1) 1) ((r i) 0) ((k a n) 0))))
(lex.add.entry '("ampipholis" GR (((a m) 0) ((p i1) 1) ((p o) 0) ((l i) 0) ((s) 0))))
(lex.add.entry '("anavyssos" GR (((a) 0) ((n a) 0) ((v i s) 0) ((s o) 0) ((s) 0))))
(lex.add.entry '("and" EN (((E1 n) 1) ((d) 0))))
(lex.add.entry '("archaeologica" nil (((a r) 0) ((k a) 0) ((e) 0) ((o) 0) ((l o) 0) ((dZ i1) 1) ((k a) 0))))
(lex.add.entry '("archaia" GR (((a r) 0) ((k a) 0) ((j a) 0))))
(lex.add.entry '("archaic" EN (((a r) 0) ((k a) 0) ((i k) 0))))
(lex.add.entry '("archer" EN (((a1 r) 1) ((tS e r) 0))))
(lex.add.entry '("ares" GR (((a1) 1) ((r e) 0) ((s) 0))))
(lex.add.entry '("argos" GR (((a r) 0) ((g O1) 1) ((s) 0))))
(lex.add.entry '("argyra" GR (((a r) 0) ((g i1) 1) ((r a) 0))))
(lex.add.entry '("aristion" GR (((a) 0) ((r i1) 1) ((s t j O n) 0))))
(lex.add.entry '("aristocles" GR (((a) 0) ((r i) 0) ((s t o1) 1) ((k l E) 0) ((s) 0))))
(lex.add.entry '("art" EN (((a1 r) 1) ((t) 0))))
(lex.add.entry '("artemis" GR (((a r) 0) ((t e1) 1) ((m i) 0) ((s) 0))))
(lex.add.entry '("aryballoi" GR (((a) 0) ((r i) 0) ((b a l) 0) ((l O1) 1) ((i) 0))))
(lex.add.entry '("aryballos" GR (((a) 0) ((r i) 0) ((b a l) 0) ((l O1) 1) ((s) 0))))
(lex.add.entry '("at" EN (((e t) 0))))
(lex.add.entry '("atene" IT (((a) 0) ((t e1) 1) ((n e) 0))))
(lex.add.entry '("athenian" EN (((a) 0) ((t e) 0) ((n j a n) 0))))
(lex.add.entry '("athens" EN (((a) 0) ((t e n) 0) ((s) 0))))
(lex.add.entry '("athinon" EN (((a) 0) ((t i) 0) ((n o n) 0))))
(lex.add.entry '("attalus" GR (((a t) 0) ((t a1) 1) ((l u) 0) ((s) 0))))
(lex.add.entry '("boardman" EN (((b o r) 0) ((d m e n) 0))))
(lex.add.entry '("cantaro" GR (((k a n) 0) ((t a1) 1) ((r o) 0))))
(lex.add.entry '("chalkina" GR (((k a1 l) 1) ((k i1) 0) ((n a) 0))))
(lex.add.entry '("classical" EN (((k l a s) 0) ((s i) 0) ((k a l) 0))))
(lex.add.entry '("cleofrade" IT (((k l e) 0) ((o) 0) ((f r a1) 1) ((d e) 0))))
(lex.add.entry '("coins" EN (((k o) 0) ((i1 n) 1) ((s) 0))))
(lex.add.entry '("copyright" EN (((k O1) 1) ((p i) 0) ((r a i g t) 0))))
(lex.add.entry '("corinto" IT (((k o) 0) ((r i1 n) 1) ((t o) 0))))
(lex.add.entry '("cre" GR (((k r E1) 1))))
(lex.add.entry '("d.C." ACR (((d o) 0) ((p o) 0) ((k r i1) 1) ((s t o) 0))))
(lex.add.entry '("decir" GR (((d e) 0) ((s i1 r) 1))))
(lex.add.entry '("delo" IT (((d E1) 1) ((l o) 0))))
(lex.add.entry '("delos" GR (((d E1) 1) ((l O) 0) ((s) 0))))
(lex.add.entry '("deme" GR (((d E1) 1) ((m e) 0))))
(lex.add.entry '("diadumeno" IT (((d j a) 0) ((d u) 0) ((m e1) 1) ((n o) 0))))
(lex.add.entry '("dinos" GR (((d i1) 1) ((n O) 0) ((s) 0))))
(lex.add.entry '("dioniso" IT (((d j o) 0) ((n i1) 1) ((z o) 0))))
(lex.add.entry '("doriforo" IT (((d o) 0) ((r i1) 1) ((f O) 0) ((r o) 0))))
(lex.add.entry '("du" EN (((d u1) 1))))
(lex.add.entry '("ekdotiki" GR (((e k d o) 0) ((t i) 0) ((k i) 0))))
(lex.add.entry '("elliniki" GR (((e l) 0) ((l i) 0) ((n i) 0) ((k i) 0))))
(lex.add.entry '("eucharides" GR (((e) 0) ((u) 0) ((k a) 0) ((r i) 0) ((d E1) 1) ((s) 0))))
(lex.add.entry '("eukarpos" GR (((e) 0) ((u) 0) ((k a1 r) 1) ((p O) 0) ((s) 0))))
(lex.add.entry '("eutimide" IT (((e) 0) ((u) 0) ((t i) 0) ((m i1) 1) ((d e) 0))))
(lex.add.entry '("fidia" IT (((f i1) 1) ((d j a) 0))))
(lex.add.entry '("florina" IT (((f l o) 0) ((r i1) 1) ((n a) 0))))
(lex.add.entry '("fur" GR (((f u1 r) 1))))
(lex.add.entry '("galiziani" IT (((g a) 0) ((l i ts) 0) ((ts j a1) 1) ((n i) 0))))
(lex.add.entry '("getty" EN (((g E1 t) 1) ((t i) 0))))
(lex.add.entry '("gewerbe" EN (((g e) 0) ((w E1 r) 1) ((b e) 0))))
(lex.add.entry '("greek" EN (((g r i k) 0))))
(lex.add.entry '("hadra" GR (((a) 0) ((d r a) 0))))
(lex.add.entry '("hamburg" EN (((a1 m) 1) ((b o r) 0) )))
(lex.add.entry '("hoplite" EN (((O) 0) ((p l i1) 1) ((t e) 0))))
(lex.add.entry '("hudson" EN (((j u d) 0) ((s o n) 0))))
(lex.add.entry '("idria" IT (((i1) 1) ((d r i) 0) ((a) 0))))
(lex.add.entry '("idrie" IT (((i) 0) ((d r i1) 1) ((e) 0))))
(lex.add.entry '("ii" ACR (((s e) 0) ((k o1 n) 1) ((d o) 0))))
(lex.add.entry '("iliou" EN (((i) 0) ((l j o1) 1) ((u) 0))))
(lex.add.entry '("ioannina" IT (((i) 0) ((o) 0) ((a n) 0) ((n i1) 1) ((n a) 0))))
(lex.add.entry '("ipeiros" IT  (((i) 0) ((p E1 i) 1) ((r O) 0) ((s) 0))))
(lex.add.entry '("ismenion" IT (((i) 0) ((z m e1) 1) ((n j O n) 0))))
(lex.add.entry '("j" EN (((dZ e) 0) ((i) 0))))
(lex.add.entry '("jersey" EN (((dZ E1 r) 1) ((s e) 0) ((i) 0))))
(lex.add.entry '("kai" GR (((k a1) 1) ((i) 0))))
(lex.add.entry '("kalpis" GR (((k a l) 0) ((p i) 0) ((s) 0))))
(lex.add.entry '("kantharos" GR (((k a n) 0) ((t a1) 1) ((r O) 0) ((s) 0))))
(lex.add.entry '("kavala" GR (((k a) 0) ((v a1) 1) ((l a) 0))))
(lex.add.entry '("klismos" GR (((k l i1) 1) ((z m O) 0) ((s) 0))))
(lex.add.entry '("komastes" GR (((k o) 0) ((m a) 0) ((s t E1) 1) ((s) 0))))
(lex.add.entry '("kouroi" GR (((k o) 0) ((u) 0) ((r o1) 1) ((i) 0))))
(lex.add.entry '("kouros" GR (((k o) 0) ((u) 0) ((r o1) 1) ((s) 0))))
(lex.add.entry '("kourosevolvette" GR (((k o) 0) ((u) 0) ((r o) 0) ((z e) 0) ((v o l) 0) ((v e1 t) 1) ((t e) 0))))
(lex.add.entry '("kroissos" GR (((k r o) 0) ((i s) 0) ((s o) 0) ((s) 0))))
(lex.add.entry '("kunst" GR (((k u1 n) 1) ((s t) 0))))
(lex.add.entry '("kylix" GR (((k i) 0) ((l i k) 0) ((s) 0))))
(lex.add.entry '("lekithos" GR (((l e) 0) ((k i) 0) ((t O1) 1) ((s) 0))))
(lex.add.entry '("lekythoi" GR (((l e) 0) ((k i) 0) ((t O1) 1) ((i) 0))))
(lex.add.entry '("lekythos" GRl (((l e) 0) ((k i) 0) ((t O1) 1) ((s) 0))))
(lex.add.entry '("leucius" GR (((l e1 u) 1) ((tS u) 0) ((s) 0))))
(lex.add.entry '("mantiklos" GR (((m a n) 0) ((t i1) 1) ((k l O) 0) ((s) 0))))
(lex.add.entry '("martin" EN (((m a1 r) 1) ((t i n) 0))))
(lex.add.entry '("meidiama" GR (((m e) 0) ((i) 0) ((d j a1) 1) ((m a) 0))))
(lex.add.entry '("meidias" GR (((m e) 0) ((i1) 1) ((d j a) 0) ((s) 0))))
(lex.add.entry '("meilesios" GR (((m e) 0) ((i) 0) ((l e) 0) ((z j O1) 1) ((s) 0))))
(lex.add.entry '("meilesioy" GR (((m e) 0) ((i) 0) ((l e) 0) ((z j O1) 1) ((i) 0))))
(lex.add.entry '("metic" EN (((m e) 0) ((t i1 k) 1))))
(lex.add.entry '("metropolitan" EN (((m e) 0) ((t r o) 0) ((p O1) 1) ((l i) 0) ((t a n) 0))))
(lex.add.entry '("miliziade" IT (((m i) 0) ((l i ts) 0) ((ts i1) 1) ((a) 0) ((d e) 0))))
(lex.add.entry '("mourning" GR (((m o) 0) ((u1 r) 1) ((n i ng) 0) ((g) 0))))
(lex.add.entry '("musee" EN (((m u) 0) ((z e1) 1))))
(lex.add.entry '("museum" EN (((m u) 0) ((z e1) 1) ((u m) 0))))
(lex.add.entry '("necropolis" GR (((n e) 0) ((k r O1) 1) ((p o) 0) ((l i) 0) ((s) 0))))
(lex.add.entry '("new" EN (((n i u) 1) )))
(lex.add.entry '("nomismata" GR (((n o) 0) ((m i) 0) ((z m a1) 1) ((t a) 0))))
(lex.add.entry '("nymphides" GR (((n i m) 0) ((f i) 0) ((d e) 0) ((s) 0))))
(lex.add.entry '("of" EN (((O1 f) 1))))
(lex.add.entry '("oikonomidis" GR (((o) 0) ((i) 0) ((k o) 0) ((n o) 0) ((m i) 0) ((d i) 0) ((s) 0))))
(lex.add.entry '("oikos" GR (((o) 0) ((i) 0) ((k o) 0) ((s) 0))))
(lex.add.entry '("oinochoe" GR (((o) 0) ((i) 0) ((n o) 0) ((k O1) 1) ((e) 0))))
(lex.add.entry '("painterly" EN (((p e) 0) ((i n) 0) ((t e r) 0) ((l i) 0))))
(lex.add.entry '("palais" FR (((p a) 0) ((l e1) 1))))
(lex.add.entry '("panatenaica" IT (((p a) 0) ((n a) 0) ((t e) 0) ((n a1) 1) ((i) 0) ((k a) 0))))
(lex.add.entry '("patrae" GR (((p a1) 1) ((t r a) 0) ((E1) 1))))
(lex.add.entry '("pensylvania" EN (((p e n) 0) ((s i l) 0) ((v E1) 1) ((n i) 0) ((a) 0))))
(lex.add.entry '("period" EN (((p i) 0) ((r i) 0) ((o d) 0))))
(lex.add.entry '("persis" FR (((p E1 r) 1) ((s i) 0) ((s) 0))))
(lex.add.entry '("petit" EN (((p e) 0) ((t i1) 1))))
(lex.add.entry '("philip" EN (((f i1) 1) ((l i p) 0))))
(lex.add.entry '("philoxenos" GR (((p i) 0) ((l o k) 0) ((s e) 0) ((n O1) 1) ((s) 0))))
(lex.add.entry '("philoxenou" GR (((p i) 0) ((l o k) 0) ((s e) 0) ((n O1) 1) )))
(lex.add.entry '("phoebus" GR (((f o ) 0) ((e1) 1) ((b u) 0) ((s) 0))))
(lex.add.entry '("pitsa" GR (((p i1 t) 1) ((s a) 0))))
(lex.add.entry '("plc" GR (((p i1) 1) ((E1 l) 1) ((l e) 0) ((tS i1) 1))))
(lex.add.entry '("poich" GR (((p O1) 1) ((i k) 0))))
(lex.add.entry '("policleto" EN (((p o) 0) ((l i) 0) ((k l e1) 1) ((t o) 0))))
(lex.add.entry '("potnia" GR (((p O1 t n j a) 1))))
(lex.add.entry '("pp" ACR (((p a1) 1) ((dZ i) 0) ((n e) 0))))
(lex.add.entry '("pp." ACR (((p a1) 1) ((dZ i) 0) ((n e) 0))))
(lex.add.entry '("princeton" EN (((p r i n) 0) ((s t o n) 0))))
(lex.add.entry '("prochous" GR (((p r o) 0) ((k o1) 1) ((u) 0) ((s) 0))))
(lex.add.entry '("red" EN (((r e1 d) 1))))
(lex.add.entry '("rhodes" EN (((r o) 0) ((d e) 0) ((s) 0))))
(lex.add.entry '("rhyton" GR (((r i) 0) ((t o n) 0))))
(lex.add.entry '("roman" EN (((r o1) 1) ((m a n) 0))))
(lex.add.entry '("sarapis" GR (((s a) 0) ((r a1) 1) ((p i) 0) ((s) 0))))
(lex.add.entry '("school" EN (((s k u l) 0))))
(lex.add.entry '("sculpture" EN (((s k a l) 0) ((p t u r) 0))))
(lex.add.entry '("sikyon" GR (((s i1) 1) ((k i) 0) ((O n) 0))))
(lex.add.entry '("slope" EN (((z l O1) 1) ((p ) 0))))
(lex.add.entry '("sotades" GR (((s o) 0) ((t a) 0) ((d e) 0) ((s) 0))))
(lex.add.entry '("splancnoscopia" IT (((s p l a n) 0) ((k n o) 0) ((s k o) 0) ((p i1) 1) ((a) 0))))
(lex.add.entry '("stamnoi" GR (((s t a m) 0) ((n O1) 1) ((i) 0))))
(lex.add.entry '("stamnos" GR (((s t a m) 0) ((n O1) 1) ((s) 0))))
(lex.add.entry '("stater" EN (((s t a1) 1) ((t e r) 0))))
(lex.add.entry '("studies" EN (((s t a) 0) ((d i) 0) ((s) 0))))
(lex.add.entry '("tebe" IT (((t E1) 1) ((b e) 0))))
(lex.add.entry '("techni" EN (((t e k) 0) ((n i) 0))))
(lex.add.entry '("technis" EN (((t E1 k) 1) ((n i) 0) ((S) 0))))
(lex.add.entry '("tetradracma" IT (((t e) 0) ((t r a) 0) ((d r a1 k m a) 1))))
(lex.add.entry '("tetradracme" IT (((t e) 0) ((t r a) 0) ((d r a1 k m e) 1))))
(lex.add.entry '("thames" EN (((t e) 0) ((i m) 0) ((s) 0))))
(lex.add.entry '("thassos" GR (((t a s) 0) ((s o) 0) ((s) 0))))
(lex.add.entry '("the" EN (((dz E1) 1))))
(lex.add.entry '("theron" GR (((t e1) 1) ((r O n) 0))))
(lex.add.entry '("thessaloniki" GR (((t e s) 0) ((s a) 0) ((l O1) 1) ((n i) 0) ((k i) 0))))
(lex.add.entry '("toledo" IT (((t o) 0) ((l E1) 1) ((d o) 0))))
(lex.add.entry '("trovla" GR (((t r O1) 1) ((v l a) 0))))
(lex.add.entry '("und" EN (((a1 n) 1) ((d) 0))))
(lex.add.entry '("vases" EN (((v a1) 1) ((z e) 0) ((s) 0))))
(lex.add.entry '("vergina" GR (((v e r) 0) ((dZ i1) 1) ((n a) 0))))
(lex.add.entry '("vitsa" GR (((v i1 t) 1) ((s a) 0))))
(lex.add.entry '("vokotopoulouI" GR (((v o) 0) ((k o) 0) ((t o1) 1) ((p o) 0) ((u) 0) ((l o) 0) ((u i) 0) )))
(lex.add.entry '("wagner" EN (((v a g n e r) 0))))
(lex.add.entry '("west" EN (((w E1) 1) ((s t) 0))))
(lex.add.entry '("wurzburg" EN (((v u r) 0) ((z b u r) 0) ((g) 0))))
(lex.add.entry '("york" EN (((j o r) 0) ((k) 0))))
(lex.add.entry '("zagoriou" GR (((dz a) 0) ((g o) 0) ((r j O1) 1) ((u) 0))))
(lex.add.entry '("zeus" IT (((dz e1) 1) ((u) 0) ((s) 0))))
(lex.add.entry ' ("copie" IT (((k O1) 1) ((p i) 0) ((e) 0))) )
(lex.add.entry ' ("un'immagine" IT (((u n) 0) ((i m) 0) ((m a1) 1) ((dZ i) 0) ((n e) 0))))
 
;;WORD out of vocabolary PER SOLEML_CARINI 
(lex.add.entry ' ("due-trecento" N (((d u1 e) 1) ((t r e) 0) ((tS E1 n) 1) ((t o) 0))))
(lex.add.entry ' ("kahloubrha" S (((k a1) 1) ((l u) 0) ((b r a) 0) )))
(lex.add.entry ' ("kalonga" S (((k a1) 1) ((l o n) 0) ((g a) 0) )))
(lex.add.entry ' ("kalu-balu" S (((k a1) 1) ((l u) 0) ((b a1) 1) ((l u) 0))))
(lex.add.entry ' ("chalung-gra" S (((tS a1) 1) ((l u ng) 0) ((g) 0) ((g r a1) 1))))
(lex.add.entry ' ("taccuino" S-MS (((t a k) 0) ((k w i1) 1) ((n o) 0))))

;;ACRONIMI e abbreviazioni
(lex.add.entry 
 '("ac" ACR (((a) 0) ((v a1 n) 1) ((t i) 0) ((k r i1) 1) ((s t o) 0))))
(lex.add.entry 
 '("dc" ACR (((d o) 0) ((p o) 0) ((k r i1) 1) ((s t o) 0))))
(lex.add.entry 
 '("fig" ACR (((f i) 0) ((g u1) 1) ((r a) 0))))
(lex.add.entry 
 '("ill" ACR (((i l) 0) ((l u) 0) ((s t r a ts) 0) ((ts j o1) 1) ((n e) 0))))
(lex.add.entry 
 '("pp" ACR (((p a1) 1) ((dZ i) 0) ((n e) 0))))
(lex.add.entry 
 '("ecc" ACR (((e tS) 0) ((tS E1) 1) ((t e) 0) ((r a) 0))))
 
;; DA vedere le regole di trascrizione per le parole che finiscono per q
(lex.add.entry 
'("iraq" nil (((i) 0) ((r a1 k) 1))))
 
;;SIMBOLI e PUNTEGGIATURA iSOLATA
(lex.add.entry 
 '("\!" SB (((p u1 n) 1) ((t o) 0) ((e) 0) ((s k l a) 0) ((m a) 0) ((t i1) 1) ((v o) 0))))
(lex.add.entry 
 '("\"" SB (((v i r) 0) ((g o) 0) ((l e1 t) 1) ((t e) 0))))
(lex.add.entry 
 '("\#" SB (((k a n) 0) ((tS e l) 0) ((l e1 t) 1) ((t o) 0))))
(lex.add.entry 
 '("%" SB (((p e1 r) 0) ((tS e1 n) 1) ((t o) 0))))
(lex.add.entry 
 '("&" SB (((E1 n) 1) ((d) 0))))
(lex.add.entry 
 '("\'" SB (((a1) 1) ((p i) 0) ((tS e) 0))))
(lex.add.entry 
 '("\(" SB (((a) 0) ((p E1 r) 1) ((t a) 0) ((t o1 n) 1) ((d a) 0))))
(lex.add.entry 
 '("\)" SB (((k j u1) 1) ((s a) 0) ((t o1 n) 1) ((d a) 0))))
(lex.add.entry 
 '("\*" SB (((a s) 0) ((t e) 0) ((r i1 s) 1)  ((k o) 0))))
(lex.add.entry 
 '("\+" SB (((p j u1) 1))))
(lex.add.entry 
 '("\," SB (((v i1 r) 1) ((g o) 0) ((l a) 0)))) 
(lex.add.entry 
 '("\-" SB (((m e1) 1) ((n o) 0))))
(lex.add.entry 
 '("\." SB (((p u1 n) 1) ((t o) 0))))
(lex.add.entry 
 '("\/" SB (((d i) 0) ((v i1) 1) ((z o) 0))))
(lex.add.entry 
 '("\:" SB (((d u1) 1) ((e) 0) ((p u1 n) 1) ((t i) 0))))
(lex.add.entry 
 '("\;" SB (((p u1 n) 1) ((t o) 0) ((e) 0) ((v i1 r) 1) ((g o) 0) ((l a) 0))))
(lex.add.entry 
 '("\<" SB (((m i) 0) ((n o1) 1) ((r e) 0))))
(lex.add.entry 
 '("\=" SB (((u) 0) ((g w a1) 1) ((l e) 0))))
(lex.add.entry 
 '(">" SB (((m a dZ) 0) ((dZ o1) 1) ((r e) 0))))
(lex.add.entry 
 '("\?" SB (((p u1 n) 1) ((t o) 0) ((d i) 0) ((d o) 0) ((m a1 n) 1) ((d a) 0))))
(lex.add.entry 
 '("\@" SB (((k j O1 tS) 1) ((tS o) 0) ((l a) 0))))
(lex.add.entry 
 '("\[" SB (((a) 0) ((p E1 r) 1) ((t a) 0) ((k w a1) 1) ((d r a) 0))))
(lex.add.entry 
 '("\\" SB (((b a1 r) 1) ((r a) 1))))
(lex.add.entry 
 '("\]" SB (((k j u1) 1) ((s a) 0) ((k w a1) 1) ((d r a) 0))))   
(lex.add.entry 
 '("\^" SB (((k a p) 0) ((p E1 l) 1) ((l o) 0)) ))
(lex.add.entry 
 '("_" SB (((s o t) 0) ((t o) 0) ((l i) 0) ((n e) 0) ((a) 0) ((t u1) 1) ((r a) 0))))
(lex.add.entry 
 '("\`" SB (((a1) 1) ((p i) 0) ((tS e) 0))))
(lex.add.entry 
 '("\{" SB (((a) 0) ((p E1 r) 1) ((t a) 0) ((g r a1) 1) ((f a) 0))))
(lex.add.entry 
 '("\|" SB (((b a1 r) 1) ((r a) 1))))
(lex.add.entry 
 '("\}" SB (((k j u1) 1) ((s a) 0) ((g r a1) 1) ((f a) 0))))
(lex.add.entry 
 '("~" SB (((t i1 l) 1) ((d e) 0)) ))
(lex.add.entry 
 '("\" SB (((g r a1) 1) ((d i) 0))))
(lex.add.entry 
 '(" " SB (((s p a1 ts) 1) ((ts j o) 0))))
(lex.add.entry 
 '("\t" SB (((t a1 b) 1))))
(lex.add.entry 
 '("\n" SB (((n w o1) 1) ((v a) 0) ((l i1) 1) ((n e) 0) ((a) 0))))


(provide 'italian_lexicon)
