/* DBCS (double-byte) charset to unicode. 0x0000 means no mapping */
/* hi = (code >> 6) */
/* lo = code & 0x3F */
/* rawoff = cp936_to_unicode_hitbl[hi] */
/* if (rawoff != 0xFFFF) ucode = _raw[rawoff+lo] */
const uint16_t cp936_to_unicode_raw[23040] = {
	/* codebase=0x0000 rawbase=0x0000 */
	0x0000,0x0001,0x0002,0x0003,0x0004,0x0005,0x0006,0x0007, /* 0x0000-0x0007 */
	0x0008,0x0009,0x000a,0x000b,0x000c,0x000d,0x000e,0x000f, /* 0x0008-0x000F */
	0x0010,0x0011,0x0012,0x0013,0x0014,0x0015,0x0016,0x0017, /* 0x0010-0x0017 */
	0x0018,0x0019,0x001a,0x001b,0x001c,0x001d,0x001e,0x001f, /* 0x0018-0x001F */
	0x0020,0x0021,0x0022,0x0023,0x0024,0x0025,0x0026,0x0027, /* 0x0020-0x0027 */
	0x0028,0x0029,0x002a,0x002b,0x002c,0x002d,0x002e,0x002f, /* 0x0028-0x002F */
	0x0030,0x0031,0x0032,0x0033,0x0034,0x0035,0x0036,0x0037, /* 0x0030-0x0037 */
	0x0038,0x0039,0x003a,0x003b,0x003c,0x003d,0x003e,0x003f, /* 0x0038-0x003F */
	/* codebase=0x0040 rawbase=0x0040 */
	0x0040,0x0041,0x0042,0x0043,0x0044,0x0045,0x0046,0x0047, /* 0x0040-0x0047 */
	0x0048,0x0049,0x004a,0x004b,0x004c,0x004d,0x004e,0x004f, /* 0x0048-0x004F */
	0x0050,0x0051,0x0052,0x0053,0x0054,0x0055,0x0056,0x0057, /* 0x0050-0x0057 */
	0x0058,0x0059,0x005a,0x005b,0x005c,0x005d,0x005e,0x005f, /* 0x0058-0x005F */
	0x0060,0x0061,0x0062,0x0063,0x0064,0x0065,0x0066,0x0067, /* 0x0060-0x0067 */
	0x0068,0x0069,0x006a,0x006b,0x006c,0x006d,0x006e,0x006f, /* 0x0068-0x006F */
	0x0070,0x0071,0x0072,0x0073,0x0074,0x0075,0x0076,0x0077, /* 0x0070-0x0077 */
	0x0078,0x0079,0x007a,0x007b,0x007c,0x007d,0x007e,0x007f, /* 0x0078-0x007F */
	/* codebase=0x0080 rawbase=0x0080 */
	0x20ac,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x0080-0x0087 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x0088-0x008F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x0090-0x0097 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x0098-0x009F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x00A0-0x00A7 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x00A8-0x00AF */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x00B0-0x00B7 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x00B8-0x00BF */
	/* codebase=0x8140 rawbase=0x00c0 */
	0x4e02,0x4e04,0x4e05,0x4e06,0x4e0f,0x4e12,0x4e17,0x4e1f, /* 0x8140-0x8147 */
	0x4e20,0x4e21,0x4e23,0x4e26,0x4e29,0x4e2e,0x4e2f,0x4e31, /* 0x8148-0x814F */
	0x4e33,0x4e35,0x4e37,0x4e3c,0x4e40,0x4e41,0x4e42,0x4e44, /* 0x8150-0x8157 */
	0x4e46,0x4e4a,0x4e51,0x4e55,0x4e57,0x4e5a,0x4e5b,0x4e62, /* 0x8158-0x815F */
	0x4e63,0x4e64,0x4e65,0x4e67,0x4e68,0x4e6a,0x4e6b,0x4e6c, /* 0x8160-0x8167 */
	0x4e6d,0x4e6e,0x4e6f,0x4e72,0x4e74,0x4e75,0x4e76,0x4e77, /* 0x8168-0x816F */
	0x4e78,0x4e79,0x4e7a,0x4e7b,0x4e7c,0x4e7d,0x4e7f,0x4e80, /* 0x8170-0x8177 */
	0x4e81,0x4e82,0x4e83,0x4e84,0x4e85,0x4e87,0x4e8a,0x0000, /* 0x8178-0x817F */
	/* codebase=0x8180 rawbase=0x0100 */
	0x4e90,0x4e96,0x4e97,0x4e99,0x4e9c,0x4e9d,0x4e9e,0x4ea3, /* 0x8180-0x8187 */
	0x4eaa,0x4eaf,0x4eb0,0x4eb1,0x4eb4,0x4eb6,0x4eb7,0x4eb8, /* 0x8188-0x818F */
	0x4eb9,0x4ebc,0x4ebd,0x4ebe,0x4ec8,0x4ecc,0x4ecf,0x4ed0, /* 0x8190-0x8197 */
	0x4ed2,0x4eda,0x4edb,0x4edc,0x4ee0,0x4ee2,0x4ee6,0x4ee7, /* 0x8198-0x819F */
	0x4ee9,0x4eed,0x4eee,0x4eef,0x4ef1,0x4ef4,0x4ef8,0x4ef9, /* 0x81A0-0x81A7 */
	0x4efa,0x4efc,0x4efe,0x4f00,0x4f02,0x4f03,0x4f04,0x4f05, /* 0x81A8-0x81AF */
	0x4f06,0x4f07,0x4f08,0x4f0b,0x4f0c,0x4f12,0x4f13,0x4f14, /* 0x81B0-0x81B7 */
	0x4f15,0x4f16,0x4f1c,0x4f1d,0x4f21,0x4f23,0x4f28,0x4f29, /* 0x81B8-0x81BF */
	/* codebase=0x81c0 rawbase=0x0140 */
	0x4f2c,0x4f2d,0x4f2e,0x4f31,0x4f33,0x4f35,0x4f37,0x4f39, /* 0x81C0-0x81C7 */
	0x4f3b,0x4f3e,0x4f3f,0x4f40,0x4f41,0x4f42,0x4f44,0x4f45, /* 0x81C8-0x81CF */
	0x4f47,0x4f48,0x4f49,0x4f4a,0x4f4b,0x4f4c,0x4f52,0x4f54, /* 0x81D0-0x81D7 */
	0x4f56,0x4f61,0x4f62,0x4f66,0x4f68,0x4f6a,0x4f6b,0x4f6d, /* 0x81D8-0x81DF */
	0x4f6e,0x4f71,0x4f72,0x4f75,0x4f77,0x4f78,0x4f79,0x4f7a, /* 0x81E0-0x81E7 */
	0x4f7d,0x4f80,0x4f81,0x4f82,0x4f85,0x4f86,0x4f87,0x4f8a, /* 0x81E8-0x81EF */
	0x4f8c,0x4f8e,0x4f90,0x4f92,0x4f93,0x4f95,0x4f96,0x4f98, /* 0x81F0-0x81F7 */
	0x4f99,0x4f9a,0x4f9c,0x4f9e,0x4f9f,0x4fa1,0x4fa2,0x0000, /* 0x81F8-0x81FF */
	/* codebase=0x8240 rawbase=0x0180 */
	0x4fa4,0x4fab,0x4fad,0x4fb0,0x4fb1,0x4fb2,0x4fb3,0x4fb4, /* 0x8240-0x8247 */
	0x4fb6,0x4fb7,0x4fb8,0x4fb9,0x4fba,0x4fbb,0x4fbc,0x4fbd, /* 0x8248-0x824F */
	0x4fbe,0x4fc0,0x4fc1,0x4fc2,0x4fc6,0x4fc7,0x4fc8,0x4fc9, /* 0x8250-0x8257 */
	0x4fcb,0x4fcc,0x4fcd,0x4fd2,0x4fd3,0x4fd4,0x4fd5,0x4fd6, /* 0x8258-0x825F */
	0x4fd9,0x4fdb,0x4fe0,0x4fe2,0x4fe4,0x4fe5,0x4fe7,0x4feb, /* 0x8260-0x8267 */
	0x4fec,0x4ff0,0x4ff2,0x4ff4,0x4ff5,0x4ff6,0x4ff7,0x4ff9, /* 0x8268-0x826F */
	0x4ffb,0x4ffc,0x4ffd,0x4fff,0x5000,0x5001,0x5002,0x5003, /* 0x8270-0x8277 */
	0x5004,0x5005,0x5006,0x5007,0x5008,0x5009,0x500a,0x0000, /* 0x8278-0x827F */
	/* codebase=0x8280 rawbase=0x01c0 */
	0x500b,0x500e,0x5010,0x5011,0x5013,0x5015,0x5016,0x5017, /* 0x8280-0x8287 */
	0x501b,0x501d,0x501e,0x5020,0x5022,0x5023,0x5024,0x5027, /* 0x8288-0x828F */
	0x502b,0x502f,0x5030,0x5031,0x5032,0x5033,0x5034,0x5035, /* 0x8290-0x8297 */
	0x5036,0x5037,0x5038,0x5039,0x503b,0x503d,0x503f,0x5040, /* 0x8298-0x829F */
	0x5041,0x5042,0x5044,0x5045,0x5046,0x5049,0x504a,0x504b, /* 0x82A0-0x82A7 */
	0x504d,0x5050,0x5051,0x5052,0x5053,0x5054,0x5056,0x5057, /* 0x82A8-0x82AF */
	0x5058,0x5059,0x505b,0x505d,0x505e,0x505f,0x5060,0x5061, /* 0x82B0-0x82B7 */
	0x5062,0x5063,0x5064,0x5066,0x5067,0x5068,0x5069,0x506a, /* 0x82B8-0x82BF */
	/* codebase=0x82c0 rawbase=0x0200 */
	0x506b,0x506d,0x506e,0x506f,0x5070,0x5071,0x5072,0x5073, /* 0x82C0-0x82C7 */
	0x5074,0x5075,0x5078,0x5079,0x507a,0x507c,0x507d,0x5081, /* 0x82C8-0x82CF */
	0x5082,0x5083,0x5084,0x5086,0x5087,0x5089,0x508a,0x508b, /* 0x82D0-0x82D7 */
	0x508c,0x508e,0x508f,0x5090,0x5091,0x5092,0x5093,0x5094, /* 0x82D8-0x82DF */
	0x5095,0x5096,0x5097,0x5098,0x5099,0x509a,0x509b,0x509c, /* 0x82E0-0x82E7 */
	0x509d,0x509e,0x509f,0x50a0,0x50a1,0x50a2,0x50a4,0x50a6, /* 0x82E8-0x82EF */
	0x50aa,0x50ab,0x50ad,0x50ae,0x50af,0x50b0,0x50b1,0x50b3, /* 0x82F0-0x82F7 */
	0x50b4,0x50b5,0x50b6,0x50b7,0x50b8,0x50b9,0x50bc,0x0000, /* 0x82F8-0x82FF */
	/* codebase=0x8340 rawbase=0x0240 */
	0x50bd,0x50be,0x50bf,0x50c0,0x50c1,0x50c2,0x50c3,0x50c4, /* 0x8340-0x8347 */
	0x50c5,0x50c6,0x50c7,0x50c8,0x50c9,0x50ca,0x50cb,0x50cc, /* 0x8348-0x834F */
	0x50cd,0x50ce,0x50d0,0x50d1,0x50d2,0x50d3,0x50d4,0x50d5, /* 0x8350-0x8357 */
	0x50d7,0x50d8,0x50d9,0x50db,0x50dc,0x50dd,0x50de,0x50df, /* 0x8358-0x835F */
	0x50e0,0x50e1,0x50e2,0x50e3,0x50e4,0x50e5,0x50e8,0x50e9, /* 0x8360-0x8367 */
	0x50ea,0x50eb,0x50ef,0x50f0,0x50f1,0x50f2,0x50f4,0x50f6, /* 0x8368-0x836F */
	0x50f7,0x50f8,0x50f9,0x50fa,0x50fc,0x50fd,0x50fe,0x50ff, /* 0x8370-0x8377 */
	0x5100,0x5101,0x5102,0x5103,0x5104,0x5105,0x5108,0x0000, /* 0x8378-0x837F */
	/* codebase=0x8380 rawbase=0x0280 */
	0x5109,0x510a,0x510c,0x510d,0x510e,0x510f,0x5110,0x5111, /* 0x8380-0x8387 */
	0x5113,0x5114,0x5115,0x5116,0x5117,0x5118,0x5119,0x511a, /* 0x8388-0x838F */
	0x511b,0x511c,0x511d,0x511e,0x511f,0x5120,0x5122,0x5123, /* 0x8390-0x8397 */
	0x5124,0x5125,0x5126,0x5127,0x5128,0x5129,0x512a,0x512b, /* 0x8398-0x839F */
	0x512c,0x512d,0x512e,0x512f,0x5130,0x5131,0x5132,0x5133, /* 0x83A0-0x83A7 */
	0x5134,0x5135,0x5136,0x5137,0x5138,0x5139,0x513a,0x513b, /* 0x83A8-0x83AF */
	0x513c,0x513d,0x513e,0x5142,0x5147,0x514a,0x514c,0x514e, /* 0x83B0-0x83B7 */
	0x514f,0x5150,0x5152,0x5153,0x5157,0x5158,0x5159,0x515b, /* 0x83B8-0x83BF */
	/* codebase=0x83c0 rawbase=0x02c0 */
	0x515d,0x515e,0x515f,0x5160,0x5161,0x5163,0x5164,0x5166, /* 0x83C0-0x83C7 */
	0x5167,0x5169,0x516a,0x516f,0x5172,0x517a,0x517e,0x517f, /* 0x83C8-0x83CF */
	0x5183,0x5184,0x5186,0x5187,0x518a,0x518b,0x518e,0x518f, /* 0x83D0-0x83D7 */
	0x5190,0x5191,0x5193,0x5194,0x5198,0x519a,0x519d,0x519e, /* 0x83D8-0x83DF */
	0x519f,0x51a1,0x51a3,0x51a6,0x51a7,0x51a8,0x51a9,0x51aa, /* 0x83E0-0x83E7 */
	0x51ad,0x51ae,0x51b4,0x51b8,0x51b9,0x51ba,0x51be,0x51bf, /* 0x83E8-0x83EF */
	0x51c1,0x51c2,0x51c3,0x51c5,0x51c8,0x51ca,0x51cd,0x51ce, /* 0x83F0-0x83F7 */
	0x51d0,0x51d2,0x51d3,0x51d4,0x51d5,0x51d6,0x51d7,0x0000, /* 0x83F8-0x83FF */
	/* codebase=0x8440 rawbase=0x0300 */
	0x51d8,0x51d9,0x51da,0x51dc,0x51de,0x51df,0x51e2,0x51e3, /* 0x8440-0x8447 */
	0x51e5,0x51e6,0x51e7,0x51e8,0x51e9,0x51ea,0x51ec,0x51ee, /* 0x8448-0x844F */
	0x51f1,0x51f2,0x51f4,0x51f7,0x51fe,0x5204,0x5205,0x5209, /* 0x8450-0x8457 */
	0x520b,0x520c,0x520f,0x5210,0x5213,0x5214,0x5215,0x521c, /* 0x8458-0x845F */
	0x521e,0x521f,0x5221,0x5222,0x5223,0x5225,0x5226,0x5227, /* 0x8460-0x8467 */
	0x522a,0x522c,0x522f,0x5231,0x5232,0x5234,0x5235,0x523c, /* 0x8468-0x846F */
	0x523e,0x5244,0x5245,0x5246,0x5247,0x5248,0x5249,0x524b, /* 0x8470-0x8477 */
	0x524e,0x524f,0x5252,0x5253,0x5255,0x5257,0x5258,0x0000, /* 0x8478-0x847F */
	/* codebase=0x8480 rawbase=0x0340 */
	0x5259,0x525a,0x525b,0x525d,0x525f,0x5260,0x5262,0x5263, /* 0x8480-0x8487 */
	0x5264,0x5266,0x5268,0x526b,0x526c,0x526d,0x526e,0x5270, /* 0x8488-0x848F */
	0x5271,0x5273,0x5274,0x5275,0x5276,0x5277,0x5278,0x5279, /* 0x8490-0x8497 */
	0x527a,0x527b,0x527c,0x527e,0x5280,0x5283,0x5284,0x5285, /* 0x8498-0x849F */
	0x5286,0x5287,0x5289,0x528a,0x528b,0x528c,0x528d,0x528e, /* 0x84A0-0x84A7 */
	0x528f,0x5291,0x5292,0x5294,0x5295,0x5296,0x5297,0x5298, /* 0x84A8-0x84AF */
	0x5299,0x529a,0x529c,0x52a4,0x52a5,0x52a6,0x52a7,0x52ae, /* 0x84B0-0x84B7 */
	0x52af,0x52b0,0x52b4,0x52b5,0x52b6,0x52b7,0x52b8,0x52b9, /* 0x84B8-0x84BF */
	/* codebase=0x84c0 rawbase=0x0380 */
	0x52ba,0x52bb,0x52bc,0x52bd,0x52c0,0x52c1,0x52c2,0x52c4, /* 0x84C0-0x84C7 */
	0x52c5,0x52c6,0x52c8,0x52ca,0x52cc,0x52cd,0x52ce,0x52cf, /* 0x84C8-0x84CF */
	0x52d1,0x52d3,0x52d4,0x52d5,0x52d7,0x52d9,0x52da,0x52db, /* 0x84D0-0x84D7 */
	0x52dc,0x52dd,0x52de,0x52e0,0x52e1,0x52e2,0x52e3,0x52e5, /* 0x84D8-0x84DF */
	0x52e6,0x52e7,0x52e8,0x52e9,0x52ea,0x52eb,0x52ec,0x52ed, /* 0x84E0-0x84E7 */
	0x52ee,0x52ef,0x52f1,0x52f2,0x52f3,0x52f4,0x52f5,0x52f6, /* 0x84E8-0x84EF */
	0x52f7,0x52f8,0x52fb,0x52fc,0x52fd,0x5301,0x5302,0x5303, /* 0x84F0-0x84F7 */
	0x5304,0x5307,0x5309,0x530a,0x530b,0x530c,0x530e,0x0000, /* 0x84F8-0x84FF */
	/* codebase=0x8540 rawbase=0x03c0 */
	0x5311,0x5312,0x5313,0x5314,0x5318,0x531b,0x531c,0x531e, /* 0x8540-0x8547 */
	0x531f,0x5322,0x5324,0x5325,0x5327,0x5328,0x5329,0x532b, /* 0x8548-0x854F */
	0x532c,0x532d,0x532f,0x5330,0x5331,0x5332,0x5333,0x5334, /* 0x8550-0x8557 */
	0x5335,0x5336,0x5337,0x5338,0x533c,0x533d,0x5340,0x5342, /* 0x8558-0x855F */
	0x5344,0x5346,0x534b,0x534c,0x534d,0x5350,0x5354,0x5358, /* 0x8560-0x8567 */
	0x5359,0x535b,0x535d,0x5365,0x5368,0x536a,0x536c,0x536d, /* 0x8568-0x856F */
	0x5372,0x5376,0x5379,0x537b,0x537c,0x537d,0x537e,0x5380, /* 0x8570-0x8577 */
	0x5381,0x5383,0x5387,0x5388,0x538a,0x538e,0x538f,0x0000, /* 0x8578-0x857F */
	/* codebase=0x8580 rawbase=0x0400 */
	0x5390,0x5391,0x5392,0x5393,0x5394,0x5396,0x5397,0x5399, /* 0x8580-0x8587 */
	0x539b,0x539c,0x539e,0x53a0,0x53a1,0x53a4,0x53a7,0x53aa, /* 0x8588-0x858F */
	0x53ab,0x53ac,0x53ad,0x53af,0x53b0,0x53b1,0x53b2,0x53b3, /* 0x8590-0x8597 */
	0x53b4,0x53b5,0x53b7,0x53b8,0x53b9,0x53ba,0x53bc,0x53bd, /* 0x8598-0x859F */
	0x53be,0x53c0,0x53c3,0x53c4,0x53c5,0x53c6,0x53c7,0x53ce, /* 0x85A0-0x85A7 */
	0x53cf,0x53d0,0x53d2,0x53d3,0x53d5,0x53da,0x53dc,0x53dd, /* 0x85A8-0x85AF */
	0x53de,0x53e1,0x53e2,0x53e7,0x53f4,0x53fa,0x53fe,0x53ff, /* 0x85B0-0x85B7 */
	0x5400,0x5402,0x5405,0x5407,0x540b,0x5414,0x5418,0x5419, /* 0x85B8-0x85BF */
	/* codebase=0x85c0 rawbase=0x0440 */
	0x541a,0x541c,0x5422,0x5424,0x5425,0x542a,0x5430,0x5433, /* 0x85C0-0x85C7 */
	0x5436,0x5437,0x543a,0x543d,0x543f,0x5441,0x5442,0x5444, /* 0x85C8-0x85CF */
	0x5445,0x5447,0x5449,0x544c,0x544d,0x544e,0x544f,0x5451, /* 0x85D0-0x85D7 */
	0x545a,0x545d,0x545e,0x545f,0x5460,0x5461,0x5463,0x5465, /* 0x85D8-0x85DF */
	0x5467,0x5469,0x546a,0x546b,0x546c,0x546d,0x546e,0x546f, /* 0x85E0-0x85E7 */
	0x5470,0x5474,0x5479,0x547a,0x547e,0x547f,0x5481,0x5483, /* 0x85E8-0x85EF */
	0x5485,0x5487,0x5488,0x5489,0x548a,0x548d,0x5491,0x5493, /* 0x85F0-0x85F7 */
	0x5497,0x5498,0x549c,0x549e,0x549f,0x54a0,0x54a1,0x0000, /* 0x85F8-0x85FF */
	/* codebase=0x8640 rawbase=0x0480 */
	0x54a2,0x54a5,0x54ae,0x54b0,0x54b2,0x54b5,0x54b6,0x54b7, /* 0x8640-0x8647 */
	0x54b9,0x54ba,0x54bc,0x54be,0x54c3,0x54c5,0x54ca,0x54cb, /* 0x8648-0x864F */
	0x54d6,0x54d8,0x54db,0x54e0,0x54e1,0x54e2,0x54e3,0x54e4, /* 0x8650-0x8657 */
	0x54eb,0x54ec,0x54ef,0x54f0,0x54f1,0x54f4,0x54f5,0x54f6, /* 0x8658-0x865F */
	0x54f7,0x54f8,0x54f9,0x54fb,0x54fe,0x5500,0x5502,0x5503, /* 0x8660-0x8667 */
	0x5504,0x5505,0x5508,0x550a,0x550b,0x550c,0x550d,0x550e, /* 0x8668-0x866F */
	0x5512,0x5513,0x5515,0x5516,0x5517,0x5518,0x5519,0x551a, /* 0x8670-0x8677 */
	0x551c,0x551d,0x551e,0x551f,0x5521,0x5525,0x5526,0x0000, /* 0x8678-0x867F */
	/* codebase=0x8680 rawbase=0x04c0 */
	0x5528,0x5529,0x552b,0x552d,0x5532,0x5534,0x5535,0x5536, /* 0x8680-0x8687 */
	0x5538,0x5539,0x553a,0x553b,0x553d,0x5540,0x5542,0x5545, /* 0x8688-0x868F */
	0x5547,0x5548,0x554b,0x554c,0x554d,0x554e,0x554f,0x5551, /* 0x8690-0x8697 */
	0x5552,0x5553,0x5554,0x5557,0x5558,0x5559,0x555a,0x555b, /* 0x8698-0x869F */
	0x555d,0x555e,0x555f,0x5560,0x5562,0x5563,0x5568,0x5569, /* 0x86A0-0x86A7 */
	0x556b,0x556f,0x5570,0x5571,0x5572,0x5573,0x5574,0x5579, /* 0x86A8-0x86AF */
	0x557a,0x557d,0x557f,0x5585,0x5586,0x558c,0x558d,0x558e, /* 0x86B0-0x86B7 */
	0x5590,0x5592,0x5593,0x5595,0x5596,0x5597,0x559a,0x559b, /* 0x86B8-0x86BF */
	/* codebase=0x86c0 rawbase=0x0500 */
	0x559e,0x55a0,0x55a1,0x55a2,0x55a3,0x55a4,0x55a5,0x55a6, /* 0x86C0-0x86C7 */
	0x55a8,0x55a9,0x55aa,0x55ab,0x55ac,0x55ad,0x55ae,0x55af, /* 0x86C8-0x86CF */
	0x55b0,0x55b2,0x55b4,0x55b6,0x55b8,0x55ba,0x55bc,0x55bf, /* 0x86D0-0x86D7 */
	0x55c0,0x55c1,0x55c2,0x55c3,0x55c6,0x55c7,0x55c8,0x55ca, /* 0x86D8-0x86DF */
	0x55cb,0x55ce,0x55cf,0x55d0,0x55d5,0x55d7,0x55d8,0x55d9, /* 0x86E0-0x86E7 */
	0x55da,0x55db,0x55de,0x55e0,0x55e2,0x55e7,0x55e9,0x55ed, /* 0x86E8-0x86EF */
	0x55ee,0x55f0,0x55f1,0x55f4,0x55f6,0x55f8,0x55f9,0x55fa, /* 0x86F0-0x86F7 */
	0x55fb,0x55fc,0x55ff,0x5602,0x5603,0x5604,0x5605,0x0000, /* 0x86F8-0x86FF */
	/* codebase=0x8740 rawbase=0x0540 */
	0x5606,0x5607,0x560a,0x560b,0x560d,0x5610,0x5611,0x5612, /* 0x8740-0x8747 */
	0x5613,0x5614,0x5615,0x5616,0x5617,0x5619,0x561a,0x561c, /* 0x8748-0x874F */
	0x561d,0x5620,0x5621,0x5622,0x5625,0x5626,0x5628,0x5629, /* 0x8750-0x8757 */
	0x562a,0x562b,0x562e,0x562f,0x5630,0x5633,0x5635,0x5637, /* 0x8758-0x875F */
	0x5638,0x563a,0x563c,0x563d,0x563e,0x5640,0x5641,0x5642, /* 0x8760-0x8767 */
	0x5643,0x5644,0x5645,0x5646,0x5647,0x5648,0x5649,0x564a, /* 0x8768-0x876F */
	0x564b,0x564f,0x5650,0x5651,0x5652,0x5653,0x5655,0x5656, /* 0x8770-0x8777 */
	0x565a,0x565b,0x565d,0x565e,0x565f,0x5660,0x5661,0x0000, /* 0x8778-0x877F */
	/* codebase=0x8780 rawbase=0x0580 */
	0x5663,0x5665,0x5666,0x5667,0x566d,0x566e,0x566f,0x5670, /* 0x8780-0x8787 */
	0x5672,0x5673,0x5674,0x5675,0x5677,0x5678,0x5679,0x567a, /* 0x8788-0x878F */
	0x567d,0x567e,0x567f,0x5680,0x5681,0x5682,0x5683,0x5684, /* 0x8790-0x8797 */
	0x5687,0x5688,0x5689,0x568a,0x568b,0x568c,0x568d,0x5690, /* 0x8798-0x879F */
	0x5691,0x5692,0x5694,0x5695,0x5696,0x5697,0x5698,0x5699, /* 0x87A0-0x87A7 */
	0x569a,0x569b,0x569c,0x569d,0x569e,0x569f,0x56a0,0x56a1, /* 0x87A8-0x87AF */
	0x56a2,0x56a4,0x56a5,0x56a6,0x56a7,0x56a8,0x56a9,0x56aa, /* 0x87B0-0x87B7 */
	0x56ab,0x56ac,0x56ad,0x56ae,0x56b0,0x56b1,0x56b2,0x56b3, /* 0x87B8-0x87BF */
	/* codebase=0x87c0 rawbase=0x05c0 */
	0x56b4,0x56b5,0x56b6,0x56b8,0x56b9,0x56ba,0x56bb,0x56bd, /* 0x87C0-0x87C7 */
	0x56be,0x56bf,0x56c0,0x56c1,0x56c2,0x56c3,0x56c4,0x56c5, /* 0x87C8-0x87CF */
	0x56c6,0x56c7,0x56c8,0x56c9,0x56cb,0x56cc,0x56cd,0x56ce, /* 0x87D0-0x87D7 */
	0x56cf,0x56d0,0x56d1,0x56d2,0x56d3,0x56d5,0x56d6,0x56d8, /* 0x87D8-0x87DF */
	0x56d9,0x56dc,0x56e3,0x56e5,0x56e6,0x56e7,0x56e8,0x56e9, /* 0x87E0-0x87E7 */
	0x56ea,0x56ec,0x56ee,0x56ef,0x56f2,0x56f3,0x56f6,0x56f7, /* 0x87E8-0x87EF */
	0x56f8,0x56fb,0x56fc,0x5700,0x5701,0x5702,0x5705,0x5707, /* 0x87F0-0x87F7 */
	0x570b,0x570c,0x570d,0x570e,0x570f,0x5710,0x5711,0x0000, /* 0x87F8-0x87FF */
	/* codebase=0x8840 rawbase=0x0600 */
	0x5712,0x5713,0x5714,0x5715,0x5716,0x5717,0x5718,0x5719, /* 0x8840-0x8847 */
	0x571a,0x571b,0x571d,0x571e,0x5720,0x5721,0x5722,0x5724, /* 0x8848-0x884F */
	0x5725,0x5726,0x5727,0x572b,0x5731,0x5732,0x5734,0x5735, /* 0x8850-0x8857 */
	0x5736,0x5737,0x5738,0x573c,0x573d,0x573f,0x5741,0x5743, /* 0x8858-0x885F */
	0x5744,0x5745,0x5746,0x5748,0x5749,0x574b,0x5752,0x5753, /* 0x8860-0x8867 */
	0x5754,0x5755,0x5756,0x5758,0x5759,0x5762,0x5763,0x5765, /* 0x8868-0x886F */
	0x5767,0x576c,0x576e,0x5770,0x5771,0x5772,0x5774,0x5775, /* 0x8870-0x8877 */
	0x5778,0x5779,0x577a,0x577d,0x577e,0x577f,0x5780,0x0000, /* 0x8878-0x887F */
	/* codebase=0x8880 rawbase=0x0640 */
	0x5781,0x5787,0x5788,0x5789,0x578a,0x578d,0x578e,0x578f, /* 0x8880-0x8887 */
	0x5790,0x5791,0x5794,0x5795,0x5796,0x5797,0x5798,0x5799, /* 0x8888-0x888F */
	0x579a,0x579c,0x579d,0x579e,0x579f,0x57a5,0x57a8,0x57aa, /* 0x8890-0x8897 */
	0x57ac,0x57af,0x57b0,0x57b1,0x57b3,0x57b5,0x57b6,0x57b7, /* 0x8898-0x889F */
	0x57b9,0x57ba,0x57bb,0x57bc,0x57bd,0x57be,0x57bf,0x57c0, /* 0x88A0-0x88A7 */
	0x57c1,0x57c4,0x57c5,0x57c6,0x57c7,0x57c8,0x57c9,0x57ca, /* 0x88A8-0x88AF */
	0x57cc,0x57cd,0x57d0,0x57d1,0x57d3,0x57d6,0x57d7,0x57db, /* 0x88B0-0x88B7 */
	0x57dc,0x57de,0x57e1,0x57e2,0x57e3,0x57e5,0x57e6,0x57e7, /* 0x88B8-0x88BF */
	/* codebase=0x88c0 rawbase=0x0680 */
	0x57e8,0x57e9,0x57ea,0x57eb,0x57ec,0x57ee,0x57f0,0x57f1, /* 0x88C0-0x88C7 */
	0x57f2,0x57f3,0x57f5,0x57f6,0x57f7,0x57fb,0x57fc,0x57fe, /* 0x88C8-0x88CF */
	0x57ff,0x5801,0x5803,0x5804,0x5805,0x5808,0x5809,0x580a, /* 0x88D0-0x88D7 */
	0x580c,0x580e,0x580f,0x5810,0x5812,0x5813,0x5814,0x5816, /* 0x88D8-0x88DF */
	0x5817,0x5818,0x581a,0x581b,0x581c,0x581d,0x581f,0x5822, /* 0x88E0-0x88E7 */
	0x5823,0x5825,0x5826,0x5827,0x5828,0x5829,0x582b,0x582c, /* 0x88E8-0x88EF */
	0x582d,0x582e,0x582f,0x5831,0x5832,0x5833,0x5834,0x5836, /* 0x88F0-0x88F7 */
	0x5837,0x5838,0x5839,0x583a,0x583b,0x583c,0x583d,0x0000, /* 0x88F8-0x88FF */
	/* codebase=0x8940 rawbase=0x06c0 */
	0x583e,0x583f,0x5840,0x5841,0x5842,0x5843,0x5845,0x5846, /* 0x8940-0x8947 */
	0x5847,0x5848,0x5849,0x584a,0x584b,0x584e,0x584f,0x5850, /* 0x8948-0x894F */
	0x5852,0x5853,0x5855,0x5856,0x5857,0x5859,0x585a,0x585b, /* 0x8950-0x8957 */
	0x585c,0x585d,0x585f,0x5860,0x5861,0x5862,0x5863,0x5864, /* 0x8958-0x895F */
	0x5866,0x5867,0x5868,0x5869,0x586a,0x586d,0x586e,0x586f, /* 0x8960-0x8967 */
	0x5870,0x5871,0x5872,0x5873,0x5874,0x5875,0x5876,0x5877, /* 0x8968-0x896F */
	0x5878,0x5879,0x587a,0x587b,0x587c,0x587d,0x587f,0x5882, /* 0x8970-0x8977 */
	0x5884,0x5886,0x5887,0x5888,0x588a,0x588b,0x588c,0x0000, /* 0x8978-0x897F */
	/* codebase=0x8980 rawbase=0x0700 */
	0x588d,0x588e,0x588f,0x5890,0x5891,0x5894,0x5895,0x5896, /* 0x8980-0x8987 */
	0x5897,0x5898,0x589b,0x589c,0x589d,0x58a0,0x58a1,0x58a2, /* 0x8988-0x898F */
	0x58a3,0x58a4,0x58a5,0x58a6,0x58a7,0x58aa,0x58ab,0x58ac, /* 0x8990-0x8997 */
	0x58ad,0x58ae,0x58af,0x58b0,0x58b1,0x58b2,0x58b3,0x58b4, /* 0x8998-0x899F */
	0x58b5,0x58b6,0x58b7,0x58b8,0x58b9,0x58ba,0x58bb,0x58bd, /* 0x89A0-0x89A7 */
	0x58be,0x58bf,0x58c0,0x58c2,0x58c3,0x58c4,0x58c6,0x58c7, /* 0x89A8-0x89AF */
	0x58c8,0x58c9,0x58ca,0x58cb,0x58cc,0x58cd,0x58ce,0x58cf, /* 0x89B0-0x89B7 */
	0x58d0,0x58d2,0x58d3,0x58d4,0x58d6,0x58d7,0x58d8,0x58d9, /* 0x89B8-0x89BF */
	/* codebase=0x89c0 rawbase=0x0740 */
	0x58da,0x58db,0x58dc,0x58dd,0x58de,0x58df,0x58e0,0x58e1, /* 0x89C0-0x89C7 */
	0x58e2,0x58e3,0x58e5,0x58e6,0x58e7,0x58e8,0x58e9,0x58ea, /* 0x89C8-0x89CF */
	0x58ed,0x58ef,0x58f1,0x58f2,0x58f4,0x58f5,0x58f7,0x58f8, /* 0x89D0-0x89D7 */
	0x58fa,0x58fb,0x58fc,0x58fd,0x58fe,0x58ff,0x5900,0x5901, /* 0x89D8-0x89DF */
	0x5903,0x5905,0x5906,0x5908,0x5909,0x590a,0x590b,0x590c, /* 0x89E0-0x89E7 */
	0x590e,0x5910,0x5911,0x5912,0x5913,0x5917,0x5918,0x591b, /* 0x89E8-0x89EF */
	0x591d,0x591e,0x5920,0x5921,0x5922,0x5923,0x5926,0x5928, /* 0x89F0-0x89F7 */
	0x592c,0x5930,0x5932,0x5933,0x5935,0x5936,0x593b,0x0000, /* 0x89F8-0x89FF */
	/* codebase=0x8a40 rawbase=0x0780 */
	0x593d,0x593e,0x593f,0x5940,0x5943,0x5945,0x5946,0x594a, /* 0x8A40-0x8A47 */
	0x594c,0x594d,0x5950,0x5952,0x5953,0x5959,0x595b,0x595c, /* 0x8A48-0x8A4F */
	0x595d,0x595e,0x595f,0x5961,0x5963,0x5964,0x5966,0x5967, /* 0x8A50-0x8A57 */
	0x5968,0x5969,0x596a,0x596b,0x596c,0x596d,0x596e,0x596f, /* 0x8A58-0x8A5F */
	0x5970,0x5971,0x5972,0x5975,0x5977,0x597a,0x597b,0x597c, /* 0x8A60-0x8A67 */
	0x597e,0x597f,0x5980,0x5985,0x5989,0x598b,0x598c,0x598e, /* 0x8A68-0x8A6F */
	0x598f,0x5990,0x5991,0x5994,0x5995,0x5998,0x599a,0x599b, /* 0x8A70-0x8A77 */
	0x599c,0x599d,0x599f,0x59a0,0x59a1,0x59a2,0x59a6,0x0000, /* 0x8A78-0x8A7F */
	/* codebase=0x8a80 rawbase=0x07c0 */
	0x59a7,0x59ac,0x59ad,0x59b0,0x59b1,0x59b3,0x59b4,0x59b5, /* 0x8A80-0x8A87 */
	0x59b6,0x59b7,0x59b8,0x59ba,0x59bc,0x59bd,0x59bf,0x59c0, /* 0x8A88-0x8A8F */
	0x59c1,0x59c2,0x59c3,0x59c4,0x59c5,0x59c7,0x59c8,0x59c9, /* 0x8A90-0x8A97 */
	0x59cc,0x59cd,0x59ce,0x59cf,0x59d5,0x59d6,0x59d9,0x59db, /* 0x8A98-0x8A9F */
	0x59de,0x59df,0x59e0,0x59e1,0x59e2,0x59e4,0x59e6,0x59e7, /* 0x8AA0-0x8AA7 */
	0x59e9,0x59ea,0x59eb,0x59ed,0x59ee,0x59ef,0x59f0,0x59f1, /* 0x8AA8-0x8AAF */
	0x59f2,0x59f3,0x59f4,0x59f5,0x59f6,0x59f7,0x59f8,0x59fa, /* 0x8AB0-0x8AB7 */
	0x59fc,0x59fd,0x59fe,0x5a00,0x5a02,0x5a0a,0x5a0b,0x5a0d, /* 0x8AB8-0x8ABF */
	/* codebase=0x8ac0 rawbase=0x0800 */
	0x5a0e,0x5a0f,0x5a10,0x5a12,0x5a14,0x5a15,0x5a16,0x5a17, /* 0x8AC0-0x8AC7 */
	0x5a19,0x5a1a,0x5a1b,0x5a1d,0x5a1e,0x5a21,0x5a22,0x5a24, /* 0x8AC8-0x8ACF */
	0x5a26,0x5a27,0x5a28,0x5a2a,0x5a2b,0x5a2c,0x5a2d,0x5a2e, /* 0x8AD0-0x8AD7 */
	0x5a2f,0x5a30,0x5a33,0x5a35,0x5a37,0x5a38,0x5a39,0x5a3a, /* 0x8AD8-0x8ADF */
	0x5a3b,0x5a3d,0x5a3e,0x5a3f,0x5a41,0x5a42,0x5a43,0x5a44, /* 0x8AE0-0x8AE7 */
	0x5a45,0x5a47,0x5a48,0x5a4b,0x5a4c,0x5a4d,0x5a4e,0x5a4f, /* 0x8AE8-0x8AEF */
	0x5a50,0x5a51,0x5a52,0x5a53,0x5a54,0x5a56,0x5a57,0x5a58, /* 0x8AF0-0x8AF7 */
	0x5a59,0x5a5b,0x5a5c,0x5a5d,0x5a5e,0x5a5f,0x5a60,0x0000, /* 0x8AF8-0x8AFF */
	/* codebase=0x8b40 rawbase=0x0840 */
	0x5a61,0x5a63,0x5a64,0x5a65,0x5a66,0x5a68,0x5a69,0x5a6b, /* 0x8B40-0x8B47 */
	0x5a6c,0x5a6d,0x5a6e,0x5a6f,0x5a70,0x5a71,0x5a72,0x5a73, /* 0x8B48-0x8B4F */
	0x5a78,0x5a79,0x5a7b,0x5a7c,0x5a7d,0x5a7e,0x5a80,0x5a81, /* 0x8B50-0x8B57 */
	0x5a82,0x5a83,0x5a84,0x5a85,0x5a86,0x5a87,0x5a88,0x5a89, /* 0x8B58-0x8B5F */
	0x5a8a,0x5a8b,0x5a8c,0x5a8d,0x5a8e,0x5a8f,0x5a90,0x5a91, /* 0x8B60-0x8B67 */
	0x5a93,0x5a94,0x5a95,0x5a96,0x5a97,0x5a98,0x5a99,0x5a9c, /* 0x8B68-0x8B6F */
	0x5a9d,0x5a9e,0x5a9f,0x5aa0,0x5aa1,0x5aa2,0x5aa3,0x5aa4, /* 0x8B70-0x8B77 */
	0x5aa5,0x5aa6,0x5aa7,0x5aa8,0x5aa9,0x5aab,0x5aac,0x0000, /* 0x8B78-0x8B7F */
	/* codebase=0x8b80 rawbase=0x0880 */
	0x5aad,0x5aae,0x5aaf,0x5ab0,0x5ab1,0x5ab4,0x5ab6,0x5ab7, /* 0x8B80-0x8B87 */
	0x5ab9,0x5aba,0x5abb,0x5abc,0x5abd,0x5abf,0x5ac0,0x5ac3, /* 0x8B88-0x8B8F */
	0x5ac4,0x5ac5,0x5ac6,0x5ac7,0x5ac8,0x5aca,0x5acb,0x5acd, /* 0x8B90-0x8B97 */
	0x5ace,0x5acf,0x5ad0,0x5ad1,0x5ad3,0x5ad5,0x5ad7,0x5ad9, /* 0x8B98-0x8B9F */
	0x5ada,0x5adb,0x5add,0x5ade,0x5adf,0x5ae2,0x5ae4,0x5ae5, /* 0x8BA0-0x8BA7 */
	0x5ae7,0x5ae8,0x5aea,0x5aec,0x5aed,0x5aee,0x5aef,0x5af0, /* 0x8BA8-0x8BAF */
	0x5af2,0x5af3,0x5af4,0x5af5,0x5af6,0x5af7,0x5af8,0x5af9, /* 0x8BB0-0x8BB7 */
	0x5afa,0x5afb,0x5afc,0x5afd,0x5afe,0x5aff,0x5b00,0x5b01, /* 0x8BB8-0x8BBF */
	/* codebase=0x8bc0 rawbase=0x08c0 */
	0x5b02,0x5b03,0x5b04,0x5b05,0x5b06,0x5b07,0x5b08,0x5b0a, /* 0x8BC0-0x8BC7 */
	0x5b0b,0x5b0c,0x5b0d,0x5b0e,0x5b0f,0x5b10,0x5b11,0x5b12, /* 0x8BC8-0x8BCF */
	0x5b13,0x5b14,0x5b15,0x5b18,0x5b19,0x5b1a,0x5b1b,0x5b1c, /* 0x8BD0-0x8BD7 */
	0x5b1d,0x5b1e,0x5b1f,0x5b20,0x5b21,0x5b22,0x5b23,0x5b24, /* 0x8BD8-0x8BDF */
	0x5b25,0x5b26,0x5b27,0x5b28,0x5b29,0x5b2a,0x5b2b,0x5b2c, /* 0x8BE0-0x8BE7 */
	0x5b2d,0x5b2e,0x5b2f,0x5b30,0x5b31,0x5b33,0x5b35,0x5b36, /* 0x8BE8-0x8BEF */
	0x5b38,0x5b39,0x5b3a,0x5b3b,0x5b3c,0x5b3d,0x5b3e,0x5b3f, /* 0x8BF0-0x8BF7 */
	0x5b41,0x5b42,0x5b43,0x5b44,0x5b45,0x5b46,0x5b47,0x0000, /* 0x8BF8-0x8BFF */
	/* codebase=0x8c40 rawbase=0x0900 */
	0x5b48,0x5b49,0x5b4a,0x5b4b,0x5b4c,0x5b4d,0x5b4e,0x5b4f, /* 0x8C40-0x8C47 */
	0x5b52,0x5b56,0x5b5e,0x5b60,0x5b61,0x5b67,0x5b68,0x5b6b, /* 0x8C48-0x8C4F */
	0x5b6d,0x5b6e,0x5b6f,0x5b72,0x5b74,0x5b76,0x5b77,0x5b78, /* 0x8C50-0x8C57 */
	0x5b79,0x5b7b,0x5b7c,0x5b7e,0x5b7f,0x5b82,0x5b86,0x5b8a, /* 0x8C58-0x8C5F */
	0x5b8d,0x5b8e,0x5b90,0x5b91,0x5b92,0x5b94,0x5b96,0x5b9f, /* 0x8C60-0x8C67 */
	0x5ba7,0x5ba8,0x5ba9,0x5bac,0x5bad,0x5bae,0x5baf,0x5bb1, /* 0x8C68-0x8C6F */
	0x5bb2,0x5bb7,0x5bba,0x5bbb,0x5bbc,0x5bc0,0x5bc1,0x5bc3, /* 0x8C70-0x8C77 */
	0x5bc8,0x5bc9,0x5bca,0x5bcb,0x5bcd,0x5bce,0x5bcf,0x0000, /* 0x8C78-0x8C7F */
	/* codebase=0x8c80 rawbase=0x0940 */
	0x5bd1,0x5bd4,0x5bd5,0x5bd6,0x5bd7,0x5bd8,0x5bd9,0x5bda, /* 0x8C80-0x8C87 */
	0x5bdb,0x5bdc,0x5be0,0x5be2,0x5be3,0x5be6,0x5be7,0x5be9, /* 0x8C88-0x8C8F */
	0x5bea,0x5beb,0x5bec,0x5bed,0x5bef,0x5bf1,0x5bf2,0x5bf3, /* 0x8C90-0x8C97 */
	0x5bf4,0x5bf5,0x5bf6,0x5bf7,0x5bfd,0x5bfe,0x5c00,0x5c02, /* 0x8C98-0x8C9F */
	0x5c03,0x5c05,0x5c07,0x5c08,0x5c0b,0x5c0c,0x5c0d,0x5c0e, /* 0x8CA0-0x8CA7 */
	0x5c10,0x5c12,0x5c13,0x5c17,0x5c19,0x5c1b,0x5c1e,0x5c1f, /* 0x8CA8-0x8CAF */
	0x5c20,0x5c21,0x5c23,0x5c26,0x5c28,0x5c29,0x5c2a,0x5c2b, /* 0x8CB0-0x8CB7 */
	0x5c2d,0x5c2e,0x5c2f,0x5c30,0x5c32,0x5c33,0x5c35,0x5c36, /* 0x8CB8-0x8CBF */
	/* codebase=0x8cc0 rawbase=0x0980 */
	0x5c37,0x5c43,0x5c44,0x5c46,0x5c47,0x5c4c,0x5c4d,0x5c52, /* 0x8CC0-0x8CC7 */
	0x5c53,0x5c54,0x5c56,0x5c57,0x5c58,0x5c5a,0x5c5b,0x5c5c, /* 0x8CC8-0x8CCF */
	0x5c5d,0x5c5f,0x5c62,0x5c64,0x5c67,0x5c68,0x5c69,0x5c6a, /* 0x8CD0-0x8CD7 */
	0x5c6b,0x5c6c,0x5c6d,0x5c70,0x5c72,0x5c73,0x5c74,0x5c75, /* 0x8CD8-0x8CDF */
	0x5c76,0x5c77,0x5c78,0x5c7b,0x5c7c,0x5c7d,0x5c7e,0x5c80, /* 0x8CE0-0x8CE7 */
	0x5c83,0x5c84,0x5c85,0x5c86,0x5c87,0x5c89,0x5c8a,0x5c8b, /* 0x8CE8-0x8CEF */
	0x5c8e,0x5c8f,0x5c92,0x5c93,0x5c95,0x5c9d,0x5c9e,0x5c9f, /* 0x8CF0-0x8CF7 */
	0x5ca0,0x5ca1,0x5ca4,0x5ca5,0x5ca6,0x5ca7,0x5ca8,0x0000, /* 0x8CF8-0x8CFF */
	/* codebase=0x8d40 rawbase=0x09c0 */
	0x5caa,0x5cae,0x5caf,0x5cb0,0x5cb2,0x5cb4,0x5cb6,0x5cb9, /* 0x8D40-0x8D47 */
	0x5cba,0x5cbb,0x5cbc,0x5cbe,0x5cc0,0x5cc2,0x5cc3,0x5cc5, /* 0x8D48-0x8D4F */
	0x5cc6,0x5cc7,0x5cc8,0x5cc9,0x5cca,0x5ccc,0x5ccd,0x5cce, /* 0x8D50-0x8D57 */
	0x5ccf,0x5cd0,0x5cd1,0x5cd3,0x5cd4,0x5cd5,0x5cd6,0x5cd7, /* 0x8D58-0x8D5F */
	0x5cd8,0x5cda,0x5cdb,0x5cdc,0x5cdd,0x5cde,0x5cdf,0x5ce0, /* 0x8D60-0x8D67 */
	0x5ce2,0x5ce3,0x5ce7,0x5ce9,0x5ceb,0x5cec,0x5cee,0x5cef, /* 0x8D68-0x8D6F */
	0x5cf1,0x5cf2,0x5cf3,0x5cf4,0x5cf5,0x5cf6,0x5cf7,0x5cf8, /* 0x8D70-0x8D77 */
	0x5cf9,0x5cfa,0x5cfc,0x5cfd,0x5cfe,0x5cff,0x5d00,0x0000, /* 0x8D78-0x8D7F */
	/* codebase=0x8d80 rawbase=0x0a00 */
	0x5d01,0x5d04,0x5d05,0x5d08,0x5d09,0x5d0a,0x5d0b,0x5d0c, /* 0x8D80-0x8D87 */
	0x5d0d,0x5d0f,0x5d10,0x5d11,0x5d12,0x5d13,0x5d15,0x5d17, /* 0x8D88-0x8D8F */
	0x5d18,0x5d19,0x5d1a,0x5d1c,0x5d1d,0x5d1f,0x5d20,0x5d21, /* 0x8D90-0x8D97 */
	0x5d22,0x5d23,0x5d25,0x5d28,0x5d2a,0x5d2b,0x5d2c,0x5d2f, /* 0x8D98-0x8D9F */
	0x5d30,0x5d31,0x5d32,0x5d33,0x5d35,0x5d36,0x5d37,0x5d38, /* 0x8DA0-0x8DA7 */
	0x5d39,0x5d3a,0x5d3b,0x5d3c,0x5d3f,0x5d40,0x5d41,0x5d42, /* 0x8DA8-0x8DAF */
	0x5d43,0x5d44,0x5d45,0x5d46,0x5d48,0x5d49,0x5d4d,0x5d4e, /* 0x8DB0-0x8DB7 */
	0x5d4f,0x5d50,0x5d51,0x5d52,0x5d53,0x5d54,0x5d55,0x5d56, /* 0x8DB8-0x8DBF */
	/* codebase=0x8dc0 rawbase=0x0a40 */
	0x5d57,0x5d59,0x5d5a,0x5d5c,0x5d5e,0x5d5f,0x5d60,0x5d61, /* 0x8DC0-0x8DC7 */
	0x5d62,0x5d63,0x5d64,0x5d65,0x5d66,0x5d67,0x5d68,0x5d6a, /* 0x8DC8-0x8DCF */
	0x5d6d,0x5d6e,0x5d70,0x5d71,0x5d72,0x5d73,0x5d75,0x5d76, /* 0x8DD0-0x8DD7 */
	0x5d77,0x5d78,0x5d79,0x5d7a,0x5d7b,0x5d7c,0x5d7d,0x5d7e, /* 0x8DD8-0x8DDF */
	0x5d7f,0x5d80,0x5d81,0x5d83,0x5d84,0x5d85,0x5d86,0x5d87, /* 0x8DE0-0x8DE7 */
	0x5d88,0x5d89,0x5d8a,0x5d8b,0x5d8c,0x5d8d,0x5d8e,0x5d8f, /* 0x8DE8-0x8DEF */
	0x5d90,0x5d91,0x5d92,0x5d93,0x5d94,0x5d95,0x5d96,0x5d97, /* 0x8DF0-0x8DF7 */
	0x5d98,0x5d9a,0x5d9b,0x5d9c,0x5d9e,0x5d9f,0x5da0,0x0000, /* 0x8DF8-0x8DFF */
	/* codebase=0x8e40 rawbase=0x0a80 */
	0x5da1,0x5da2,0x5da3,0x5da4,0x5da5,0x5da6,0x5da7,0x5da8, /* 0x8E40-0x8E47 */
	0x5da9,0x5daa,0x5dab,0x5dac,0x5dad,0x5dae,0x5daf,0x5db0, /* 0x8E48-0x8E4F */
	0x5db1,0x5db2,0x5db3,0x5db4,0x5db5,0x5db6,0x5db8,0x5db9, /* 0x8E50-0x8E57 */
	0x5dba,0x5dbb,0x5dbc,0x5dbd,0x5dbe,0x5dbf,0x5dc0,0x5dc1, /* 0x8E58-0x8E5F */
	0x5dc2,0x5dc3,0x5dc4,0x5dc6,0x5dc7,0x5dc8,0x5dc9,0x5dca, /* 0x8E60-0x8E67 */
	0x5dcb,0x5dcc,0x5dce,0x5dcf,0x5dd0,0x5dd1,0x5dd2,0x5dd3, /* 0x8E68-0x8E6F */
	0x5dd4,0x5dd5,0x5dd6,0x5dd7,0x5dd8,0x5dd9,0x5dda,0x5ddc, /* 0x8E70-0x8E77 */
	0x5ddf,0x5de0,0x5de3,0x5de4,0x5dea,0x5dec,0x5ded,0x0000, /* 0x8E78-0x8E7F */
	/* codebase=0x8e80 rawbase=0x0ac0 */
	0x5df0,0x5df5,0x5df6,0x5df8,0x5df9,0x5dfa,0x5dfb,0x5dfc, /* 0x8E80-0x8E87 */
	0x5dff,0x5e00,0x5e04,0x5e07,0x5e09,0x5e0a,0x5e0b,0x5e0d, /* 0x8E88-0x8E8F */
	0x5e0e,0x5e12,0x5e13,0x5e17,0x5e1e,0x5e1f,0x5e20,0x5e21, /* 0x8E90-0x8E97 */
	0x5e22,0x5e23,0x5e24,0x5e25,0x5e28,0x5e29,0x5e2a,0x5e2b, /* 0x8E98-0x8E9F */
	0x5e2c,0x5e2f,0x5e30,0x5e32,0x5e33,0x5e34,0x5e35,0x5e36, /* 0x8EA0-0x8EA7 */
	0x5e39,0x5e3a,0x5e3e,0x5e3f,0x5e40,0x5e41,0x5e43,0x5e46, /* 0x8EA8-0x8EAF */
	0x5e47,0x5e48,0x5e49,0x5e4a,0x5e4b,0x5e4d,0x5e4e,0x5e4f, /* 0x8EB0-0x8EB7 */
	0x5e50,0x5e51,0x5e52,0x5e53,0x5e56,0x5e57,0x5e58,0x5e59, /* 0x8EB8-0x8EBF */
	/* codebase=0x8ec0 rawbase=0x0b00 */
	0x5e5a,0x5e5c,0x5e5d,0x5e5f,0x5e60,0x5e63,0x5e64,0x5e65, /* 0x8EC0-0x8EC7 */
	0x5e66,0x5e67,0x5e68,0x5e69,0x5e6a,0x5e6b,0x5e6c,0x5e6d, /* 0x8EC8-0x8ECF */
	0x5e6e,0x5e6f,0x5e70,0x5e71,0x5e75,0x5e77,0x5e79,0x5e7e, /* 0x8ED0-0x8ED7 */
	0x5e81,0x5e82,0x5e83,0x5e85,0x5e88,0x5e89,0x5e8c,0x5e8d, /* 0x8ED8-0x8EDF */
	0x5e8e,0x5e92,0x5e98,0x5e9b,0x5e9d,0x5ea1,0x5ea2,0x5ea3, /* 0x8EE0-0x8EE7 */
	0x5ea4,0x5ea8,0x5ea9,0x5eaa,0x5eab,0x5eac,0x5eae,0x5eaf, /* 0x8EE8-0x8EEF */
	0x5eb0,0x5eb1,0x5eb2,0x5eb4,0x5eba,0x5ebb,0x5ebc,0x5ebd, /* 0x8EF0-0x8EF7 */
	0x5ebf,0x5ec0,0x5ec1,0x5ec2,0x5ec3,0x5ec4,0x5ec5,0x0000, /* 0x8EF8-0x8EFF */
	/* codebase=0x8f40 rawbase=0x0b40 */
	0x5ec6,0x5ec7,0x5ec8,0x5ecb,0x5ecc,0x5ecd,0x5ece,0x5ecf, /* 0x8F40-0x8F47 */
	0x5ed0,0x5ed4,0x5ed5,0x5ed7,0x5ed8,0x5ed9,0x5eda,0x5edc, /* 0x8F48-0x8F4F */
	0x5edd,0x5ede,0x5edf,0x5ee0,0x5ee1,0x5ee2,0x5ee3,0x5ee4, /* 0x8F50-0x8F57 */
	0x5ee5,0x5ee6,0x5ee7,0x5ee9,0x5eeb,0x5eec,0x5eed,0x5eee, /* 0x8F58-0x8F5F */
	0x5eef,0x5ef0,0x5ef1,0x5ef2,0x5ef3,0x5ef5,0x5ef8,0x5ef9, /* 0x8F60-0x8F67 */
	0x5efb,0x5efc,0x5efd,0x5f05,0x5f06,0x5f07,0x5f09,0x5f0c, /* 0x8F68-0x8F6F */
	0x5f0d,0x5f0e,0x5f10,0x5f12,0x5f14,0x5f16,0x5f19,0x5f1a, /* 0x8F70-0x8F77 */
	0x5f1c,0x5f1d,0x5f1e,0x5f21,0x5f22,0x5f23,0x5f24,0x0000, /* 0x8F78-0x8F7F */
	/* codebase=0x8f80 rawbase=0x0b80 */
	0x5f28,0x5f2b,0x5f2c,0x5f2e,0x5f30,0x5f32,0x5f33,0x5f34, /* 0x8F80-0x8F87 */
	0x5f35,0x5f36,0x5f37,0x5f38,0x5f3b,0x5f3d,0x5f3e,0x5f3f, /* 0x8F88-0x8F8F */
	0x5f41,0x5f42,0x5f43,0x5f44,0x5f45,0x5f46,0x5f47,0x5f48, /* 0x8F90-0x8F97 */
	0x5f49,0x5f4a,0x5f4b,0x5f4c,0x5f4d,0x5f4e,0x5f4f,0x5f51, /* 0x8F98-0x8F9F */
	0x5f54,0x5f59,0x5f5a,0x5f5b,0x5f5c,0x5f5e,0x5f5f,0x5f60, /* 0x8FA0-0x8FA7 */
	0x5f63,0x5f65,0x5f67,0x5f68,0x5f6b,0x5f6e,0x5f6f,0x5f72, /* 0x8FA8-0x8FAF */
	0x5f74,0x5f75,0x5f76,0x5f78,0x5f7a,0x5f7d,0x5f7e,0x5f7f, /* 0x8FB0-0x8FB7 */
	0x5f83,0x5f86,0x5f8d,0x5f8e,0x5f8f,0x5f91,0x5f93,0x5f94, /* 0x8FB8-0x8FBF */
	/* codebase=0x8fc0 rawbase=0x0bc0 */
	0x5f96,0x5f9a,0x5f9b,0x5f9d,0x5f9e,0x5f9f,0x5fa0,0x5fa2, /* 0x8FC0-0x8FC7 */
	0x5fa3,0x5fa4,0x5fa5,0x5fa6,0x5fa7,0x5fa9,0x5fab,0x5fac, /* 0x8FC8-0x8FCF */
	0x5faf,0x5fb0,0x5fb1,0x5fb2,0x5fb3,0x5fb4,0x5fb6,0x5fb8, /* 0x8FD0-0x8FD7 */
	0x5fb9,0x5fba,0x5fbb,0x5fbe,0x5fbf,0x5fc0,0x5fc1,0x5fc2, /* 0x8FD8-0x8FDF */
	0x5fc7,0x5fc8,0x5fca,0x5fcb,0x5fce,0x5fd3,0x5fd4,0x5fd5, /* 0x8FE0-0x8FE7 */
	0x5fda,0x5fdb,0x5fdc,0x5fde,0x5fdf,0x5fe2,0x5fe3,0x5fe5, /* 0x8FE8-0x8FEF */
	0x5fe6,0x5fe8,0x5fe9,0x5fec,0x5fef,0x5ff0,0x5ff2,0x5ff3, /* 0x8FF0-0x8FF7 */
	0x5ff4,0x5ff6,0x5ff7,0x5ff9,0x5ffa,0x5ffc,0x6007,0x0000, /* 0x8FF8-0x8FFF */
	/* codebase=0x9040 rawbase=0x0c00 */
	0x6008,0x6009,0x600b,0x600c,0x6010,0x6011,0x6013,0x6017, /* 0x9040-0x9047 */
	0x6018,0x601a,0x601e,0x601f,0x6022,0x6023,0x6024,0x602c, /* 0x9048-0x904F */
	0x602d,0x602e,0x6030,0x6031,0x6032,0x6033,0x6034,0x6036, /* 0x9050-0x9057 */
	0x6037,0x6038,0x6039,0x603a,0x603d,0x603e,0x6040,0x6044, /* 0x9058-0x905F */
	0x6045,0x6046,0x6047,0x6048,0x6049,0x604a,0x604c,0x604e, /* 0x9060-0x9067 */
	0x604f,0x6051,0x6053,0x6054,0x6056,0x6057,0x6058,0x605b, /* 0x9068-0x906F */
	0x605c,0x605e,0x605f,0x6060,0x6061,0x6065,0x6066,0x606e, /* 0x9070-0x9077 */
	0x6071,0x6072,0x6074,0x6075,0x6077,0x607e,0x6080,0x0000, /* 0x9078-0x907F */
	/* codebase=0x9080 rawbase=0x0c40 */
	0x6081,0x6082,0x6085,0x6086,0x6087,0x6088,0x608a,0x608b, /* 0x9080-0x9087 */
	0x608e,0x608f,0x6090,0x6091,0x6093,0x6095,0x6097,0x6098, /* 0x9088-0x908F */
	0x6099,0x609c,0x609e,0x60a1,0x60a2,0x60a4,0x60a5,0x60a7, /* 0x9090-0x9097 */
	0x60a9,0x60aa,0x60ae,0x60b0,0x60b3,0x60b5,0x60b6,0x60b7, /* 0x9098-0x909F */
	0x60b9,0x60ba,0x60bd,0x60be,0x60bf,0x60c0,0x60c1,0x60c2, /* 0x90A0-0x90A7 */
	0x60c3,0x60c4,0x60c7,0x60c8,0x60c9,0x60cc,0x60cd,0x60ce, /* 0x90A8-0x90AF */
	0x60cf,0x60d0,0x60d2,0x60d3,0x60d4,0x60d6,0x60d7,0x60d9, /* 0x90B0-0x90B7 */
	0x60db,0x60de,0x60e1,0x60e2,0x60e3,0x60e4,0x60e5,0x60ea, /* 0x90B8-0x90BF */
	/* codebase=0x90c0 rawbase=0x0c80 */
	0x60f1,0x60f2,0x60f5,0x60f7,0x60f8,0x60fb,0x60fc,0x60fd, /* 0x90C0-0x90C7 */
	0x60fe,0x60ff,0x6102,0x6103,0x6104,0x6105,0x6107,0x610a, /* 0x90C8-0x90CF */
	0x610b,0x610c,0x6110,0x6111,0x6112,0x6113,0x6114,0x6116, /* 0x90D0-0x90D7 */
	0x6117,0x6118,0x6119,0x611b,0x611c,0x611d,0x611e,0x6121, /* 0x90D8-0x90DF */
	0x6122,0x6125,0x6128,0x6129,0x612a,0x612c,0x612d,0x612e, /* 0x90E0-0x90E7 */
	0x612f,0x6130,0x6131,0x6132,0x6133,0x6134,0x6135,0x6136, /* 0x90E8-0x90EF */
	0x6137,0x6138,0x6139,0x613a,0x613b,0x613c,0x613d,0x613e, /* 0x90F0-0x90F7 */
	0x6140,0x6141,0x6142,0x6143,0x6144,0x6145,0x6146,0x0000, /* 0x90F8-0x90FF */
	/* codebase=0x9140 rawbase=0x0cc0 */
	0x6147,0x6149,0x614b,0x614d,0x614f,0x6150,0x6152,0x6153, /* 0x9140-0x9147 */
	0x6154,0x6156,0x6157,0x6158,0x6159,0x615a,0x615b,0x615c, /* 0x9148-0x914F */
	0x615e,0x615f,0x6160,0x6161,0x6163,0x6164,0x6165,0x6166, /* 0x9150-0x9157 */
	0x6169,0x616a,0x616b,0x616c,0x616d,0x616e,0x616f,0x6171, /* 0x9158-0x915F */
	0x6172,0x6173,0x6174,0x6176,0x6178,0x6179,0x617a,0x617b, /* 0x9160-0x9167 */
	0x617c,0x617d,0x617e,0x617f,0x6180,0x6181,0x6182,0x6183, /* 0x9168-0x916F */
	0x6184,0x6185,0x6186,0x6187,0x6188,0x6189,0x618a,0x618c, /* 0x9170-0x9177 */
	0x618d,0x618f,0x6190,0x6191,0x6192,0x6193,0x6195,0x0000, /* 0x9178-0x917F */
	/* codebase=0x9180 rawbase=0x0d00 */
	0x6196,0x6197,0x6198,0x6199,0x619a,0x619b,0x619c,0x619e, /* 0x9180-0x9187 */
	0x619f,0x61a0,0x61a1,0x61a2,0x61a3,0x61a4,0x61a5,0x61a6, /* 0x9188-0x918F */
	0x61aa,0x61ab,0x61ad,0x61ae,0x61af,0x61b0,0x61b1,0x61b2, /* 0x9190-0x9197 */
	0x61b3,0x61b4,0x61b5,0x61b6,0x61b8,0x61b9,0x61ba,0x61bb, /* 0x9198-0x919F */
	0x61bc,0x61bd,0x61bf,0x61c0,0x61c1,0x61c3,0x61c4,0x61c5, /* 0x91A0-0x91A7 */
	0x61c6,0x61c7,0x61c9,0x61cc,0x61cd,0x61ce,0x61cf,0x61d0, /* 0x91A8-0x91AF */
	0x61d3,0x61d5,0x61d6,0x61d7,0x61d8,0x61d9,0x61da,0x61db, /* 0x91B0-0x91B7 */
	0x61dc,0x61dd,0x61de,0x61df,0x61e0,0x61e1,0x61e2,0x61e3, /* 0x91B8-0x91BF */
	/* codebase=0x91c0 rawbase=0x0d40 */
	0x61e4,0x61e5,0x61e7,0x61e8,0x61e9,0x61ea,0x61eb,0x61ec, /* 0x91C0-0x91C7 */
	0x61ed,0x61ee,0x61ef,0x61f0,0x61f1,0x61f2,0x61f3,0x61f4, /* 0x91C8-0x91CF */
	0x61f6,0x61f7,0x61f8,0x61f9,0x61fa,0x61fb,0x61fc,0x61fd, /* 0x91D0-0x91D7 */
	0x61fe,0x6200,0x6201,0x6202,0x6203,0x6204,0x6205,0x6207, /* 0x91D8-0x91DF */
	0x6209,0x6213,0x6214,0x6219,0x621c,0x621d,0x621e,0x6220, /* 0x91E0-0x91E7 */
	0x6223,0x6226,0x6227,0x6228,0x6229,0x622b,0x622d,0x622f, /* 0x91E8-0x91EF */
	0x6230,0x6231,0x6232,0x6235,0x6236,0x6238,0x6239,0x623a, /* 0x91F0-0x91F7 */
	0x623b,0x623c,0x6242,0x6244,0x6245,0x6246,0x624a,0x0000, /* 0x91F8-0x91FF */
	/* codebase=0x9240 rawbase=0x0d80 */
	0x624f,0x6250,0x6255,0x6256,0x6257,0x6259,0x625a,0x625c, /* 0x9240-0x9247 */
	0x625d,0x625e,0x625f,0x6260,0x6261,0x6262,0x6264,0x6265, /* 0x9248-0x924F */
	0x6268,0x6271,0x6272,0x6274,0x6275,0x6277,0x6278,0x627a, /* 0x9250-0x9257 */
	0x627b,0x627d,0x6281,0x6282,0x6283,0x6285,0x6286,0x6287, /* 0x9258-0x925F */
	0x6288,0x628b,0x628c,0x628d,0x628e,0x628f,0x6290,0x6294, /* 0x9260-0x9267 */
	0x6299,0x629c,0x629d,0x629e,0x62a3,0x62a6,0x62a7,0x62a9, /* 0x9268-0x926F */
	0x62aa,0x62ad,0x62ae,0x62af,0x62b0,0x62b2,0x62b3,0x62b4, /* 0x9270-0x9277 */
	0x62b6,0x62b7,0x62b8,0x62ba,0x62be,0x62c0,0x62c1,0x0000, /* 0x9278-0x927F */
	/* codebase=0x9280 rawbase=0x0dc0 */
	0x62c3,0x62cb,0x62cf,0x62d1,0x62d5,0x62dd,0x62de,0x62e0, /* 0x9280-0x9287 */
	0x62e1,0x62e4,0x62ea,0x62eb,0x62f0,0x62f2,0x62f5,0x62f8, /* 0x9288-0x928F */
	0x62f9,0x62fa,0x62fb,0x6300,0x6303,0x6304,0x6305,0x6306, /* 0x9290-0x9297 */
	0x630a,0x630b,0x630c,0x630d,0x630f,0x6310,0x6312,0x6313, /* 0x9298-0x929F */
	0x6314,0x6315,0x6317,0x6318,0x6319,0x631c,0x6326,0x6327, /* 0x92A0-0x92A7 */
	0x6329,0x632c,0x632d,0x632e,0x6330,0x6331,0x6333,0x6334, /* 0x92A8-0x92AF */
	0x6335,0x6336,0x6337,0x6338,0x633b,0x633c,0x633e,0x633f, /* 0x92B0-0x92B7 */
	0x6340,0x6341,0x6344,0x6347,0x6348,0x634a,0x6351,0x6352, /* 0x92B8-0x92BF */
	/* codebase=0x92c0 rawbase=0x0e00 */
	0x6353,0x6354,0x6356,0x6357,0x6358,0x6359,0x635a,0x635b, /* 0x92C0-0x92C7 */
	0x635c,0x635d,0x6360,0x6364,0x6365,0x6366,0x6368,0x636a, /* 0x92C8-0x92CF */
	0x636b,0x636c,0x636f,0x6370,0x6372,0x6373,0x6374,0x6375, /* 0x92D0-0x92D7 */
	0x6378,0x6379,0x637c,0x637d,0x637e,0x637f,0x6381,0x6383, /* 0x92D8-0x92DF */
	0x6384,0x6385,0x6386,0x638b,0x638d,0x6391,0x6393,0x6394, /* 0x92E0-0x92E7 */
	0x6395,0x6397,0x6399,0x639a,0x639b,0x639c,0x639d,0x639e, /* 0x92E8-0x92EF */
	0x639f,0x63a1,0x63a4,0x63a6,0x63ab,0x63af,0x63b1,0x63b2, /* 0x92F0-0x92F7 */
	0x63b5,0x63b6,0x63b9,0x63bb,0x63bd,0x63bf,0x63c0,0x0000, /* 0x92F8-0x92FF */
	/* codebase=0x9340 rawbase=0x0e40 */
	0x63c1,0x63c2,0x63c3,0x63c5,0x63c7,0x63c8,0x63ca,0x63cb, /* 0x9340-0x9347 */
	0x63cc,0x63d1,0x63d3,0x63d4,0x63d5,0x63d7,0x63d8,0x63d9, /* 0x9348-0x934F */
	0x63da,0x63db,0x63dc,0x63dd,0x63df,0x63e2,0x63e4,0x63e5, /* 0x9350-0x9357 */
	0x63e6,0x63e7,0x63e8,0x63eb,0x63ec,0x63ee,0x63ef,0x63f0, /* 0x9358-0x935F */
	0x63f1,0x63f3,0x63f5,0x63f7,0x63f9,0x63fa,0x63fb,0x63fc, /* 0x9360-0x9367 */
	0x63fe,0x6403,0x6404,0x6406,0x6407,0x6408,0x6409,0x640a, /* 0x9368-0x936F */
	0x640d,0x640e,0x6411,0x6412,0x6415,0x6416,0x6417,0x6418, /* 0x9370-0x9377 */
	0x6419,0x641a,0x641d,0x641f,0x6422,0x6423,0x6424,0x0000, /* 0x9378-0x937F */
	/* codebase=0x9380 rawbase=0x0e80 */
	0x6425,0x6427,0x6428,0x6429,0x642b,0x642e,0x642f,0x6430, /* 0x9380-0x9387 */
	0x6431,0x6432,0x6433,0x6435,0x6436,0x6437,0x6438,0x6439, /* 0x9388-0x938F */
	0x643b,0x643c,0x643e,0x6440,0x6442,0x6443,0x6449,0x644b, /* 0x9390-0x9397 */
	0x644c,0x644d,0x644e,0x644f,0x6450,0x6451,0x6453,0x6455, /* 0x9398-0x939F */
	0x6456,0x6457,0x6459,0x645a,0x645b,0x645c,0x645d,0x645f, /* 0x93A0-0x93A7 */
	0x6460,0x6461,0x6462,0x6463,0x6464,0x6465,0x6466,0x6468, /* 0x93A8-0x93AF */
	0x646a,0x646b,0x646c,0x646e,0x646f,0x6470,0x6471,0x6472, /* 0x93B0-0x93B7 */
	0x6473,0x6474,0x6475,0x6476,0x6477,0x647b,0x647c,0x647d, /* 0x93B8-0x93BF */
	/* codebase=0x93c0 rawbase=0x0ec0 */
	0x647e,0x647f,0x6480,0x6481,0x6483,0x6486,0x6488,0x6489, /* 0x93C0-0x93C7 */
	0x648a,0x648b,0x648c,0x648d,0x648e,0x648f,0x6490,0x6493, /* 0x93C8-0x93CF */
	0x6494,0x6497,0x6498,0x649a,0x649b,0x649c,0x649d,0x649f, /* 0x93D0-0x93D7 */
	0x64a0,0x64a1,0x64a2,0x64a3,0x64a5,0x64a6,0x64a7,0x64a8, /* 0x93D8-0x93DF */
	0x64aa,0x64ab,0x64af,0x64b1,0x64b2,0x64b3,0x64b4,0x64b6, /* 0x93E0-0x93E7 */
	0x64b9,0x64bb,0x64bd,0x64be,0x64bf,0x64c1,0x64c3,0x64c4, /* 0x93E8-0x93EF */
	0x64c6,0x64c7,0x64c8,0x64c9,0x64ca,0x64cb,0x64cc,0x64cf, /* 0x93F0-0x93F7 */
	0x64d1,0x64d3,0x64d4,0x64d5,0x64d6,0x64d9,0x64da,0x0000, /* 0x93F8-0x93FF */
	/* codebase=0x9440 rawbase=0x0f00 */
	0x64db,0x64dc,0x64dd,0x64df,0x64e0,0x64e1,0x64e3,0x64e5, /* 0x9440-0x9447 */
	0x64e7,0x64e8,0x64e9,0x64ea,0x64eb,0x64ec,0x64ed,0x64ee, /* 0x9448-0x944F */
	0x64ef,0x64f0,0x64f1,0x64f2,0x64f3,0x64f4,0x64f5,0x64f6, /* 0x9450-0x9457 */
	0x64f7,0x64f8,0x64f9,0x64fa,0x64fb,0x64fc,0x64fd,0x64fe, /* 0x9458-0x945F */
	0x64ff,0x6501,0x6502,0x6503,0x6504,0x6505,0x6506,0x6507, /* 0x9460-0x9467 */
	0x6508,0x650a,0x650b,0x650c,0x650d,0x650e,0x650f,0x6510, /* 0x9468-0x946F */
	0x6511,0x6513,0x6514,0x6515,0x6516,0x6517,0x6519,0x651a, /* 0x9470-0x9477 */
	0x651b,0x651c,0x651d,0x651e,0x651f,0x6520,0x6521,0x0000, /* 0x9478-0x947F */
	/* codebase=0x9480 rawbase=0x0f40 */
	0x6522,0x6523,0x6524,0x6526,0x6527,0x6528,0x6529,0x652a, /* 0x9480-0x9487 */
	0x652c,0x652d,0x6530,0x6531,0x6532,0x6533,0x6537,0x653a, /* 0x9488-0x948F */
	0x653c,0x653d,0x6540,0x6541,0x6542,0x6543,0x6544,0x6546, /* 0x9490-0x9497 */
	0x6547,0x654a,0x654b,0x654d,0x654e,0x6550,0x6552,0x6553, /* 0x9498-0x949F */
	0x6554,0x6557,0x6558,0x655a,0x655c,0x655f,0x6560,0x6561, /* 0x94A0-0x94A7 */
	0x6564,0x6565,0x6567,0x6568,0x6569,0x656a,0x656d,0x656e, /* 0x94A8-0x94AF */
	0x656f,0x6571,0x6573,0x6575,0x6576,0x6578,0x6579,0x657a, /* 0x94B0-0x94B7 */
	0x657b,0x657c,0x657d,0x657e,0x657f,0x6580,0x6581,0x6582, /* 0x94B8-0x94BF */
	/* codebase=0x94c0 rawbase=0x0f80 */
	0x6583,0x6584,0x6585,0x6586,0x6588,0x6589,0x658a,0x658d, /* 0x94C0-0x94C7 */
	0x658e,0x658f,0x6592,0x6594,0x6595,0x6596,0x6598,0x659a, /* 0x94C8-0x94CF */
	0x659d,0x659e,0x65a0,0x65a2,0x65a3,0x65a6,0x65a8,0x65aa, /* 0x94D0-0x94D7 */
	0x65ac,0x65ae,0x65b1,0x65b2,0x65b3,0x65b4,0x65b5,0x65b6, /* 0x94D8-0x94DF */
	0x65b7,0x65b8,0x65ba,0x65bb,0x65be,0x65bf,0x65c0,0x65c2, /* 0x94E0-0x94E7 */
	0x65c7,0x65c8,0x65c9,0x65ca,0x65cd,0x65d0,0x65d1,0x65d3, /* 0x94E8-0x94EF */
	0x65d4,0x65d5,0x65d8,0x65d9,0x65da,0x65db,0x65dc,0x65dd, /* 0x94F0-0x94F7 */
	0x65de,0x65df,0x65e1,0x65e3,0x65e4,0x65ea,0x65eb,0x0000, /* 0x94F8-0x94FF */
	/* codebase=0x9540 rawbase=0x0fc0 */
	0x65f2,0x65f3,0x65f4,0x65f5,0x65f8,0x65f9,0x65fb,0x65fc, /* 0x9540-0x9547 */
	0x65fd,0x65fe,0x65ff,0x6601,0x6604,0x6605,0x6607,0x6608, /* 0x9548-0x954F */
	0x6609,0x660b,0x660d,0x6610,0x6611,0x6612,0x6616,0x6617, /* 0x9550-0x9557 */
	0x6618,0x661a,0x661b,0x661c,0x661e,0x6621,0x6622,0x6623, /* 0x9558-0x955F */
	0x6624,0x6626,0x6629,0x662a,0x662b,0x662c,0x662e,0x6630, /* 0x9560-0x9567 */
	0x6632,0x6633,0x6637,0x6638,0x6639,0x663a,0x663b,0x663d, /* 0x9568-0x956F */
	0x663f,0x6640,0x6642,0x6644,0x6645,0x6646,0x6647,0x6648, /* 0x9570-0x9577 */
	0x6649,0x664a,0x664d,0x664e,0x6650,0x6651,0x6658,0x0000, /* 0x9578-0x957F */
	/* codebase=0x9580 rawbase=0x1000 */
	0x6659,0x665b,0x665c,0x665d,0x665e,0x6660,0x6662,0x6663, /* 0x9580-0x9587 */
	0x6665,0x6667,0x6669,0x666a,0x666b,0x666c,0x666d,0x6671, /* 0x9588-0x958F */
	0x6672,0x6673,0x6675,0x6678,0x6679,0x667b,0x667c,0x667d, /* 0x9590-0x9597 */
	0x667f,0x6680,0x6681,0x6683,0x6685,0x6686,0x6688,0x6689, /* 0x9598-0x959F */
	0x668a,0x668b,0x668d,0x668e,0x668f,0x6690,0x6692,0x6693, /* 0x95A0-0x95A7 */
	0x6694,0x6695,0x6698,0x6699,0x669a,0x669b,0x669c,0x669e, /* 0x95A8-0x95AF */
	0x669f,0x66a0,0x66a1,0x66a2,0x66a3,0x66a4,0x66a5,0x66a6, /* 0x95B0-0x95B7 */
	0x66a9,0x66aa,0x66ab,0x66ac,0x66ad,0x66af,0x66b0,0x66b1, /* 0x95B8-0x95BF */
	/* codebase=0x95c0 rawbase=0x1040 */
	0x66b2,0x66b3,0x66b5,0x66b6,0x66b7,0x66b8,0x66ba,0x66bb, /* 0x95C0-0x95C7 */
	0x66bc,0x66bd,0x66bf,0x66c0,0x66c1,0x66c2,0x66c3,0x66c4, /* 0x95C8-0x95CF */
	0x66c5,0x66c6,0x66c7,0x66c8,0x66c9,0x66ca,0x66cb,0x66cc, /* 0x95D0-0x95D7 */
	0x66cd,0x66ce,0x66cf,0x66d0,0x66d1,0x66d2,0x66d3,0x66d4, /* 0x95D8-0x95DF */
	0x66d5,0x66d6,0x66d7,0x66d8,0x66da,0x66de,0x66df,0x66e0, /* 0x95E0-0x95E7 */
	0x66e1,0x66e2,0x66e3,0x66e4,0x66e5,0x66e7,0x66e8,0x66ea, /* 0x95E8-0x95EF */
	0x66eb,0x66ec,0x66ed,0x66ee,0x66ef,0x66f1,0x66f5,0x66f6, /* 0x95F0-0x95F7 */
	0x66f8,0x66fa,0x66fb,0x66fd,0x6701,0x6702,0x6703,0x0000, /* 0x95F8-0x95FF */
	/* codebase=0x9640 rawbase=0x1080 */
	0x6704,0x6705,0x6706,0x6707,0x670c,0x670e,0x670f,0x6711, /* 0x9640-0x9647 */
	0x6712,0x6713,0x6716,0x6718,0x6719,0x671a,0x671c,0x671e, /* 0x9648-0x964F */
	0x6720,0x6721,0x6722,0x6723,0x6724,0x6725,0x6727,0x6729, /* 0x9650-0x9657 */
	0x672e,0x6730,0x6732,0x6733,0x6736,0x6737,0x6738,0x6739, /* 0x9658-0x965F */
	0x673b,0x673c,0x673e,0x673f,0x6741,0x6744,0x6745,0x6747, /* 0x9660-0x9667 */
	0x674a,0x674b,0x674d,0x6752,0x6754,0x6755,0x6757,0x6758, /* 0x9668-0x966F */
	0x6759,0x675a,0x675b,0x675d,0x6762,0x6763,0x6764,0x6766, /* 0x9670-0x9677 */
	0x6767,0x676b,0x676c,0x676e,0x6771,0x6774,0x6776,0x0000, /* 0x9678-0x967F */
	/* codebase=0x9680 rawbase=0x10c0 */
	0x6778,0x6779,0x677a,0x677b,0x677d,0x6780,0x6782,0x6783, /* 0x9680-0x9687 */
	0x6785,0x6786,0x6788,0x678a,0x678c,0x678d,0x678e,0x678f, /* 0x9688-0x968F */
	0x6791,0x6792,0x6793,0x6794,0x6796,0x6799,0x679b,0x679f, /* 0x9690-0x9697 */
	0x67a0,0x67a1,0x67a4,0x67a6,0x67a9,0x67ac,0x67ae,0x67b1, /* 0x9698-0x969F */
	0x67b2,0x67b4,0x67b9,0x67ba,0x67bb,0x67bc,0x67bd,0x67be, /* 0x96A0-0x96A7 */
	0x67bf,0x67c0,0x67c2,0x67c5,0x67c6,0x67c7,0x67c8,0x67c9, /* 0x96A8-0x96AF */
	0x67ca,0x67cb,0x67cc,0x67cd,0x67ce,0x67d5,0x67d6,0x67d7, /* 0x96B0-0x96B7 */
	0x67db,0x67df,0x67e1,0x67e3,0x67e4,0x67e6,0x67e7,0x67e8, /* 0x96B8-0x96BF */
	/* codebase=0x96c0 rawbase=0x1100 */
	0x67ea,0x67eb,0x67ed,0x67ee,0x67f2,0x67f5,0x67f6,0x67f7, /* 0x96C0-0x96C7 */
	0x67f8,0x67f9,0x67fa,0x67fb,0x67fc,0x67fe,0x6801,0x6802, /* 0x96C8-0x96CF */
	0x6803,0x6804,0x6806,0x680d,0x6810,0x6812,0x6814,0x6815, /* 0x96D0-0x96D7 */
	0x6818,0x6819,0x681a,0x681b,0x681c,0x681e,0x681f,0x6820, /* 0x96D8-0x96DF */
	0x6822,0x6823,0x6824,0x6825,0x6826,0x6827,0x6828,0x682b, /* 0x96E0-0x96E7 */
	0x682c,0x682d,0x682e,0x682f,0x6830,0x6831,0x6834,0x6835, /* 0x96E8-0x96EF */
	0x6836,0x683a,0x683b,0x683f,0x6847,0x684b,0x684d,0x684f, /* 0x96F0-0x96F7 */
	0x6852,0x6856,0x6857,0x6858,0x6859,0x685a,0x685b,0x0000, /* 0x96F8-0x96FF */
	/* codebase=0x9740 rawbase=0x1140 */
	0x685c,0x685d,0x685e,0x685f,0x686a,0x686c,0x686d,0x686e, /* 0x9740-0x9747 */
	0x686f,0x6870,0x6871,0x6872,0x6873,0x6875,0x6878,0x6879, /* 0x9748-0x974F */
	0x687a,0x687b,0x687c,0x687d,0x687e,0x687f,0x6880,0x6882, /* 0x9750-0x9757 */
	0x6884,0x6887,0x6888,0x6889,0x688a,0x688b,0x688c,0x688d, /* 0x9758-0x975F */
	0x688e,0x6890,0x6891,0x6892,0x6894,0x6895,0x6896,0x6898, /* 0x9760-0x9767 */
	0x6899,0x689a,0x689b,0x689c,0x689d,0x689e,0x689f,0x68a0, /* 0x9768-0x976F */
	0x68a1,0x68a3,0x68a4,0x68a5,0x68a9,0x68aa,0x68ab,0x68ac, /* 0x9770-0x9777 */
	0x68ae,0x68b1,0x68b2,0x68b4,0x68b6,0x68b7,0x68b8,0x0000, /* 0x9778-0x977F */
	/* codebase=0x9780 rawbase=0x1180 */
	0x68b9,0x68ba,0x68bb,0x68bc,0x68bd,0x68be,0x68bf,0x68c1, /* 0x9780-0x9787 */
	0x68c3,0x68c4,0x68c5,0x68c6,0x68c7,0x68c8,0x68ca,0x68cc, /* 0x9788-0x978F */
	0x68ce,0x68cf,0x68d0,0x68d1,0x68d3,0x68d4,0x68d6,0x68d7, /* 0x9790-0x9797 */
	0x68d9,0x68db,0x68dc,0x68dd,0x68de,0x68df,0x68e1,0x68e2, /* 0x9798-0x979F */
	0x68e4,0x68e5,0x68e6,0x68e7,0x68e8,0x68e9,0x68ea,0x68eb, /* 0x97A0-0x97A7 */
	0x68ec,0x68ed,0x68ef,0x68f2,0x68f3,0x68f4,0x68f6,0x68f7, /* 0x97A8-0x97AF */
	0x68f8,0x68fb,0x68fd,0x68fe,0x68ff,0x6900,0x6902,0x6903, /* 0x97B0-0x97B7 */
	0x6904,0x6906,0x6907,0x6908,0x6909,0x690a,0x690c,0x690f, /* 0x97B8-0x97BF */
	/* codebase=0x97c0 rawbase=0x11c0 */
	0x6911,0x6913,0x6914,0x6915,0x6916,0x6917,0x6918,0x6919, /* 0x97C0-0x97C7 */
	0x691a,0x691b,0x691c,0x691d,0x691e,0x6921,0x6922,0x6923, /* 0x97C8-0x97CF */
	0x6925,0x6926,0x6927,0x6928,0x6929,0x692a,0x692b,0x692c, /* 0x97D0-0x97D7 */
	0x692e,0x692f,0x6931,0x6932,0x6933,0x6935,0x6936,0x6937, /* 0x97D8-0x97DF */
	0x6938,0x693a,0x693b,0x693c,0x693e,0x6940,0x6941,0x6943, /* 0x97E0-0x97E7 */
	0x6944,0x6945,0x6946,0x6947,0x6948,0x6949,0x694a,0x694b, /* 0x97E8-0x97EF */
	0x694c,0x694d,0x694e,0x694f,0x6950,0x6951,0x6952,0x6953, /* 0x97F0-0x97F7 */
	0x6955,0x6956,0x6958,0x6959,0x695b,0x695c,0x695f,0x0000, /* 0x97F8-0x97FF */
	/* codebase=0x9840 rawbase=0x1200 */
	0x6961,0x6962,0x6964,0x6965,0x6967,0x6968,0x6969,0x696a, /* 0x9840-0x9847 */
	0x696c,0x696d,0x696f,0x6970,0x6972,0x6973,0x6974,0x6975, /* 0x9848-0x984F */
	0x6976,0x697a,0x697b,0x697d,0x697e,0x697f,0x6981,0x6983, /* 0x9850-0x9857 */
	0x6985,0x698a,0x698b,0x698c,0x698e,0x698f,0x6990,0x6991, /* 0x9858-0x985F */
	0x6992,0x6993,0x6996,0x6997,0x6999,0x699a,0x699d,0x699e, /* 0x9860-0x9867 */
	0x699f,0x69a0,0x69a1,0x69a2,0x69a3,0x69a4,0x69a5,0x69a6, /* 0x9868-0x986F */
	0x69a9,0x69aa,0x69ac,0x69ae,0x69af,0x69b0,0x69b2,0x69b3, /* 0x9870-0x9877 */
	0x69b5,0x69b6,0x69b8,0x69b9,0x69ba,0x69bc,0x69bd,0x0000, /* 0x9878-0x987F */
	/* codebase=0x9880 rawbase=0x1240 */
	0x69be,0x69bf,0x69c0,0x69c2,0x69c3,0x69c4,0x69c5,0x69c6, /* 0x9880-0x9887 */
	0x69c7,0x69c8,0x69c9,0x69cb,0x69cd,0x69cf,0x69d1,0x69d2, /* 0x9888-0x988F */
	0x69d3,0x69d5,0x69d6,0x69d7,0x69d8,0x69d9,0x69da,0x69dc, /* 0x9890-0x9897 */
	0x69dd,0x69de,0x69e1,0x69e2,0x69e3,0x69e4,0x69e5,0x69e6, /* 0x9898-0x989F */
	0x69e7,0x69e8,0x69e9,0x69ea,0x69eb,0x69ec,0x69ee,0x69ef, /* 0x98A0-0x98A7 */
	0x69f0,0x69f1,0x69f3,0x69f4,0x69f5,0x69f6,0x69f7,0x69f8, /* 0x98A8-0x98AF */
	0x69f9,0x69fa,0x69fb,0x69fc,0x69fe,0x6a00,0x6a01,0x6a02, /* 0x98B0-0x98B7 */
	0x6a03,0x6a04,0x6a05,0x6a06,0x6a07,0x6a08,0x6a09,0x6a0b, /* 0x98B8-0x98BF */
	/* codebase=0x98c0 rawbase=0x1280 */
	0x6a0c,0x6a0d,0x6a0e,0x6a0f,0x6a10,0x6a11,0x6a12,0x6a13, /* 0x98C0-0x98C7 */
	0x6a14,0x6a15,0x6a16,0x6a19,0x6a1a,0x6a1b,0x6a1c,0x6a1d, /* 0x98C8-0x98CF */
	0x6a1e,0x6a20,0x6a22,0x6a23,0x6a24,0x6a25,0x6a26,0x6a27, /* 0x98D0-0x98D7 */
	0x6a29,0x6a2b,0x6a2c,0x6a2d,0x6a2e,0x6a30,0x6a32,0x6a33, /* 0x98D8-0x98DF */
	0x6a34,0x6a36,0x6a37,0x6a38,0x6a39,0x6a3a,0x6a3b,0x6a3c, /* 0x98E0-0x98E7 */
	0x6a3f,0x6a40,0x6a41,0x6a42,0x6a43,0x6a45,0x6a46,0x6a48, /* 0x98E8-0x98EF */
	0x6a49,0x6a4a,0x6a4b,0x6a4c,0x6a4d,0x6a4e,0x6a4f,0x6a51, /* 0x98F0-0x98F7 */
	0x6a52,0x6a53,0x6a54,0x6a55,0x6a56,0x6a57,0x6a5a,0x0000, /* 0x98F8-0x98FF */
	/* codebase=0x9940 rawbase=0x12c0 */
	0x6a5c,0x6a5d,0x6a5e,0x6a5f,0x6a60,0x6a62,0x6a63,0x6a64, /* 0x9940-0x9947 */
	0x6a66,0x6a67,0x6a68,0x6a69,0x6a6a,0x6a6b,0x6a6c,0x6a6d, /* 0x9948-0x994F */
	0x6a6e,0x6a6f,0x6a70,0x6a72,0x6a73,0x6a74,0x6a75,0x6a76, /* 0x9950-0x9957 */
	0x6a77,0x6a78,0x6a7a,0x6a7b,0x6a7d,0x6a7e,0x6a7f,0x6a81, /* 0x9958-0x995F */
	0x6a82,0x6a83,0x6a85,0x6a86,0x6a87,0x6a88,0x6a89,0x6a8a, /* 0x9960-0x9967 */
	0x6a8b,0x6a8c,0x6a8d,0x6a8f,0x6a92,0x6a93,0x6a94,0x6a95, /* 0x9968-0x996F */
	0x6a96,0x6a98,0x6a99,0x6a9a,0x6a9b,0x6a9c,0x6a9d,0x6a9e, /* 0x9970-0x9977 */
	0x6a9f,0x6aa1,0x6aa2,0x6aa3,0x6aa4,0x6aa5,0x6aa6,0x0000, /* 0x9978-0x997F */
	/* codebase=0x9980 rawbase=0x1300 */
	0x6aa7,0x6aa8,0x6aaa,0x6aad,0x6aae,0x6aaf,0x6ab0,0x6ab1, /* 0x9980-0x9987 */
	0x6ab2,0x6ab3,0x6ab4,0x6ab5,0x6ab6,0x6ab7,0x6ab8,0x6ab9, /* 0x9988-0x998F */
	0x6aba,0x6abb,0x6abc,0x6abd,0x6abe,0x6abf,0x6ac0,0x6ac1, /* 0x9990-0x9997 */
	0x6ac2,0x6ac3,0x6ac4,0x6ac5,0x6ac6,0x6ac7,0x6ac8,0x6ac9, /* 0x9998-0x999F */
	0x6aca,0x6acb,0x6acc,0x6acd,0x6ace,0x6acf,0x6ad0,0x6ad1, /* 0x99A0-0x99A7 */
	0x6ad2,0x6ad3,0x6ad4,0x6ad5,0x6ad6,0x6ad7,0x6ad8,0x6ad9, /* 0x99A8-0x99AF */
	0x6ada,0x6adb,0x6adc,0x6add,0x6ade,0x6adf,0x6ae0,0x6ae1, /* 0x99B0-0x99B7 */
	0x6ae2,0x6ae3,0x6ae4,0x6ae5,0x6ae6,0x6ae7,0x6ae8,0x6ae9, /* 0x99B8-0x99BF */
	/* codebase=0x99c0 rawbase=0x1340 */
	0x6aea,0x6aeb,0x6aec,0x6aed,0x6aee,0x6aef,0x6af0,0x6af1, /* 0x99C0-0x99C7 */
	0x6af2,0x6af3,0x6af4,0x6af5,0x6af6,0x6af7,0x6af8,0x6af9, /* 0x99C8-0x99CF */
	0x6afa,0x6afb,0x6afc,0x6afd,0x6afe,0x6aff,0x6b00,0x6b01, /* 0x99D0-0x99D7 */
	0x6b02,0x6b03,0x6b04,0x6b05,0x6b06,0x6b07,0x6b08,0x6b09, /* 0x99D8-0x99DF */
	0x6b0a,0x6b0b,0x6b0c,0x6b0d,0x6b0e,0x6b0f,0x6b10,0x6b11, /* 0x99E0-0x99E7 */
	0x6b12,0x6b13,0x6b14,0x6b15,0x6b16,0x6b17,0x6b18,0x6b19, /* 0x99E8-0x99EF */
	0x6b1a,0x6b1b,0x6b1c,0x6b1d,0x6b1e,0x6b1f,0x6b25,0x6b26, /* 0x99F0-0x99F7 */
	0x6b28,0x6b29,0x6b2a,0x6b2b,0x6b2c,0x6b2d,0x6b2e,0x0000, /* 0x99F8-0x99FF */
	/* codebase=0x9a40 rawbase=0x1380 */
	0x6b2f,0x6b30,0x6b31,0x6b33,0x6b34,0x6b35,0x6b36,0x6b38, /* 0x9A40-0x9A47 */
	0x6b3b,0x6b3c,0x6b3d,0x6b3f,0x6b40,0x6b41,0x6b42,0x6b44, /* 0x9A48-0x9A4F */
	0x6b45,0x6b48,0x6b4a,0x6b4b,0x6b4d,0x6b4e,0x6b4f,0x6b50, /* 0x9A50-0x9A57 */
	0x6b51,0x6b52,0x6b53,0x6b54,0x6b55,0x6b56,0x6b57,0x6b58, /* 0x9A58-0x9A5F */
	0x6b5a,0x6b5b,0x6b5c,0x6b5d,0x6b5e,0x6b5f,0x6b60,0x6b61, /* 0x9A60-0x9A67 */
	0x6b68,0x6b69,0x6b6b,0x6b6c,0x6b6d,0x6b6e,0x6b6f,0x6b70, /* 0x9A68-0x9A6F */
	0x6b71,0x6b72,0x6b73,0x6b74,0x6b75,0x6b76,0x6b77,0x6b78, /* 0x9A70-0x9A77 */
	0x6b7a,0x6b7d,0x6b7e,0x6b7f,0x6b80,0x6b85,0x6b88,0x0000, /* 0x9A78-0x9A7F */
	/* codebase=0x9a80 rawbase=0x13c0 */
	0x6b8c,0x6b8e,0x6b8f,0x6b90,0x6b91,0x6b94,0x6b95,0x6b97, /* 0x9A80-0x9A87 */
	0x6b98,0x6b99,0x6b9c,0x6b9d,0x6b9e,0x6b9f,0x6ba0,0x6ba2, /* 0x9A88-0x9A8F */
	0x6ba3,0x6ba4,0x6ba5,0x6ba6,0x6ba7,0x6ba8,0x6ba9,0x6bab, /* 0x9A90-0x9A97 */
	0x6bac,0x6bad,0x6bae,0x6baf,0x6bb0,0x6bb1,0x6bb2,0x6bb6, /* 0x9A98-0x9A9F */
	0x6bb8,0x6bb9,0x6bba,0x6bbb,0x6bbc,0x6bbd,0x6bbe,0x6bc0, /* 0x9AA0-0x9AA7 */
	0x6bc3,0x6bc4,0x6bc6,0x6bc7,0x6bc8,0x6bc9,0x6bca,0x6bcc, /* 0x9AA8-0x9AAF */
	0x6bce,0x6bd0,0x6bd1,0x6bd8,0x6bda,0x6bdc,0x6bdd,0x6bde, /* 0x9AB0-0x9AB7 */
	0x6bdf,0x6be0,0x6be2,0x6be3,0x6be4,0x6be5,0x6be6,0x6be7, /* 0x9AB8-0x9ABF */
	/* codebase=0x9ac0 rawbase=0x1400 */
	0x6be8,0x6be9,0x6bec,0x6bed,0x6bee,0x6bf0,0x6bf1,0x6bf2, /* 0x9AC0-0x9AC7 */
	0x6bf4,0x6bf6,0x6bf7,0x6bf8,0x6bfa,0x6bfb,0x6bfc,0x6bfe, /* 0x9AC8-0x9ACF */
	0x6bff,0x6c00,0x6c01,0x6c02,0x6c03,0x6c04,0x6c08,0x6c09, /* 0x9AD0-0x9AD7 */
	0x6c0a,0x6c0b,0x6c0c,0x6c0e,0x6c12,0x6c17,0x6c1c,0x6c1d, /* 0x9AD8-0x9ADF */
	0x6c1e,0x6c20,0x6c23,0x6c25,0x6c2b,0x6c2c,0x6c2d,0x6c31, /* 0x9AE0-0x9AE7 */
	0x6c33,0x6c36,0x6c37,0x6c39,0x6c3a,0x6c3b,0x6c3c,0x6c3e, /* 0x9AE8-0x9AEF */
	0x6c3f,0x6c43,0x6c44,0x6c45,0x6c48,0x6c4b,0x6c4c,0x6c4d, /* 0x9AF0-0x9AF7 */
	0x6c4e,0x6c4f,0x6c51,0x6c52,0x6c53,0x6c56,0x6c58,0x0000, /* 0x9AF8-0x9AFF */
	/* codebase=0x9b40 rawbase=0x1440 */
	0x6c59,0x6c5a,0x6c62,0x6c63,0x6c65,0x6c66,0x6c67,0x6c6b, /* 0x9B40-0x9B47 */
	0x6c6c,0x6c6d,0x6c6e,0x6c6f,0x6c71,0x6c73,0x6c75,0x6c77, /* 0x9B48-0x9B4F */
	0x6c78,0x6c7a,0x6c7b,0x6c7c,0x6c7f,0x6c80,0x6c84,0x6c87, /* 0x9B50-0x9B57 */
	0x6c8a,0x6c8b,0x6c8d,0x6c8e,0x6c91,0x6c92,0x6c95,0x6c96, /* 0x9B58-0x9B5F */
	0x6c97,0x6c98,0x6c9a,0x6c9c,0x6c9d,0x6c9e,0x6ca0,0x6ca2, /* 0x9B60-0x9B67 */
	0x6ca8,0x6cac,0x6caf,0x6cb0,0x6cb4,0x6cb5,0x6cb6,0x6cb7, /* 0x9B68-0x9B6F */
	0x6cba,0x6cc0,0x6cc1,0x6cc2,0x6cc3,0x6cc6,0x6cc7,0x6cc8, /* 0x9B70-0x9B77 */
	0x6ccb,0x6ccd,0x6cce,0x6ccf,0x6cd1,0x6cd2,0x6cd8,0x0000, /* 0x9B78-0x9B7F */
	/* codebase=0x9b80 rawbase=0x1480 */
	0x6cd9,0x6cda,0x6cdc,0x6cdd,0x6cdf,0x6ce4,0x6ce6,0x6ce7, /* 0x9B80-0x9B87 */
	0x6ce9,0x6cec,0x6ced,0x6cf2,0x6cf4,0x6cf9,0x6cff,0x6d00, /* 0x9B88-0x9B8F */
	0x6d02,0x6d03,0x6d05,0x6d06,0x6d08,0x6d09,0x6d0a,0x6d0d, /* 0x9B90-0x9B97 */
	0x6d0f,0x6d10,0x6d11,0x6d13,0x6d14,0x6d15,0x6d16,0x6d18, /* 0x9B98-0x9B9F */
	0x6d1c,0x6d1d,0x6d1f,0x6d20,0x6d21,0x6d22,0x6d23,0x6d24, /* 0x9BA0-0x9BA7 */
	0x6d26,0x6d28,0x6d29,0x6d2c,0x6d2d,0x6d2f,0x6d30,0x6d34, /* 0x9BA8-0x9BAF */
	0x6d36,0x6d37,0x6d38,0x6d3a,0x6d3f,0x6d40,0x6d42,0x6d44, /* 0x9BB0-0x9BB7 */
	0x6d49,0x6d4c,0x6d50,0x6d55,0x6d56,0x6d57,0x6d58,0x6d5b, /* 0x9BB8-0x9BBF */
	/* codebase=0x9bc0 rawbase=0x14c0 */
	0x6d5d,0x6d5f,0x6d61,0x6d62,0x6d64,0x6d65,0x6d67,0x6d68, /* 0x9BC0-0x9BC7 */
	0x6d6b,0x6d6c,0x6d6d,0x6d70,0x6d71,0x6d72,0x6d73,0x6d75, /* 0x9BC8-0x9BCF */
	0x6d76,0x6d79,0x6d7a,0x6d7b,0x6d7d,0x6d7e,0x6d7f,0x6d80, /* 0x9BD0-0x9BD7 */
	0x6d81,0x6d83,0x6d84,0x6d86,0x6d87,0x6d8a,0x6d8b,0x6d8d, /* 0x9BD8-0x9BDF */
	0x6d8f,0x6d90,0x6d92,0x6d96,0x6d97,0x6d98,0x6d99,0x6d9a, /* 0x9BE0-0x9BE7 */
	0x6d9c,0x6da2,0x6da5,0x6dac,0x6dad,0x6db0,0x6db1,0x6db3, /* 0x9BE8-0x9BEF */
	0x6db4,0x6db6,0x6db7,0x6db9,0x6dba,0x6dbb,0x6dbc,0x6dbd, /* 0x9BF0-0x9BF7 */
	0x6dbe,0x6dc1,0x6dc2,0x6dc3,0x6dc8,0x6dc9,0x6dca,0x0000, /* 0x9BF8-0x9BFF */
	/* codebase=0x9c40 rawbase=0x1500 */
	0x6dcd,0x6dce,0x6dcf,0x6dd0,0x6dd2,0x6dd3,0x6dd4,0x6dd5, /* 0x9C40-0x9C47 */
	0x6dd7,0x6dda,0x6ddb,0x6ddc,0x6ddf,0x6de2,0x6de3,0x6de5, /* 0x9C48-0x9C4F */
	0x6de7,0x6de8,0x6de9,0x6dea,0x6ded,0x6def,0x6df0,0x6df2, /* 0x9C50-0x9C57 */
	0x6df4,0x6df5,0x6df6,0x6df8,0x6dfa,0x6dfd,0x6dfe,0x6dff, /* 0x9C58-0x9C5F */
	0x6e00,0x6e01,0x6e02,0x6e03,0x6e04,0x6e06,0x6e07,0x6e08, /* 0x9C60-0x9C67 */
	0x6e09,0x6e0b,0x6e0f,0x6e12,0x6e13,0x6e15,0x6e18,0x6e19, /* 0x9C68-0x9C6F */
	0x6e1b,0x6e1c,0x6e1e,0x6e1f,0x6e22,0x6e26,0x6e27,0x6e28, /* 0x9C70-0x9C77 */
	0x6e2a,0x6e2c,0x6e2e,0x6e30,0x6e31,0x6e33,0x6e35,0x0000, /* 0x9C78-0x9C7F */
	/* codebase=0x9c80 rawbase=0x1540 */
	0x6e36,0x6e37,0x6e39,0x6e3b,0x6e3c,0x6e3d,0x6e3e,0x6e3f, /* 0x9C80-0x9C87 */
	0x6e40,0x6e41,0x6e42,0x6e45,0x6e46,0x6e47,0x6e48,0x6e49, /* 0x9C88-0x9C8F */
	0x6e4a,0x6e4b,0x6e4c,0x6e4f,0x6e50,0x6e51,0x6e52,0x6e55, /* 0x9C90-0x9C97 */
	0x6e57,0x6e59,0x6e5a,0x6e5c,0x6e5d,0x6e5e,0x6e60,0x6e61, /* 0x9C98-0x9C9F */
	0x6e62,0x6e63,0x6e64,0x6e65,0x6e66,0x6e67,0x6e68,0x6e69, /* 0x9CA0-0x9CA7 */
	0x6e6a,0x6e6c,0x6e6d,0x6e6f,0x6e70,0x6e71,0x6e72,0x6e73, /* 0x9CA8-0x9CAF */
	0x6e74,0x6e75,0x6e76,0x6e77,0x6e78,0x6e79,0x6e7a,0x6e7b, /* 0x9CB0-0x9CB7 */
	0x6e7c,0x6e7d,0x6e80,0x6e81,0x6e82,0x6e84,0x6e87,0x6e88, /* 0x9CB8-0x9CBF */
	/* codebase=0x9cc0 rawbase=0x1580 */
	0x6e8a,0x6e8b,0x6e8c,0x6e8d,0x6e8e,0x6e91,0x6e92,0x6e93, /* 0x9CC0-0x9CC7 */
	0x6e94,0x6e95,0x6e96,0x6e97,0x6e99,0x6e9a,0x6e9b,0x6e9d, /* 0x9CC8-0x9CCF */
	0x6e9e,0x6ea0,0x6ea1,0x6ea3,0x6ea4,0x6ea6,0x6ea8,0x6ea9, /* 0x9CD0-0x9CD7 */
	0x6eab,0x6eac,0x6ead,0x6eae,0x6eb0,0x6eb3,0x6eb5,0x6eb8, /* 0x9CD8-0x9CDF */
	0x6eb9,0x6ebc,0x6ebe,0x6ebf,0x6ec0,0x6ec3,0x6ec4,0x6ec5, /* 0x9CE0-0x9CE7 */
	0x6ec6,0x6ec8,0x6ec9,0x6eca,0x6ecc,0x6ecd,0x6ece,0x6ed0, /* 0x9CE8-0x9CEF */
	0x6ed2,0x6ed6,0x6ed8,0x6ed9,0x6edb,0x6edc,0x6edd,0x6ee3, /* 0x9CF0-0x9CF7 */
	0x6ee7,0x6eea,0x6eeb,0x6eec,0x6eed,0x6eee,0x6eef,0x0000, /* 0x9CF8-0x9CFF */
	/* codebase=0x9d40 rawbase=0x15c0 */
	0x6ef0,0x6ef1,0x6ef2,0x6ef3,0x6ef5,0x6ef6,0x6ef7,0x6ef8, /* 0x9D40-0x9D47 */
	0x6efa,0x6efb,0x6efc,0x6efd,0x6efe,0x6eff,0x6f00,0x6f01, /* 0x9D48-0x9D4F */
	0x6f03,0x6f04,0x6f05,0x6f07,0x6f08,0x6f0a,0x6f0b,0x6f0c, /* 0x9D50-0x9D57 */
	0x6f0d,0x6f0e,0x6f10,0x6f11,0x6f12,0x6f16,0x6f17,0x6f18, /* 0x9D58-0x9D5F */
	0x6f19,0x6f1a,0x6f1b,0x6f1c,0x6f1d,0x6f1e,0x6f1f,0x6f21, /* 0x9D60-0x9D67 */
	0x6f22,0x6f23,0x6f25,0x6f26,0x6f27,0x6f28,0x6f2c,0x6f2e, /* 0x9D68-0x9D6F */
	0x6f30,0x6f32,0x6f34,0x6f35,0x6f37,0x6f38,0x6f39,0x6f3a, /* 0x9D70-0x9D77 */
	0x6f3b,0x6f3c,0x6f3d,0x6f3f,0x6f40,0x6f41,0x6f42,0x0000, /* 0x9D78-0x9D7F */
	/* codebase=0x9d80 rawbase=0x1600 */
	0x6f43,0x6f44,0x6f45,0x6f48,0x6f49,0x6f4a,0x6f4c,0x6f4e, /* 0x9D80-0x9D87 */
	0x6f4f,0x6f50,0x6f51,0x6f52,0x6f53,0x6f54,0x6f55,0x6f56, /* 0x9D88-0x9D8F */
	0x6f57,0x6f59,0x6f5a,0x6f5b,0x6f5d,0x6f5f,0x6f60,0x6f61, /* 0x9D90-0x9D97 */
	0x6f63,0x6f64,0x6f65,0x6f67,0x6f68,0x6f69,0x6f6a,0x6f6b, /* 0x9D98-0x9D9F */
	0x6f6c,0x6f6f,0x6f70,0x6f71,0x6f73,0x6f75,0x6f76,0x6f77, /* 0x9DA0-0x9DA7 */
	0x6f79,0x6f7b,0x6f7d,0x6f7e,0x6f7f,0x6f80,0x6f81,0x6f82, /* 0x9DA8-0x9DAF */
	0x6f83,0x6f85,0x6f86,0x6f87,0x6f8a,0x6f8b,0x6f8f,0x6f90, /* 0x9DB0-0x9DB7 */
	0x6f91,0x6f92,0x6f93,0x6f94,0x6f95,0x6f96,0x6f97,0x6f98, /* 0x9DB8-0x9DBF */
	/* codebase=0x9dc0 rawbase=0x1640 */
	0x6f99,0x6f9a,0x6f9b,0x6f9d,0x6f9e,0x6f9f,0x6fa0,0x6fa2, /* 0x9DC0-0x9DC7 */
	0x6fa3,0x6fa4,0x6fa5,0x6fa6,0x6fa8,0x6fa9,0x6faa,0x6fab, /* 0x9DC8-0x9DCF */
	0x6fac,0x6fad,0x6fae,0x6faf,0x6fb0,0x6fb1,0x6fb2,0x6fb4, /* 0x9DD0-0x9DD7 */
	0x6fb5,0x6fb7,0x6fb8,0x6fba,0x6fbb,0x6fbc,0x6fbd,0x6fbe, /* 0x9DD8-0x9DDF */
	0x6fbf,0x6fc1,0x6fc3,0x6fc4,0x6fc5,0x6fc6,0x6fc7,0x6fc8, /* 0x9DE0-0x9DE7 */
	0x6fca,0x6fcb,0x6fcc,0x6fcd,0x6fce,0x6fcf,0x6fd0,0x6fd3, /* 0x9DE8-0x9DEF */
	0x6fd4,0x6fd5,0x6fd6,0x6fd7,0x6fd8,0x6fd9,0x6fda,0x6fdb, /* 0x9DF0-0x9DF7 */
	0x6fdc,0x6fdd,0x6fdf,0x6fe2,0x6fe3,0x6fe4,0x6fe5,0x0000, /* 0x9DF8-0x9DFF */
	/* codebase=0x9e40 rawbase=0x1680 */
	0x6fe6,0x6fe7,0x6fe8,0x6fe9,0x6fea,0x6feb,0x6fec,0x6fed, /* 0x9E40-0x9E47 */
	0x6ff0,0x6ff1,0x6ff2,0x6ff3,0x6ff4,0x6ff5,0x6ff6,0x6ff7, /* 0x9E48-0x9E4F */
	0x6ff8,0x6ff9,0x6ffa,0x6ffb,0x6ffc,0x6ffd,0x6ffe,0x6fff, /* 0x9E50-0x9E57 */
	0x7000,0x7001,0x7002,0x7003,0x7004,0x7005,0x7006,0x7007, /* 0x9E58-0x9E5F */
	0x7008,0x7009,0x700a,0x700b,0x700c,0x700d,0x700e,0x700f, /* 0x9E60-0x9E67 */
	0x7010,0x7012,0x7013,0x7014,0x7015,0x7016,0x7017,0x7018, /* 0x9E68-0x9E6F */
	0x7019,0x701c,0x701d,0x701e,0x701f,0x7020,0x7021,0x7022, /* 0x9E70-0x9E77 */
	0x7024,0x7025,0x7026,0x7027,0x7028,0x7029,0x702a,0x0000, /* 0x9E78-0x9E7F */
	/* codebase=0x9e80 rawbase=0x16c0 */
	0x702b,0x702c,0x702d,0x702e,0x702f,0x7030,0x7031,0x7032, /* 0x9E80-0x9E87 */
	0x7033,0x7034,0x7036,0x7037,0x7038,0x703a,0x703b,0x703c, /* 0x9E88-0x9E8F */
	0x703d,0x703e,0x703f,0x7040,0x7041,0x7042,0x7043,0x7044, /* 0x9E90-0x9E97 */
	0x7045,0x7046,0x7047,0x7048,0x7049,0x704a,0x704b,0x704d, /* 0x9E98-0x9E9F */
	0x704e,0x7050,0x7051,0x7052,0x7053,0x7054,0x7055,0x7056, /* 0x9EA0-0x9EA7 */
	0x7057,0x7058,0x7059,0x705a,0x705b,0x705c,0x705d,0x705f, /* 0x9EA8-0x9EAF */
	0x7060,0x7061,0x7062,0x7063,0x7064,0x7065,0x7066,0x7067, /* 0x9EB0-0x9EB7 */
	0x7068,0x7069,0x706a,0x706e,0x7071,0x7072,0x7073,0x7074, /* 0x9EB8-0x9EBF */
	/* codebase=0x9ec0 rawbase=0x1700 */
	0x7077,0x7079,0x707a,0x707b,0x707d,0x7081,0x7082,0x7083, /* 0x9EC0-0x9EC7 */
	0x7084,0x7086,0x7087,0x7088,0x708b,0x708c,0x708d,0x708f, /* 0x9EC8-0x9ECF */
	0x7090,0x7091,0x7093,0x7097,0x7098,0x709a,0x709b,0x709e, /* 0x9ED0-0x9ED7 */
	0x709f,0x70a0,0x70a1,0x70a2,0x70a3,0x70a4,0x70a5,0x70a6, /* 0x9ED8-0x9EDF */
	0x70a7,0x70a8,0x70a9,0x70aa,0x70b0,0x70b2,0x70b4,0x70b5, /* 0x9EE0-0x9EE7 */
	0x70b6,0x70ba,0x70be,0x70bf,0x70c4,0x70c5,0x70c6,0x70c7, /* 0x9EE8-0x9EEF */
	0x70c9,0x70cb,0x70cc,0x70cd,0x70ce,0x70cf,0x70d0,0x70d1, /* 0x9EF0-0x9EF7 */
	0x70d2,0x70d3,0x70d4,0x70d5,0x70d6,0x70d7,0x70da,0x0000, /* 0x9EF8-0x9EFF */
	/* codebase=0x9f40 rawbase=0x1740 */
	0x70dc,0x70dd,0x70de,0x70e0,0x70e1,0x70e2,0x70e3,0x70e5, /* 0x9F40-0x9F47 */
	0x70ea,0x70ee,0x70f0,0x70f1,0x70f2,0x70f3,0x70f4,0x70f5, /* 0x9F48-0x9F4F */
	0x70f6,0x70f8,0x70fa,0x70fb,0x70fc,0x70fe,0x70ff,0x7100, /* 0x9F50-0x9F57 */
	0x7101,0x7102,0x7103,0x7104,0x7105,0x7106,0x7107,0x7108, /* 0x9F58-0x9F5F */
	0x710b,0x710c,0x710d,0x710e,0x710f,0x7111,0x7112,0x7114, /* 0x9F60-0x9F67 */
	0x7117,0x711b,0x711c,0x711d,0x711e,0x711f,0x7120,0x7121, /* 0x9F68-0x9F6F */
	0x7122,0x7123,0x7124,0x7125,0x7127,0x7128,0x7129,0x712a, /* 0x9F70-0x9F77 */
	0x712b,0x712c,0x712d,0x712e,0x7132,0x7133,0x7134,0x0000, /* 0x9F78-0x9F7F */
	/* codebase=0x9f80 rawbase=0x1780 */
	0x7135,0x7137,0x7138,0x7139,0x713a,0x713b,0x713c,0x713d, /* 0x9F80-0x9F87 */
	0x713e,0x713f,0x7140,0x7141,0x7142,0x7143,0x7144,0x7146, /* 0x9F88-0x9F8F */
	0x7147,0x7148,0x7149,0x714b,0x714d,0x714f,0x7150,0x7151, /* 0x9F90-0x9F97 */
	0x7152,0x7153,0x7154,0x7155,0x7156,0x7157,0x7158,0x7159, /* 0x9F98-0x9F9F */
	0x715a,0x715b,0x715d,0x715f,0x7160,0x7161,0x7162,0x7163, /* 0x9FA0-0x9FA7 */
	0x7165,0x7169,0x716a,0x716b,0x716c,0x716d,0x716f,0x7170, /* 0x9FA8-0x9FAF */
	0x7171,0x7174,0x7175,0x7176,0x7177,0x7179,0x717b,0x717c, /* 0x9FB0-0x9FB7 */
	0x717e,0x717f,0x7180,0x7181,0x7182,0x7183,0x7185,0x7186, /* 0x9FB8-0x9FBF */
	/* codebase=0x9fc0 rawbase=0x17c0 */
	0x7187,0x7188,0x7189,0x718b,0x718c,0x718d,0x718e,0x7190, /* 0x9FC0-0x9FC7 */
	0x7191,0x7192,0x7193,0x7195,0x7196,0x7197,0x719a,0x719b, /* 0x9FC8-0x9FCF */
	0x719c,0x719d,0x719e,0x71a1,0x71a2,0x71a3,0x71a4,0x71a5, /* 0x9FD0-0x9FD7 */
	0x71a6,0x71a7,0x71a9,0x71aa,0x71ab,0x71ad,0x71ae,0x71af, /* 0x9FD8-0x9FDF */
	0x71b0,0x71b1,0x71b2,0x71b4,0x71b6,0x71b7,0x71b8,0x71ba, /* 0x9FE0-0x9FE7 */
	0x71bb,0x71bc,0x71bd,0x71be,0x71bf,0x71c0,0x71c1,0x71c2, /* 0x9FE8-0x9FEF */
	0x71c4,0x71c5,0x71c6,0x71c7,0x71c8,0x71c9,0x71ca,0x71cb, /* 0x9FF0-0x9FF7 */
	0x71cc,0x71cd,0x71cf,0x71d0,0x71d1,0x71d2,0x71d3,0x0000, /* 0x9FF8-0x9FFF */
	/* codebase=0xa040 rawbase=0x1800 */
	0x71d6,0x71d7,0x71d8,0x71d9,0x71da,0x71db,0x71dc,0x71dd, /* 0xA040-0xA047 */
	0x71de,0x71df,0x71e1,0x71e2,0x71e3,0x71e4,0x71e6,0x71e8, /* 0xA048-0xA04F */
	0x71e9,0x71ea,0x71eb,0x71ec,0x71ed,0x71ef,0x71f0,0x71f1, /* 0xA050-0xA057 */
	0x71f2,0x71f3,0x71f4,0x71f5,0x71f6,0x71f7,0x71f8,0x71fa, /* 0xA058-0xA05F */
	0x71fb,0x71fc,0x71fd,0x71fe,0x71ff,0x7200,0x7201,0x7202, /* 0xA060-0xA067 */
	0x7203,0x7204,0x7205,0x7207,0x7208,0x7209,0x720a,0x720b, /* 0xA068-0xA06F */
	0x720c,0x720d,0x720e,0x720f,0x7210,0x7211,0x7212,0x7213, /* 0xA070-0xA077 */
	0x7214,0x7215,0x7216,0x7217,0x7218,0x7219,0x721a,0x0000, /* 0xA078-0xA07F */
	/* codebase=0xa080 rawbase=0x1840 */
	0x721b,0x721c,0x721e,0x721f,0x7220,0x7221,0x7222,0x7223, /* 0xA080-0xA087 */
	0x7224,0x7225,0x7226,0x7227,0x7229,0x722b,0x722d,0x722e, /* 0xA088-0xA08F */
	0x722f,0x7232,0x7233,0x7234,0x723a,0x723c,0x723e,0x7240, /* 0xA090-0xA097 */
	0x7241,0x7242,0x7243,0x7244,0x7245,0x7246,0x7249,0x724a, /* 0xA098-0xA09F */
	0x724b,0x724e,0x724f,0x7250,0x7251,0x7253,0x7254,0x7255, /* 0xA0A0-0xA0A7 */
	0x7257,0x7258,0x725a,0x725c,0x725e,0x7260,0x7263,0x7264, /* 0xA0A8-0xA0AF */
	0x7265,0x7268,0x726a,0x726b,0x726c,0x726d,0x7270,0x7271, /* 0xA0B0-0xA0B7 */
	0x7273,0x7274,0x7276,0x7277,0x7278,0x727b,0x727c,0x727d, /* 0xA0B8-0xA0BF */
	/* codebase=0xa0c0 rawbase=0x1880 */
	0x7282,0x7283,0x7285,0x7286,0x7287,0x7288,0x7289,0x728c, /* 0xA0C0-0xA0C7 */
	0x728e,0x7290,0x7291,0x7293,0x7294,0x7295,0x7296,0x7297, /* 0xA0C8-0xA0CF */
	0x7298,0x7299,0x729a,0x729b,0x729c,0x729d,0x729e,0x72a0, /* 0xA0D0-0xA0D7 */
	0x72a1,0x72a2,0x72a3,0x72a4,0x72a5,0x72a6,0x72a7,0x72a8, /* 0xA0D8-0xA0DF */
	0x72a9,0x72aa,0x72ab,0x72ae,0x72b1,0x72b2,0x72b3,0x72b5, /* 0xA0E0-0xA0E7 */
	0x72ba,0x72bb,0x72bc,0x72bd,0x72be,0x72bf,0x72c0,0x72c5, /* 0xA0E8-0xA0EF */
	0x72c6,0x72c7,0x72c9,0x72ca,0x72cb,0x72cc,0x72cf,0x72d1, /* 0xA0F0-0xA0F7 */
	0x72d3,0x72d4,0x72d5,0x72d6,0x72d8,0x72da,0x72db,0x0000, /* 0xA0F8-0xA0FF */
	/* codebase=0xa180 rawbase=0x18c0 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA180-0xA187 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA188-0xA18F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA190-0xA197 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA198-0xA19F */
	0x0000,0x3000,0x3001,0x3002,0x00b7,0x02c9,0x02c7,0x00a8, /* 0xA1A0-0xA1A7 */
	0x3003,0x3005,0x2014,0xff5e,0x2016,0x2026,0x2018,0x2019, /* 0xA1A8-0xA1AF */
	0x201c,0x201d,0x3014,0x3015,0x3008,0x3009,0x300a,0x300b, /* 0xA1B0-0xA1B7 */
	0x300c,0x300d,0x300e,0x300f,0x3016,0x3017,0x3010,0x3011, /* 0xA1B8-0xA1BF */
	/* codebase=0xa1c0 rawbase=0x1900 */
	0x00b1,0x00d7,0x00f7,0x2236,0x2227,0x2228,0x2211,0x220f, /* 0xA1C0-0xA1C7 */
	0x222a,0x2229,0x2208,0x2237,0x221a,0x22a5,0x2225,0x2220, /* 0xA1C8-0xA1CF */
	0x2312,0x2299,0x222b,0x222e,0x2261,0x224c,0x2248,0x223d, /* 0xA1D0-0xA1D7 */
	0x221d,0x2260,0x226e,0x226f,0x2264,0x2265,0x221e,0x2235, /* 0xA1D8-0xA1DF */
	0x2234,0x2642,0x2640,0x00b0,0x2032,0x2033,0x2103,0xff04, /* 0xA1E0-0xA1E7 */
	0x00a4,0xffe0,0xffe1,0x2030,0x00a7,0x2116,0x2606,0x2605, /* 0xA1E8-0xA1EF */
	0x25cb,0x25cf,0x25ce,0x25c7,0x25c6,0x25a1,0x25a0,0x25b3, /* 0xA1F0-0xA1F7 */
	0x25b2,0x203b,0x2192,0x2190,0x2191,0x2193,0x3013,0x0000, /* 0xA1F8-0xA1FF */
	/* codebase=0xa280 rawbase=0x1940 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA280-0xA287 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA288-0xA28F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA290-0xA297 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA298-0xA29F */
	0x0000,0x2170,0x2171,0x2172,0x2173,0x2174,0x2175,0x2176, /* 0xA2A0-0xA2A7 */
	0x2177,0x2178,0x2179,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA2A8-0xA2AF */
	0x0000,0x2488,0x2489,0x248a,0x248b,0x248c,0x248d,0x248e, /* 0xA2B0-0xA2B7 */
	0x248f,0x2490,0x2491,0x2492,0x2493,0x2494,0x2495,0x2496, /* 0xA2B8-0xA2BF */
	/* codebase=0xa2c0 rawbase=0x1980 */
	0x2497,0x2498,0x2499,0x249a,0x249b,0x2474,0x2475,0x2476, /* 0xA2C0-0xA2C7 */
	0x2477,0x2478,0x2479,0x247a,0x247b,0x247c,0x247d,0x247e, /* 0xA2C8-0xA2CF */
	0x247f,0x2480,0x2481,0x2482,0x2483,0x2484,0x2485,0x2486, /* 0xA2D0-0xA2D7 */
	0x2487,0x2460,0x2461,0x2462,0x2463,0x2464,0x2465,0x2466, /* 0xA2D8-0xA2DF */
	0x2467,0x2468,0x2469,0x0000,0x0000,0x3220,0x3221,0x3222, /* 0xA2E0-0xA2E7 */
	0x3223,0x3224,0x3225,0x3226,0x3227,0x3228,0x3229,0x0000, /* 0xA2E8-0xA2EF */
	0x0000,0x2160,0x2161,0x2162,0x2163,0x2164,0x2165,0x2166, /* 0xA2F0-0xA2F7 */
	0x2167,0x2168,0x2169,0x216a,0x216b,0x0000,0x0000,0x0000, /* 0xA2F8-0xA2FF */
	/* codebase=0xa380 rawbase=0x19c0 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA380-0xA387 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA388-0xA38F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA390-0xA397 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA398-0xA39F */
	0x0000,0xff01,0xff02,0xff03,0xffe5,0xff05,0xff06,0xff07, /* 0xA3A0-0xA3A7 */
	0xff08,0xff09,0xff0a,0xff0b,0xff0c,0xff0d,0xff0e,0xff0f, /* 0xA3A8-0xA3AF */
	0xff10,0xff11,0xff12,0xff13,0xff14,0xff15,0xff16,0xff17, /* 0xA3B0-0xA3B7 */
	0xff18,0xff19,0xff1a,0xff1b,0xff1c,0xff1d,0xff1e,0xff1f, /* 0xA3B8-0xA3BF */
	/* codebase=0xa3c0 rawbase=0x1a00 */
	0xff20,0xff21,0xff22,0xff23,0xff24,0xff25,0xff26,0xff27, /* 0xA3C0-0xA3C7 */
	0xff28,0xff29,0xff2a,0xff2b,0xff2c,0xff2d,0xff2e,0xff2f, /* 0xA3C8-0xA3CF */
	0xff30,0xff31,0xff32,0xff33,0xff34,0xff35,0xff36,0xff37, /* 0xA3D0-0xA3D7 */
	0xff38,0xff39,0xff3a,0xff3b,0xff3c,0xff3d,0xff3e,0xff3f, /* 0xA3D8-0xA3DF */
	0xff40,0xff41,0xff42,0xff43,0xff44,0xff45,0xff46,0xff47, /* 0xA3E0-0xA3E7 */
	0xff48,0xff49,0xff4a,0xff4b,0xff4c,0xff4d,0xff4e,0xff4f, /* 0xA3E8-0xA3EF */
	0xff50,0xff51,0xff52,0xff53,0xff54,0xff55,0xff56,0xff57, /* 0xA3F0-0xA3F7 */
	0xff58,0xff59,0xff5a,0xff5b,0xff5c,0xff5d,0xffe3,0x0000, /* 0xA3F8-0xA3FF */
	/* codebase=0xa480 rawbase=0x1a40 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA480-0xA487 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA488-0xA48F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA490-0xA497 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA498-0xA49F */
	0x0000,0x3041,0x3042,0x3043,0x3044,0x3045,0x3046,0x3047, /* 0xA4A0-0xA4A7 */
	0x3048,0x3049,0x304a,0x304b,0x304c,0x304d,0x304e,0x304f, /* 0xA4A8-0xA4AF */
	0x3050,0x3051,0x3052,0x3053,0x3054,0x3055,0x3056,0x3057, /* 0xA4B0-0xA4B7 */
	0x3058,0x3059,0x305a,0x305b,0x305c,0x305d,0x305e,0x305f, /* 0xA4B8-0xA4BF */
	/* codebase=0xa4c0 rawbase=0x1a80 */
	0x3060,0x3061,0x3062,0x3063,0x3064,0x3065,0x3066,0x3067, /* 0xA4C0-0xA4C7 */
	0x3068,0x3069,0x306a,0x306b,0x306c,0x306d,0x306e,0x306f, /* 0xA4C8-0xA4CF */
	0x3070,0x3071,0x3072,0x3073,0x3074,0x3075,0x3076,0x3077, /* 0xA4D0-0xA4D7 */
	0x3078,0x3079,0x307a,0x307b,0x307c,0x307d,0x307e,0x307f, /* 0xA4D8-0xA4DF */
	0x3080,0x3081,0x3082,0x3083,0x3084,0x3085,0x3086,0x3087, /* 0xA4E0-0xA4E7 */
	0x3088,0x3089,0x308a,0x308b,0x308c,0x308d,0x308e,0x308f, /* 0xA4E8-0xA4EF */
	0x3090,0x3091,0x3092,0x3093,0x0000,0x0000,0x0000,0x0000, /* 0xA4F0-0xA4F7 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA4F8-0xA4FF */
	/* codebase=0xa580 rawbase=0x1ac0 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA580-0xA587 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA588-0xA58F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA590-0xA597 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA598-0xA59F */
	0x0000,0x30a1,0x30a2,0x30a3,0x30a4,0x30a5,0x30a6,0x30a7, /* 0xA5A0-0xA5A7 */
	0x30a8,0x30a9,0x30aa,0x30ab,0x30ac,0x30ad,0x30ae,0x30af, /* 0xA5A8-0xA5AF */
	0x30b0,0x30b1,0x30b2,0x30b3,0x30b4,0x30b5,0x30b6,0x30b7, /* 0xA5B0-0xA5B7 */
	0x30b8,0x30b9,0x30ba,0x30bb,0x30bc,0x30bd,0x30be,0x30bf, /* 0xA5B8-0xA5BF */
	/* codebase=0xa5c0 rawbase=0x1b00 */
	0x30c0,0x30c1,0x30c2,0x30c3,0x30c4,0x30c5,0x30c6,0x30c7, /* 0xA5C0-0xA5C7 */
	0x30c8,0x30c9,0x30ca,0x30cb,0x30cc,0x30cd,0x30ce,0x30cf, /* 0xA5C8-0xA5CF */
	0x30d0,0x30d1,0x30d2,0x30d3,0x30d4,0x30d5,0x30d6,0x30d7, /* 0xA5D0-0xA5D7 */
	0x30d8,0x30d9,0x30da,0x30db,0x30dc,0x30dd,0x30de,0x30df, /* 0xA5D8-0xA5DF */
	0x30e0,0x30e1,0x30e2,0x30e3,0x30e4,0x30e5,0x30e6,0x30e7, /* 0xA5E0-0xA5E7 */
	0x30e8,0x30e9,0x30ea,0x30eb,0x30ec,0x30ed,0x30ee,0x30ef, /* 0xA5E8-0xA5EF */
	0x30f0,0x30f1,0x30f2,0x30f3,0x30f4,0x30f5,0x30f6,0x0000, /* 0xA5F0-0xA5F7 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA5F8-0xA5FF */
	/* codebase=0xa680 rawbase=0x1b40 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA680-0xA687 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA688-0xA68F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA690-0xA697 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA698-0xA69F */
	0x0000,0x0391,0x0392,0x0393,0x0394,0x0395,0x0396,0x0397, /* 0xA6A0-0xA6A7 */
	0x0398,0x0399,0x039a,0x039b,0x039c,0x039d,0x039e,0x039f, /* 0xA6A8-0xA6AF */
	0x03a0,0x03a1,0x03a3,0x03a4,0x03a5,0x03a6,0x03a7,0x03a8, /* 0xA6B0-0xA6B7 */
	0x03a9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA6B8-0xA6BF */
	/* codebase=0xa6c0 rawbase=0x1b80 */
	0x0000,0x03b1,0x03b2,0x03b3,0x03b4,0x03b5,0x03b6,0x03b7, /* 0xA6C0-0xA6C7 */
	0x03b8,0x03b9,0x03ba,0x03bb,0x03bc,0x03bd,0x03be,0x03bf, /* 0xA6C8-0xA6CF */
	0x03c0,0x03c1,0x03c3,0x03c4,0x03c5,0x03c6,0x03c7,0x03c8, /* 0xA6D0-0xA6D7 */
	0x03c9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA6D8-0xA6DF */
	0xfe35,0xfe36,0xfe39,0xfe3a,0xfe3f,0xfe40,0xfe3d,0xfe3e, /* 0xA6E0-0xA6E7 */
	0xfe41,0xfe42,0xfe43,0xfe44,0x0000,0x0000,0xfe3b,0xfe3c, /* 0xA6E8-0xA6EF */
	0xfe37,0xfe38,0xfe31,0x0000,0xfe33,0xfe34,0x0000,0x0000, /* 0xA6F0-0xA6F7 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA6F8-0xA6FF */
	/* codebase=0xa780 rawbase=0x1bc0 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA780-0xA787 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA788-0xA78F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA790-0xA797 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA798-0xA79F */
	0x0000,0x0410,0x0411,0x0412,0x0413,0x0414,0x0415,0x0401, /* 0xA7A0-0xA7A7 */
	0x0416,0x0417,0x0418,0x0419,0x041a,0x041b,0x041c,0x041d, /* 0xA7A8-0xA7AF */
	0x041e,0x041f,0x0420,0x0421,0x0422,0x0423,0x0424,0x0425, /* 0xA7B0-0xA7B7 */
	0x0426,0x0427,0x0428,0x0429,0x042a,0x042b,0x042c,0x042d, /* 0xA7B8-0xA7BF */
	/* codebase=0xa7c0 rawbase=0x1c00 */
	0x042e,0x042f,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA7C0-0xA7C7 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA7C8-0xA7CF */
	0x0000,0x0430,0x0431,0x0432,0x0433,0x0434,0x0435,0x0451, /* 0xA7D0-0xA7D7 */
	0x0436,0x0437,0x0438,0x0439,0x043a,0x043b,0x043c,0x043d, /* 0xA7D8-0xA7DF */
	0x043e,0x043f,0x0440,0x0441,0x0442,0x0443,0x0444,0x0445, /* 0xA7E0-0xA7E7 */
	0x0446,0x0447,0x0448,0x0449,0x044a,0x044b,0x044c,0x044d, /* 0xA7E8-0xA7EF */
	0x044e,0x044f,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA7F0-0xA7F7 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA7F8-0xA7FF */
	/* codebase=0xa840 rawbase=0x1c40 */
	0x02ca,0x02cb,0x02d9,0x2013,0x2015,0x2025,0x2035,0x2105, /* 0xA840-0xA847 */
	0x2109,0x2196,0x2197,0x2198,0x2199,0x2215,0x221f,0x2223, /* 0xA848-0xA84F */
	0x2252,0x2266,0x2267,0x22bf,0x2550,0x2551,0x2552,0x2553, /* 0xA850-0xA857 */
	0x2554,0x2555,0x2556,0x2557,0x2558,0x2559,0x255a,0x255b, /* 0xA858-0xA85F */
	0x255c,0x255d,0x255e,0x255f,0x2560,0x2561,0x2562,0x2563, /* 0xA860-0xA867 */
	0x2564,0x2565,0x2566,0x2567,0x2568,0x2569,0x256a,0x256b, /* 0xA868-0xA86F */
	0x256c,0x256d,0x256e,0x256f,0x2570,0x2571,0x2572,0x2573, /* 0xA870-0xA877 */
	0x2581,0x2582,0x2583,0x2584,0x2585,0x2586,0x2587,0x0000, /* 0xA878-0xA87F */
	/* codebase=0xa880 rawbase=0x1c80 */
	0x2588,0x2589,0x258a,0x258b,0x258c,0x258d,0x258e,0x258f, /* 0xA880-0xA887 */
	0x2593,0x2594,0x2595,0x25bc,0x25bd,0x25e2,0x25e3,0x25e4, /* 0xA888-0xA88F */
	0x25e5,0x2609,0x2295,0x3012,0x301d,0x301e,0x0000,0x0000, /* 0xA890-0xA897 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA898-0xA89F */
	0x0000,0x0101,0x00e1,0x01ce,0x00e0,0x0113,0x00e9,0x011b, /* 0xA8A0-0xA8A7 */
	0x00e8,0x012b,0x00ed,0x01d0,0x00ec,0x014d,0x00f3,0x01d2, /* 0xA8A8-0xA8AF */
	0x00f2,0x016b,0x00fa,0x01d4,0x00f9,0x01d6,0x01d8,0x01da, /* 0xA8B0-0xA8B7 */
	0x01dc,0x00fc,0x00ea,0x0251,0x0000,0x0144,0x0148,0x0000, /* 0xA8B8-0xA8BF */
	/* codebase=0xa8c0 rawbase=0x1cc0 */
	0x0261,0x0000,0x0000,0x0000,0x0000,0x3105,0x3106,0x3107, /* 0xA8C0-0xA8C7 */
	0x3108,0x3109,0x310a,0x310b,0x310c,0x310d,0x310e,0x310f, /* 0xA8C8-0xA8CF */
	0x3110,0x3111,0x3112,0x3113,0x3114,0x3115,0x3116,0x3117, /* 0xA8D0-0xA8D7 */
	0x3118,0x3119,0x311a,0x311b,0x311c,0x311d,0x311e,0x311f, /* 0xA8D8-0xA8DF */
	0x3120,0x3121,0x3122,0x3123,0x3124,0x3125,0x3126,0x3127, /* 0xA8E0-0xA8E7 */
	0x3128,0x3129,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA8E8-0xA8EF */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA8F0-0xA8F7 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA8F8-0xA8FF */
	/* codebase=0xa940 rawbase=0x1d00 */
	0x3021,0x3022,0x3023,0x3024,0x3025,0x3026,0x3027,0x3028, /* 0xA940-0xA947 */
	0x3029,0x32a3,0x338e,0x338f,0x339c,0x339d,0x339e,0x33a1, /* 0xA948-0xA94F */
	0x33c4,0x33ce,0x33d1,0x33d2,0x33d5,0xfe30,0xffe2,0xffe4, /* 0xA950-0xA957 */
	0x0000,0x2121,0x3231,0x0000,0x2010,0x0000,0x0000,0x0000, /* 0xA958-0xA95F */
	0x30fc,0x309b,0x309c,0x30fd,0x30fe,0x3006,0x309d,0x309e, /* 0xA960-0xA967 */
	0xfe49,0xfe4a,0xfe4b,0xfe4c,0xfe4d,0xfe4e,0xfe4f,0xfe50, /* 0xA968-0xA96F */
	0xfe51,0xfe52,0xfe54,0xfe55,0xfe56,0xfe57,0xfe59,0xfe5a, /* 0xA970-0xA977 */
	0xfe5b,0xfe5c,0xfe5d,0xfe5e,0xfe5f,0xfe60,0xfe61,0x0000, /* 0xA978-0xA97F */
	/* codebase=0xa980 rawbase=0x1d40 */
	0xfe62,0xfe63,0xfe64,0xfe65,0xfe66,0xfe68,0xfe69,0xfe6a, /* 0xA980-0xA987 */
	0xfe6b,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA988-0xA98F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3007,0x0000, /* 0xA990-0xA997 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA998-0xA99F */
	0x0000,0x0000,0x0000,0x0000,0x2500,0x2501,0x2502,0x2503, /* 0xA9A0-0xA9A7 */
	0x2504,0x2505,0x2506,0x2507,0x2508,0x2509,0x250a,0x250b, /* 0xA9A8-0xA9AF */
	0x250c,0x250d,0x250e,0x250f,0x2510,0x2511,0x2512,0x2513, /* 0xA9B0-0xA9B7 */
	0x2514,0x2515,0x2516,0x2517,0x2518,0x2519,0x251a,0x251b, /* 0xA9B8-0xA9BF */
	/* codebase=0xa9c0 rawbase=0x1d80 */
	0x251c,0x251d,0x251e,0x251f,0x2520,0x2521,0x2522,0x2523, /* 0xA9C0-0xA9C7 */
	0x2524,0x2525,0x2526,0x2527,0x2528,0x2529,0x252a,0x252b, /* 0xA9C8-0xA9CF */
	0x252c,0x252d,0x252e,0x252f,0x2530,0x2531,0x2532,0x2533, /* 0xA9D0-0xA9D7 */
	0x2534,0x2535,0x2536,0x2537,0x2538,0x2539,0x253a,0x253b, /* 0xA9D8-0xA9DF */
	0x253c,0x253d,0x253e,0x253f,0x2540,0x2541,0x2542,0x2543, /* 0xA9E0-0xA9E7 */
	0x2544,0x2545,0x2546,0x2547,0x2548,0x2549,0x254a,0x254b, /* 0xA9E8-0xA9EF */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA9F0-0xA9F7 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA9F8-0xA9FF */
	/* codebase=0xaa40 rawbase=0x1dc0 */
	0x72dc,0x72dd,0x72df,0x72e2,0x72e3,0x72e4,0x72e5,0x72e6, /* 0xAA40-0xAA47 */
	0x72e7,0x72ea,0x72eb,0x72f5,0x72f6,0x72f9,0x72fd,0x72fe, /* 0xAA48-0xAA4F */
	0x72ff,0x7300,0x7302,0x7304,0x7305,0x7306,0x7307,0x7308, /* 0xAA50-0xAA57 */
	0x7309,0x730b,0x730c,0x730d,0x730f,0x7310,0x7311,0x7312, /* 0xAA58-0xAA5F */
	0x7314,0x7318,0x7319,0x731a,0x731f,0x7320,0x7323,0x7324, /* 0xAA60-0xAA67 */
	0x7326,0x7327,0x7328,0x732d,0x732f,0x7330,0x7332,0x7333, /* 0xAA68-0xAA6F */
	0x7335,0x7336,0x733a,0x733b,0x733c,0x733d,0x7340,0x7341, /* 0xAA70-0xAA77 */
	0x7342,0x7343,0x7344,0x7345,0x7346,0x7347,0x7348,0x0000, /* 0xAA78-0xAA7F */
	/* codebase=0xaa80 rawbase=0x1e00 */
	0x7349,0x734a,0x734b,0x734c,0x734e,0x734f,0x7351,0x7353, /* 0xAA80-0xAA87 */
	0x7354,0x7355,0x7356,0x7358,0x7359,0x735a,0x735b,0x735c, /* 0xAA88-0xAA8F */
	0x735d,0x735e,0x735f,0x7361,0x7362,0x7363,0x7364,0x7365, /* 0xAA90-0xAA97 */
	0x7366,0x7367,0x7368,0x7369,0x736a,0x736b,0x736e,0x7370, /* 0xAA98-0xAA9F */
	0x7371,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xAAA0-0xAAA7 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xAAA8-0xAAAF */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xAAB0-0xAAB7 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xAAB8-0xAABF */
	/* codebase=0xab40 rawbase=0x1e40 */
	0x7372,0x7373,0x7374,0x7375,0x7376,0x7377,0x7378,0x7379, /* 0xAB40-0xAB47 */
	0x737a,0x737b,0x737c,0x737d,0x737f,0x7380,0x7381,0x7382, /* 0xAB48-0xAB4F */
	0x7383,0x7385,0x7386,0x7388,0x738a,0x738c,0x738d,0x738f, /* 0xAB50-0xAB57 */
	0x7390,0x7392,0x7393,0x7394,0x7395,0x7397,0x7398,0x7399, /* 0xAB58-0xAB5F */
	0x739a,0x739c,0x739d,0x739e,0x73a0,0x73a1,0x73a3,0x73a4, /* 0xAB60-0xAB67 */
	0x73a5,0x73a6,0x73a7,0x73a8,0x73aa,0x73ac,0x73ad,0x73b1, /* 0xAB68-0xAB6F */
	0x73b4,0x73b5,0x73b6,0x73b8,0x73b9,0x73bc,0x73bd,0x73be, /* 0xAB70-0xAB77 */
	0x73bf,0x73c1,0x73c3,0x73c4,0x73c5,0x73c6,0x73c7,0x0000, /* 0xAB78-0xAB7F */
	/* codebase=0xab80 rawbase=0x1e80 */
	0x73cb,0x73cc,0x73ce,0x73d2,0x73d3,0x73d4,0x73d5,0x73d6, /* 0xAB80-0xAB87 */
	0x73d7,0x73d8,0x73da,0x73db,0x73dc,0x73dd,0x73df,0x73e1, /* 0xAB88-0xAB8F */
	0x73e2,0x73e3,0x73e4,0x73e6,0x73e8,0x73ea,0x73eb,0x73ec, /* 0xAB90-0xAB97 */
	0x73ee,0x73ef,0x73f0,0x73f1,0x73f3,0x73f4,0x73f5,0x73f6, /* 0xAB98-0xAB9F */
	0x73f7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xABA0-0xABA7 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xABA8-0xABAF */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xABB0-0xABB7 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xABB8-0xABBF */
	/* codebase=0xac40 rawbase=0x1ec0 */
	0x73f8,0x73f9,0x73fa,0x73fb,0x73fc,0x73fd,0x73fe,0x73ff, /* 0xAC40-0xAC47 */
	0x7400,0x7401,0x7402,0x7404,0x7407,0x7408,0x740b,0x740c, /* 0xAC48-0xAC4F */
	0x740d,0x740e,0x7411,0x7412,0x7413,0x7414,0x7415,0x7416, /* 0xAC50-0xAC57 */
	0x7417,0x7418,0x7419,0x741c,0x741d,0x741e,0x741f,0x7420, /* 0xAC58-0xAC5F */
	0x7421,0x7423,0x7424,0x7427,0x7429,0x742b,0x742d,0x742f, /* 0xAC60-0xAC67 */
	0x7431,0x7432,0x7437,0x7438,0x7439,0x743a,0x743b,0x743d, /* 0xAC68-0xAC6F */
	0x743e,0x743f,0x7440,0x7442,0x7443,0x7444,0x7445,0x7446, /* 0xAC70-0xAC77 */
	0x7447,0x7448,0x7449,0x744a,0x744b,0x744c,0x744d,0x0000, /* 0xAC78-0xAC7F */
	/* codebase=0xac80 rawbase=0x1f00 */
	0x744e,0x744f,0x7450,0x7451,0x7452,0x7453,0x7454,0x7456, /* 0xAC80-0xAC87 */
	0x7458,0x745d,0x7460,0x7461,0x7462,0x7463,0x7464,0x7465, /* 0xAC88-0xAC8F */
	0x7466,0x7467,0x7468,0x7469,0x746a,0x746b,0x746c,0x746e, /* 0xAC90-0xAC97 */
	0x746f,0x7471,0x7472,0x7473,0x7474,0x7475,0x7478,0x7479, /* 0xAC98-0xAC9F */
	0x747a,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xACA0-0xACA7 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xACA8-0xACAF */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xACB0-0xACB7 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xACB8-0xACBF */
	/* codebase=0xad40 rawbase=0x1f40 */
	0x747b,0x747c,0x747d,0x747f,0x7482,0x7484,0x7485,0x7486, /* 0xAD40-0xAD47 */
	0x7488,0x7489,0x748a,0x748c,0x748d,0x748f,0x7491,0x7492, /* 0xAD48-0xAD4F */
	0x7493,0x7494,0x7495,0x7496,0x7497,0x7498,0x7499,0x749a, /* 0xAD50-0xAD57 */
	0x749b,0x749d,0x749f,0x74a0,0x74a1,0x74a2,0x74a3,0x74a4, /* 0xAD58-0xAD5F */
	0x74a5,0x74a6,0x74aa,0x74ab,0x74ac,0x74ad,0x74ae,0x74af, /* 0xAD60-0xAD67 */
	0x74b0,0x74b1,0x74b2,0x74b3,0x74b4,0x74b5,0x74b6,0x74b7, /* 0xAD68-0xAD6F */
	0x74b8,0x74b9,0x74bb,0x74bc,0x74bd,0x74be,0x74bf,0x74c0, /* 0xAD70-0xAD77 */
	0x74c1,0x74c2,0x74c3,0x74c4,0x74c5,0x74c6,0x74c7,0x0000, /* 0xAD78-0xAD7F */
	/* codebase=0xad80 rawbase=0x1f80 */
	0x74c8,0x74c9,0x74ca,0x74cb,0x74cc,0x74cd,0x74ce,0x74cf, /* 0xAD80-0xAD87 */
	0x74d0,0x74d1,0x74d3,0x74d4,0x74d5,0x74d6,0x74d7,0x74d8, /* 0xAD88-0xAD8F */
	0x74d9,0x74da,0x74db,0x74dd,0x74df,0x74e1,0x74e5,0x74e7, /* 0xAD90-0xAD97 */
	0x74e8,0x74e9,0x74ea,0x74eb,0x74ec,0x74ed,0x74f0,0x74f1, /* 0xAD98-0xAD9F */
	0x74f2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xADA0-0xADA7 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xADA8-0xADAF */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xADB0-0xADB7 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xADB8-0xADBF */
	/* codebase=0xae40 rawbase=0x1fc0 */
	0x74f3,0x74f5,0x74f8,0x74f9,0x74fa,0x74fb,0x74fc,0x74fd, /* 0xAE40-0xAE47 */
	0x74fe,0x7500,0x7501,0x7502,0x7503,0x7505,0x7506,0x7507, /* 0xAE48-0xAE4F */
	0x7508,0x7509,0x750a,0x750b,0x750c,0x750e,0x7510,0x7512, /* 0xAE50-0xAE57 */
	0x7514,0x7515,0x7516,0x7517,0x751b,0x751d,0x751e,0x7520, /* 0xAE58-0xAE5F */
	0x7521,0x7522,0x7523,0x7524,0x7526,0x7527,0x752a,0x752e, /* 0xAE60-0xAE67 */
	0x7534,0x7536,0x7539,0x753c,0x753d,0x753f,0x7541,0x7542, /* 0xAE68-0xAE6F */
	0x7543,0x7544,0x7546,0x7547,0x7549,0x754a,0x754d,0x7550, /* 0xAE70-0xAE77 */
	0x7551,0x7552,0x7553,0x7555,0x7556,0x7557,0x7558,0x0000, /* 0xAE78-0xAE7F */
	/* codebase=0xae80 rawbase=0x2000 */
	0x755d,0x755e,0x755f,0x7560,0x7561,0x7562,0x7563,0x7564, /* 0xAE80-0xAE87 */
	0x7567,0x7568,0x7569,0x756b,0x756c,0x756d,0x756e,0x756f, /* 0xAE88-0xAE8F */
	0x7570,0x7571,0x7573,0x7575,0x7576,0x7577,0x757a,0x757b, /* 0xAE90-0xAE97 */
	0x757c,0x757d,0x757e,0x7580,0x7581,0x7582,0x7584,0x7585, /* 0xAE98-0xAE9F */
	0x7587,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xAEA0-0xAEA7 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xAEA8-0xAEAF */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xAEB0-0xAEB7 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xAEB8-0xAEBF */
	/* codebase=0xaf40 rawbase=0x2040 */
	0x7588,0x7589,0x758a,0x758c,0x758d,0x758e,0x7590,0x7593, /* 0xAF40-0xAF47 */
	0x7595,0x7598,0x759b,0x759c,0x759e,0x75a2,0x75a6,0x75a7, /* 0xAF48-0xAF4F */
	0x75a8,0x75a9,0x75aa,0x75ad,0x75b6,0x75b7,0x75ba,0x75bb, /* 0xAF50-0xAF57 */
	0x75bf,0x75c0,0x75c1,0x75c6,0x75cb,0x75cc,0x75ce,0x75cf, /* 0xAF58-0xAF5F */
	0x75d0,0x75d1,0x75d3,0x75d7,0x75d9,0x75da,0x75dc,0x75dd, /* 0xAF60-0xAF67 */
	0x75df,0x75e0,0x75e1,0x75e5,0x75e9,0x75ec,0x75ed,0x75ee, /* 0xAF68-0xAF6F */
	0x75ef,0x75f2,0x75f3,0x75f5,0x75f6,0x75f7,0x75f8,0x75fa, /* 0xAF70-0xAF77 */
	0x75fb,0x75fd,0x75fe,0x7602,0x7604,0x7606,0x7607,0x0000, /* 0xAF78-0xAF7F */
	/* codebase=0xaf80 rawbase=0x2080 */
	0x7608,0x7609,0x760b,0x760d,0x760e,0x760f,0x7611,0x7612, /* 0xAF80-0xAF87 */
	0x7613,0x7614,0x7616,0x761a,0x761c,0x761d,0x761e,0x7621, /* 0xAF88-0xAF8F */
	0x7623,0x7627,0x7628,0x762c,0x762e,0x762f,0x7631,0x7632, /* 0xAF90-0xAF97 */
	0x7636,0x7637,0x7639,0x763a,0x763b,0x763d,0x7641,0x7642, /* 0xAF98-0xAF9F */
	0x7644,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xAFA0-0xAFA7 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xAFA8-0xAFAF */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xAFB0-0xAFB7 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xAFB8-0xAFBF */
	/* codebase=0xb040 rawbase=0x20c0 */
	0x7645,0x7646,0x7647,0x7648,0x7649,0x764a,0x764b,0x764e, /* 0xB040-0xB047 */
	0x764f,0x7650,0x7651,0x7652,0x7653,0x7655,0x7657,0x7658, /* 0xB048-0xB04F */
	0x7659,0x765a,0x765b,0x765d,0x765f,0x7660,0x7661,0x7662, /* 0xB050-0xB057 */
	0x7664,0x7665,0x7666,0x7667,0x7668,0x7669,0x766a,0x766c, /* 0xB058-0xB05F */
	0x766d,0x766e,0x7670,0x7671,0x7672,0x7673,0x7674,0x7675, /* 0xB060-0xB067 */
	0x7676,0x7677,0x7679,0x767a,0x767c,0x767f,0x7680,0x7681, /* 0xB068-0xB06F */
	0x7683,0x7685,0x7689,0x768a,0x768c,0x768d,0x768f,0x7690, /* 0xB070-0xB077 */
	0x7692,0x7694,0x7695,0x7697,0x7698,0x769a,0x769b,0x0000, /* 0xB078-0xB07F */
	/* codebase=0xb080 rawbase=0x2100 */
	0x769c,0x769d,0x769e,0x769f,0x76a0,0x76a1,0x76a2,0x76a3, /* 0xB080-0xB087 */
	0x76a5,0x76a6,0x76a7,0x76a8,0x76a9,0x76aa,0x76ab,0x76ac, /* 0xB088-0xB08F */
	0x76ad,0x76af,0x76b0,0x76b3,0x76b5,0x76b6,0x76b7,0x76b8, /* 0xB090-0xB097 */
	0x76b9,0x76ba,0x76bb,0x76bc,0x76bd,0x76be,0x76c0,0x76c1, /* 0xB098-0xB09F */
	0x76c3,0x554a,0x963f,0x57c3,0x6328,0x54ce,0x5509,0x54c0, /* 0xB0A0-0xB0A7 */
	0x7691,0x764c,0x853c,0x77ee,0x827e,0x788d,0x7231,0x9698, /* 0xB0A8-0xB0AF */
	0x978d,0x6c28,0x5b89,0x4ffa,0x6309,0x6697,0x5cb8,0x80fa, /* 0xB0B0-0xB0B7 */
	0x6848,0x80ae,0x6602,0x76ce,0x51f9,0x6556,0x71ac,0x7ff1, /* 0xB0B8-0xB0BF */
	/* codebase=0xb0c0 rawbase=0x2140 */
	0x8884,0x50b2,0x5965,0x61ca,0x6fb3,0x82ad,0x634c,0x6252, /* 0xB0C0-0xB0C7 */
	0x53ed,0x5427,0x7b06,0x516b,0x75a4,0x5df4,0x62d4,0x8dcb, /* 0xB0C8-0xB0CF */
	0x9776,0x628a,0x8019,0x575d,0x9738,0x7f62,0x7238,0x767d, /* 0xB0D0-0xB0D7 */
	0x67cf,0x767e,0x6446,0x4f70,0x8d25,0x62dc,0x7a17,0x6591, /* 0xB0D8-0xB0DF */
	0x73ed,0x642c,0x6273,0x822c,0x9881,0x677f,0x7248,0x626e, /* 0xB0E0-0xB0E7 */
	0x62cc,0x4f34,0x74e3,0x534a,0x529e,0x7eca,0x90a6,0x5e2e, /* 0xB0E8-0xB0EF */
	0x6886,0x699c,0x8180,0x7ed1,0x68d2,0x78c5,0x868c,0x9551, /* 0xB0F0-0xB0F7 */
	0x508d,0x8c24,0x82de,0x80de,0x5305,0x8912,0x5265,0x0000, /* 0xB0F8-0xB0FF */
	/* codebase=0xb140 rawbase=0x2180 */
	0x76c4,0x76c7,0x76c9,0x76cb,0x76cc,0x76d3,0x76d5,0x76d9, /* 0xB140-0xB147 */
	0x76da,0x76dc,0x76dd,0x76de,0x76e0,0x76e1,0x76e2,0x76e3, /* 0xB148-0xB14F */
	0x76e4,0x76e6,0x76e7,0x76e8,0x76e9,0x76ea,0x76eb,0x76ec, /* 0xB150-0xB157 */
	0x76ed,0x76f0,0x76f3,0x76f5,0x76f6,0x76f7,0x76fa,0x76fb, /* 0xB158-0xB15F */
	0x76fd,0x76ff,0x7700,0x7702,0x7703,0x7705,0x7706,0x770a, /* 0xB160-0xB167 */
	0x770c,0x770e,0x770f,0x7710,0x7711,0x7712,0x7713,0x7714, /* 0xB168-0xB16F */
	0x7715,0x7716,0x7717,0x7718,0x771b,0x771c,0x771d,0x771e, /* 0xB170-0xB177 */
	0x7721,0x7723,0x7724,0x7725,0x7727,0x772a,0x772b,0x0000, /* 0xB178-0xB17F */
	/* codebase=0xb180 rawbase=0x21c0 */
	0x772c,0x772e,0x7730,0x7731,0x7732,0x7733,0x7734,0x7739, /* 0xB180-0xB187 */
	0x773b,0x773d,0x773e,0x773f,0x7742,0x7744,0x7745,0x7746, /* 0xB188-0xB18F */
	0x7748,0x7749,0x774a,0x774b,0x774c,0x774d,0x774e,0x774f, /* 0xB190-0xB197 */
	0x7752,0x7753,0x7754,0x7755,0x7756,0x7757,0x7758,0x7759, /* 0xB198-0xB19F */
	0x775c,0x8584,0x96f9,0x4fdd,0x5821,0x9971,0x5b9d,0x62b1, /* 0xB1A0-0xB1A7 */
	0x62a5,0x66b4,0x8c79,0x9c8d,0x7206,0x676f,0x7891,0x60b2, /* 0xB1A8-0xB1AF */
	0x5351,0x5317,0x8f88,0x80cc,0x8d1d,0x94a1,0x500d,0x72c8, /* 0xB1B0-0xB1B7 */
	0x5907,0x60eb,0x7119,0x88ab,0x5954,0x82ef,0x672c,0x7b28, /* 0xB1B8-0xB1BF */
	/* codebase=0xb1c0 rawbase=0x2200 */
	0x5d29,0x7ef7,0x752d,0x6cf5,0x8e66,0x8ff8,0x903c,0x9f3b, /* 0xB1C0-0xB1C7 */
	0x6bd4,0x9119,0x7b14,0x5f7c,0x78a7,0x84d6,0x853d,0x6bd5, /* 0xB1C8-0xB1CF */
	0x6bd9,0x6bd6,0x5e01,0x5e87,0x75f9,0x95ed,0x655d,0x5f0a, /* 0xB1D0-0xB1D7 */
	0x5fc5,0x8f9f,0x58c1,0x81c2,0x907f,0x965b,0x97ad,0x8fb9, /* 0xB1D8-0xB1DF */
	0x7f16,0x8d2c,0x6241,0x4fbf,0x53d8,0x535e,0x8fa8,0x8fa9, /* 0xB1E0-0xB1E7 */
	0x8fab,0x904d,0x6807,0x5f6a,0x8198,0x8868,0x9cd6,0x618b, /* 0xB1E8-0xB1EF */
	0x522b,0x762a,0x5f6c,0x658c,0x6fd2,0x6ee8,0x5bbe,0x6448, /* 0xB1F0-0xB1F7 */
	0x5175,0x51b0,0x67c4,0x4e19,0x79c9,0x997c,0x70b3,0x0000, /* 0xB1F8-0xB1FF */
	/* codebase=0xb240 rawbase=0x2240 */
	0x775d,0x775e,0x775f,0x7760,0x7764,0x7767,0x7769,0x776a, /* 0xB240-0xB247 */
	0x776d,0x776e,0x776f,0x7770,0x7771,0x7772,0x7773,0x7774, /* 0xB248-0xB24F */
	0x7775,0x7776,0x7777,0x7778,0x777a,0x777b,0x777c,0x7781, /* 0xB250-0xB257 */
	0x7782,0x7783,0x7786,0x7787,0x7788,0x7789,0x778a,0x778b, /* 0xB258-0xB25F */
	0x778f,0x7790,0x7793,0x7794,0x7795,0x7796,0x7797,0x7798, /* 0xB260-0xB267 */
	0x7799,0x779a,0x779b,0x779c,0x779d,0x779e,0x77a1,0x77a3, /* 0xB268-0xB26F */
	0x77a4,0x77a6,0x77a8,0x77ab,0x77ad,0x77ae,0x77af,0x77b1, /* 0xB270-0xB277 */
	0x77b2,0x77b4,0x77b6,0x77b7,0x77b8,0x77b9,0x77ba,0x0000, /* 0xB278-0xB27F */
	/* codebase=0xb280 rawbase=0x2280 */
	0x77bc,0x77be,0x77c0,0x77c1,0x77c2,0x77c3,0x77c4,0x77c5, /* 0xB280-0xB287 */
	0x77c6,0x77c7,0x77c8,0x77c9,0x77ca,0x77cb,0x77cc,0x77ce, /* 0xB288-0xB28F */
	0x77cf,0x77d0,0x77d1,0x77d2,0x77d3,0x77d4,0x77d5,0x77d6, /* 0xB290-0xB297 */
	0x77d8,0x77d9,0x77da,0x77dd,0x77de,0x77df,0x77e0,0x77e1, /* 0xB298-0xB29F */
	0x77e4,0x75c5,0x5e76,0x73bb,0x83e0,0x64ad,0x62e8,0x94b5, /* 0xB2A0-0xB2A7 */
	0x6ce2,0x535a,0x52c3,0x640f,0x94c2,0x7b94,0x4f2f,0x5e1b, /* 0xB2A8-0xB2AF */
	0x8236,0x8116,0x818a,0x6e24,0x6cca,0x9a73,0x6355,0x535c, /* 0xB2B0-0xB2B7 */
	0x54fa,0x8865,0x57e0,0x4e0d,0x5e03,0x6b65,0x7c3f,0x90e8, /* 0xB2B8-0xB2BF */
	/* codebase=0xb2c0 rawbase=0x22c0 */
	0x6016,0x64e6,0x731c,0x88c1,0x6750,0x624d,0x8d22,0x776c, /* 0xB2C0-0xB2C7 */
	0x8e29,0x91c7,0x5f69,0x83dc,0x8521,0x9910,0x53c2,0x8695, /* 0xB2C8-0xB2CF */
	0x6b8b,0x60ed,0x60e8,0x707f,0x82cd,0x8231,0x4ed3,0x6ca7, /* 0xB2D0-0xB2D7 */
	0x85cf,0x64cd,0x7cd9,0x69fd,0x66f9,0x8349,0x5395,0x7b56, /* 0xB2D8-0xB2DF */
	0x4fa7,0x518c,0x6d4b,0x5c42,0x8e6d,0x63d2,0x53c9,0x832c, /* 0xB2E0-0xB2E7 */
	0x8336,0x67e5,0x78b4,0x643d,0x5bdf,0x5c94,0x5dee,0x8be7, /* 0xB2E8-0xB2EF */
	0x62c6,0x67f4,0x8c7a,0x6400,0x63ba,0x8749,0x998b,0x8c17, /* 0xB2F0-0xB2F7 */
	0x7f20,0x94f2,0x4ea7,0x9610,0x98a4,0x660c,0x7316,0x0000, /* 0xB2F8-0xB2FF */
	/* codebase=0xb340 rawbase=0x2300 */
	0x77e6,0x77e8,0x77ea,0x77ef,0x77f0,0x77f1,0x77f2,0x77f4, /* 0xB340-0xB347 */
	0x77f5,0x77f7,0x77f9,0x77fa,0x77fb,0x77fc,0x7803,0x7804, /* 0xB348-0xB34F */
	0x7805,0x7806,0x7807,0x7808,0x780a,0x780b,0x780e,0x780f, /* 0xB350-0xB357 */
	0x7810,0x7813,0x7815,0x7819,0x781b,0x781e,0x7820,0x7821, /* 0xB358-0xB35F */
	0x7822,0x7824,0x7828,0x782a,0x782b,0x782e,0x782f,0x7831, /* 0xB360-0xB367 */
	0x7832,0x7833,0x7835,0x7836,0x783d,0x783f,0x7841,0x7842, /* 0xB368-0xB36F */
	0x7843,0x7844,0x7846,0x7848,0x7849,0x784a,0x784b,0x784d, /* 0xB370-0xB377 */
	0x784f,0x7851,0x7853,0x7854,0x7858,0x7859,0x785a,0x0000, /* 0xB378-0xB37F */
	/* codebase=0xb380 rawbase=0x2340 */
	0x785b,0x785c,0x785e,0x785f,0x7860,0x7861,0x7862,0x7863, /* 0xB380-0xB387 */
	0x7864,0x7865,0x7866,0x7867,0x7868,0x7869,0x786f,0x7870, /* 0xB388-0xB38F */
	0x7871,0x7872,0x7873,0x7874,0x7875,0x7876,0x7878,0x7879, /* 0xB390-0xB397 */
	0x787a,0x787b,0x787d,0x787e,0x787f,0x7880,0x7881,0x7882, /* 0xB398-0xB39F */
	0x7883,0x573a,0x5c1d,0x5e38,0x957f,0x507f,0x80a0,0x5382, /* 0xB3A0-0xB3A7 */
	0x655e,0x7545,0x5531,0x5021,0x8d85,0x6284,0x949e,0x671d, /* 0xB3A8-0xB3AF */
	0x5632,0x6f6e,0x5de2,0x5435,0x7092,0x8f66,0x626f,0x64a4, /* 0xB3B0-0xB3B7 */
	0x63a3,0x5f7b,0x6f88,0x90f4,0x81e3,0x8fb0,0x5c18,0x6668, /* 0xB3B8-0xB3BF */
	/* codebase=0xb3c0 rawbase=0x2380 */
	0x5ff1,0x6c89,0x9648,0x8d81,0x886c,0x6491,0x79f0,0x57ce, /* 0xB3C0-0xB3C7 */
	0x6a59,0x6210,0x5448,0x4e58,0x7a0b,0x60e9,0x6f84,0x8bda, /* 0xB3C8-0xB3CF */
	0x627f,0x901e,0x9a8b,0x79e4,0x5403,0x75f4,0x6301,0x5319, /* 0xB3D0-0xB3D7 */
	0x6c60,0x8fdf,0x5f1b,0x9a70,0x803b,0x9f7f,0x4f88,0x5c3a, /* 0xB3D8-0xB3DF */
	0x8d64,0x7fc5,0x65a5,0x70bd,0x5145,0x51b2,0x866b,0x5d07, /* 0xB3E0-0xB3E7 */
	0x5ba0,0x62bd,0x916c,0x7574,0x8e0c,0x7a20,0x6101,0x7b79, /* 0xB3E8-0xB3EF */
	0x4ec7,0x7ef8,0x7785,0x4e11,0x81ed,0x521d,0x51fa,0x6a71, /* 0xB3F0-0xB3F7 */
	0x53a8,0x8e87,0x9504,0x96cf,0x6ec1,0x9664,0x695a,0x0000, /* 0xB3F8-0xB3FF */
	/* codebase=0xb440 rawbase=0x23c0 */
	0x7884,0x7885,0x7886,0x7888,0x788a,0x788b,0x788f,0x7890, /* 0xB440-0xB447 */
	0x7892,0x7894,0x7895,0x7896,0x7899,0x789d,0x789e,0x78a0, /* 0xB448-0xB44F */
	0x78a2,0x78a4,0x78a6,0x78a8,0x78a9,0x78aa,0x78ab,0x78ac, /* 0xB450-0xB457 */
	0x78ad,0x78ae,0x78af,0x78b5,0x78b6,0x78b7,0x78b8,0x78ba, /* 0xB458-0xB45F */
	0x78bb,0x78bc,0x78bd,0x78bf,0x78c0,0x78c2,0x78c3,0x78c4, /* 0xB460-0xB467 */
	0x78c6,0x78c7,0x78c8,0x78cc,0x78cd,0x78ce,0x78cf,0x78d1, /* 0xB468-0xB46F */
	0x78d2,0x78d3,0x78d6,0x78d7,0x78d8,0x78da,0x78db,0x78dc, /* 0xB470-0xB477 */
	0x78dd,0x78de,0x78df,0x78e0,0x78e1,0x78e2,0x78e3,0x0000, /* 0xB478-0xB47F */
	/* codebase=0xb480 rawbase=0x2400 */
	0x78e4,0x78e5,0x78e6,0x78e7,0x78e9,0x78ea,0x78eb,0x78ed, /* 0xB480-0xB487 */
	0x78ee,0x78ef,0x78f0,0x78f1,0x78f3,0x78f5,0x78f6,0x78f8, /* 0xB488-0xB48F */
	0x78f9,0x78fb,0x78fc,0x78fd,0x78fe,0x78ff,0x7900,0x7902, /* 0xB490-0xB497 */
	0x7903,0x7904,0x7906,0x7907,0x7908,0x7909,0x790a,0x790b, /* 0xB498-0xB49F */
	0x790c,0x7840,0x50a8,0x77d7,0x6410,0x89e6,0x5904,0x63e3, /* 0xB4A0-0xB4A7 */
	0x5ddd,0x7a7f,0x693d,0x4f20,0x8239,0x5598,0x4e32,0x75ae, /* 0xB4A8-0xB4AF */
	0x7a97,0x5e62,0x5e8a,0x95ef,0x521b,0x5439,0x708a,0x6376, /* 0xB4B0-0xB4B7 */
	0x9524,0x5782,0x6625,0x693f,0x9187,0x5507,0x6df3,0x7eaf, /* 0xB4B8-0xB4BF */
	/* codebase=0xb4c0 rawbase=0x2440 */
	0x8822,0x6233,0x7ef0,0x75b5,0x8328,0x78c1,0x96cc,0x8f9e, /* 0xB4C0-0xB4C7 */
	0x6148,0x74f7,0x8bcd,0x6b64,0x523a,0x8d50,0x6b21,0x806a, /* 0xB4C8-0xB4CF */
	0x8471,0x56f1,0x5306,0x4ece,0x4e1b,0x51d1,0x7c97,0x918b, /* 0xB4D0-0xB4D7 */
	0x7c07,0x4fc3,0x8e7f,0x7be1,0x7a9c,0x6467,0x5d14,0x50ac, /* 0xB4D8-0xB4DF */
	0x8106,0x7601,0x7cb9,0x6dec,0x7fe0,0x6751,0x5b58,0x5bf8, /* 0xB4E0-0xB4E7 */
	0x78cb,0x64ae,0x6413,0x63aa,0x632b,0x9519,0x642d,0x8fbe, /* 0xB4E8-0xB4EF */
	0x7b54,0x7629,0x6253,0x5927,0x5446,0x6b79,0x50a3,0x6234, /* 0xB4F0-0xB4F7 */
	0x5e26,0x6b86,0x4ee3,0x8d37,0x888b,0x5f85,0x902e,0x0000, /* 0xB4F8-0xB4FF */
	/* codebase=0xb540 rawbase=0x2480 */
	0x790d,0x790e,0x790f,0x7910,0x7911,0x7912,0x7914,0x7915, /* 0xB540-0xB547 */
	0x7916,0x7917,0x7918,0x7919,0x791a,0x791b,0x791c,0x791d, /* 0xB548-0xB54F */
	0x791f,0x7920,0x7921,0x7922,0x7923,0x7925,0x7926,0x7927, /* 0xB550-0xB557 */
	0x7928,0x7929,0x792a,0x792b,0x792c,0x792d,0x792e,0x792f, /* 0xB558-0xB55F */
	0x7930,0x7931,0x7932,0x7933,0x7935,0x7936,0x7937,0x7938, /* 0xB560-0xB567 */
	0x7939,0x793d,0x793f,0x7942,0x7943,0x7944,0x7945,0x7947, /* 0xB568-0xB56F */
	0x794a,0x794b,0x794c,0x794d,0x794e,0x794f,0x7950,0x7951, /* 0xB570-0xB577 */
	0x7952,0x7954,0x7955,0x7958,0x7959,0x7961,0x7963,0x0000, /* 0xB578-0xB57F */
	/* codebase=0xb580 rawbase=0x24c0 */
	0x7964,0x7966,0x7969,0x796a,0x796b,0x796c,0x796e,0x7970, /* 0xB580-0xB587 */
	0x7971,0x7972,0x7973,0x7974,0x7975,0x7976,0x7979,0x797b, /* 0xB588-0xB58F */
	0x797c,0x797d,0x797e,0x797f,0x7982,0x7983,0x7986,0x7987, /* 0xB590-0xB597 */
	0x7988,0x7989,0x798b,0x798c,0x798d,0x798e,0x7990,0x7991, /* 0xB598-0xB59F */
	0x7992,0x6020,0x803d,0x62c5,0x4e39,0x5355,0x90f8,0x63b8, /* 0xB5A0-0xB5A7 */
	0x80c6,0x65e6,0x6c2e,0x4f46,0x60ee,0x6de1,0x8bde,0x5f39, /* 0xB5A8-0xB5AF */
	0x86cb,0x5f53,0x6321,0x515a,0x8361,0x6863,0x5200,0x6363, /* 0xB5B0-0xB5B7 */
	0x8e48,0x5012,0x5c9b,0x7977,0x5bfc,0x5230,0x7a3b,0x60bc, /* 0xB5B8-0xB5BF */
	/* codebase=0xb5c0 rawbase=0x2500 */
	0x9053,0x76d7,0x5fb7,0x5f97,0x7684,0x8e6c,0x706f,0x767b, /* 0xB5C0-0xB5C7 */
	0x7b49,0x77aa,0x51f3,0x9093,0x5824,0x4f4e,0x6ef4,0x8fea, /* 0xB5C8-0xB5CF */
	0x654c,0x7b1b,0x72c4,0x6da4,0x7fdf,0x5ae1,0x62b5,0x5e95, /* 0xB5D0-0xB5D7 */
	0x5730,0x8482,0x7b2c,0x5e1d,0x5f1f,0x9012,0x7f14,0x98a0, /* 0xB5D8-0xB5DF */
	0x6382,0x6ec7,0x7898,0x70b9,0x5178,0x975b,0x57ab,0x7535, /* 0xB5E0-0xB5E7 */
	0x4f43,0x7538,0x5e97,0x60e6,0x5960,0x6dc0,0x6bbf,0x7889, /* 0xB5E8-0xB5EF */
	0x53fc,0x96d5,0x51cb,0x5201,0x6389,0x540a,0x9493,0x8c03, /* 0xB5F0-0xB5F7 */
	0x8dcc,0x7239,0x789f,0x8776,0x8fed,0x8c0d,0x53e0,0x0000, /* 0xB5F8-0xB5FF */
	/* codebase=0xb640 rawbase=0x2540 */
	0x7993,0x7994,0x7995,0x7996,0x7997,0x7998,0x7999,0x799b, /* 0xB640-0xB647 */
	0x799c,0x799d,0x799e,0x799f,0x79a0,0x79a1,0x79a2,0x79a3, /* 0xB648-0xB64F */
	0x79a4,0x79a5,0x79a6,0x79a8,0x79a9,0x79aa,0x79ab,0x79ac, /* 0xB650-0xB657 */
	0x79ad,0x79ae,0x79af,0x79b0,0x79b1,0x79b2,0x79b4,0x79b5, /* 0xB658-0xB65F */
	0x79b6,0x79b7,0x79b8,0x79bc,0x79bf,0x79c2,0x79c4,0x79c5, /* 0xB660-0xB667 */
	0x79c7,0x79c8,0x79ca,0x79cc,0x79ce,0x79cf,0x79d0,0x79d3, /* 0xB668-0xB66F */
	0x79d4,0x79d6,0x79d7,0x79d9,0x79da,0x79db,0x79dc,0x79dd, /* 0xB670-0xB677 */
	0x79de,0x79e0,0x79e1,0x79e2,0x79e5,0x79e8,0x79ea,0x0000, /* 0xB678-0xB67F */
	/* codebase=0xb680 rawbase=0x2580 */
	0x79ec,0x79ee,0x79f1,0x79f2,0x79f3,0x79f4,0x79f5,0x79f6, /* 0xB680-0xB687 */
	0x79f7,0x79f9,0x79fa,0x79fc,0x79fe,0x79ff,0x7a01,0x7a04, /* 0xB688-0xB68F */
	0x7a05,0x7a07,0x7a08,0x7a09,0x7a0a,0x7a0c,0x7a0f,0x7a10, /* 0xB690-0xB697 */
	0x7a11,0x7a12,0x7a13,0x7a15,0x7a16,0x7a18,0x7a19,0x7a1b, /* 0xB698-0xB69F */
	0x7a1c,0x4e01,0x76ef,0x53ee,0x9489,0x9876,0x9f0e,0x952d, /* 0xB6A0-0xB6A7 */
	0x5b9a,0x8ba2,0x4e22,0x4e1c,0x51ac,0x8463,0x61c2,0x52a8, /* 0xB6A8-0xB6AF */
	0x680b,0x4f97,0x606b,0x51bb,0x6d1e,0x515c,0x6296,0x6597, /* 0xB6B0-0xB6B7 */
	0x9661,0x8c46,0x9017,0x75d8,0x90fd,0x7763,0x6bd2,0x728a, /* 0xB6B8-0xB6BF */
	/* codebase=0xb6c0 rawbase=0x25c0 */
	0x72ec,0x8bfb,0x5835,0x7779,0x8d4c,0x675c,0x9540,0x809a, /* 0xB6C0-0xB6C7 */
	0x5ea6,0x6e21,0x5992,0x7aef,0x77ed,0x953b,0x6bb5,0x65ad, /* 0xB6C8-0xB6CF */
	0x7f0e,0x5806,0x5151,0x961f,0x5bf9,0x58a9,0x5428,0x8e72, /* 0xB6D0-0xB6D7 */
	0x6566,0x987f,0x56e4,0x949d,0x76fe,0x9041,0x6387,0x54c6, /* 0xB6D8-0xB6DF */
	0x591a,0x593a,0x579b,0x8eb2,0x6735,0x8dfa,0x8235,0x5241, /* 0xB6E0-0xB6E7 */
	0x60f0,0x5815,0x86fe,0x5ce8,0x9e45,0x4fc4,0x989d,0x8bb9, /* 0xB6E8-0xB6EF */
	0x5a25,0x6076,0x5384,0x627c,0x904f,0x9102,0x997f,0x6069, /* 0xB6F0-0xB6F7 */
	0x800c,0x513f,0x8033,0x5c14,0x9975,0x6d31,0x4e8c,0x0000, /* 0xB6F8-0xB6FF */
	/* codebase=0xb740 rawbase=0x2600 */
	0x7a1d,0x7a1f,0x7a21,0x7a22,0x7a24,0x7a25,0x7a26,0x7a27, /* 0xB740-0xB747 */
	0x7a28,0x7a29,0x7a2a,0x7a2b,0x7a2c,0x7a2d,0x7a2e,0x7a2f, /* 0xB748-0xB74F */
	0x7a30,0x7a31,0x7a32,0x7a34,0x7a35,0x7a36,0x7a38,0x7a3a, /* 0xB750-0xB757 */
	0x7a3e,0x7a40,0x7a41,0x7a42,0x7a43,0x7a44,0x7a45,0x7a47, /* 0xB758-0xB75F */
	0x7a48,0x7a49,0x7a4a,0x7a4b,0x7a4c,0x7a4d,0x7a4e,0x7a4f, /* 0xB760-0xB767 */
	0x7a50,0x7a52,0x7a53,0x7a54,0x7a55,0x7a56,0x7a58,0x7a59, /* 0xB768-0xB76F */
	0x7a5a,0x7a5b,0x7a5c,0x7a5d,0x7a5e,0x7a5f,0x7a60,0x7a61, /* 0xB770-0xB777 */
	0x7a62,0x7a63,0x7a64,0x7a65,0x7a66,0x7a67,0x7a68,0x0000, /* 0xB778-0xB77F */
	/* codebase=0xb780 rawbase=0x2640 */
	0x7a69,0x7a6a,0x7a6b,0x7a6c,0x7a6d,0x7a6e,0x7a6f,0x7a71, /* 0xB780-0xB787 */
	0x7a72,0x7a73,0x7a75,0x7a7b,0x7a7c,0x7a7d,0x7a7e,0x7a82, /* 0xB788-0xB78F */
	0x7a85,0x7a87,0x7a89,0x7a8a,0x7a8b,0x7a8c,0x7a8e,0x7a8f, /* 0xB790-0xB797 */
	0x7a90,0x7a93,0x7a94,0x7a99,0x7a9a,0x7a9b,0x7a9e,0x7aa1, /* 0xB798-0xB79F */
	0x7aa2,0x8d30,0x53d1,0x7f5a,0x7b4f,0x4f10,0x4e4f,0x9600, /* 0xB7A0-0xB7A7 */
	0x6cd5,0x73d0,0x85e9,0x5e06,0x756a,0x7ffb,0x6a0a,0x77fe, /* 0xB7A8-0xB7AF */
	0x9492,0x7e41,0x51e1,0x70e6,0x53cd,0x8fd4,0x8303,0x8d29, /* 0xB7B0-0xB7B7 */
	0x72af,0x996d,0x6cdb,0x574a,0x82b3,0x65b9,0x80aa,0x623f, /* 0xB7B8-0xB7BF */
	/* codebase=0xb7c0 rawbase=0x2680 */
	0x9632,0x59a8,0x4eff,0x8bbf,0x7eba,0x653e,0x83f2,0x975e, /* 0xB7C0-0xB7C7 */
	0x5561,0x98de,0x80a5,0x532a,0x8bfd,0x5420,0x80ba,0x5e9f, /* 0xB7C8-0xB7CF */
	0x6cb8,0x8d39,0x82ac,0x915a,0x5429,0x6c1b,0x5206,0x7eb7, /* 0xB7D0-0xB7D7 */
	0x575f,0x711a,0x6c7e,0x7c89,0x594b,0x4efd,0x5fff,0x6124, /* 0xB7D8-0xB7DF */
	0x7caa,0x4e30,0x5c01,0x67ab,0x8702,0x5cf0,0x950b,0x98ce, /* 0xB7E0-0xB7E7 */
	0x75af,0x70fd,0x9022,0x51af,0x7f1d,0x8bbd,0x5949,0x51e4, /* 0xB7E8-0xB7EF */
	0x4f5b,0x5426,0x592b,0x6577,0x80a4,0x5b75,0x6276,0x62c2, /* 0xB7F0-0xB7F7 */
	0x8f90,0x5e45,0x6c1f,0x7b26,0x4f0f,0x4fd8,0x670d,0x0000, /* 0xB7F8-0xB7FF */
	/* codebase=0xb840 rawbase=0x26c0 */
	0x7aa3,0x7aa4,0x7aa7,0x7aa9,0x7aaa,0x7aab,0x7aae,0x7aaf, /* 0xB840-0xB847 */
	0x7ab0,0x7ab1,0x7ab2,0x7ab4,0x7ab5,0x7ab6,0x7ab7,0x7ab8, /* 0xB848-0xB84F */
	0x7ab9,0x7aba,0x7abb,0x7abc,0x7abd,0x7abe,0x7ac0,0x7ac1, /* 0xB850-0xB857 */
	0x7ac2,0x7ac3,0x7ac4,0x7ac5,0x7ac6,0x7ac7,0x7ac8,0x7ac9, /* 0xB858-0xB85F */
	0x7aca,0x7acc,0x7acd,0x7ace,0x7acf,0x7ad0,0x7ad1,0x7ad2, /* 0xB860-0xB867 */
	0x7ad3,0x7ad4,0x7ad5,0x7ad7,0x7ad8,0x7ada,0x7adb,0x7adc, /* 0xB868-0xB86F */
	0x7add,0x7ae1,0x7ae2,0x7ae4,0x7ae7,0x7ae8,0x7ae9,0x7aea, /* 0xB870-0xB877 */
	0x7aeb,0x7aec,0x7aee,0x7af0,0x7af1,0x7af2,0x7af3,0x0000, /* 0xB878-0xB87F */
	/* codebase=0xb880 rawbase=0x2700 */
	0x7af4,0x7af5,0x7af6,0x7af7,0x7af8,0x7afb,0x7afc,0x7afe, /* 0xB880-0xB887 */
	0x7b00,0x7b01,0x7b02,0x7b05,0x7b07,0x7b09,0x7b0c,0x7b0d, /* 0xB888-0xB88F */
	0x7b0e,0x7b10,0x7b12,0x7b13,0x7b16,0x7b17,0x7b18,0x7b1a, /* 0xB890-0xB897 */
	0x7b1c,0x7b1d,0x7b1f,0x7b21,0x7b22,0x7b23,0x7b27,0x7b29, /* 0xB898-0xB89F */
	0x7b2d,0x6d6e,0x6daa,0x798f,0x88b1,0x5f17,0x752b,0x629a, /* 0xB8A0-0xB8A7 */
	0x8f85,0x4fef,0x91dc,0x65a7,0x812f,0x8151,0x5e9c,0x8150, /* 0xB8A8-0xB8AF */
	0x8d74,0x526f,0x8986,0x8d4b,0x590d,0x5085,0x4ed8,0x961c, /* 0xB8B0-0xB8B7 */
	0x7236,0x8179,0x8d1f,0x5bcc,0x8ba3,0x9644,0x5987,0x7f1a, /* 0xB8B8-0xB8BF */
	/* codebase=0xb8c0 rawbase=0x2740 */
	0x5490,0x5676,0x560e,0x8be5,0x6539,0x6982,0x9499,0x76d6, /* 0xB8C0-0xB8C7 */
	0x6e89,0x5e72,0x7518,0x6746,0x67d1,0x7aff,0x809d,0x8d76, /* 0xB8C8-0xB8CF */
	0x611f,0x79c6,0x6562,0x8d63,0x5188,0x521a,0x94a2,0x7f38, /* 0xB8D0-0xB8D7 */
	0x809b,0x7eb2,0x5c97,0x6e2f,0x6760,0x7bd9,0x768b,0x9ad8, /* 0xB8D8-0xB8DF */
	0x818f,0x7f94,0x7cd5,0x641e,0x9550,0x7a3f,0x544a,0x54e5, /* 0xB8E0-0xB8E7 */
	0x6b4c,0x6401,0x6208,0x9e3d,0x80f3,0x7599,0x5272,0x9769, /* 0xB8E8-0xB8EF */
	0x845b,0x683c,0x86e4,0x9601,0x9694,0x94ec,0x4e2a,0x5404, /* 0xB8F0-0xB8F7 */
	0x7ed9,0x6839,0x8ddf,0x8015,0x66f4,0x5e9a,0x7fb9,0x0000, /* 0xB8F8-0xB8FF */
	/* codebase=0xb940 rawbase=0x2780 */
	0x7b2f,0x7b30,0x7b32,0x7b34,0x7b35,0x7b36,0x7b37,0x7b39, /* 0xB940-0xB947 */
	0x7b3b,0x7b3d,0x7b3f,0x7b40,0x7b41,0x7b42,0x7b43,0x7b44, /* 0xB948-0xB94F */
	0x7b46,0x7b48,0x7b4a,0x7b4d,0x7b4e,0x7b53,0x7b55,0x7b57, /* 0xB950-0xB957 */
	0x7b59,0x7b5c,0x7b5e,0x7b5f,0x7b61,0x7b63,0x7b64,0x7b65, /* 0xB958-0xB95F */
	0x7b66,0x7b67,0x7b68,0x7b69,0x7b6a,0x7b6b,0x7b6c,0x7b6d, /* 0xB960-0xB967 */
	0x7b6f,0x7b70,0x7b73,0x7b74,0x7b76,0x7b78,0x7b7a,0x7b7c, /* 0xB968-0xB96F */
	0x7b7d,0x7b7f,0x7b81,0x7b82,0x7b83,0x7b84,0x7b86,0x7b87, /* 0xB970-0xB977 */
	0x7b88,0x7b89,0x7b8a,0x7b8b,0x7b8c,0x7b8e,0x7b8f,0x0000, /* 0xB978-0xB97F */
	/* codebase=0xb980 rawbase=0x27c0 */
	0x7b91,0x7b92,0x7b93,0x7b96,0x7b98,0x7b99,0x7b9a,0x7b9b, /* 0xB980-0xB987 */
	0x7b9e,0x7b9f,0x7ba0,0x7ba3,0x7ba4,0x7ba5,0x7bae,0x7baf, /* 0xB988-0xB98F */
	0x7bb0,0x7bb2,0x7bb3,0x7bb5,0x7bb6,0x7bb7,0x7bb9,0x7bba, /* 0xB990-0xB997 */
	0x7bbb,0x7bbc,0x7bbd,0x7bbe,0x7bbf,0x7bc0,0x7bc2,0x7bc3, /* 0xB998-0xB99F */
	0x7bc4,0x57c2,0x803f,0x6897,0x5de5,0x653b,0x529f,0x606d, /* 0xB9A0-0xB9A7 */
	0x9f9a,0x4f9b,0x8eac,0x516c,0x5bab,0x5f13,0x5de9,0x6c5e, /* 0xB9A8-0xB9AF */
	0x62f1,0x8d21,0x5171,0x94a9,0x52fe,0x6c9f,0x82df,0x72d7, /* 0xB9B0-0xB9B7 */
	0x57a2,0x6784,0x8d2d,0x591f,0x8f9c,0x83c7,0x5495,0x7b8d, /* 0xB9B8-0xB9BF */
	/* codebase=0xb9c0 rawbase=0x2800 */
	0x4f30,0x6cbd,0x5b64,0x59d1,0x9f13,0x53e4,0x86ca,0x9aa8, /* 0xB9C0-0xB9C7 */
	0x8c37,0x80a1,0x6545,0x987e,0x56fa,0x96c7,0x522e,0x74dc, /* 0xB9C8-0xB9CF */
	0x5250,0x5be1,0x6302,0x8902,0x4e56,0x62d0,0x602a,0x68fa, /* 0xB9D0-0xB9D7 */
	0x5173,0x5b98,0x51a0,0x89c2,0x7ba1,0x9986,0x7f50,0x60ef, /* 0xB9D8-0xB9DF */
	0x704c,0x8d2f,0x5149,0x5e7f,0x901b,0x7470,0x89c4,0x572d, /* 0xB9E0-0xB9E7 */
	0x7845,0x5f52,0x9f9f,0x95fa,0x8f68,0x9b3c,0x8be1,0x7678, /* 0xB9E8-0xB9EF */
	0x6842,0x67dc,0x8dea,0x8d35,0x523d,0x8f8a,0x6eda,0x68cd, /* 0xB9F0-0xB9F7 */
	0x9505,0x90ed,0x56fd,0x679c,0x88f9,0x8fc7,0x54c8,0x0000, /* 0xB9F8-0xB9FF */
	/* codebase=0xba40 rawbase=0x2840 */
	0x7bc5,0x7bc8,0x7bc9,0x7bca,0x7bcb,0x7bcd,0x7bce,0x7bcf, /* 0xBA40-0xBA47 */
	0x7bd0,0x7bd2,0x7bd4,0x7bd5,0x7bd6,0x7bd7,0x7bd8,0x7bdb, /* 0xBA48-0xBA4F */
	0x7bdc,0x7bde,0x7bdf,0x7be0,0x7be2,0x7be3,0x7be4,0x7be7, /* 0xBA50-0xBA57 */
	0x7be8,0x7be9,0x7beb,0x7bec,0x7bed,0x7bef,0x7bf0,0x7bf2, /* 0xBA58-0xBA5F */
	0x7bf3,0x7bf4,0x7bf5,0x7bf6,0x7bf8,0x7bf9,0x7bfa,0x7bfb, /* 0xBA60-0xBA67 */
	0x7bfd,0x7bff,0x7c00,0x7c01,0x7c02,0x7c03,0x7c04,0x7c05, /* 0xBA68-0xBA6F */
	0x7c06,0x7c08,0x7c09,0x7c0a,0x7c0d,0x7c0e,0x7c10,0x7c11, /* 0xBA70-0xBA77 */
	0x7c12,0x7c13,0x7c14,0x7c15,0x7c17,0x7c18,0x7c19,0x0000, /* 0xBA78-0xBA7F */
	/* codebase=0xba80 rawbase=0x2880 */
	0x7c1a,0x7c1b,0x7c1c,0x7c1d,0x7c1e,0x7c20,0x7c21,0x7c22, /* 0xBA80-0xBA87 */
	0x7c23,0x7c24,0x7c25,0x7c28,0x7c29,0x7c2b,0x7c2c,0x7c2d, /* 0xBA88-0xBA8F */
	0x7c2e,0x7c2f,0x7c30,0x7c31,0x7c32,0x7c33,0x7c34,0x7c35, /* 0xBA90-0xBA97 */
	0x7c36,0x7c37,0x7c39,0x7c3a,0x7c3b,0x7c3c,0x7c3d,0x7c3e, /* 0xBA98-0xBA9F */
	0x7c42,0x9ab8,0x5b69,0x6d77,0x6c26,0x4ea5,0x5bb3,0x9a87, /* 0xBAA0-0xBAA7 */
	0x9163,0x61a8,0x90af,0x97e9,0x542b,0x6db5,0x5bd2,0x51fd, /* 0xBAA8-0xBAAF */
	0x558a,0x7f55,0x7ff0,0x64bc,0x634d,0x65f1,0x61be,0x608d, /* 0xBAB0-0xBAB7 */
	0x710a,0x6c57,0x6c49,0x592f,0x676d,0x822a,0x58d5,0x568e, /* 0xBAB8-0xBABF */
	/* codebase=0xbac0 rawbase=0x28c0 */
	0x8c6a,0x6beb,0x90dd,0x597d,0x8017,0x53f7,0x6d69,0x5475, /* 0xBAC0-0xBAC7 */
	0x559d,0x8377,0x83cf,0x6838,0x79be,0x548c,0x4f55,0x5408, /* 0xBAC8-0xBACF */
	0x76d2,0x8c89,0x9602,0x6cb3,0x6db8,0x8d6b,0x8910,0x9e64, /* 0xBAD0-0xBAD7 */
	0x8d3a,0x563f,0x9ed1,0x75d5,0x5f88,0x72e0,0x6068,0x54fc, /* 0xBAD8-0xBADF */
	0x4ea8,0x6a2a,0x8861,0x6052,0x8f70,0x54c4,0x70d8,0x8679, /* 0xBAE0-0xBAE7 */
	0x9e3f,0x6d2a,0x5b8f,0x5f18,0x7ea2,0x5589,0x4faf,0x7334, /* 0xBAE8-0xBAEF */
	0x543c,0x539a,0x5019,0x540e,0x547c,0x4e4e,0x5ffd,0x745a, /* 0xBAF0-0xBAF7 */
	0x58f6,0x846b,0x80e1,0x8774,0x72d0,0x7cca,0x6e56,0x0000, /* 0xBAF8-0xBAFF */
	/* codebase=0xbb40 rawbase=0x2900 */
	0x7c43,0x7c44,0x7c45,0x7c46,0x7c47,0x7c48,0x7c49,0x7c4a, /* 0xBB40-0xBB47 */
	0x7c4b,0x7c4c,0x7c4e,0x7c4f,0x7c50,0x7c51,0x7c52,0x7c53, /* 0xBB48-0xBB4F */
	0x7c54,0x7c55,0x7c56,0x7c57,0x7c58,0x7c59,0x7c5a,0x7c5b, /* 0xBB50-0xBB57 */
	0x7c5c,0x7c5d,0x7c5e,0x7c5f,0x7c60,0x7c61,0x7c62,0x7c63, /* 0xBB58-0xBB5F */
	0x7c64,0x7c65,0x7c66,0x7c67,0x7c68,0x7c69,0x7c6a,0x7c6b, /* 0xBB60-0xBB67 */
	0x7c6c,0x7c6d,0x7c6e,0x7c6f,0x7c70,0x7c71,0x7c72,0x7c75, /* 0xBB68-0xBB6F */
	0x7c76,0x7c77,0x7c78,0x7c79,0x7c7a,0x7c7e,0x7c7f,0x7c80, /* 0xBB70-0xBB77 */
	0x7c81,0x7c82,0x7c83,0x7c84,0x7c85,0x7c86,0x7c87,0x0000, /* 0xBB78-0xBB7F */
	/* codebase=0xbb80 rawbase=0x2940 */
	0x7c88,0x7c8a,0x7c8b,0x7c8c,0x7c8d,0x7c8e,0x7c8f,0x7c90, /* 0xBB80-0xBB87 */
	0x7c93,0x7c94,0x7c96,0x7c99,0x7c9a,0x7c9b,0x7ca0,0x7ca1, /* 0xBB88-0xBB8F */
	0x7ca3,0x7ca6,0x7ca7,0x7ca8,0x7ca9,0x7cab,0x7cac,0x7cad, /* 0xBB90-0xBB97 */
	0x7caf,0x7cb0,0x7cb4,0x7cb5,0x7cb6,0x7cb7,0x7cb8,0x7cba, /* 0xBB98-0xBB9F */
	0x7cbb,0x5f27,0x864e,0x552c,0x62a4,0x4e92,0x6caa,0x6237, /* 0xBBA0-0xBBA7 */
	0x82b1,0x54d7,0x534e,0x733e,0x6ed1,0x753b,0x5212,0x5316, /* 0xBBA8-0xBBAF */
	0x8bdd,0x69d0,0x5f8a,0x6000,0x6dee,0x574f,0x6b22,0x73af, /* 0xBBB0-0xBBB7 */
	0x6853,0x8fd8,0x7f13,0x6362,0x60a3,0x5524,0x75ea,0x8c62, /* 0xBBB8-0xBBBF */
	/* codebase=0xbbc0 rawbase=0x2980 */
	0x7115,0x6da3,0x5ba6,0x5e7b,0x8352,0x614c,0x9ec4,0x78fa, /* 0xBBC0-0xBBC7 */
	0x8757,0x7c27,0x7687,0x51f0,0x60f6,0x714c,0x6643,0x5e4c, /* 0xBBC8-0xBBCF */
	0x604d,0x8c0e,0x7070,0x6325,0x8f89,0x5fbd,0x6062,0x86d4, /* 0xBBD0-0xBBD7 */
	0x56de,0x6bc1,0x6094,0x6167,0x5349,0x60e0,0x6666,0x8d3f, /* 0xBBD8-0xBBDF */
	0x79fd,0x4f1a,0x70e9,0x6c47,0x8bb3,0x8bf2,0x7ed8,0x8364, /* 0xBBE0-0xBBE7 */
	0x660f,0x5a5a,0x9b42,0x6d51,0x6df7,0x8c41,0x6d3b,0x4f19, /* 0xBBE8-0xBBEF */
	0x706b,0x83b7,0x6216,0x60d1,0x970d,0x8d27,0x7978,0x51fb, /* 0xBBF0-0xBBF7 */
	0x573e,0x57fa,0x673a,0x7578,0x7a3d,0x79ef,0x7b95,0x0000, /* 0xBBF8-0xBBFF */
	/* codebase=0xbc40 rawbase=0x29c0 */
	0x7cbf,0x7cc0,0x7cc2,0x7cc3,0x7cc4,0x7cc6,0x7cc9,0x7ccb, /* 0xBC40-0xBC47 */
	0x7cce,0x7ccf,0x7cd0,0x7cd1,0x7cd2,0x7cd3,0x7cd4,0x7cd8, /* 0xBC48-0xBC4F */
	0x7cda,0x7cdb,0x7cdd,0x7cde,0x7ce1,0x7ce2,0x7ce3,0x7ce4, /* 0xBC50-0xBC57 */
	0x7ce5,0x7ce6,0x7ce7,0x7ce9,0x7cea,0x7ceb,0x7cec,0x7ced, /* 0xBC58-0xBC5F */
	0x7cee,0x7cf0,0x7cf1,0x7cf2,0x7cf3,0x7cf4,0x7cf5,0x7cf6, /* 0xBC60-0xBC67 */
	0x7cf7,0x7cf9,0x7cfa,0x7cfc,0x7cfd,0x7cfe,0x7cff,0x7d00, /* 0xBC68-0xBC6F */
	0x7d01,0x7d02,0x7d03,0x7d04,0x7d05,0x7d06,0x7d07,0x7d08, /* 0xBC70-0xBC77 */
	0x7d09,0x7d0b,0x7d0c,0x7d0d,0x7d0e,0x7d0f,0x7d10,0x0000, /* 0xBC78-0xBC7F */
	/* codebase=0xbc80 rawbase=0x2a00 */
	0x7d11,0x7d12,0x7d13,0x7d14,0x7d15,0x7d16,0x7d17,0x7d18, /* 0xBC80-0xBC87 */
	0x7d19,0x7d1a,0x7d1b,0x7d1c,0x7d1d,0x7d1e,0x7d1f,0x7d21, /* 0xBC88-0xBC8F */
	0x7d23,0x7d24,0x7d25,0x7d26,0x7d28,0x7d29,0x7d2a,0x7d2c, /* 0xBC90-0xBC97 */
	0x7d2d,0x7d2e,0x7d30,0x7d31,0x7d32,0x7d33,0x7d34,0x7d35, /* 0xBC98-0xBC9F */
	0x7d36,0x808c,0x9965,0x8ff9,0x6fc0,0x8ba5,0x9e21,0x59ec, /* 0xBCA0-0xBCA7 */
	0x7ee9,0x7f09,0x5409,0x6781,0x68d8,0x8f91,0x7c4d,0x96c6, /* 0xBCA8-0xBCAF */
	0x53ca,0x6025,0x75be,0x6c72,0x5373,0x5ac9,0x7ea7,0x6324, /* 0xBCB0-0xBCB7 */
	0x51e0,0x810a,0x5df1,0x84df,0x6280,0x5180,0x5b63,0x4f0e, /* 0xBCB8-0xBCBF */
	/* codebase=0xbcc0 rawbase=0x2a40 */
	0x796d,0x5242,0x60b8,0x6d4e,0x5bc4,0x5bc2,0x8ba1,0x8bb0, /* 0xBCC0-0xBCC7 */
	0x65e2,0x5fcc,0x9645,0x5993,0x7ee7,0x7eaa,0x5609,0x67b7, /* 0xBCC8-0xBCCF */
	0x5939,0x4f73,0x5bb6,0x52a0,0x835a,0x988a,0x8d3e,0x7532, /* 0xBCD0-0xBCD7 */
	0x94be,0x5047,0x7a3c,0x4ef7,0x67b6,0x9a7e,0x5ac1,0x6b7c, /* 0xBCD8-0xBCDF */
	0x76d1,0x575a,0x5c16,0x7b3a,0x95f4,0x714e,0x517c,0x80a9, /* 0xBCE0-0xBCE7 */
	0x8270,0x5978,0x7f04,0x8327,0x68c0,0x67ec,0x78b1,0x7877, /* 0xBCE8-0xBCEF */
	0x62e3,0x6361,0x7b80,0x4fed,0x526a,0x51cf,0x8350,0x69db, /* 0xBCF0-0xBCF7 */
	0x9274,0x8df5,0x8d31,0x89c1,0x952e,0x7bad,0x4ef6,0x0000, /* 0xBCF8-0xBCFF */
	/* codebase=0xbd40 rawbase=0x2a80 */
	0x7d37,0x7d38,0x7d39,0x7d3a,0x7d3b,0x7d3c,0x7d3d,0x7d3e, /* 0xBD40-0xBD47 */
	0x7d3f,0x7d40,0x7d41,0x7d42,0x7d43,0x7d44,0x7d45,0x7d46, /* 0xBD48-0xBD4F */
	0x7d47,0x7d48,0x7d49,0x7d4a,0x7d4b,0x7d4c,0x7d4d,0x7d4e, /* 0xBD50-0xBD57 */
	0x7d4f,0x7d50,0x7d51,0x7d52,0x7d53,0x7d54,0x7d55,0x7d56, /* 0xBD58-0xBD5F */
	0x7d57,0x7d58,0x7d59,0x7d5a,0x7d5b,0x7d5c,0x7d5d,0x7d5e, /* 0xBD60-0xBD67 */
	0x7d5f,0x7d60,0x7d61,0x7d62,0x7d63,0x7d64,0x7d65,0x7d66, /* 0xBD68-0xBD6F */
	0x7d67,0x7d68,0x7d69,0x7d6a,0x7d6b,0x7d6c,0x7d6d,0x7d6f, /* 0xBD70-0xBD77 */
	0x7d70,0x7d71,0x7d72,0x7d73,0x7d74,0x7d75,0x7d76,0x0000, /* 0xBD78-0xBD7F */
	/* codebase=0xbd80 rawbase=0x2ac0 */
	0x7d78,0x7d79,0x7d7a,0x7d7b,0x7d7c,0x7d7d,0x7d7e,0x7d7f, /* 0xBD80-0xBD87 */
	0x7d80,0x7d81,0x7d82,0x7d83,0x7d84,0x7d85,0x7d86,0x7d87, /* 0xBD88-0xBD8F */
	0x7d88,0x7d89,0x7d8a,0x7d8b,0x7d8c,0x7d8d,0x7d8e,0x7d8f, /* 0xBD90-0xBD97 */
	0x7d90,0x7d91,0x7d92,0x7d93,0x7d94,0x7d95,0x7d96,0x7d97, /* 0xBD98-0xBD9F */
	0x7d98,0x5065,0x8230,0x5251,0x996f,0x6e10,0x6e85,0x6da7, /* 0xBDA0-0xBDA7 */
	0x5efa,0x50f5,0x59dc,0x5c06,0x6d46,0x6c5f,0x7586,0x848b, /* 0xBDA8-0xBDAF */
	0x6868,0x5956,0x8bb2,0x5320,0x9171,0x964d,0x8549,0x6912, /* 0xBDB0-0xBDB7 */
	0x7901,0x7126,0x80f6,0x4ea4,0x90ca,0x6d47,0x9a84,0x5a07, /* 0xBDB8-0xBDBF */
	/* codebase=0xbdc0 rawbase=0x2b00 */
	0x56bc,0x6405,0x94f0,0x77eb,0x4fa5,0x811a,0x72e1,0x89d2, /* 0xBDC0-0xBDC7 */
	0x997a,0x7f34,0x7ede,0x527f,0x6559,0x9175,0x8f7f,0x8f83, /* 0xBDC8-0xBDCF */
	0x53eb,0x7a96,0x63ed,0x63a5,0x7686,0x79f8,0x8857,0x9636, /* 0xBDD0-0xBDD7 */
	0x622a,0x52ab,0x8282,0x6854,0x6770,0x6377,0x776b,0x7aed, /* 0xBDD8-0xBDDF */
	0x6d01,0x7ed3,0x89e3,0x59d0,0x6212,0x85c9,0x82a5,0x754c, /* 0xBDE0-0xBDE7 */
	0x501f,0x4ecb,0x75a5,0x8beb,0x5c4a,0x5dfe,0x7b4b,0x65a4, /* 0xBDE8-0xBDEF */
	0x91d1,0x4eca,0x6d25,0x895f,0x7d27,0x9526,0x4ec5,0x8c28, /* 0xBDF0-0xBDF7 */
	0x8fdb,0x9773,0x664b,0x7981,0x8fd1,0x70ec,0x6d78,0x0000, /* 0xBDF8-0xBDFF */
	/* codebase=0xbe40 rawbase=0x2b40 */
	0x7d99,0x7d9a,0x7d9b,0x7d9c,0x7d9d,0x7d9e,0x7d9f,0x7da0, /* 0xBE40-0xBE47 */
	0x7da1,0x7da2,0x7da3,0x7da4,0x7da5,0x7da7,0x7da8,0x7da9, /* 0xBE48-0xBE4F */
	0x7daa,0x7dab,0x7dac,0x7dad,0x7daf,0x7db0,0x7db1,0x7db2, /* 0xBE50-0xBE57 */
	0x7db3,0x7db4,0x7db5,0x7db6,0x7db7,0x7db8,0x7db9,0x7dba, /* 0xBE58-0xBE5F */
	0x7dbb,0x7dbc,0x7dbd,0x7dbe,0x7dbf,0x7dc0,0x7dc1,0x7dc2, /* 0xBE60-0xBE67 */
	0x7dc3,0x7dc4,0x7dc5,0x7dc6,0x7dc7,0x7dc8,0x7dc9,0x7dca, /* 0xBE68-0xBE6F */
	0x7dcb,0x7dcc,0x7dcd,0x7dce,0x7dcf,0x7dd0,0x7dd1,0x7dd2, /* 0xBE70-0xBE77 */
	0x7dd3,0x7dd4,0x7dd5,0x7dd6,0x7dd7,0x7dd8,0x7dd9,0x0000, /* 0xBE78-0xBE7F */
	/* codebase=0xbe80 rawbase=0x2b80 */
	0x7dda,0x7ddb,0x7ddc,0x7ddd,0x7dde,0x7ddf,0x7de0,0x7de1, /* 0xBE80-0xBE87 */
	0x7de2,0x7de3,0x7de4,0x7de5,0x7de6,0x7de7,0x7de8,0x7de9, /* 0xBE88-0xBE8F */
	0x7dea,0x7deb,0x7dec,0x7ded,0x7dee,0x7def,0x7df0,0x7df1, /* 0xBE90-0xBE97 */
	0x7df2,0x7df3,0x7df4,0x7df5,0x7df6,0x7df7,0x7df8,0x7df9, /* 0xBE98-0xBE9F */
	0x7dfa,0x5c3d,0x52b2,0x8346,0x5162,0x830e,0x775b,0x6676, /* 0xBEA0-0xBEA7 */
	0x9cb8,0x4eac,0x60ca,0x7cbe,0x7cb3,0x7ecf,0x4e95,0x8b66, /* 0xBEA8-0xBEAF */
	0x666f,0x9888,0x9759,0x5883,0x656c,0x955c,0x5f84,0x75c9, /* 0xBEB0-0xBEB7 */
	0x9756,0x7adf,0x7ade,0x51c0,0x70af,0x7a98,0x63ea,0x7a76, /* 0xBEB8-0xBEBF */
	/* codebase=0xbec0 rawbase=0x2bc0 */
	0x7ea0,0x7396,0x97ed,0x4e45,0x7078,0x4e5d,0x9152,0x53a9, /* 0xBEC0-0xBEC7 */
	0x6551,0x65e7,0x81fc,0x8205,0x548e,0x5c31,0x759a,0x97a0, /* 0xBEC8-0xBECF */
	0x62d8,0x72d9,0x75bd,0x5c45,0x9a79,0x83ca,0x5c40,0x5480, /* 0xBED0-0xBED7 */
	0x77e9,0x4e3e,0x6cae,0x805a,0x62d2,0x636e,0x5de8,0x5177, /* 0xBED8-0xBEDF */
	0x8ddd,0x8e1e,0x952f,0x4ff1,0x53e5,0x60e7,0x70ac,0x5267, /* 0xBEE0-0xBEE7 */
	0x6350,0x9e43,0x5a1f,0x5026,0x7737,0x5377,0x7ee2,0x6485, /* 0xBEE8-0xBEEF */
	0x652b,0x6289,0x6398,0x5014,0x7235,0x89c9,0x51b3,0x8bc0, /* 0xBEF0-0xBEF7 */
	0x7edd,0x5747,0x83cc,0x94a7,0x519b,0x541b,0x5cfb,0x0000, /* 0xBEF8-0xBEFF */
	/* codebase=0xbf40 rawbase=0x2c00 */
	0x7dfb,0x7dfc,0x7dfd,0x7dfe,0x7dff,0x7e00,0x7e01,0x7e02, /* 0xBF40-0xBF47 */
	0x7e03,0x7e04,0x7e05,0x7e06,0x7e07,0x7e08,0x7e09,0x7e0a, /* 0xBF48-0xBF4F */
	0x7e0b,0x7e0c,0x7e0d,0x7e0e,0x7e0f,0x7e10,0x7e11,0x7e12, /* 0xBF50-0xBF57 */
	0x7e13,0x7e14,0x7e15,0x7e16,0x7e17,0x7e18,0x7e19,0x7e1a, /* 0xBF58-0xBF5F */
	0x7e1b,0x7e1c,0x7e1d,0x7e1e,0x7e1f,0x7e20,0x7e21,0x7e22, /* 0xBF60-0xBF67 */
	0x7e23,0x7e24,0x7e25,0x7e26,0x7e27,0x7e28,0x7e29,0x7e2a, /* 0xBF68-0xBF6F */
	0x7e2b,0x7e2c,0x7e2d,0x7e2e,0x7e2f,0x7e30,0x7e31,0x7e32, /* 0xBF70-0xBF77 */
	0x7e33,0x7e34,0x7e35,0x7e36,0x7e37,0x7e38,0x7e39,0x0000, /* 0xBF78-0xBF7F */
	/* codebase=0xbf80 rawbase=0x2c40 */
	0x7e3a,0x7e3c,0x7e3d,0x7e3e,0x7e3f,0x7e40,0x7e42,0x7e43, /* 0xBF80-0xBF87 */
	0x7e44,0x7e45,0x7e46,0x7e48,0x7e49,0x7e4a,0x7e4b,0x7e4c, /* 0xBF88-0xBF8F */
	0x7e4d,0x7e4e,0x7e4f,0x7e50,0x7e51,0x7e52,0x7e53,0x7e54, /* 0xBF90-0xBF97 */
	0x7e55,0x7e56,0x7e57,0x7e58,0x7e59,0x7e5a,0x7e5b,0x7e5c, /* 0xBF98-0xBF9F */
	0x7e5d,0x4fca,0x7ae3,0x6d5a,0x90e1,0x9a8f,0x5580,0x5496, /* 0xBFA0-0xBFA7 */
	0x5361,0x54af,0x5f00,0x63e9,0x6977,0x51ef,0x6168,0x520a, /* 0xBFA8-0xBFAF */
	0x582a,0x52d8,0x574e,0x780d,0x770b,0x5eb7,0x6177,0x7ce0, /* 0xBFB0-0xBFB7 */
	0x625b,0x6297,0x4ea2,0x7095,0x8003,0x62f7,0x70e4,0x9760, /* 0xBFB8-0xBFBF */
	/* codebase=0xbfc0 rawbase=0x2c80 */
	0x5777,0x82db,0x67ef,0x68f5,0x78d5,0x9897,0x79d1,0x58f3, /* 0xBFC0-0xBFC7 */
	0x54b3,0x53ef,0x6e34,0x514b,0x523b,0x5ba2,0x8bfe,0x80af, /* 0xBFC8-0xBFCF */
	0x5543,0x57a6,0x6073,0x5751,0x542d,0x7a7a,0x6050,0x5b54, /* 0xBFD0-0xBFD7 */
	0x63a7,0x62a0,0x53e3,0x6263,0x5bc7,0x67af,0x54ed,0x7a9f, /* 0xBFD8-0xBFDF */
	0x82e6,0x9177,0x5e93,0x88e4,0x5938,0x57ae,0x630e,0x8de8, /* 0xBFE0-0xBFE7 */
	0x80ef,0x5757,0x7b77,0x4fa9,0x5feb,0x5bbd,0x6b3e,0x5321, /* 0xBFE8-0xBFEF */
	0x7b50,0x72c2,0x6846,0x77ff,0x7736,0x65f7,0x51b5,0x4e8f, /* 0xBFF0-0xBFF7 */
	0x76d4,0x5cbf,0x7aa5,0x8475,0x594e,0x9b41,0x5080,0x0000, /* 0xBFF8-0xBFFF */
	/* codebase=0xc040 rawbase=0x2cc0 */
	0x7e5e,0x7e5f,0x7e60,0x7e61,0x7e62,0x7e63,0x7e64,0x7e65, /* 0xC040-0xC047 */
	0x7e66,0x7e67,0x7e68,0x7e69,0x7e6a,0x7e6b,0x7e6c,0x7e6d, /* 0xC048-0xC04F */
	0x7e6e,0x7e6f,0x7e70,0x7e71,0x7e72,0x7e73,0x7e74,0x7e75, /* 0xC050-0xC057 */
	0x7e76,0x7e77,0x7e78,0x7e79,0x7e7a,0x7e7b,0x7e7c,0x7e7d, /* 0xC058-0xC05F */
	0x7e7e,0x7e7f,0x7e80,0x7e81,0x7e83,0x7e84,0x7e85,0x7e86, /* 0xC060-0xC067 */
	0x7e87,0x7e88,0x7e89,0x7e8a,0x7e8b,0x7e8c,0x7e8d,0x7e8e, /* 0xC068-0xC06F */
	0x7e8f,0x7e90,0x7e91,0x7e92,0x7e93,0x7e94,0x7e95,0x7e96, /* 0xC070-0xC077 */
	0x7e97,0x7e98,0x7e99,0x7e9a,0x7e9c,0x7e9d,0x7e9e,0x0000, /* 0xC078-0xC07F */
	/* codebase=0xc080 rawbase=0x2d00 */
	0x7eae,0x7eb4,0x7ebb,0x7ebc,0x7ed6,0x7ee4,0x7eec,0x7ef9, /* 0xC080-0xC087 */
	0x7f0a,0x7f10,0x7f1e,0x7f37,0x7f39,0x7f3b,0x7f3c,0x7f3d, /* 0xC088-0xC08F */
	0x7f3e,0x7f3f,0x7f40,0x7f41,0x7f43,0x7f46,0x7f47,0x7f48, /* 0xC090-0xC097 */
	0x7f49,0x7f4a,0x7f4b,0x7f4c,0x7f4d,0x7f4e,0x7f4f,0x7f52, /* 0xC098-0xC09F */
	0x7f53,0x9988,0x6127,0x6e83,0x5764,0x6606,0x6346,0x56f0, /* 0xC0A0-0xC0A7 */
	0x62ec,0x6269,0x5ed3,0x9614,0x5783,0x62c9,0x5587,0x8721, /* 0xC0A8-0xC0AF */
	0x814a,0x8fa3,0x5566,0x83b1,0x6765,0x8d56,0x84dd,0x5a6a, /* 0xC0B0-0xC0B7 */
	0x680f,0x62e6,0x7bee,0x9611,0x5170,0x6f9c,0x8c30,0x63fd, /* 0xC0B8-0xC0BF */
	/* codebase=0xc0c0 rawbase=0x2d40 */
	0x89c8,0x61d2,0x7f06,0x70c2,0x6ee5,0x7405,0x6994,0x72fc, /* 0xC0C0-0xC0C7 */
	0x5eca,0x90ce,0x6717,0x6d6a,0x635e,0x52b3,0x7262,0x8001, /* 0xC0C8-0xC0CF */
	0x4f6c,0x59e5,0x916a,0x70d9,0x6d9d,0x52d2,0x4e50,0x96f7, /* 0xC0D0-0xC0D7 */
	0x956d,0x857e,0x78ca,0x7d2f,0x5121,0x5792,0x64c2,0x808b, /* 0xC0D8-0xC0DF */
	0x7c7b,0x6cea,0x68f1,0x695e,0x51b7,0x5398,0x68a8,0x7281, /* 0xC0E0-0xC0E7 */
	0x9ece,0x7bf1,0x72f8,0x79bb,0x6f13,0x7406,0x674e,0x91cc, /* 0xC0E8-0xC0EF */
	0x9ca4,0x793c,0x8389,0x8354,0x540f,0x6817,0x4e3d,0x5389, /* 0xC0F0-0xC0F7 */
	0x52b1,0x783e,0x5386,0x5229,0x5088,0x4f8b,0x4fd0,0x0000, /* 0xC0F8-0xC0FF */
	/* codebase=0xc140 rawbase=0x2d80 */
	0x7f56,0x7f59,0x7f5b,0x7f5c,0x7f5d,0x7f5e,0x7f60,0x7f63, /* 0xC140-0xC147 */
	0x7f64,0x7f65,0x7f66,0x7f67,0x7f6b,0x7f6c,0x7f6d,0x7f6f, /* 0xC148-0xC14F */
	0x7f70,0x7f73,0x7f75,0x7f76,0x7f77,0x7f78,0x7f7a,0x7f7b, /* 0xC150-0xC157 */
	0x7f7c,0x7f7d,0x7f7f,0x7f80,0x7f82,0x7f83,0x7f84,0x7f85, /* 0xC158-0xC15F */
	0x7f86,0x7f87,0x7f88,0x7f89,0x7f8b,0x7f8d,0x7f8f,0x7f90, /* 0xC160-0xC167 */
	0x7f91,0x7f92,0x7f93,0x7f95,0x7f96,0x7f97,0x7f98,0x7f99, /* 0xC168-0xC16F */
	0x7f9b,0x7f9c,0x7fa0,0x7fa2,0x7fa3,0x7fa5,0x7fa6,0x7fa8, /* 0xC170-0xC177 */
	0x7fa9,0x7faa,0x7fab,0x7fac,0x7fad,0x7fae,0x7fb1,0x0000, /* 0xC178-0xC17F */
	/* codebase=0xc180 rawbase=0x2dc0 */
	0x7fb3,0x7fb4,0x7fb5,0x7fb6,0x7fb7,0x7fba,0x7fbb,0x7fbe, /* 0xC180-0xC187 */
	0x7fc0,0x7fc2,0x7fc3,0x7fc4,0x7fc6,0x7fc7,0x7fc8,0x7fc9, /* 0xC188-0xC18F */
	0x7fcb,0x7fcd,0x7fcf,0x7fd0,0x7fd1,0x7fd2,0x7fd3,0x7fd6, /* 0xC190-0xC197 */
	0x7fd7,0x7fd9,0x7fda,0x7fdb,0x7fdc,0x7fdd,0x7fde,0x7fe2, /* 0xC198-0xC19F */
	0x7fe3,0x75e2,0x7acb,0x7c92,0x6ca5,0x96b6,0x529b,0x7483, /* 0xC1A0-0xC1A7 */
	0x54e9,0x4fe9,0x8054,0x83b2,0x8fde,0x9570,0x5ec9,0x601c, /* 0xC1A8-0xC1AF */
	0x6d9f,0x5e18,0x655b,0x8138,0x94fe,0x604b,0x70bc,0x7ec3, /* 0xC1B0-0xC1B7 */
	0x7cae,0x51c9,0x6881,0x7cb1,0x826f,0x4e24,0x8f86,0x91cf, /* 0xC1B8-0xC1BF */
	/* codebase=0xc1c0 rawbase=0x2e00 */
	0x667e,0x4eae,0x8c05,0x64a9,0x804a,0x50da,0x7597,0x71ce, /* 0xC1C0-0xC1C7 */
	0x5be5,0x8fbd,0x6f66,0x4e86,0x6482,0x9563,0x5ed6,0x6599, /* 0xC1C8-0xC1CF */
	0x5217,0x88c2,0x70c8,0x52a3,0x730e,0x7433,0x6797,0x78f7, /* 0xC1D0-0xC1D7 */
	0x9716,0x4e34,0x90bb,0x9cde,0x6dcb,0x51db,0x8d41,0x541d, /* 0xC1D8-0xC1DF */
	0x62ce,0x73b2,0x83f1,0x96f6,0x9f84,0x94c3,0x4f36,0x7f9a, /* 0xC1E0-0xC1E7 */
	0x51cc,0x7075,0x9675,0x5cad,0x9886,0x53e6,0x4ee4,0x6e9c, /* 0xC1E8-0xC1EF */
	0x7409,0x69b4,0x786b,0x998f,0x7559,0x5218,0x7624,0x6d41, /* 0xC1F0-0xC1F7 */
	0x67f3,0x516d,0x9f99,0x804b,0x5499,0x7b3c,0x7abf,0x0000, /* 0xC1F8-0xC1FF */
	/* codebase=0xc240 rawbase=0x2e40 */
	0x7fe4,0x7fe7,0x7fe8,0x7fea,0x7feb,0x7fec,0x7fed,0x7fef, /* 0xC240-0xC247 */
	0x7ff2,0x7ff4,0x7ff5,0x7ff6,0x7ff7,0x7ff8,0x7ff9,0x7ffa, /* 0xC248-0xC24F */
	0x7ffd,0x7ffe,0x7fff,0x8002,0x8007,0x8008,0x8009,0x800a, /* 0xC250-0xC257 */
	0x800e,0x800f,0x8011,0x8013,0x801a,0x801b,0x801d,0x801e, /* 0xC258-0xC25F */
	0x801f,0x8021,0x8023,0x8024,0x802b,0x802c,0x802d,0x802e, /* 0xC260-0xC267 */
	0x802f,0x8030,0x8032,0x8034,0x8039,0x803a,0x803c,0x803e, /* 0xC268-0xC26F */
	0x8040,0x8041,0x8044,0x8045,0x8047,0x8048,0x8049,0x804e, /* 0xC270-0xC277 */
	0x804f,0x8050,0x8051,0x8053,0x8055,0x8056,0x8057,0x0000, /* 0xC278-0xC27F */
	/* codebase=0xc280 rawbase=0x2e80 */
	0x8059,0x805b,0x805c,0x805d,0x805e,0x805f,0x8060,0x8061, /* 0xC280-0xC287 */
	0x8062,0x8063,0x8064,0x8065,0x8066,0x8067,0x8068,0x806b, /* 0xC288-0xC28F */
	0x806c,0x806d,0x806e,0x806f,0x8070,0x8072,0x8073,0x8074, /* 0xC290-0xC297 */
	0x8075,0x8076,0x8077,0x8078,0x8079,0x807a,0x807b,0x807c, /* 0xC298-0xC29F */
	0x807d,0x9686,0x5784,0x62e2,0x9647,0x697c,0x5a04,0x6402, /* 0xC2A0-0xC2A7 */
	0x7bd3,0x6f0f,0x964b,0x82a6,0x5362,0x9885,0x5e90,0x7089, /* 0xC2A8-0xC2AF */
	0x63b3,0x5364,0x864f,0x9c81,0x9e93,0x788c,0x9732,0x8def, /* 0xC2B0-0xC2B7 */
	0x8d42,0x9e7f,0x6f5e,0x7984,0x5f55,0x9646,0x622e,0x9a74, /* 0xC2B8-0xC2BF */
	/* codebase=0xc2c0 rawbase=0x2ec0 */
	0x5415,0x94dd,0x4fa3,0x65c5,0x5c65,0x5c61,0x7f15,0x8651, /* 0xC2C0-0xC2C7 */
	0x6c2f,0x5f8b,0x7387,0x6ee4,0x7eff,0x5ce6,0x631b,0x5b6a, /* 0xC2C8-0xC2CF */
	0x6ee6,0x5375,0x4e71,0x63a0,0x7565,0x62a1,0x8f6e,0x4f26, /* 0xC2D0-0xC2D7 */
	0x4ed1,0x6ca6,0x7eb6,0x8bba,0x841d,0x87ba,0x7f57,0x903b, /* 0xC2D8-0xC2DF */
	0x9523,0x7ba9,0x9aa1,0x88f8,0x843d,0x6d1b,0x9a86,0x7edc, /* 0xC2E0-0xC2E7 */
	0x5988,0x9ebb,0x739b,0x7801,0x8682,0x9a6c,0x9a82,0x561b, /* 0xC2E8-0xC2EF */
	0x5417,0x57cb,0x4e70,0x9ea6,0x5356,0x8fc8,0x8109,0x7792, /* 0xC2F0-0xC2F7 */
	0x9992,0x86ee,0x6ee1,0x8513,0x66fc,0x6162,0x6f2b,0x0000, /* 0xC2F8-0xC2FF */
	/* codebase=0xc340 rawbase=0x2f00 */
	0x807e,0x8081,0x8082,0x8085,0x8088,0x808a,0x808d,0x808e, /* 0xC340-0xC347 */
	0x808f,0x8090,0x8091,0x8092,0x8094,0x8095,0x8097,0x8099, /* 0xC348-0xC34F */
	0x809e,0x80a3,0x80a6,0x80a7,0x80a8,0x80ac,0x80b0,0x80b3, /* 0xC350-0xC357 */
	0x80b5,0x80b6,0x80b8,0x80b9,0x80bb,0x80c5,0x80c7,0x80c8, /* 0xC358-0xC35F */
	0x80c9,0x80ca,0x80cb,0x80cf,0x80d0,0x80d1,0x80d2,0x80d3, /* 0xC360-0xC367 */
	0x80d4,0x80d5,0x80d8,0x80df,0x80e0,0x80e2,0x80e3,0x80e6, /* 0xC368-0xC36F */
	0x80ee,0x80f5,0x80f7,0x80f9,0x80fb,0x80fe,0x80ff,0x8100, /* 0xC370-0xC377 */
	0x8101,0x8103,0x8104,0x8105,0x8107,0x8108,0x810b,0x0000, /* 0xC378-0xC37F */
	/* codebase=0xc380 rawbase=0x2f40 */
	0x810c,0x8115,0x8117,0x8119,0x811b,0x811c,0x811d,0x811f, /* 0xC380-0xC387 */
	0x8120,0x8121,0x8122,0x8123,0x8124,0x8125,0x8126,0x8127, /* 0xC388-0xC38F */
	0x8128,0x8129,0x812a,0x812b,0x812d,0x812e,0x8130,0x8133, /* 0xC390-0xC397 */
	0x8134,0x8135,0x8137,0x8139,0x813a,0x813b,0x813c,0x813d, /* 0xC398-0xC39F */
	0x813f,0x8c29,0x8292,0x832b,0x76f2,0x6c13,0x5fd9,0x83bd, /* 0xC3A0-0xC3A7 */
	0x732b,0x8305,0x951a,0x6bdb,0x77db,0x94c6,0x536f,0x8302, /* 0xC3A8-0xC3AF */
	0x5192,0x5e3d,0x8c8c,0x8d38,0x4e48,0x73ab,0x679a,0x6885, /* 0xC3B0-0xC3B7 */
	0x9176,0x9709,0x7164,0x6ca1,0x7709,0x5a92,0x9541,0x6bcf, /* 0xC3B8-0xC3BF */
	/* codebase=0xc3c0 rawbase=0x2f80 */
	0x7f8e,0x6627,0x5bd0,0x59b9,0x5a9a,0x95e8,0x95f7,0x4eec, /* 0xC3C0-0xC3C7 */
	0x840c,0x8499,0x6aac,0x76df,0x9530,0x731b,0x68a6,0x5b5f, /* 0xC3C8-0xC3CF */
	0x772f,0x919a,0x9761,0x7cdc,0x8ff7,0x8c1c,0x5f25,0x7c73, /* 0xC3D0-0xC3D7 */
	0x79d8,0x89c5,0x6ccc,0x871c,0x5bc6,0x5e42,0x68c9,0x7720, /* 0xC3D8-0xC3DF */
	0x7ef5,0x5195,0x514d,0x52c9,0x5a29,0x7f05,0x9762,0x82d7, /* 0xC3E0-0xC3E7 */
	0x63cf,0x7784,0x85d0,0x79d2,0x6e3a,0x5e99,0x5999,0x8511, /* 0xC3E8-0xC3EF */
	0x706d,0x6c11,0x62bf,0x76bf,0x654f,0x60af,0x95fd,0x660e, /* 0xC3F0-0xC3F7 */
	0x879f,0x9e23,0x94ed,0x540d,0x547d,0x8c2c,0x6478,0x0000, /* 0xC3F8-0xC3FF */
	/* codebase=0xc440 rawbase=0x2fc0 */
	0x8140,0x8141,0x8142,0x8143,0x8144,0x8145,0x8147,0x8149, /* 0xC440-0xC447 */
	0x814d,0x814e,0x814f,0x8152,0x8156,0x8157,0x8158,0x815b, /* 0xC448-0xC44F */
	0x815c,0x815d,0x815e,0x815f,0x8161,0x8162,0x8163,0x8164, /* 0xC450-0xC457 */
	0x8166,0x8168,0x816a,0x816b,0x816c,0x816f,0x8172,0x8173, /* 0xC458-0xC45F */
	0x8175,0x8176,0x8177,0x8178,0x8181,0x8183,0x8184,0x8185, /* 0xC460-0xC467 */
	0x8186,0x8187,0x8189,0x818b,0x818c,0x818d,0x818e,0x8190, /* 0xC468-0xC46F */
	0x8192,0x8193,0x8194,0x8195,0x8196,0x8197,0x8199,0x819a, /* 0xC470-0xC477 */
	0x819e,0x819f,0x81a0,0x81a1,0x81a2,0x81a4,0x81a5,0x0000, /* 0xC478-0xC47F */
	/* codebase=0xc480 rawbase=0x3000 */
	0x81a7,0x81a9,0x81ab,0x81ac,0x81ad,0x81ae,0x81af,0x81b0, /* 0xC480-0xC487 */
	0x81b1,0x81b2,0x81b4,0x81b5,0x81b6,0x81b7,0x81b8,0x81b9, /* 0xC488-0xC48F */
	0x81bc,0x81bd,0x81be,0x81bf,0x81c4,0x81c5,0x81c7,0x81c8, /* 0xC490-0xC497 */
	0x81c9,0x81cb,0x81cd,0x81ce,0x81cf,0x81d0,0x81d1,0x81d2, /* 0xC498-0xC49F */
	0x81d3,0x6479,0x8611,0x6a21,0x819c,0x78e8,0x6469,0x9b54, /* 0xC4A0-0xC4A7 */
	0x62b9,0x672b,0x83ab,0x58a8,0x9ed8,0x6cab,0x6f20,0x5bde, /* 0xC4A8-0xC4AF */
	0x964c,0x8c0b,0x725f,0x67d0,0x62c7,0x7261,0x4ea9,0x59c6, /* 0xC4B0-0xC4B7 */
	0x6bcd,0x5893,0x66ae,0x5e55,0x52df,0x6155,0x6728,0x76ee, /* 0xC4B8-0xC4BF */
	/* codebase=0xc4c0 rawbase=0x3040 */
	0x7766,0x7267,0x7a46,0x62ff,0x54ea,0x5450,0x94a0,0x90a3, /* 0xC4C0-0xC4C7 */
	0x5a1c,0x7eb3,0x6c16,0x4e43,0x5976,0x8010,0x5948,0x5357, /* 0xC4C8-0xC4CF */
	0x7537,0x96be,0x56ca,0x6320,0x8111,0x607c,0x95f9,0x6dd6, /* 0xC4D0-0xC4D7 */
	0x5462,0x9981,0x5185,0x5ae9,0x80fd,0x59ae,0x9713,0x502a, /* 0xC4D8-0xC4DF */
	0x6ce5,0x5c3c,0x62df,0x4f60,0x533f,0x817b,0x9006,0x6eba, /* 0xC4E0-0xC4E7 */
	0x852b,0x62c8,0x5e74,0x78be,0x64b5,0x637b,0x5ff5,0x5a18, /* 0xC4E8-0xC4EF */
	0x917f,0x9e1f,0x5c3f,0x634f,0x8042,0x5b7d,0x556e,0x954a, /* 0xC4F0-0xC4F7 */
	0x954d,0x6d85,0x60a8,0x67e0,0x72de,0x51dd,0x5b81,0x0000, /* 0xC4F8-0xC4FF */
	/* codebase=0xc540 rawbase=0x3080 */
	0x81d4,0x81d5,0x81d6,0x81d7,0x81d8,0x81d9,0x81da,0x81db, /* 0xC540-0xC547 */
	0x81dc,0x81dd,0x81de,0x81df,0x81e0,0x81e1,0x81e2,0x81e4, /* 0xC548-0xC54F */
	0x81e5,0x81e6,0x81e8,0x81e9,0x81eb,0x81ee,0x81ef,0x81f0, /* 0xC550-0xC557 */
	0x81f1,0x81f2,0x81f5,0x81f6,0x81f7,0x81f8,0x81f9,0x81fa, /* 0xC558-0xC55F */
	0x81fd,0x81ff,0x8203,0x8207,0x8208,0x8209,0x820a,0x820b, /* 0xC560-0xC567 */
	0x820e,0x820f,0x8211,0x8213,0x8215,0x8216,0x8217,0x8218, /* 0xC568-0xC56F */
	0x8219,0x821a,0x821d,0x8220,0x8224,0x8225,0x8226,0x8227, /* 0xC570-0xC577 */
	0x8229,0x822e,0x8232,0x823a,0x823c,0x823d,0x823f,0x0000, /* 0xC578-0xC57F */
	/* codebase=0xc580 rawbase=0x30c0 */
	0x8240,0x8241,0x8242,0x8243,0x8245,0x8246,0x8248,0x824a, /* 0xC580-0xC587 */
	0x824c,0x824d,0x824e,0x8250,0x8251,0x8252,0x8253,0x8254, /* 0xC588-0xC58F */
	0x8255,0x8256,0x8257,0x8259,0x825b,0x825c,0x825d,0x825e, /* 0xC590-0xC597 */
	0x8260,0x8261,0x8262,0x8263,0x8264,0x8265,0x8266,0x8267, /* 0xC598-0xC59F */
	0x8269,0x62e7,0x6cde,0x725b,0x626d,0x94ae,0x7ebd,0x8113, /* 0xC5A0-0xC5A7 */
	0x6d53,0x519c,0x5f04,0x5974,0x52aa,0x6012,0x5973,0x6696, /* 0xC5A8-0xC5AF */
	0x8650,0x759f,0x632a,0x61e6,0x7cef,0x8bfa,0x54e6,0x6b27, /* 0xC5B0-0xC5B7 */
	0x9e25,0x6bb4,0x85d5,0x5455,0x5076,0x6ca4,0x556a,0x8db4, /* 0xC5B8-0xC5BF */
	/* codebase=0xc5c0 rawbase=0x3100 */
	0x722c,0x5e15,0x6015,0x7436,0x62cd,0x6392,0x724c,0x5f98, /* 0xC5C0-0xC5C7 */
	0x6e43,0x6d3e,0x6500,0x6f58,0x76d8,0x78d0,0x76fc,0x7554, /* 0xC5C8-0xC5CF */
	0x5224,0x53db,0x4e53,0x5e9e,0x65c1,0x802a,0x80d6,0x629b, /* 0xC5D0-0xC5D7 */
	0x5486,0x5228,0x70ae,0x888d,0x8dd1,0x6ce1,0x5478,0x80da, /* 0xC5D8-0xC5DF */
	0x57f9,0x88f4,0x8d54,0x966a,0x914d,0x4f69,0x6c9b,0x55b7, /* 0xC5E0-0xC5E7 */
	0x76c6,0x7830,0x62a8,0x70f9,0x6f8e,0x5f6d,0x84ec,0x68da, /* 0xC5E8-0xC5EF */
	0x787c,0x7bf7,0x81a8,0x670b,0x9e4f,0x6367,0x78b0,0x576f, /* 0xC5F0-0xC5F7 */
	0x7812,0x9739,0x6279,0x62ab,0x5288,0x7435,0x6bd7,0x0000, /* 0xC5F8-0xC5FF */
	/* codebase=0xc640 rawbase=0x3140 */
	0x826a,0x826b,0x826c,0x826d,0x8271,0x8275,0x8276,0x8277, /* 0xC640-0xC647 */
	0x8278,0x827b,0x827c,0x8280,0x8281,0x8283,0x8285,0x8286, /* 0xC648-0xC64F */
	0x8287,0x8289,0x828c,0x8290,0x8293,0x8294,0x8295,0x8296, /* 0xC650-0xC657 */
	0x829a,0x829b,0x829e,0x82a0,0x82a2,0x82a3,0x82a7,0x82b2, /* 0xC658-0xC65F */
	0x82b5,0x82b6,0x82ba,0x82bb,0x82bc,0x82bf,0x82c0,0x82c2, /* 0xC660-0xC667 */
	0x82c3,0x82c5,0x82c6,0x82c9,0x82d0,0x82d6,0x82d9,0x82da, /* 0xC668-0xC66F */
	0x82dd,0x82e2,0x82e7,0x82e8,0x82e9,0x82ea,0x82ec,0x82ed, /* 0xC670-0xC677 */
	0x82ee,0x82f0,0x82f2,0x82f3,0x82f5,0x82f6,0x82f8,0x0000, /* 0xC678-0xC67F */
	/* codebase=0xc680 rawbase=0x3180 */
	0x82fa,0x82fc,0x82fd,0x82fe,0x82ff,0x8300,0x830a,0x830b, /* 0xC680-0xC687 */
	0x830d,0x8310,0x8312,0x8313,0x8316,0x8318,0x8319,0x831d, /* 0xC688-0xC68F */
	0x831e,0x831f,0x8320,0x8321,0x8322,0x8323,0x8324,0x8325, /* 0xC690-0xC697 */
	0x8326,0x8329,0x832a,0x832e,0x8330,0x8332,0x8337,0x833b, /* 0xC698-0xC69F */
	0x833d,0x5564,0x813e,0x75b2,0x76ae,0x5339,0x75de,0x50fb, /* 0xC6A0-0xC6A7 */
	0x5c41,0x8b6c,0x7bc7,0x504f,0x7247,0x9a97,0x98d8,0x6f02, /* 0xC6A8-0xC6AF */
	0x74e2,0x7968,0x6487,0x77a5,0x62fc,0x9891,0x8d2b,0x54c1, /* 0xC6B0-0xC6B7 */
	0x8058,0x4e52,0x576a,0x82f9,0x840d,0x5e73,0x51ed,0x74f6, /* 0xC6B8-0xC6BF */
	/* codebase=0xc6c0 rawbase=0x31c0 */
	0x8bc4,0x5c4f,0x5761,0x6cfc,0x9887,0x5a46,0x7834,0x9b44, /* 0xC6C0-0xC6C7 */
	0x8feb,0x7c95,0x5256,0x6251,0x94fa,0x4ec6,0x8386,0x8461, /* 0xC6C8-0xC6CF */
	0x83e9,0x84b2,0x57d4,0x6734,0x5703,0x666e,0x6d66,0x8c31, /* 0xC6D0-0xC6D7 */
	0x66dd,0x7011,0x671f,0x6b3a,0x6816,0x621a,0x59bb,0x4e03, /* 0xC6D8-0xC6DF */
	0x51c4,0x6f06,0x67d2,0x6c8f,0x5176,0x68cb,0x5947,0x6b67, /* 0xC6E0-0xC6E7 */
	0x7566,0x5d0e,0x8110,0x9f50,0x65d7,0x7948,0x7941,0x9a91, /* 0xC6E8-0xC6EF */
	0x8d77,0x5c82,0x4e5e,0x4f01,0x542f,0x5951,0x780c,0x5668, /* 0xC6F0-0xC6F7 */
	0x6c14,0x8fc4,0x5f03,0x6c7d,0x6ce3,0x8bab,0x6390,0x0000, /* 0xC6F8-0xC6FF */
	/* codebase=0xc740 rawbase=0x3200 */
	0x833e,0x833f,0x8341,0x8342,0x8344,0x8345,0x8348,0x834a, /* 0xC740-0xC747 */
	0x834b,0x834c,0x834d,0x834e,0x8353,0x8355,0x8356,0x8357, /* 0xC748-0xC74F */
	0x8358,0x8359,0x835d,0x8362,0x8370,0x8371,0x8372,0x8373, /* 0xC750-0xC757 */
	0x8374,0x8375,0x8376,0x8379,0x837a,0x837e,0x837f,0x8380, /* 0xC758-0xC75F */
	0x8381,0x8382,0x8383,0x8384,0x8387,0x8388,0x838a,0x838b, /* 0xC760-0xC767 */
	0x838c,0x838d,0x838f,0x8390,0x8391,0x8394,0x8395,0x8396, /* 0xC768-0xC76F */
	0x8397,0x8399,0x839a,0x839d,0x839f,0x83a1,0x83a2,0x83a3, /* 0xC770-0xC777 */
	0x83a4,0x83a5,0x83a6,0x83a7,0x83ac,0x83ad,0x83ae,0x0000, /* 0xC778-0xC77F */
	/* codebase=0xc780 rawbase=0x3240 */
	0x83af,0x83b5,0x83bb,0x83be,0x83bf,0x83c2,0x83c3,0x83c4, /* 0xC780-0xC787 */
	0x83c6,0x83c8,0x83c9,0x83cb,0x83cd,0x83ce,0x83d0,0x83d1, /* 0xC788-0xC78F */
	0x83d2,0x83d3,0x83d5,0x83d7,0x83d9,0x83da,0x83db,0x83de, /* 0xC790-0xC797 */
	0x83e2,0x83e3,0x83e4,0x83e6,0x83e7,0x83e8,0x83eb,0x83ec, /* 0xC798-0xC79F */
	0x83ed,0x6070,0x6d3d,0x7275,0x6266,0x948e,0x94c5,0x5343, /* 0xC7A0-0xC7A7 */
	0x8fc1,0x7b7e,0x4edf,0x8c26,0x4e7e,0x9ed4,0x94b1,0x94b3, /* 0xC7A8-0xC7AF */
	0x524d,0x6f5c,0x9063,0x6d45,0x8c34,0x5811,0x5d4c,0x6b20, /* 0xC7B0-0xC7B7 */
	0x6b49,0x67aa,0x545b,0x8154,0x7f8c,0x5899,0x8537,0x5f3a, /* 0xC7B8-0xC7BF */
	/* codebase=0xc7c0 rawbase=0x3280 */
	0x62a2,0x6a47,0x9539,0x6572,0x6084,0x6865,0x77a7,0x4e54, /* 0xC7C0-0xC7C7 */
	0x4fa8,0x5de7,0x9798,0x64ac,0x7fd8,0x5ced,0x4fcf,0x7a8d, /* 0xC7C8-0xC7CF */
	0x5207,0x8304,0x4e14,0x602f,0x7a83,0x94a6,0x4fb5,0x4eb2, /* 0xC7D0-0xC7D7 */
	0x79e6,0x7434,0x52e4,0x82b9,0x64d2,0x79bd,0x5bdd,0x6c81, /* 0xC7D8-0xC7DF */
	0x9752,0x8f7b,0x6c22,0x503e,0x537f,0x6e05,0x64ce,0x6674, /* 0xC7E0-0xC7E7 */
	0x6c30,0x60c5,0x9877,0x8bf7,0x5e86,0x743c,0x7a77,0x79cb, /* 0xC7E8-0xC7EF */
	0x4e18,0x90b1,0x7403,0x6c42,0x56da,0x914b,0x6cc5,0x8d8b, /* 0xC7F0-0xC7F7 */
	0x533a,0x86c6,0x66f2,0x8eaf,0x5c48,0x9a71,0x6e20,0x0000, /* 0xC7F8-0xC7FF */
	/* codebase=0xc840 rawbase=0x32c0 */
	0x83ee,0x83ef,0x83f3,0x83f4,0x83f5,0x83f6,0x83f7,0x83fa, /* 0xC840-0xC847 */
	0x83fb,0x83fc,0x83fe,0x83ff,0x8400,0x8402,0x8405,0x8407, /* 0xC848-0xC84F */
	0x8408,0x8409,0x840a,0x8410,0x8412,0x8413,0x8414,0x8415, /* 0xC850-0xC857 */
	0x8416,0x8417,0x8419,0x841a,0x841b,0x841e,0x841f,0x8420, /* 0xC858-0xC85F */
	0x8421,0x8422,0x8423,0x8429,0x842a,0x842b,0x842c,0x842d, /* 0xC860-0xC867 */
	0x842e,0x842f,0x8430,0x8432,0x8433,0x8434,0x8435,0x8436, /* 0xC868-0xC86F */
	0x8437,0x8439,0x843a,0x843b,0x843e,0x843f,0x8440,0x8441, /* 0xC870-0xC877 */
	0x8442,0x8443,0x8444,0x8445,0x8447,0x8448,0x8449,0x0000, /* 0xC878-0xC87F */
	/* codebase=0xc880 rawbase=0x3300 */
	0x844a,0x844b,0x844c,0x844d,0x844e,0x844f,0x8450,0x8452, /* 0xC880-0xC887 */
	0x8453,0x8454,0x8455,0x8456,0x8458,0x845d,0x845e,0x845f, /* 0xC888-0xC88F */
	0x8460,0x8462,0x8464,0x8465,0x8466,0x8467,0x8468,0x846a, /* 0xC890-0xC897 */
	0x846e,0x846f,0x8470,0x8472,0x8474,0x8477,0x8479,0x847b, /* 0xC898-0xC89F */
	0x847c,0x53d6,0x5a36,0x9f8b,0x8da3,0x53bb,0x5708,0x98a7, /* 0xC8A0-0xC8A7 */
	0x6743,0x919b,0x6cc9,0x5168,0x75ca,0x62f3,0x72ac,0x5238, /* 0xC8A8-0xC8AF */
	0x529d,0x7f3a,0x7094,0x7638,0x5374,0x9e4a,0x69b7,0x786e, /* 0xC8B0-0xC8B7 */
	0x96c0,0x88d9,0x7fa4,0x7136,0x71c3,0x5189,0x67d3,0x74e4, /* 0xC8B8-0xC8BF */
	/* codebase=0xc8c0 rawbase=0x3340 */
	0x58e4,0x6518,0x56b7,0x8ba9,0x9976,0x6270,0x7ed5,0x60f9, /* 0xC8C0-0xC8C7 */
	0x70ed,0x58ec,0x4ec1,0x4eba,0x5fcd,0x97e7,0x4efb,0x8ba4, /* 0xC8C8-0xC8CF */
	0x5203,0x598a,0x7eab,0x6254,0x4ecd,0x65e5,0x620e,0x8338, /* 0xC8D0-0xC8D7 */
	0x84c9,0x8363,0x878d,0x7194,0x6eb6,0x5bb9,0x7ed2,0x5197, /* 0xC8D8-0xC8DF */
	0x63c9,0x67d4,0x8089,0x8339,0x8815,0x5112,0x5b7a,0x5982, /* 0xC8E0-0xC8E7 */
	0x8fb1,0x4e73,0x6c5d,0x5165,0x8925,0x8f6f,0x962e,0x854a, /* 0xC8E8-0xC8EF */
	0x745e,0x9510,0x95f0,0x6da6,0x82e5,0x5f31,0x6492,0x6d12, /* 0xC8F0-0xC8F7 */
	0x8428,0x816e,0x9cc3,0x585e,0x8d5b,0x4e09,0x53c1,0x0000, /* 0xC8F8-0xC8FF */
	/* codebase=0xc940 rawbase=0x3380 */
	0x847d,0x847e,0x847f,0x8480,0x8481,0x8483,0x8484,0x8485, /* 0xC940-0xC947 */
	0x8486,0x848a,0x848d,0x848f,0x8490,0x8491,0x8492,0x8493, /* 0xC948-0xC94F */
	0x8494,0x8495,0x8496,0x8498,0x849a,0x849b,0x849d,0x849e, /* 0xC950-0xC957 */
	0x849f,0x84a0,0x84a2,0x84a3,0x84a4,0x84a5,0x84a6,0x84a7, /* 0xC958-0xC95F */
	0x84a8,0x84a9,0x84aa,0x84ab,0x84ac,0x84ad,0x84ae,0x84b0, /* 0xC960-0xC967 */
	0x84b1,0x84b3,0x84b5,0x84b6,0x84b7,0x84bb,0x84bc,0x84be, /* 0xC968-0xC96F */
	0x84c0,0x84c2,0x84c3,0x84c5,0x84c6,0x84c7,0x84c8,0x84cb, /* 0xC970-0xC977 */
	0x84cc,0x84ce,0x84cf,0x84d2,0x84d4,0x84d5,0x84d7,0x0000, /* 0xC978-0xC97F */
	/* codebase=0xc980 rawbase=0x33c0 */
	0x84d8,0x84d9,0x84da,0x84db,0x84dc,0x84de,0x84e1,0x84e2, /* 0xC980-0xC987 */
	0x84e4,0x84e7,0x84e8,0x84e9,0x84ea,0x84eb,0x84ed,0x84ee, /* 0xC988-0xC98F */
	0x84ef,0x84f1,0x84f2,0x84f3,0x84f4,0x84f5,0x84f6,0x84f7, /* 0xC990-0xC997 */
	0x84f8,0x84f9,0x84fa,0x84fb,0x84fd,0x84fe,0x8500,0x8501, /* 0xC998-0xC99F */
	0x8502,0x4f1e,0x6563,0x6851,0x55d3,0x4e27,0x6414,0x9a9a, /* 0xC9A0-0xC9A7 */
	0x626b,0x5ac2,0x745f,0x8272,0x6da9,0x68ee,0x50e7,0x838e, /* 0xC9A8-0xC9AF */
	0x7802,0x6740,0x5239,0x6c99,0x7eb1,0x50bb,0x5565,0x715e, /* 0xC9B0-0xC9B7 */
	0x7b5b,0x6652,0x73ca,0x82eb,0x6749,0x5c71,0x5220,0x717d, /* 0xC9B8-0xC9BF */
	/* codebase=0xc9c0 rawbase=0x3400 */
	0x886b,0x95ea,0x9655,0x64c5,0x8d61,0x81b3,0x5584,0x6c55, /* 0xC9C0-0xC9C7 */
	0x6247,0x7f2e,0x5892,0x4f24,0x5546,0x8d4f,0x664c,0x4e0a, /* 0xC9C8-0xC9CF */
	0x5c1a,0x88f3,0x68a2,0x634e,0x7a0d,0x70e7,0x828d,0x52fa, /* 0xC9D0-0xC9D7 */
	0x97f6,0x5c11,0x54e8,0x90b5,0x7ecd,0x5962,0x8d4a,0x86c7, /* 0xC9D8-0xC9DF */
	0x820c,0x820d,0x8d66,0x6444,0x5c04,0x6151,0x6d89,0x793e, /* 0xC9E0-0xC9E7 */
	0x8bbe,0x7837,0x7533,0x547b,0x4f38,0x8eab,0x6df1,0x5a20, /* 0xC9E8-0xC9EF */
	0x7ec5,0x795e,0x6c88,0x5ba1,0x5a76,0x751a,0x80be,0x614e, /* 0xC9F0-0xC9F7 */
	0x6e17,0x58f0,0x751f,0x7525,0x7272,0x5347,0x7ef3,0x0000, /* 0xC9F8-0xC9FF */
	/* codebase=0xca40 rawbase=0x3440 */
	0x8503,0x8504,0x8505,0x8506,0x8507,0x8508,0x8509,0x850a, /* 0xCA40-0xCA47 */
	0x850b,0x850d,0x850e,0x850f,0x8510,0x8512,0x8514,0x8515, /* 0xCA48-0xCA4F */
	0x8516,0x8518,0x8519,0x851b,0x851c,0x851d,0x851e,0x8520, /* 0xCA50-0xCA57 */
	0x8522,0x8523,0x8524,0x8525,0x8526,0x8527,0x8528,0x8529, /* 0xCA58-0xCA5F */
	0x852a,0x852d,0x852e,0x852f,0x8530,0x8531,0x8532,0x8533, /* 0xCA60-0xCA67 */
	0x8534,0x8535,0x8536,0x853e,0x853f,0x8540,0x8541,0x8542, /* 0xCA68-0xCA6F */
	0x8544,0x8545,0x8546,0x8547,0x854b,0x854c,0x854d,0x854e, /* 0xCA70-0xCA77 */
	0x854f,0x8550,0x8551,0x8552,0x8553,0x8554,0x8555,0x0000, /* 0xCA78-0xCA7F */
	/* codebase=0xca80 rawbase=0x3480 */
	0x8557,0x8558,0x855a,0x855b,0x855c,0x855d,0x855f,0x8560, /* 0xCA80-0xCA87 */
	0x8561,0x8562,0x8563,0x8565,0x8566,0x8567,0x8569,0x856a, /* 0xCA88-0xCA8F */
	0x856b,0x856c,0x856d,0x856e,0x856f,0x8570,0x8571,0x8573, /* 0xCA90-0xCA97 */
	0x8575,0x8576,0x8577,0x8578,0x857c,0x857d,0x857f,0x8580, /* 0xCA98-0xCA9F */
	0x8581,0x7701,0x76db,0x5269,0x80dc,0x5723,0x5e08,0x5931, /* 0xCAA0-0xCAA7 */
	0x72ee,0x65bd,0x6e7f,0x8bd7,0x5c38,0x8671,0x5341,0x77f3, /* 0xCAA8-0xCAAF */
	0x62fe,0x65f6,0x4ec0,0x98df,0x8680,0x5b9e,0x8bc6,0x53f2, /* 0xCAB0-0xCAB7 */
	0x77e2,0x4f7f,0x5c4e,0x9a76,0x59cb,0x5f0f,0x793a,0x58eb, /* 0xCAB8-0xCABF */
	/* codebase=0xcac0 rawbase=0x34c0 */
	0x4e16,0x67ff,0x4e8b,0x62ed,0x8a93,0x901d,0x52bf,0x662f, /* 0xCAC0-0xCAC7 */
	0x55dc,0x566c,0x9002,0x4ed5,0x4f8d,0x91ca,0x9970,0x6c0f, /* 0xCAC8-0xCACF */
	0x5e02,0x6043,0x5ba4,0x89c6,0x8bd5,0x6536,0x624b,0x9996, /* 0xCAD0-0xCAD7 */
	0x5b88,0x5bff,0x6388,0x552e,0x53d7,0x7626,0x517d,0x852c, /* 0xCAD8-0xCADF */
	0x67a2,0x68b3,0x6b8a,0x6292,0x8f93,0x53d4,0x8212,0x6dd1, /* 0xCAE0-0xCAE7 */
	0x758f,0x4e66,0x8d4e,0x5b70,0x719f,0x85af,0x6691,0x66d9, /* 0xCAE8-0xCAEF */
	0x7f72,0x8700,0x9ecd,0x9f20,0x5c5e,0x672f,0x8ff0,0x6811, /* 0xCAF0-0xCAF7 */
	0x675f,0x620d,0x7ad6,0x5885,0x5eb6,0x6570,0x6f31,0x0000, /* 0xCAF8-0xCAFF */
	/* codebase=0xcb40 rawbase=0x3500 */
	0x8582,0x8583,0x8586,0x8588,0x8589,0x858a,0x858b,0x858c, /* 0xCB40-0xCB47 */
	0x858d,0x858e,0x8590,0x8591,0x8592,0x8593,0x8594,0x8595, /* 0xCB48-0xCB4F */
	0x8596,0x8597,0x8598,0x8599,0x859a,0x859d,0x859e,0x859f, /* 0xCB50-0xCB57 */
	0x85a0,0x85a1,0x85a2,0x85a3,0x85a5,0x85a6,0x85a7,0x85a9, /* 0xCB58-0xCB5F */
	0x85ab,0x85ac,0x85ad,0x85b1,0x85b2,0x85b3,0x85b4,0x85b5, /* 0xCB60-0xCB67 */
	0x85b6,0x85b8,0x85ba,0x85bb,0x85bc,0x85bd,0x85be,0x85bf, /* 0xCB68-0xCB6F */
	0x85c0,0x85c2,0x85c3,0x85c4,0x85c5,0x85c6,0x85c7,0x85c8, /* 0xCB70-0xCB77 */
	0x85ca,0x85cb,0x85cc,0x85cd,0x85ce,0x85d1,0x85d2,0x0000, /* 0xCB78-0xCB7F */
	/* codebase=0xcb80 rawbase=0x3540 */
	0x85d4,0x85d6,0x85d7,0x85d8,0x85d9,0x85da,0x85db,0x85dd, /* 0xCB80-0xCB87 */
	0x85de,0x85df,0x85e0,0x85e1,0x85e2,0x85e3,0x85e5,0x85e6, /* 0xCB88-0xCB8F */
	0x85e7,0x85e8,0x85ea,0x85eb,0x85ec,0x85ed,0x85ee,0x85ef, /* 0xCB90-0xCB97 */
	0x85f0,0x85f1,0x85f2,0x85f3,0x85f4,0x85f5,0x85f6,0x85f7, /* 0xCB98-0xCB9F */
	0x85f8,0x6055,0x5237,0x800d,0x6454,0x8870,0x7529,0x5e05, /* 0xCBA0-0xCBA7 */
	0x6813,0x62f4,0x971c,0x53cc,0x723d,0x8c01,0x6c34,0x7761, /* 0xCBA8-0xCBAF */
	0x7a0e,0x542e,0x77ac,0x987a,0x821c,0x8bf4,0x7855,0x6714, /* 0xCBB0-0xCBB7 */
	0x70c1,0x65af,0x6495,0x5636,0x601d,0x79c1,0x53f8,0x4e1d, /* 0xCBB8-0xCBBF */
	/* codebase=0xcbc0 rawbase=0x3580 */
	0x6b7b,0x8086,0x5bfa,0x55e3,0x56db,0x4f3a,0x4f3c,0x9972, /* 0xCBC0-0xCBC7 */
	0x5df3,0x677e,0x8038,0x6002,0x9882,0x9001,0x5b8b,0x8bbc, /* 0xCBC8-0xCBCF */
	0x8bf5,0x641c,0x8258,0x64de,0x55fd,0x82cf,0x9165,0x4fd7, /* 0xCBD0-0xCBD7 */
	0x7d20,0x901f,0x7c9f,0x50f3,0x5851,0x6eaf,0x5bbf,0x8bc9, /* 0xCBD8-0xCBDF */
	0x8083,0x9178,0x849c,0x7b97,0x867d,0x968b,0x968f,0x7ee5, /* 0xCBE0-0xCBE7 */
	0x9ad3,0x788e,0x5c81,0x7a57,0x9042,0x96a7,0x795f,0x5b59, /* 0xCBE8-0xCBEF */
	0x635f,0x7b0b,0x84d1,0x68ad,0x5506,0x7f29,0x7410,0x7d22, /* 0xCBF0-0xCBF7 */
	0x9501,0x6240,0x584c,0x4ed6,0x5b83,0x5979,0x5854,0x0000, /* 0xCBF8-0xCBFF */
	/* codebase=0xcc40 rawbase=0x35c0 */
	0x85f9,0x85fa,0x85fc,0x85fd,0x85fe,0x8600,0x8601,0x8602, /* 0xCC40-0xCC47 */
	0x8603,0x8604,0x8606,0x8607,0x8608,0x8609,0x860a,0x860b, /* 0xCC48-0xCC4F */
	0x860c,0x860d,0x860e,0x860f,0x8610,0x8612,0x8613,0x8614, /* 0xCC50-0xCC57 */
	0x8615,0x8617,0x8618,0x8619,0x861a,0x861b,0x861c,0x861d, /* 0xCC58-0xCC5F */
	0x861e,0x861f,0x8620,0x8621,0x8622,0x8623,0x8624,0x8625, /* 0xCC60-0xCC67 */
	0x8626,0x8628,0x862a,0x862b,0x862c,0x862d,0x862e,0x862f, /* 0xCC68-0xCC6F */
	0x8630,0x8631,0x8632,0x8633,0x8634,0x8635,0x8636,0x8637, /* 0xCC70-0xCC77 */
	0x8639,0x863a,0x863b,0x863d,0x863e,0x863f,0x8640,0x0000, /* 0xCC78-0xCC7F */
	/* codebase=0xcc80 rawbase=0x3600 */
	0x8641,0x8642,0x8643,0x8644,0x8645,0x8646,0x8647,0x8648, /* 0xCC80-0xCC87 */
	0x8649,0x864a,0x864b,0x864c,0x8652,0x8653,0x8655,0x8656, /* 0xCC88-0xCC8F */
	0x8657,0x8658,0x8659,0x865b,0x865c,0x865d,0x865f,0x8660, /* 0xCC90-0xCC97 */
	0x8661,0x8663,0x8664,0x8665,0x8666,0x8667,0x8668,0x8669, /* 0xCC98-0xCC9F */
	0x866a,0x736d,0x631e,0x8e4b,0x8e0f,0x80ce,0x82d4,0x62ac, /* 0xCCA0-0xCCA7 */
	0x53f0,0x6cf0,0x915e,0x592a,0x6001,0x6c70,0x574d,0x644a, /* 0xCCA8-0xCCAF */
	0x8d2a,0x762b,0x6ee9,0x575b,0x6a80,0x75f0,0x6f6d,0x8c2d, /* 0xCCB0-0xCCB7 */
	0x8c08,0x5766,0x6bef,0x8892,0x78b3,0x63a2,0x53f9,0x70ad, /* 0xCCB8-0xCCBF */
	/* codebase=0xccc0 rawbase=0x3640 */
	0x6c64,0x5858,0x642a,0x5802,0x68e0,0x819b,0x5510,0x7cd6, /* 0xCCC0-0xCCC7 */
	0x5018,0x8eba,0x6dcc,0x8d9f,0x70eb,0x638f,0x6d9b,0x6ed4, /* 0xCCC8-0xCCCF */
	0x7ee6,0x8404,0x6843,0x9003,0x6dd8,0x9676,0x8ba8,0x5957, /* 0xCCD0-0xCCD7 */
	0x7279,0x85e4,0x817e,0x75bc,0x8a8a,0x68af,0x5254,0x8e22, /* 0xCCD8-0xCCDF */
	0x9511,0x63d0,0x9898,0x8e44,0x557c,0x4f53,0x66ff,0x568f, /* 0xCCE0-0xCCE7 */
	0x60d5,0x6d95,0x5243,0x5c49,0x5929,0x6dfb,0x586b,0x7530, /* 0xCCE8-0xCCEF */
	0x751c,0x606c,0x8214,0x8146,0x6311,0x6761,0x8fe2,0x773a, /* 0xCCF0-0xCCF7 */
	0x8df3,0x8d34,0x94c1,0x5e16,0x5385,0x542c,0x70c3,0x0000, /* 0xCCF8-0xCCFF */
	/* codebase=0xcd40 rawbase=0x3680 */
	0x866d,0x866f,0x8670,0x8672,0x8673,0x8674,0x8675,0x8676, /* 0xCD40-0xCD47 */
	0x8677,0x8678,0x8683,0x8684,0x8685,0x8686,0x8687,0x8688, /* 0xCD48-0xCD4F */
	0x8689,0x868e,0x868f,0x8690,0x8691,0x8692,0x8694,0x8696, /* 0xCD50-0xCD57 */
	0x8697,0x8698,0x8699,0x869a,0x869b,0x869e,0x869f,0x86a0, /* 0xCD58-0xCD5F */
	0x86a1,0x86a2,0x86a5,0x86a6,0x86ab,0x86ad,0x86ae,0x86b2, /* 0xCD60-0xCD67 */
	0x86b3,0x86b7,0x86b8,0x86b9,0x86bb,0x86bc,0x86bd,0x86be, /* 0xCD68-0xCD6F */
	0x86bf,0x86c1,0x86c2,0x86c3,0x86c5,0x86c8,0x86cc,0x86cd, /* 0xCD70-0xCD77 */
	0x86d2,0x86d3,0x86d5,0x86d6,0x86d7,0x86da,0x86dc,0x0000, /* 0xCD78-0xCD7F */
	/* codebase=0xcd80 rawbase=0x36c0 */
	0x86dd,0x86e0,0x86e1,0x86e2,0x86e3,0x86e5,0x86e6,0x86e7, /* 0xCD80-0xCD87 */
	0x86e8,0x86ea,0x86eb,0x86ec,0x86ef,0x86f5,0x86f6,0x86f7, /* 0xCD88-0xCD8F */
	0x86fa,0x86fb,0x86fc,0x86fd,0x86ff,0x8701,0x8704,0x8705, /* 0xCD90-0xCD97 */
	0x8706,0x870b,0x870c,0x870e,0x870f,0x8710,0x8711,0x8714, /* 0xCD98-0xCD9F */
	0x8716,0x6c40,0x5ef7,0x505c,0x4ead,0x5ead,0x633a,0x8247, /* 0xCDA0-0xCDA7 */
	0x901a,0x6850,0x916e,0x77b3,0x540c,0x94dc,0x5f64,0x7ae5, /* 0xCDA8-0xCDAF */
	0x6876,0x6345,0x7b52,0x7edf,0x75db,0x5077,0x6295,0x5934, /* 0xCDB0-0xCDB7 */
	0x900f,0x51f8,0x79c3,0x7a81,0x56fe,0x5f92,0x9014,0x6d82, /* 0xCDB8-0xCDBF */
	/* codebase=0xcdc0 rawbase=0x3700 */
	0x5c60,0x571f,0x5410,0x5154,0x6e4d,0x56e2,0x63a8,0x9893, /* 0xCDC0-0xCDC7 */
	0x817f,0x8715,0x892a,0x9000,0x541e,0x5c6f,0x81c0,0x62d6, /* 0xCDC8-0xCDCF */
	0x6258,0x8131,0x9e35,0x9640,0x9a6e,0x9a7c,0x692d,0x59a5, /* 0xCDD0-0xCDD7 */
	0x62d3,0x553e,0x6316,0x54c7,0x86d9,0x6d3c,0x5a03,0x74e6, /* 0xCDD8-0xCDDF */
	0x889c,0x6b6a,0x5916,0x8c4c,0x5f2f,0x6e7e,0x73a9,0x987d, /* 0xCDE0-0xCDE7 */
	0x4e38,0x70f7,0x5b8c,0x7897,0x633d,0x665a,0x7696,0x60cb, /* 0xCDE8-0xCDEF */
	0x5b9b,0x5a49,0x4e07,0x8155,0x6c6a,0x738b,0x4ea1,0x6789, /* 0xCDF0-0xCDF7 */
	0x7f51,0x5f80,0x65fa,0x671b,0x5fd8,0x5984,0x5a01,0x0000, /* 0xCDF8-0xCDFF */
	/* codebase=0xce40 rawbase=0x3740 */
	0x8719,0x871b,0x871d,0x871f,0x8720,0x8724,0x8726,0x8727, /* 0xCE40-0xCE47 */
	0x8728,0x872a,0x872b,0x872c,0x872d,0x872f,0x8730,0x8732, /* 0xCE48-0xCE4F */
	0x8733,0x8735,0x8736,0x8738,0x8739,0x873a,0x873c,0x873d, /* 0xCE50-0xCE57 */
	0x8740,0x8741,0x8742,0x8743,0x8744,0x8745,0x8746,0x874a, /* 0xCE58-0xCE5F */
	0x874b,0x874d,0x874f,0x8750,0x8751,0x8752,0x8754,0x8755, /* 0xCE60-0xCE67 */
	0x8756,0x8758,0x875a,0x875b,0x875c,0x875d,0x875e,0x875f, /* 0xCE68-0xCE6F */
	0x8761,0x8762,0x8766,0x8767,0x8768,0x8769,0x876a,0x876b, /* 0xCE70-0xCE77 */
	0x876c,0x876d,0x876f,0x8771,0x8772,0x8773,0x8775,0x0000, /* 0xCE78-0xCE7F */
	/* codebase=0xce80 rawbase=0x3780 */
	0x8777,0x8778,0x8779,0x877a,0x877f,0x8780,0x8781,0x8784, /* 0xCE80-0xCE87 */
	0x8786,0x8787,0x8789,0x878a,0x878c,0x878e,0x878f,0x8790, /* 0xCE88-0xCE8F */
	0x8791,0x8792,0x8794,0x8795,0x8796,0x8798,0x8799,0x879a, /* 0xCE90-0xCE97 */
	0x879b,0x879c,0x879d,0x879e,0x87a0,0x87a1,0x87a2,0x87a3, /* 0xCE98-0xCE9F */
	0x87a4,0x5dcd,0x5fae,0x5371,0x97e6,0x8fdd,0x6845,0x56f4, /* 0xCEA0-0xCEA7 */
	0x552f,0x60df,0x4e3a,0x6f4d,0x7ef4,0x82c7,0x840e,0x59d4, /* 0xCEA8-0xCEAF */
	0x4f1f,0x4f2a,0x5c3e,0x7eac,0x672a,0x851a,0x5473,0x754f, /* 0xCEB0-0xCEB7 */
	0x80c3,0x5582,0x9b4f,0x4f4d,0x6e2d,0x8c13,0x5c09,0x6170, /* 0xCEB8-0xCEBF */
	/* codebase=0xcec0 rawbase=0x37c0 */
	0x536b,0x761f,0x6e29,0x868a,0x6587,0x95fb,0x7eb9,0x543b, /* 0xCEC0-0xCEC7 */
	0x7a33,0x7d0a,0x95ee,0x55e1,0x7fc1,0x74ee,0x631d,0x8717, /* 0xCEC8-0xCECF */
	0x6da1,0x7a9d,0x6211,0x65a1,0x5367,0x63e1,0x6c83,0x5deb, /* 0xCED0-0xCED7 */
	0x545c,0x94a8,0x4e4c,0x6c61,0x8bec,0x5c4b,0x65e0,0x829c, /* 0xCED8-0xCEDF */
	0x68a7,0x543e,0x5434,0x6bcb,0x6b66,0x4e94,0x6342,0x5348, /* 0xCEE0-0xCEE7 */
	0x821e,0x4f0d,0x4fae,0x575e,0x620a,0x96fe,0x6664,0x7269, /* 0xCEE8-0xCEEF */
	0x52ff,0x52a1,0x609f,0x8bef,0x6614,0x7199,0x6790,0x897f, /* 0xCEF0-0xCEF7 */
	0x7852,0x77fd,0x6670,0x563b,0x5438,0x9521,0x727a,0x0000, /* 0xCEF8-0xCEFF */
	/* codebase=0xcf40 rawbase=0x3800 */
	0x87a5,0x87a6,0x87a7,0x87a9,0x87aa,0x87ae,0x87b0,0x87b1, /* 0xCF40-0xCF47 */
	0x87b2,0x87b4,0x87b6,0x87b7,0x87b8,0x87b9,0x87bb,0x87bc, /* 0xCF48-0xCF4F */
	0x87be,0x87bf,0x87c1,0x87c2,0x87c3,0x87c4,0x87c5,0x87c7, /* 0xCF50-0xCF57 */
	0x87c8,0x87c9,0x87cc,0x87cd,0x87ce,0x87cf,0x87d0,0x87d4, /* 0xCF58-0xCF5F */
	0x87d5,0x87d6,0x87d7,0x87d8,0x87d9,0x87da,0x87dc,0x87dd, /* 0xCF60-0xCF67 */
	0x87de,0x87df,0x87e1,0x87e2,0x87e3,0x87e4,0x87e6,0x87e7, /* 0xCF68-0xCF6F */
	0x87e8,0x87e9,0x87eb,0x87ec,0x87ed,0x87ef,0x87f0,0x87f1, /* 0xCF70-0xCF77 */
	0x87f2,0x87f3,0x87f4,0x87f5,0x87f6,0x87f7,0x87f8,0x0000, /* 0xCF78-0xCF7F */
	/* codebase=0xcf80 rawbase=0x3840 */
	0x87fa,0x87fb,0x87fc,0x87fd,0x87ff,0x8800,0x8801,0x8802, /* 0xCF80-0xCF87 */
	0x8804,0x8805,0x8806,0x8807,0x8808,0x8809,0x880b,0x880c, /* 0xCF88-0xCF8F */
	0x880d,0x880e,0x880f,0x8810,0x8811,0x8812,0x8814,0x8817, /* 0xCF90-0xCF97 */
	0x8818,0x8819,0x881a,0x881c,0x881d,0x881e,0x881f,0x8820, /* 0xCF98-0xCF9F */
	0x8823,0x7a00,0x606f,0x5e0c,0x6089,0x819d,0x5915,0x60dc, /* 0xCFA0-0xCFA7 */
	0x7184,0x70ef,0x6eaa,0x6c50,0x7280,0x6a84,0x88ad,0x5e2d, /* 0xCFA8-0xCFAF */
	0x4e60,0x5ab3,0x559c,0x94e3,0x6d17,0x7cfb,0x9699,0x620f, /* 0xCFB0-0xCFB7 */
	0x7ec6,0x778e,0x867e,0x5323,0x971e,0x8f96,0x6687,0x5ce1, /* 0xCFB8-0xCFBF */
	/* codebase=0xcfc0 rawbase=0x3880 */
	0x4fa0,0x72ed,0x4e0b,0x53a6,0x590f,0x5413,0x6380,0x9528, /* 0xCFC0-0xCFC7 */
	0x5148,0x4ed9,0x9c9c,0x7ea4,0x54b8,0x8d24,0x8854,0x8237, /* 0xCFC8-0xCFCF */
	0x95f2,0x6d8e,0x5f26,0x5acc,0x663e,0x9669,0x73b0,0x732e, /* 0xCFD0-0xCFD7 */
	0x53bf,0x817a,0x9985,0x7fa1,0x5baa,0x9677,0x9650,0x7ebf, /* 0xCFD8-0xCFDF */
	0x76f8,0x53a2,0x9576,0x9999,0x7bb1,0x8944,0x6e58,0x4e61, /* 0xCFE0-0xCFE7 */
	0x7fd4,0x7965,0x8be6,0x60f3,0x54cd,0x4eab,0x9879,0x5df7, /* 0xCFE8-0xCFEF */
	0x6a61,0x50cf,0x5411,0x8c61,0x8427,0x785d,0x9704,0x524a, /* 0xCFF0-0xCFF7 */
	0x54ee,0x56a3,0x9500,0x6d88,0x5bb5,0x6dc6,0x6653,0x0000, /* 0xCFF8-0xCFFF */
	/* codebase=0xd040 rawbase=0x38c0 */
	0x8824,0x8825,0x8826,0x8827,0x8828,0x8829,0x882a,0x882b, /* 0xD040-0xD047 */
	0x882c,0x882d,0x882e,0x882f,0x8830,0x8831,0x8833,0x8834, /* 0xD048-0xD04F */
	0x8835,0x8836,0x8837,0x8838,0x883a,0x883b,0x883d,0x883e, /* 0xD050-0xD057 */
	0x883f,0x8841,0x8842,0x8843,0x8846,0x8847,0x8848,0x8849, /* 0xD058-0xD05F */
	0x884a,0x884b,0x884e,0x884f,0x8850,0x8851,0x8852,0x8853, /* 0xD060-0xD067 */
	0x8855,0x8856,0x8858,0x885a,0x885b,0x885c,0x885d,0x885e, /* 0xD068-0xD06F */
	0x885f,0x8860,0x8866,0x8867,0x886a,0x886d,0x886f,0x8871, /* 0xD070-0xD077 */
	0x8873,0x8874,0x8875,0x8876,0x8878,0x8879,0x887a,0x0000, /* 0xD078-0xD07F */
	/* codebase=0xd080 rawbase=0x3900 */
	0x887b,0x887c,0x8880,0x8883,0x8886,0x8887,0x8889,0x888a, /* 0xD080-0xD087 */
	0x888c,0x888e,0x888f,0x8890,0x8891,0x8893,0x8894,0x8895, /* 0xD088-0xD08F */
	0x8897,0x8898,0x8899,0x889a,0x889b,0x889d,0x889e,0x889f, /* 0xD090-0xD097 */
	0x88a0,0x88a1,0x88a3,0x88a5,0x88a6,0x88a7,0x88a8,0x88a9, /* 0xD098-0xD09F */
	0x88aa,0x5c0f,0x5b5d,0x6821,0x8096,0x5578,0x7b11,0x6548, /* 0xD0A0-0xD0A7 */
	0x6954,0x4e9b,0x6b47,0x874e,0x978b,0x534f,0x631f,0x643a, /* 0xD0A8-0xD0AF */
	0x90aa,0x659c,0x80c1,0x8c10,0x5199,0x68b0,0x5378,0x87f9, /* 0xD0B0-0xD0B7 */
	0x61c8,0x6cc4,0x6cfb,0x8c22,0x5c51,0x85aa,0x82af,0x950c, /* 0xD0B8-0xD0BF */
	/* codebase=0xd0c0 rawbase=0x3940 */
	0x6b23,0x8f9b,0x65b0,0x5ffb,0x5fc3,0x4fe1,0x8845,0x661f, /* 0xD0C0-0xD0C7 */
	0x8165,0x7329,0x60fa,0x5174,0x5211,0x578b,0x5f62,0x90a2, /* 0xD0C8-0xD0CF */
	0x884c,0x9192,0x5e78,0x674f,0x6027,0x59d3,0x5144,0x51f6, /* 0xD0D0-0xD0D7 */
	0x80f8,0x5308,0x6c79,0x96c4,0x718a,0x4f11,0x4fee,0x7f9e, /* 0xD0D8-0xD0DF */
	0x673d,0x55c5,0x9508,0x79c0,0x8896,0x7ee3,0x589f,0x620c, /* 0xD0E0-0xD0E7 */
	0x9700,0x865a,0x5618,0x987b,0x5f90,0x8bb8,0x84c4,0x9157, /* 0xD0E8-0xD0EF */
	0x53d9,0x65ed,0x5e8f,0x755c,0x6064,0x7d6e,0x5a7f,0x7eea, /* 0xD0F0-0xD0F7 */
	0x7eed,0x8f69,0x55a7,0x5ba3,0x60ac,0x65cb,0x7384,0x0000, /* 0xD0F8-0xD0FF */
	/* codebase=0xd140 rawbase=0x3980 */
	0x88ac,0x88ae,0x88af,0x88b0,0x88b2,0x88b3,0x88b4,0x88b5, /* 0xD140-0xD147 */
	0x88b6,0x88b8,0x88b9,0x88ba,0x88bb,0x88bd,0x88be,0x88bf, /* 0xD148-0xD14F */
	0x88c0,0x88c3,0x88c4,0x88c7,0x88c8,0x88ca,0x88cb,0x88cc, /* 0xD150-0xD157 */
	0x88cd,0x88cf,0x88d0,0x88d1,0x88d3,0x88d6,0x88d7,0x88da, /* 0xD158-0xD15F */
	0x88db,0x88dc,0x88dd,0x88de,0x88e0,0x88e1,0x88e6,0x88e7, /* 0xD160-0xD167 */
	0x88e9,0x88ea,0x88eb,0x88ec,0x88ed,0x88ee,0x88ef,0x88f2, /* 0xD168-0xD16F */
	0x88f5,0x88f6,0x88f7,0x88fa,0x88fb,0x88fd,0x88ff,0x8900, /* 0xD170-0xD177 */
	0x8901,0x8903,0x8904,0x8905,0x8906,0x8907,0x8908,0x0000, /* 0xD178-0xD17F */
	/* codebase=0xd180 rawbase=0x39c0 */
	0x8909,0x890b,0x890c,0x890d,0x890e,0x890f,0x8911,0x8914, /* 0xD180-0xD187 */
	0x8915,0x8916,0x8917,0x8918,0x891c,0x891d,0x891e,0x891f, /* 0xD188-0xD18F */
	0x8920,0x8922,0x8923,0x8924,0x8926,0x8927,0x8928,0x8929, /* 0xD190-0xD197 */
	0x892c,0x892d,0x892e,0x892f,0x8931,0x8932,0x8933,0x8935, /* 0xD198-0xD19F */
	0x8937,0x9009,0x7663,0x7729,0x7eda,0x9774,0x859b,0x5b66, /* 0xD1A0-0xD1A7 */
	0x7a74,0x96ea,0x8840,0x52cb,0x718f,0x5faa,0x65ec,0x8be2, /* 0xD1A8-0xD1AF */
	0x5bfb,0x9a6f,0x5de1,0x6b89,0x6c5b,0x8bad,0x8baf,0x900a, /* 0xD1B0-0xD1B7 */
	0x8fc5,0x538b,0x62bc,0x9e26,0x9e2d,0x5440,0x4e2b,0x82bd, /* 0xD1B8-0xD1BF */
	/* codebase=0xd1c0 rawbase=0x3a00 */
	0x7259,0x869c,0x5d16,0x8859,0x6daf,0x96c5,0x54d1,0x4e9a, /* 0xD1C0-0xD1C7 */
	0x8bb6,0x7109,0x54bd,0x9609,0x70df,0x6df9,0x76d0,0x4e25, /* 0xD1C8-0xD1CF */
	0x7814,0x8712,0x5ca9,0x5ef6,0x8a00,0x989c,0x960e,0x708e, /* 0xD1D0-0xD1D7 */
	0x6cbf,0x5944,0x63a9,0x773c,0x884d,0x6f14,0x8273,0x5830, /* 0xD1D8-0xD1DF */
	0x71d5,0x538c,0x781a,0x96c1,0x5501,0x5f66,0x7130,0x5bb4, /* 0xD1E0-0xD1E7 */
	0x8c1a,0x9a8c,0x6b83,0x592e,0x9e2f,0x79e7,0x6768,0x626c, /* 0xD1E8-0xD1EF */
	0x4f6f,0x75a1,0x7f8a,0x6d0b,0x9633,0x6c27,0x4ef0,0x75d2, /* 0xD1F0-0xD1F7 */
	0x517b,0x6837,0x6f3e,0x9080,0x8170,0x5996,0x7476,0x0000, /* 0xD1F8-0xD1FF */
	/* codebase=0xd240 rawbase=0x3a40 */
	0x8938,0x8939,0x893a,0x893b,0x893c,0x893d,0x893e,0x893f, /* 0xD240-0xD247 */
	0x8940,0x8942,0x8943,0x8945,0x8946,0x8947,0x8948,0x8949, /* 0xD248-0xD24F */
	0x894a,0x894b,0x894c,0x894d,0x894e,0x894f,0x8950,0x8951, /* 0xD250-0xD257 */
	0x8952,0x8953,0x8954,0x8955,0x8956,0x8957,0x8958,0x8959, /* 0xD258-0xD25F */
	0x895a,0x895b,0x895c,0x895d,0x8960,0x8961,0x8962,0x8963, /* 0xD260-0xD267 */
	0x8964,0x8965,0x8967,0x8968,0x8969,0x896a,0x896b,0x896c, /* 0xD268-0xD26F */
	0x896d,0x896e,0x896f,0x8970,0x8971,0x8972,0x8973,0x8974, /* 0xD270-0xD277 */
	0x8975,0x8976,0x8977,0x8978,0x8979,0x897a,0x897c,0x0000, /* 0xD278-0xD27F */
	/* codebase=0xd280 rawbase=0x3a80 */
	0x897d,0x897e,0x8980,0x8982,0x8984,0x8985,0x8987,0x8988, /* 0xD280-0xD287 */
	0x8989,0x898a,0x898b,0x898c,0x898d,0x898e,0x898f,0x8990, /* 0xD288-0xD28F */
	0x8991,0x8992,0x8993,0x8994,0x8995,0x8996,0x8997,0x8998, /* 0xD290-0xD297 */
	0x8999,0x899a,0x899b,0x899c,0x899d,0x899e,0x899f,0x89a0, /* 0xD298-0xD29F */
	0x89a1,0x6447,0x5c27,0x9065,0x7a91,0x8c23,0x59da,0x54ac, /* 0xD2A0-0xD2A7 */
	0x8200,0x836f,0x8981,0x8000,0x6930,0x564e,0x8036,0x7237, /* 0xD2A8-0xD2AF */
	0x91ce,0x51b6,0x4e5f,0x9875,0x6396,0x4e1a,0x53f6,0x66f3, /* 0xD2B0-0xD2B7 */
	0x814b,0x591c,0x6db2,0x4e00,0x58f9,0x533b,0x63d6,0x94f1, /* 0xD2B8-0xD2BF */
	/* codebase=0xd2c0 rawbase=0x3ac0 */
	0x4f9d,0x4f0a,0x8863,0x9890,0x5937,0x9057,0x79fb,0x4eea, /* 0xD2C0-0xD2C7 */
	0x80f0,0x7591,0x6c82,0x5b9c,0x59e8,0x5f5d,0x6905,0x8681, /* 0xD2C8-0xD2CF */
	0x501a,0x5df2,0x4e59,0x77e3,0x4ee5,0x827a,0x6291,0x6613, /* 0xD2D0-0xD2D7 */
	0x9091,0x5c79,0x4ebf,0x5f79,0x81c6,0x9038,0x8084,0x75ab, /* 0xD2D8-0xD2DF */
	0x4ea6,0x88d4,0x610f,0x6bc5,0x5fc6,0x4e49,0x76ca,0x6ea2, /* 0xD2E0-0xD2E7 */
	0x8be3,0x8bae,0x8c0a,0x8bd1,0x5f02,0x7ffc,0x7fcc,0x7ece, /* 0xD2E8-0xD2EF */
	0x8335,0x836b,0x56e0,0x6bb7,0x97f3,0x9634,0x59fb,0x541f, /* 0xD2F0-0xD2F7 */
	0x94f6,0x6deb,0x5bc5,0x996e,0x5c39,0x5f15,0x9690,0x0000, /* 0xD2F8-0xD2FF */
	/* codebase=0xd340 rawbase=0x3b00 */
	0x89a2,0x89a3,0x89a4,0x89a5,0x89a6,0x89a7,0x89a8,0x89a9, /* 0xD340-0xD347 */
	0x89aa,0x89ab,0x89ac,0x89ad,0x89ae,0x89af,0x89b0,0x89b1, /* 0xD348-0xD34F */
	0x89b2,0x89b3,0x89b4,0x89b5,0x89b6,0x89b7,0x89b8,0x89b9, /* 0xD350-0xD357 */
	0x89ba,0x89bb,0x89bc,0x89bd,0x89be,0x89bf,0x89c0,0x89c3, /* 0xD358-0xD35F */
	0x89cd,0x89d3,0x89d4,0x89d5,0x89d7,0x89d8,0x89d9,0x89db, /* 0xD360-0xD367 */
	0x89dd,0x89df,0x89e0,0x89e1,0x89e2,0x89e4,0x89e7,0x89e8, /* 0xD368-0xD36F */
	0x89e9,0x89ea,0x89ec,0x89ed,0x89ee,0x89f0,0x89f1,0x89f2, /* 0xD370-0xD377 */
	0x89f4,0x89f5,0x89f6,0x89f7,0x89f8,0x89f9,0x89fa,0x0000, /* 0xD378-0xD37F */
	/* codebase=0xd380 rawbase=0x3b40 */
	0x89fb,0x89fc,0x89fd,0x89fe,0x89ff,0x8a01,0x8a02,0x8a03, /* 0xD380-0xD387 */
	0x8a04,0x8a05,0x8a06,0x8a08,0x8a09,0x8a0a,0x8a0b,0x8a0c, /* 0xD388-0xD38F */
	0x8a0d,0x8a0e,0x8a0f,0x8a10,0x8a11,0x8a12,0x8a13,0x8a14, /* 0xD390-0xD397 */
	0x8a15,0x8a16,0x8a17,0x8a18,0x8a19,0x8a1a,0x8a1b,0x8a1c, /* 0xD398-0xD39F */
	0x8a1d,0x5370,0x82f1,0x6a31,0x5a74,0x9e70,0x5e94,0x7f28, /* 0xD3A0-0xD3A7 */
	0x83b9,0x8424,0x8425,0x8367,0x8747,0x8fce,0x8d62,0x76c8, /* 0xD3A8-0xD3AF */
	0x5f71,0x9896,0x786c,0x6620,0x54df,0x62e5,0x4f63,0x81c3, /* 0xD3B0-0xD3B7 */
	0x75c8,0x5eb8,0x96cd,0x8e0a,0x86f9,0x548f,0x6cf3,0x6d8c, /* 0xD3B8-0xD3BF */
	/* codebase=0xd3c0 rawbase=0x3b80 */
	0x6c38,0x607f,0x52c7,0x7528,0x5e7d,0x4f18,0x60a0,0x5fe7, /* 0xD3C0-0xD3C7 */
	0x5c24,0x7531,0x90ae,0x94c0,0x72b9,0x6cb9,0x6e38,0x9149, /* 0xD3C8-0xD3CF */
	0x6709,0x53cb,0x53f3,0x4f51,0x91c9,0x8bf1,0x53c8,0x5e7c, /* 0xD3D0-0xD3D7 */
	0x8fc2,0x6de4,0x4e8e,0x76c2,0x6986,0x865e,0x611a,0x8206, /* 0xD3D8-0xD3DF */
	0x4f59,0x4fde,0x903e,0x9c7c,0x6109,0x6e1d,0x6e14,0x9685, /* 0xD3E0-0xD3E7 */
	0x4e88,0x5a31,0x96e8,0x4e0e,0x5c7f,0x79b9,0x5b87,0x8bed, /* 0xD3E8-0xD3EF */
	0x7fbd,0x7389,0x57df,0x828b,0x90c1,0x5401,0x9047,0x55bb, /* 0xD3F0-0xD3F7 */
	0x5cea,0x5fa1,0x6108,0x6b32,0x72f1,0x80b2,0x8a89,0x0000, /* 0xD3F8-0xD3FF */
	/* codebase=0xd440 rawbase=0x3bc0 */
	0x8a1e,0x8a1f,0x8a20,0x8a21,0x8a22,0x8a23,0x8a24,0x8a25, /* 0xD440-0xD447 */
	0x8a26,0x8a27,0x8a28,0x8a29,0x8a2a,0x8a2b,0x8a2c,0x8a2d, /* 0xD448-0xD44F */
	0x8a2e,0x8a2f,0x8a30,0x8a31,0x8a32,0x8a33,0x8a34,0x8a35, /* 0xD450-0xD457 */
	0x8a36,0x8a37,0x8a38,0x8a39,0x8a3a,0x8a3b,0x8a3c,0x8a3d, /* 0xD458-0xD45F */
	0x8a3f,0x8a40,0x8a41,0x8a42,0x8a43,0x8a44,0x8a45,0x8a46, /* 0xD460-0xD467 */
	0x8a47,0x8a49,0x8a4a,0x8a4b,0x8a4c,0x8a4d,0x8a4e,0x8a4f, /* 0xD468-0xD46F */
	0x8a50,0x8a51,0x8a52,0x8a53,0x8a54,0x8a55,0x8a56,0x8a57, /* 0xD470-0xD477 */
	0x8a58,0x8a59,0x8a5a,0x8a5b,0x8a5c,0x8a5d,0x8a5e,0x0000, /* 0xD478-0xD47F */
	/* codebase=0xd480 rawbase=0x3c00 */
	0x8a5f,0x8a60,0x8a61,0x8a62,0x8a63,0x8a64,0x8a65,0x8a66, /* 0xD480-0xD487 */
	0x8a67,0x8a68,0x8a69,0x8a6a,0x8a6b,0x8a6c,0x8a6d,0x8a6e, /* 0xD488-0xD48F */
	0x8a6f,0x8a70,0x8a71,0x8a72,0x8a73,0x8a74,0x8a75,0x8a76, /* 0xD490-0xD497 */
	0x8a77,0x8a78,0x8a7a,0x8a7b,0x8a7c,0x8a7d,0x8a7e,0x8a7f, /* 0xD498-0xD49F */
	0x8a80,0x6d74,0x5bd3,0x88d5,0x9884,0x8c6b,0x9a6d,0x9e33, /* 0xD4A0-0xD4A7 */
	0x6e0a,0x51a4,0x5143,0x57a3,0x8881,0x539f,0x63f4,0x8f95, /* 0xD4A8-0xD4AF */
	0x56ed,0x5458,0x5706,0x733f,0x6e90,0x7f18,0x8fdc,0x82d1, /* 0xD4B0-0xD4B7 */
	0x613f,0x6028,0x9662,0x66f0,0x7ea6,0x8d8a,0x8dc3,0x94a5, /* 0xD4B8-0xD4BF */
	/* codebase=0xd4c0 rawbase=0x3c40 */
	0x5cb3,0x7ca4,0x6708,0x60a6,0x9605,0x8018,0x4e91,0x90e7, /* 0xD4C0-0xD4C7 */
	0x5300,0x9668,0x5141,0x8fd0,0x8574,0x915d,0x6655,0x97f5, /* 0xD4C8-0xD4CF */
	0x5b55,0x531d,0x7838,0x6742,0x683d,0x54c9,0x707e,0x5bb0, /* 0xD4D0-0xD4D7 */
	0x8f7d,0x518d,0x5728,0x54b1,0x6512,0x6682,0x8d5e,0x8d43, /* 0xD4D8-0xD4DF */
	0x810f,0x846c,0x906d,0x7cdf,0x51ff,0x85fb,0x67a3,0x65e9, /* 0xD4E0-0xD4E7 */
	0x6fa1,0x86a4,0x8e81,0x566a,0x9020,0x7682,0x7076,0x71e5, /* 0xD4E8-0xD4EF */
	0x8d23,0x62e9,0x5219,0x6cfd,0x8d3c,0x600e,0x589e,0x618e, /* 0xD4F0-0xD4F7 */
	0x66fe,0x8d60,0x624e,0x55b3,0x6e23,0x672d,0x8f67,0x0000, /* 0xD4F8-0xD4FF */
	/* codebase=0xd540 rawbase=0x3c80 */
	0x8a81,0x8a82,0x8a83,0x8a84,0x8a85,0x8a86,0x8a87,0x8a88, /* 0xD540-0xD547 */
	0x8a8b,0x8a8c,0x8a8d,0x8a8e,0x8a8f,0x8a90,0x8a91,0x8a92, /* 0xD548-0xD54F */
	0x8a94,0x8a95,0x8a96,0x8a97,0x8a98,0x8a99,0x8a9a,0x8a9b, /* 0xD550-0xD557 */
	0x8a9c,0x8a9d,0x8a9e,0x8a9f,0x8aa0,0x8aa1,0x8aa2,0x8aa3, /* 0xD558-0xD55F */
	0x8aa4,0x8aa5,0x8aa6,0x8aa7,0x8aa8,0x8aa9,0x8aaa,0x8aab, /* 0xD560-0xD567 */
	0x8aac,0x8aad,0x8aae,0x8aaf,0x8ab0,0x8ab1,0x8ab2,0x8ab3, /* 0xD568-0xD56F */
	0x8ab4,0x8ab5,0x8ab6,0x8ab7,0x8ab8,0x8ab9,0x8aba,0x8abb, /* 0xD570-0xD577 */
	0x8abc,0x8abd,0x8abe,0x8abf,0x8ac0,0x8ac1,0x8ac2,0x0000, /* 0xD578-0xD57F */
	/* codebase=0xd580 rawbase=0x3cc0 */
	0x8ac3,0x8ac4,0x8ac5,0x8ac6,0x8ac7,0x8ac8,0x8ac9,0x8aca, /* 0xD580-0xD587 */
	0x8acb,0x8acc,0x8acd,0x8ace,0x8acf,0x8ad0,0x8ad1,0x8ad2, /* 0xD588-0xD58F */
	0x8ad3,0x8ad4,0x8ad5,0x8ad6,0x8ad7,0x8ad8,0x8ad9,0x8ada, /* 0xD590-0xD597 */
	0x8adb,0x8adc,0x8add,0x8ade,0x8adf,0x8ae0,0x8ae1,0x8ae2, /* 0xD598-0xD59F */
	0x8ae3,0x94e1,0x95f8,0x7728,0x6805,0x69a8,0x548b,0x4e4d, /* 0xD5A0-0xD5A7 */
	0x70b8,0x8bc8,0x6458,0x658b,0x5b85,0x7a84,0x503a,0x5be8, /* 0xD5A8-0xD5AF */
	0x77bb,0x6be1,0x8a79,0x7c98,0x6cbe,0x76cf,0x65a9,0x8f97, /* 0xD5B0-0xD5B7 */
	0x5d2d,0x5c55,0x8638,0x6808,0x5360,0x6218,0x7ad9,0x6e5b, /* 0xD5B8-0xD5BF */
	/* codebase=0xd5c0 rawbase=0x3d00 */
	0x7efd,0x6a1f,0x7ae0,0x5f70,0x6f33,0x5f20,0x638c,0x6da8, /* 0xD5C0-0xD5C7 */
	0x6756,0x4e08,0x5e10,0x8d26,0x4ed7,0x80c0,0x7634,0x969c, /* 0xD5C8-0xD5CF */
	0x62db,0x662d,0x627e,0x6cbc,0x8d75,0x7167,0x7f69,0x5146, /* 0xD5D0-0xD5D7 */
	0x8087,0x53ec,0x906e,0x6298,0x54f2,0x86f0,0x8f99,0x8005, /* 0xD5D8-0xD5DF */
	0x9517,0x8517,0x8fd9,0x6d59,0x73cd,0x659f,0x771f,0x7504, /* 0xD5E0-0xD5E7 */
	0x7827,0x81fb,0x8d1e,0x9488,0x4fa6,0x6795,0x75b9,0x8bca, /* 0xD5E8-0xD5EF */
	0x9707,0x632f,0x9547,0x9635,0x84b8,0x6323,0x7741,0x5f81, /* 0xD5F0-0xD5F7 */
	0x72f0,0x4e89,0x6014,0x6574,0x62ef,0x6b63,0x653f,0x0000, /* 0xD5F8-0xD5FF */
	/* codebase=0xd640 rawbase=0x3d40 */
	0x8ae4,0x8ae5,0x8ae6,0x8ae7,0x8ae8,0x8ae9,0x8aea,0x8aeb, /* 0xD640-0xD647 */
	0x8aec,0x8aed,0x8aee,0x8aef,0x8af0,0x8af1,0x8af2,0x8af3, /* 0xD648-0xD64F */
	0x8af4,0x8af5,0x8af6,0x8af7,0x8af8,0x8af9,0x8afa,0x8afb, /* 0xD650-0xD657 */
	0x8afc,0x8afd,0x8afe,0x8aff,0x8b00,0x8b01,0x8b02,0x8b03, /* 0xD658-0xD65F */
	0x8b04,0x8b05,0x8b06,0x8b08,0x8b09,0x8b0a,0x8b0b,0x8b0c, /* 0xD660-0xD667 */
	0x8b0d,0x8b0e,0x8b0f,0x8b10,0x8b11,0x8b12,0x8b13,0x8b14, /* 0xD668-0xD66F */
	0x8b15,0x8b16,0x8b17,0x8b18,0x8b19,0x8b1a,0x8b1b,0x8b1c, /* 0xD670-0xD677 */
	0x8b1d,0x8b1e,0x8b1f,0x8b20,0x8b21,0x8b22,0x8b23,0x0000, /* 0xD678-0xD67F */
	/* codebase=0xd680 rawbase=0x3d80 */
	0x8b24,0x8b25,0x8b27,0x8b28,0x8b29,0x8b2a,0x8b2b,0x8b2c, /* 0xD680-0xD687 */
	0x8b2d,0x8b2e,0x8b2f,0x8b30,0x8b31,0x8b32,0x8b33,0x8b34, /* 0xD688-0xD68F */
	0x8b35,0x8b36,0x8b37,0x8b38,0x8b39,0x8b3a,0x8b3b,0x8b3c, /* 0xD690-0xD697 */
	0x8b3d,0x8b3e,0x8b3f,0x8b40,0x8b41,0x8b42,0x8b43,0x8b44, /* 0xD698-0xD69F */
	0x8b45,0x5e27,0x75c7,0x90d1,0x8bc1,0x829d,0x679d,0x652f, /* 0xD6A0-0xD6A7 */
	0x5431,0x8718,0x77e5,0x80a2,0x8102,0x6c41,0x4e4b,0x7ec7, /* 0xD6A8-0xD6AF */
	0x804c,0x76f4,0x690d,0x6b96,0x6267,0x503c,0x4f84,0x5740, /* 0xD6B0-0xD6B7 */
	0x6307,0x6b62,0x8dbe,0x53ea,0x65e8,0x7eb8,0x5fd7,0x631a, /* 0xD6B8-0xD6BF */
	/* codebase=0xd6c0 rawbase=0x3dc0 */
	0x63b7,0x81f3,0x81f4,0x7f6e,0x5e1c,0x5cd9,0x5236,0x667a, /* 0xD6C0-0xD6C7 */
	0x79e9,0x7a1a,0x8d28,0x7099,0x75d4,0x6ede,0x6cbb,0x7a92, /* 0xD6C8-0xD6CF */
	0x4e2d,0x76c5,0x5fe0,0x949f,0x8877,0x7ec8,0x79cd,0x80bf, /* 0xD6D0-0xD6D7 */
	0x91cd,0x4ef2,0x4f17,0x821f,0x5468,0x5dde,0x6d32,0x8bcc, /* 0xD6D8-0xD6DF */
	0x7ca5,0x8f74,0x8098,0x5e1a,0x5492,0x76b1,0x5b99,0x663c, /* 0xD6E0-0xD6E7 */
	0x9aa4,0x73e0,0x682a,0x86db,0x6731,0x732a,0x8bf8,0x8bdb, /* 0xD6E8-0xD6EF */
	0x9010,0x7af9,0x70db,0x716e,0x62c4,0x77a9,0x5631,0x4e3b, /* 0xD6F0-0xD6F7 */
	0x8457,0x67f1,0x52a9,0x86c0,0x8d2e,0x94f8,0x7b51,0x0000, /* 0xD6F8-0xD6FF */
	/* codebase=0xd740 rawbase=0x3e00 */
	0x8b46,0x8b47,0x8b48,0x8b49,0x8b4a,0x8b4b,0x8b4c,0x8b4d, /* 0xD740-0xD747 */
	0x8b4e,0x8b4f,0x8b50,0x8b51,0x8b52,0x8b53,0x8b54,0x8b55, /* 0xD748-0xD74F */
	0x8b56,0x8b57,0x8b58,0x8b59,0x8b5a,0x8b5b,0x8b5c,0x8b5d, /* 0xD750-0xD757 */
	0x8b5e,0x8b5f,0x8b60,0x8b61,0x8b62,0x8b63,0x8b64,0x8b65, /* 0xD758-0xD75F */
	0x8b67,0x8b68,0x8b69,0x8b6a,0x8b6b,0x8b6d,0x8b6e,0x8b6f, /* 0xD760-0xD767 */
	0x8b70,0x8b71,0x8b72,0x8b73,0x8b74,0x8b75,0x8b76,0x8b77, /* 0xD768-0xD76F */
	0x8b78,0x8b79,0x8b7a,0x8b7b,0x8b7c,0x8b7d,0x8b7e,0x8b7f, /* 0xD770-0xD777 */
	0x8b80,0x8b81,0x8b82,0x8b83,0x8b84,0x8b85,0x8b86,0x0000, /* 0xD778-0xD77F */
	/* codebase=0xd780 rawbase=0x3e40 */
	0x8b87,0x8b88,0x8b89,0x8b8a,0x8b8b,0x8b8c,0x8b8d,0x8b8e, /* 0xD780-0xD787 */
	0x8b8f,0x8b90,0x8b91,0x8b92,0x8b93,0x8b94,0x8b95,0x8b96, /* 0xD788-0xD78F */
	0x8b97,0x8b98,0x8b99,0x8b9a,0x8b9b,0x8b9c,0x8b9d,0x8b9e, /* 0xD790-0xD797 */
	0x8b9f,0x8bac,0x8bb1,0x8bbb,0x8bc7,0x8bd0,0x8bea,0x8c09, /* 0xD798-0xD79F */
	0x8c1e,0x4f4f,0x6ce8,0x795d,0x9a7b,0x6293,0x722a,0x62fd, /* 0xD7A0-0xD7A7 */
	0x4e13,0x7816,0x8f6c,0x64b0,0x8d5a,0x7bc6,0x6869,0x5e84, /* 0xD7A8-0xD7AF */
	0x88c5,0x5986,0x649e,0x58ee,0x72b6,0x690e,0x9525,0x8ffd, /* 0xD7B0-0xD7B7 */
	0x8d58,0x5760,0x7f00,0x8c06,0x51c6,0x6349,0x62d9,0x5353, /* 0xD7B8-0xD7BF */
	/* codebase=0xd7c0 rawbase=0x3e80 */
	0x684c,0x7422,0x8301,0x914c,0x5544,0x7740,0x707c,0x6d4a, /* 0xD7C0-0xD7C7 */
	0x5179,0x54a8,0x8d44,0x59ff,0x6ecb,0x6dc4,0x5b5c,0x7d2b, /* 0xD7C8-0xD7CF */
	0x4ed4,0x7c7d,0x6ed3,0x5b50,0x81ea,0x6e0d,0x5b57,0x9b03, /* 0xD7D0-0xD7D7 */
	0x68d5,0x8e2a,0x5b97,0x7efc,0x603b,0x7eb5,0x90b9,0x8d70, /* 0xD7D8-0xD7DF */
	0x594f,0x63cd,0x79df,0x8db3,0x5352,0x65cf,0x7956,0x8bc5, /* 0xD7E0-0xD7E7 */
	0x963b,0x7ec4,0x94bb,0x7e82,0x5634,0x9189,0x6700,0x7f6a, /* 0xD7E8-0xD7EF */
	0x5c0a,0x9075,0x6628,0x5de6,0x4f50,0x67de,0x505a,0x4f5c, /* 0xD7F0-0xD7F7 */
	0x5750,0x5ea7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD7F8-0xD7FF */
	/* codebase=0xd840 rawbase=0x3ec0 */
	0x8c38,0x8c39,0x8c3a,0x8c3b,0x8c3c,0x8c3d,0x8c3e,0x8c3f, /* 0xD840-0xD847 */
	0x8c40,0x8c42,0x8c43,0x8c44,0x8c45,0x8c48,0x8c4a,0x8c4b, /* 0xD848-0xD84F */
	0x8c4d,0x8c4e,0x8c4f,0x8c50,0x8c51,0x8c52,0x8c53,0x8c54, /* 0xD850-0xD857 */
	0x8c56,0x8c57,0x8c58,0x8c59,0x8c5b,0x8c5c,0x8c5d,0x8c5e, /* 0xD858-0xD85F */
	0x8c5f,0x8c60,0x8c63,0x8c64,0x8c65,0x8c66,0x8c67,0x8c68, /* 0xD860-0xD867 */
	0x8c69,0x8c6c,0x8c6d,0x8c6e,0x8c6f,0x8c70,0x8c71,0x8c72, /* 0xD868-0xD86F */
	0x8c74,0x8c75,0x8c76,0x8c77,0x8c7b,0x8c7c,0x8c7d,0x8c7e, /* 0xD870-0xD877 */
	0x8c7f,0x8c80,0x8c81,0x8c83,0x8c84,0x8c86,0x8c87,0x0000, /* 0xD878-0xD87F */
	/* codebase=0xd880 rawbase=0x3f00 */
	0x8c88,0x8c8b,0x8c8d,0x8c8e,0x8c8f,0x8c90,0x8c91,0x8c92, /* 0xD880-0xD887 */
	0x8c93,0x8c95,0x8c96,0x8c97,0x8c99,0x8c9a,0x8c9b,0x8c9c, /* 0xD888-0xD88F */
	0x8c9d,0x8c9e,0x8c9f,0x8ca0,0x8ca1,0x8ca2,0x8ca3,0x8ca4, /* 0xD890-0xD897 */
	0x8ca5,0x8ca6,0x8ca7,0x8ca8,0x8ca9,0x8caa,0x8cab,0x8cac, /* 0xD898-0xD89F */
	0x8cad,0x4e8d,0x4e0c,0x5140,0x4e10,0x5eff,0x5345,0x4e15, /* 0xD8A0-0xD8A7 */
	0x4e98,0x4e1e,0x9b32,0x5b6c,0x5669,0x4e28,0x79ba,0x4e3f, /* 0xD8A8-0xD8AF */
	0x5315,0x4e47,0x592d,0x723b,0x536e,0x6c10,0x56df,0x80e4, /* 0xD8B0-0xD8B7 */
	0x9997,0x6bd3,0x777e,0x9f17,0x4e36,0x4e9f,0x9f10,0x4e5c, /* 0xD8B8-0xD8BF */
	/* codebase=0xd8c0 rawbase=0x3f40 */
	0x4e69,0x4e93,0x8288,0x5b5b,0x556c,0x560f,0x4ec4,0x538d, /* 0xD8C0-0xD8C7 */
	0x539d,0x53a3,0x53a5,0x53ae,0x9765,0x8d5d,0x531a,0x53f5, /* 0xD8C8-0xD8CF */
	0x5326,0x532e,0x533e,0x8d5c,0x5366,0x5363,0x5202,0x5208, /* 0xD8D0-0xD8D7 */
	0x520e,0x522d,0x5233,0x523f,0x5240,0x524c,0x525e,0x5261, /* 0xD8D8-0xD8DF */
	0x525c,0x84af,0x527d,0x5282,0x5281,0x5290,0x5293,0x5182, /* 0xD8E0-0xD8E7 */
	0x7f54,0x4ebb,0x4ec3,0x4ec9,0x4ec2,0x4ee8,0x4ee1,0x4eeb, /* 0xD8E8-0xD8EF */
	0x4ede,0x4f1b,0x4ef3,0x4f22,0x4f64,0x4ef5,0x4f25,0x4f27, /* 0xD8F0-0xD8F7 */
	0x4f09,0x4f2b,0x4f5e,0x4f67,0x6538,0x4f5a,0x4f5d,0x0000, /* 0xD8F8-0xD8FF */
	/* codebase=0xd940 rawbase=0x3f80 */
	0x8cae,0x8caf,0x8cb0,0x8cb1,0x8cb2,0x8cb3,0x8cb4,0x8cb5, /* 0xD940-0xD947 */
	0x8cb6,0x8cb7,0x8cb8,0x8cb9,0x8cba,0x8cbb,0x8cbc,0x8cbd, /* 0xD948-0xD94F */
	0x8cbe,0x8cbf,0x8cc0,0x8cc1,0x8cc2,0x8cc3,0x8cc4,0x8cc5, /* 0xD950-0xD957 */
	0x8cc6,0x8cc7,0x8cc8,0x8cc9,0x8cca,0x8ccb,0x8ccc,0x8ccd, /* 0xD958-0xD95F */
	0x8cce,0x8ccf,0x8cd0,0x8cd1,0x8cd2,0x8cd3,0x8cd4,0x8cd5, /* 0xD960-0xD967 */
	0x8cd6,0x8cd7,0x8cd8,0x8cd9,0x8cda,0x8cdb,0x8cdc,0x8cdd, /* 0xD968-0xD96F */
	0x8cde,0x8cdf,0x8ce0,0x8ce1,0x8ce2,0x8ce3,0x8ce4,0x8ce5, /* 0xD970-0xD977 */
	0x8ce6,0x8ce7,0x8ce8,0x8ce9,0x8cea,0x8ceb,0x8cec,0x0000, /* 0xD978-0xD97F */
	/* codebase=0xd980 rawbase=0x3fc0 */
	0x8ced,0x8cee,0x8cef,0x8cf0,0x8cf1,0x8cf2,0x8cf3,0x8cf4, /* 0xD980-0xD987 */
	0x8cf5,0x8cf6,0x8cf7,0x8cf8,0x8cf9,0x8cfa,0x8cfb,0x8cfc, /* 0xD988-0xD98F */
	0x8cfd,0x8cfe,0x8cff,0x8d00,0x8d01,0x8d02,0x8d03,0x8d04, /* 0xD990-0xD997 */
	0x8d05,0x8d06,0x8d07,0x8d08,0x8d09,0x8d0a,0x8d0b,0x8d0c, /* 0xD998-0xD99F */
	0x8d0d,0x4f5f,0x4f57,0x4f32,0x4f3d,0x4f76,0x4f74,0x4f91, /* 0xD9A0-0xD9A7 */
	0x4f89,0x4f83,0x4f8f,0x4f7e,0x4f7b,0x4faa,0x4f7c,0x4fac, /* 0xD9A8-0xD9AF */
	0x4f94,0x4fe6,0x4fe8,0x4fea,0x4fc5,0x4fda,0x4fe3,0x4fdc, /* 0xD9B0-0xD9B7 */
	0x4fd1,0x4fdf,0x4ff8,0x5029,0x504c,0x4ff3,0x502c,0x500f, /* 0xD9B8-0xD9BF */
	/* codebase=0xd9c0 rawbase=0x4000 */
	0x502e,0x502d,0x4ffe,0x501c,0x500c,0x5025,0x5028,0x507e, /* 0xD9C0-0xD9C7 */
	0x5043,0x5055,0x5048,0x504e,0x506c,0x507b,0x50a5,0x50a7, /* 0xD9C8-0xD9CF */
	0x50a9,0x50ba,0x50d6,0x5106,0x50ed,0x50ec,0x50e6,0x50ee, /* 0xD9D0-0xD9D7 */
	0x5107,0x510b,0x4edd,0x6c3d,0x4f58,0x4f65,0x4fce,0x9fa0, /* 0xD9D8-0xD9DF */
	0x6c46,0x7c74,0x516e,0x5dfd,0x9ec9,0x9998,0x5181,0x5914, /* 0xD9E0-0xD9E7 */
	0x52f9,0x530d,0x8a07,0x5310,0x51eb,0x5919,0x5155,0x4ea0, /* 0xD9E8-0xD9EF */
	0x5156,0x4eb3,0x886e,0x88a4,0x4eb5,0x8114,0x88d2,0x7980, /* 0xD9F0-0xD9F7 */
	0x5b34,0x8803,0x7fb8,0x51ab,0x51b1,0x51bd,0x51bc,0x0000, /* 0xD9F8-0xD9FF */
	/* codebase=0xda40 rawbase=0x4040 */
	0x8d0e,0x8d0f,0x8d10,0x8d11,0x8d12,0x8d13,0x8d14,0x8d15, /* 0xDA40-0xDA47 */
	0x8d16,0x8d17,0x8d18,0x8d19,0x8d1a,0x8d1b,0x8d1c,0x8d20, /* 0xDA48-0xDA4F */
	0x8d51,0x8d52,0x8d57,0x8d5f,0x8d65,0x8d68,0x8d69,0x8d6a, /* 0xDA50-0xDA57 */
	0x8d6c,0x8d6e,0x8d6f,0x8d71,0x8d72,0x8d78,0x8d79,0x8d7a, /* 0xDA58-0xDA5F */
	0x8d7b,0x8d7c,0x8d7d,0x8d7e,0x8d7f,0x8d80,0x8d82,0x8d83, /* 0xDA60-0xDA67 */
	0x8d86,0x8d87,0x8d88,0x8d89,0x8d8c,0x8d8d,0x8d8e,0x8d8f, /* 0xDA68-0xDA6F */
	0x8d90,0x8d92,0x8d93,0x8d95,0x8d96,0x8d97,0x8d98,0x8d99, /* 0xDA70-0xDA77 */
	0x8d9a,0x8d9b,0x8d9c,0x8d9d,0x8d9e,0x8da0,0x8da1,0x0000, /* 0xDA78-0xDA7F */
	/* codebase=0xda80 rawbase=0x4080 */
	0x8da2,0x8da4,0x8da5,0x8da6,0x8da7,0x8da8,0x8da9,0x8daa, /* 0xDA80-0xDA87 */
	0x8dab,0x8dac,0x8dad,0x8dae,0x8daf,0x8db0,0x8db2,0x8db6, /* 0xDA88-0xDA8F */
	0x8db7,0x8db9,0x8dbb,0x8dbd,0x8dc0,0x8dc1,0x8dc2,0x8dc5, /* 0xDA90-0xDA97 */
	0x8dc7,0x8dc8,0x8dc9,0x8dca,0x8dcd,0x8dd0,0x8dd2,0x8dd3, /* 0xDA98-0xDA9F */
	0x8dd4,0x51c7,0x5196,0x51a2,0x51a5,0x8ba0,0x8ba6,0x8ba7, /* 0xDAA0-0xDAA7 */
	0x8baa,0x8bb4,0x8bb5,0x8bb7,0x8bc2,0x8bc3,0x8bcb,0x8bcf, /* 0xDAA8-0xDAAF */
	0x8bce,0x8bd2,0x8bd3,0x8bd4,0x8bd6,0x8bd8,0x8bd9,0x8bdc, /* 0xDAB0-0xDAB7 */
	0x8bdf,0x8be0,0x8be4,0x8be8,0x8be9,0x8bee,0x8bf0,0x8bf3, /* 0xDAB8-0xDABF */
	/* codebase=0xdac0 rawbase=0x40c0 */
	0x8bf6,0x8bf9,0x8bfc,0x8bff,0x8c00,0x8c02,0x8c04,0x8c07, /* 0xDAC0-0xDAC7 */
	0x8c0c,0x8c0f,0x8c11,0x8c12,0x8c14,0x8c15,0x8c16,0x8c19, /* 0xDAC8-0xDACF */
	0x8c1b,0x8c18,0x8c1d,0x8c1f,0x8c20,0x8c21,0x8c25,0x8c27, /* 0xDAD0-0xDAD7 */
	0x8c2a,0x8c2b,0x8c2e,0x8c2f,0x8c32,0x8c33,0x8c35,0x8c36, /* 0xDAD8-0xDADF */
	0x5369,0x537a,0x961d,0x9622,0x9621,0x9631,0x962a,0x963d, /* 0xDAE0-0xDAE7 */
	0x963c,0x9642,0x9649,0x9654,0x965f,0x9667,0x966c,0x9672, /* 0xDAE8-0xDAEF */
	0x9674,0x9688,0x968d,0x9697,0x96b0,0x9097,0x909b,0x909d, /* 0xDAF0-0xDAF7 */
	0x9099,0x90ac,0x90a1,0x90b4,0x90b3,0x90b6,0x90ba,0x0000, /* 0xDAF8-0xDAFF */
	/* codebase=0xdb40 rawbase=0x4100 */
	0x8dd5,0x8dd8,0x8dd9,0x8ddc,0x8de0,0x8de1,0x8de2,0x8de5, /* 0xDB40-0xDB47 */
	0x8de6,0x8de7,0x8de9,0x8ded,0x8dee,0x8df0,0x8df1,0x8df2, /* 0xDB48-0xDB4F */
	0x8df4,0x8df6,0x8dfc,0x8dfe,0x8dff,0x8e00,0x8e01,0x8e02, /* 0xDB50-0xDB57 */
	0x8e03,0x8e04,0x8e06,0x8e07,0x8e08,0x8e0b,0x8e0d,0x8e0e, /* 0xDB58-0xDB5F */
	0x8e10,0x8e11,0x8e12,0x8e13,0x8e15,0x8e16,0x8e17,0x8e18, /* 0xDB60-0xDB67 */
	0x8e19,0x8e1a,0x8e1b,0x8e1c,0x8e20,0x8e21,0x8e24,0x8e25, /* 0xDB68-0xDB6F */
	0x8e26,0x8e27,0x8e28,0x8e2b,0x8e2d,0x8e30,0x8e32,0x8e33, /* 0xDB70-0xDB77 */
	0x8e34,0x8e36,0x8e37,0x8e38,0x8e3b,0x8e3c,0x8e3e,0x0000, /* 0xDB78-0xDB7F */
	/* codebase=0xdb80 rawbase=0x4140 */
	0x8e3f,0x8e43,0x8e45,0x8e46,0x8e4c,0x8e4d,0x8e4e,0x8e4f, /* 0xDB80-0xDB87 */
	0x8e50,0x8e53,0x8e54,0x8e55,0x8e56,0x8e57,0x8e58,0x8e5a, /* 0xDB88-0xDB8F */
	0x8e5b,0x8e5c,0x8e5d,0x8e5e,0x8e5f,0x8e60,0x8e61,0x8e62, /* 0xDB90-0xDB97 */
	0x8e63,0x8e64,0x8e65,0x8e67,0x8e68,0x8e6a,0x8e6b,0x8e6e, /* 0xDB98-0xDB9F */
	0x8e71,0x90b8,0x90b0,0x90cf,0x90c5,0x90be,0x90d0,0x90c4, /* 0xDBA0-0xDBA7 */
	0x90c7,0x90d3,0x90e6,0x90e2,0x90dc,0x90d7,0x90db,0x90eb, /* 0xDBA8-0xDBAF */
	0x90ef,0x90fe,0x9104,0x9122,0x911e,0x9123,0x9131,0x912f, /* 0xDBB0-0xDBB7 */
	0x9139,0x9143,0x9146,0x520d,0x5942,0x52a2,0x52ac,0x52ad, /* 0xDBB8-0xDBBF */
	/* codebase=0xdbc0 rawbase=0x4180 */
	0x52be,0x54ff,0x52d0,0x52d6,0x52f0,0x53df,0x71ee,0x77cd, /* 0xDBC0-0xDBC7 */
	0x5ef4,0x51f5,0x51fc,0x9b2f,0x53b6,0x5f01,0x755a,0x5def, /* 0xDBC8-0xDBCF */
	0x574c,0x57a9,0x57a1,0x587e,0x58bc,0x58c5,0x58d1,0x5729, /* 0xDBD0-0xDBD7 */
	0x572c,0x572a,0x5733,0x5739,0x572e,0x572f,0x575c,0x573b, /* 0xDBD8-0xDBDF */
	0x5742,0x5769,0x5785,0x576b,0x5786,0x577c,0x577b,0x5768, /* 0xDBE0-0xDBE7 */
	0x576d,0x5776,0x5773,0x57ad,0x57a4,0x578c,0x57b2,0x57cf, /* 0xDBE8-0xDBEF */
	0x57a7,0x57b4,0x5793,0x57a0,0x57d5,0x57d8,0x57da,0x57d9, /* 0xDBF0-0xDBF7 */
	0x57d2,0x57b8,0x57f4,0x57ef,0x57f8,0x57e4,0x57dd,0x0000, /* 0xDBF8-0xDBFF */
	/* codebase=0xdc40 rawbase=0x41c0 */
	0x8e73,0x8e75,0x8e77,0x8e78,0x8e79,0x8e7a,0x8e7b,0x8e7d, /* 0xDC40-0xDC47 */
	0x8e7e,0x8e80,0x8e82,0x8e83,0x8e84,0x8e86,0x8e88,0x8e89, /* 0xDC48-0xDC4F */
	0x8e8a,0x8e8b,0x8e8c,0x8e8d,0x8e8e,0x8e91,0x8e92,0x8e93, /* 0xDC50-0xDC57 */
	0x8e95,0x8e96,0x8e97,0x8e98,0x8e99,0x8e9a,0x8e9b,0x8e9d, /* 0xDC58-0xDC5F */
	0x8e9f,0x8ea0,0x8ea1,0x8ea2,0x8ea3,0x8ea4,0x8ea5,0x8ea6, /* 0xDC60-0xDC67 */
	0x8ea7,0x8ea8,0x8ea9,0x8eaa,0x8ead,0x8eae,0x8eb0,0x8eb1, /* 0xDC68-0xDC6F */
	0x8eb3,0x8eb4,0x8eb5,0x8eb6,0x8eb7,0x8eb8,0x8eb9,0x8ebb, /* 0xDC70-0xDC77 */
	0x8ebc,0x8ebd,0x8ebe,0x8ebf,0x8ec0,0x8ec1,0x8ec2,0x0000, /* 0xDC78-0xDC7F */
	/* codebase=0xdc80 rawbase=0x4200 */
	0x8ec3,0x8ec4,0x8ec5,0x8ec6,0x8ec7,0x8ec8,0x8ec9,0x8eca, /* 0xDC80-0xDC87 */
	0x8ecb,0x8ecc,0x8ecd,0x8ecf,0x8ed0,0x8ed1,0x8ed2,0x8ed3, /* 0xDC88-0xDC8F */
	0x8ed4,0x8ed5,0x8ed6,0x8ed7,0x8ed8,0x8ed9,0x8eda,0x8edb, /* 0xDC90-0xDC97 */
	0x8edc,0x8edd,0x8ede,0x8edf,0x8ee0,0x8ee1,0x8ee2,0x8ee3, /* 0xDC98-0xDC9F */
	0x8ee4,0x580b,0x580d,0x57fd,0x57ed,0x5800,0x581e,0x5819, /* 0xDCA0-0xDCA7 */
	0x5844,0x5820,0x5865,0x586c,0x5881,0x5889,0x589a,0x5880, /* 0xDCA8-0xDCAF */
	0x99a8,0x9f19,0x61ff,0x8279,0x827d,0x827f,0x828f,0x828a, /* 0xDCB0-0xDCB7 */
	0x82a8,0x8284,0x828e,0x8291,0x8297,0x8299,0x82ab,0x82b8, /* 0xDCB8-0xDCBF */
	/* codebase=0xdcc0 rawbase=0x4240 */
	0x82be,0x82b0,0x82c8,0x82ca,0x82e3,0x8298,0x82b7,0x82ae, /* 0xDCC0-0xDCC7 */
	0x82cb,0x82cc,0x82c1,0x82a9,0x82b4,0x82a1,0x82aa,0x829f, /* 0xDCC8-0xDCCF */
	0x82c4,0x82ce,0x82a4,0x82e1,0x8309,0x82f7,0x82e4,0x830f, /* 0xDCD0-0xDCD7 */
	0x8307,0x82dc,0x82f4,0x82d2,0x82d8,0x830c,0x82fb,0x82d3, /* 0xDCD8-0xDCDF */
	0x8311,0x831a,0x8306,0x8314,0x8315,0x82e0,0x82d5,0x831c, /* 0xDCE0-0xDCE7 */
	0x8351,0x835b,0x835c,0x8308,0x8392,0x833c,0x8334,0x8331, /* 0xDCE8-0xDCEF */
	0x839b,0x835e,0x832f,0x834f,0x8347,0x8343,0x835f,0x8340, /* 0xDCF0-0xDCF7 */
	0x8317,0x8360,0x832d,0x833a,0x8333,0x8366,0x8365,0x0000, /* 0xDCF8-0xDCFF */
	/* codebase=0xdd40 rawbase=0x4280 */
	0x8ee5,0x8ee6,0x8ee7,0x8ee8,0x8ee9,0x8eea,0x8eeb,0x8eec, /* 0xDD40-0xDD47 */
	0x8eed,0x8eee,0x8eef,0x8ef0,0x8ef1,0x8ef2,0x8ef3,0x8ef4, /* 0xDD48-0xDD4F */
	0x8ef5,0x8ef6,0x8ef7,0x8ef8,0x8ef9,0x8efa,0x8efb,0x8efc, /* 0xDD50-0xDD57 */
	0x8efd,0x8efe,0x8eff,0x8f00,0x8f01,0x8f02,0x8f03,0x8f04, /* 0xDD58-0xDD5F */
	0x8f05,0x8f06,0x8f07,0x8f08,0x8f09,0x8f0a,0x8f0b,0x8f0c, /* 0xDD60-0xDD67 */
	0x8f0d,0x8f0e,0x8f0f,0x8f10,0x8f11,0x8f12,0x8f13,0x8f14, /* 0xDD68-0xDD6F */
	0x8f15,0x8f16,0x8f17,0x8f18,0x8f19,0x8f1a,0x8f1b,0x8f1c, /* 0xDD70-0xDD77 */
	0x8f1d,0x8f1e,0x8f1f,0x8f20,0x8f21,0x8f22,0x8f23,0x0000, /* 0xDD78-0xDD7F */
	/* codebase=0xdd80 rawbase=0x42c0 */
	0x8f24,0x8f25,0x8f26,0x8f27,0x8f28,0x8f29,0x8f2a,0x8f2b, /* 0xDD80-0xDD87 */
	0x8f2c,0x8f2d,0x8f2e,0x8f2f,0x8f30,0x8f31,0x8f32,0x8f33, /* 0xDD88-0xDD8F */
	0x8f34,0x8f35,0x8f36,0x8f37,0x8f38,0x8f39,0x8f3a,0x8f3b, /* 0xDD90-0xDD97 */
	0x8f3c,0x8f3d,0x8f3e,0x8f3f,0x8f40,0x8f41,0x8f42,0x8f43, /* 0xDD98-0xDD9F */
	0x8f44,0x8368,0x831b,0x8369,0x836c,0x836a,0x836d,0x836e, /* 0xDDA0-0xDDA7 */
	0x83b0,0x8378,0x83b3,0x83b4,0x83a0,0x83aa,0x8393,0x839c, /* 0xDDA8-0xDDAF */
	0x8385,0x837c,0x83b6,0x83a9,0x837d,0x83b8,0x837b,0x8398, /* 0xDDB0-0xDDB7 */
	0x839e,0x83a8,0x83ba,0x83bc,0x83c1,0x8401,0x83e5,0x83d8, /* 0xDDB8-0xDDBF */
	/* codebase=0xddc0 rawbase=0x4300 */
	0x5807,0x8418,0x840b,0x83dd,0x83fd,0x83d6,0x841c,0x8438, /* 0xDDC0-0xDDC7 */
	0x8411,0x8406,0x83d4,0x83df,0x840f,0x8403,0x83f8,0x83f9, /* 0xDDC8-0xDDCF */
	0x83ea,0x83c5,0x83c0,0x8426,0x83f0,0x83e1,0x845c,0x8451, /* 0xDDD0-0xDDD7 */
	0x845a,0x8459,0x8473,0x8487,0x8488,0x847a,0x8489,0x8478, /* 0xDDD8-0xDDDF */
	0x843c,0x8446,0x8469,0x8476,0x848c,0x848e,0x8431,0x846d, /* 0xDDE0-0xDDE7 */
	0x84c1,0x84cd,0x84d0,0x84e6,0x84bd,0x84d3,0x84ca,0x84bf, /* 0xDDE8-0xDDEF */
	0x84ba,0x84e0,0x84a1,0x84b9,0x84b4,0x8497,0x84e5,0x84e3, /* 0xDDF0-0xDDF7 */
	0x850c,0x750d,0x8538,0x84f0,0x8539,0x851f,0x853a,0x0000, /* 0xDDF8-0xDDFF */
	/* codebase=0xde40 rawbase=0x4340 */
	0x8f45,0x8f46,0x8f47,0x8f48,0x8f49,0x8f4a,0x8f4b,0x8f4c, /* 0xDE40-0xDE47 */
	0x8f4d,0x8f4e,0x8f4f,0x8f50,0x8f51,0x8f52,0x8f53,0x8f54, /* 0xDE48-0xDE4F */
	0x8f55,0x8f56,0x8f57,0x8f58,0x8f59,0x8f5a,0x8f5b,0x8f5c, /* 0xDE50-0xDE57 */
	0x8f5d,0x8f5e,0x8f5f,0x8f60,0x8f61,0x8f62,0x8f63,0x8f64, /* 0xDE58-0xDE5F */
	0x8f65,0x8f6a,0x8f80,0x8f8c,0x8f92,0x8f9d,0x8fa0,0x8fa1, /* 0xDE60-0xDE67 */
	0x8fa2,0x8fa4,0x8fa5,0x8fa6,0x8fa7,0x8faa,0x8fac,0x8fad, /* 0xDE68-0xDE6F */
	0x8fae,0x8faf,0x8fb2,0x8fb3,0x8fb4,0x8fb5,0x8fb7,0x8fb8, /* 0xDE70-0xDE77 */
	0x8fba,0x8fbb,0x8fbc,0x8fbf,0x8fc0,0x8fc3,0x8fc6,0x0000, /* 0xDE78-0xDE7F */
	/* codebase=0xde80 rawbase=0x4380 */
	0x8fc9,0x8fca,0x8fcb,0x8fcc,0x8fcd,0x8fcf,0x8fd2,0x8fd6, /* 0xDE80-0xDE87 */
	0x8fd7,0x8fda,0x8fe0,0x8fe1,0x8fe3,0x8fe7,0x8fec,0x8fef, /* 0xDE88-0xDE8F */
	0x8ff1,0x8ff2,0x8ff4,0x8ff5,0x8ff6,0x8ffa,0x8ffb,0x8ffc, /* 0xDE90-0xDE97 */
	0x8ffe,0x8fff,0x9007,0x9008,0x900c,0x900e,0x9013,0x9015, /* 0xDE98-0xDE9F */
	0x9018,0x8556,0x853b,0x84ff,0x84fc,0x8559,0x8548,0x8568, /* 0xDEA0-0xDEA7 */
	0x8564,0x855e,0x857a,0x77a2,0x8543,0x8572,0x857b,0x85a4, /* 0xDEA8-0xDEAF */
	0x85a8,0x8587,0x858f,0x8579,0x85ae,0x859c,0x8585,0x85b9, /* 0xDEB0-0xDEB7 */
	0x85b7,0x85b0,0x85d3,0x85c1,0x85dc,0x85ff,0x8627,0x8605, /* 0xDEB8-0xDEBF */
	/* codebase=0xdec0 rawbase=0x43c0 */
	0x8629,0x8616,0x863c,0x5efe,0x5f08,0x593c,0x5941,0x8037, /* 0xDEC0-0xDEC7 */
	0x5955,0x595a,0x5958,0x530f,0x5c22,0x5c25,0x5c2c,0x5c34, /* 0xDEC8-0xDECF */
	0x624c,0x626a,0x629f,0x62bb,0x62ca,0x62da,0x62d7,0x62ee, /* 0xDED0-0xDED7 */
	0x6322,0x62f6,0x6339,0x634b,0x6343,0x63ad,0x63f6,0x6371, /* 0xDED8-0xDEDF */
	0x637a,0x638e,0x63b4,0x636d,0x63ac,0x638a,0x6369,0x63ae, /* 0xDEE0-0xDEE7 */
	0x63bc,0x63f2,0x63f8,0x63e0,0x63ff,0x63c4,0x63de,0x63ce, /* 0xDEE8-0xDEEF */
	0x6452,0x63c6,0x63be,0x6445,0x6441,0x640b,0x641b,0x6420, /* 0xDEF0-0xDEF7 */
	0x640c,0x6426,0x6421,0x645e,0x6484,0x646d,0x6496,0x0000, /* 0xDEF8-0xDEFF */
	/* codebase=0xdf40 rawbase=0x4400 */
	0x9019,0x901c,0x9023,0x9024,0x9025,0x9027,0x9028,0x9029, /* 0xDF40-0xDF47 */
	0x902a,0x902b,0x902c,0x9030,0x9031,0x9032,0x9033,0x9034, /* 0xDF48-0xDF4F */
	0x9037,0x9039,0x903a,0x903d,0x903f,0x9040,0x9043,0x9045, /* 0xDF50-0xDF57 */
	0x9046,0x9048,0x9049,0x904a,0x904b,0x904c,0x904e,0x9054, /* 0xDF58-0xDF5F */
	0x9055,0x9056,0x9059,0x905a,0x905c,0x905d,0x905e,0x905f, /* 0xDF60-0xDF67 */
	0x9060,0x9061,0x9064,0x9066,0x9067,0x9069,0x906a,0x906b, /* 0xDF68-0xDF6F */
	0x906c,0x906f,0x9070,0x9071,0x9072,0x9073,0x9076,0x9077, /* 0xDF70-0xDF77 */
	0x9078,0x9079,0x907a,0x907b,0x907c,0x907e,0x9081,0x0000, /* 0xDF78-0xDF7F */
	/* codebase=0xdf80 rawbase=0x4440 */
	0x9084,0x9085,0x9086,0x9087,0x9089,0x908a,0x908c,0x908d, /* 0xDF80-0xDF87 */
	0x908e,0x908f,0x9090,0x9092,0x9094,0x9096,0x9098,0x909a, /* 0xDF88-0xDF8F */
	0x909c,0x909e,0x909f,0x90a0,0x90a4,0x90a5,0x90a7,0x90a8, /* 0xDF90-0xDF97 */
	0x90a9,0x90ab,0x90ad,0x90b2,0x90b7,0x90bc,0x90bd,0x90bf, /* 0xDF98-0xDF9F */
	0x90c0,0x647a,0x64b7,0x64b8,0x6499,0x64ba,0x64c0,0x64d0, /* 0xDFA0-0xDFA7 */
	0x64d7,0x64e4,0x64e2,0x6509,0x6525,0x652e,0x5f0b,0x5fd2, /* 0xDFA8-0xDFAF */
	0x7519,0x5f11,0x535f,0x53f1,0x53fd,0x53e9,0x53e8,0x53fb, /* 0xDFB0-0xDFB7 */
	0x5412,0x5416,0x5406,0x544b,0x5452,0x5453,0x5454,0x5456, /* 0xDFB8-0xDFBF */
	/* codebase=0xdfc0 rawbase=0x4480 */
	0x5443,0x5421,0x5457,0x5459,0x5423,0x5432,0x5482,0x5494, /* 0xDFC0-0xDFC7 */
	0x5477,0x5471,0x5464,0x549a,0x549b,0x5484,0x5476,0x5466, /* 0xDFC8-0xDFCF */
	0x549d,0x54d0,0x54ad,0x54c2,0x54b4,0x54d2,0x54a7,0x54a6, /* 0xDFD0-0xDFD7 */
	0x54d3,0x54d4,0x5472,0x54a3,0x54d5,0x54bb,0x54bf,0x54cc, /* 0xDFD8-0xDFDF */
	0x54d9,0x54da,0x54dc,0x54a9,0x54aa,0x54a4,0x54dd,0x54cf, /* 0xDFE0-0xDFE7 */
	0x54de,0x551b,0x54e7,0x5520,0x54fd,0x5514,0x54f3,0x5522, /* 0xDFE8-0xDFEF */
	0x5523,0x550f,0x5511,0x5527,0x552a,0x5567,0x558f,0x55b5, /* 0xDFF0-0xDFF7 */
	0x5549,0x556d,0x5541,0x5555,0x553f,0x5550,0x553c,0x0000, /* 0xDFF8-0xDFFF */
	/* codebase=0xe040 rawbase=0x44c0 */
	0x90c2,0x90c3,0x90c6,0x90c8,0x90c9,0x90cb,0x90cc,0x90cd, /* 0xE040-0xE047 */
	0x90d2,0x90d4,0x90d5,0x90d6,0x90d8,0x90d9,0x90da,0x90de, /* 0xE048-0xE04F */
	0x90df,0x90e0,0x90e3,0x90e4,0x90e5,0x90e9,0x90ea,0x90ec, /* 0xE050-0xE057 */
	0x90ee,0x90f0,0x90f1,0x90f2,0x90f3,0x90f5,0x90f6,0x90f7, /* 0xE058-0xE05F */
	0x90f9,0x90fa,0x90fb,0x90fc,0x90ff,0x9100,0x9101,0x9103, /* 0xE060-0xE067 */
	0x9105,0x9106,0x9107,0x9108,0x9109,0x910a,0x910b,0x910c, /* 0xE068-0xE06F */
	0x910d,0x910e,0x910f,0x9110,0x9111,0x9112,0x9113,0x9114, /* 0xE070-0xE077 */
	0x9115,0x9116,0x9117,0x9118,0x911a,0x911b,0x911c,0x0000, /* 0xE078-0xE07F */
	/* codebase=0xe080 rawbase=0x4500 */
	0x911d,0x911f,0x9120,0x9121,0x9124,0x9125,0x9126,0x9127, /* 0xE080-0xE087 */
	0x9128,0x9129,0x912a,0x912b,0x912c,0x912d,0x912e,0x9130, /* 0xE088-0xE08F */
	0x9132,0x9133,0x9134,0x9135,0x9136,0x9137,0x9138,0x913a, /* 0xE090-0xE097 */
	0x913b,0x913c,0x913d,0x913e,0x913f,0x9140,0x9141,0x9142, /* 0xE098-0xE09F */
	0x9144,0x5537,0x5556,0x5575,0x5576,0x5577,0x5533,0x5530, /* 0xE0A0-0xE0A7 */
	0x555c,0x558b,0x55d2,0x5583,0x55b1,0x55b9,0x5588,0x5581, /* 0xE0A8-0xE0AF */
	0x559f,0x557e,0x55d6,0x5591,0x557b,0x55df,0x55bd,0x55be, /* 0xE0B0-0xE0B7 */
	0x5594,0x5599,0x55ea,0x55f7,0x55c9,0x561f,0x55d1,0x55eb, /* 0xE0B8-0xE0BF */
	/* codebase=0xe0c0 rawbase=0x4540 */
	0x55ec,0x55d4,0x55e6,0x55dd,0x55c4,0x55ef,0x55e5,0x55f2, /* 0xE0C0-0xE0C7 */
	0x55f3,0x55cc,0x55cd,0x55e8,0x55f5,0x55e4,0x8f94,0x561e, /* 0xE0C8-0xE0CF */
	0x5608,0x560c,0x5601,0x5624,0x5623,0x55fe,0x5600,0x5627, /* 0xE0D0-0xE0D7 */
	0x562d,0x5658,0x5639,0x5657,0x562c,0x564d,0x5662,0x5659, /* 0xE0D8-0xE0DF */
	0x565c,0x564c,0x5654,0x5686,0x5664,0x5671,0x566b,0x567b, /* 0xE0E0-0xE0E7 */
	0x567c,0x5685,0x5693,0x56af,0x56d4,0x56d7,0x56dd,0x56e1, /* 0xE0E8-0xE0EF */
	0x56f5,0x56eb,0x56f9,0x56ff,0x5704,0x570a,0x5709,0x571c, /* 0xE0F0-0xE0F7 */
	0x5e0f,0x5e19,0x5e14,0x5e11,0x5e31,0x5e3b,0x5e3c,0x0000, /* 0xE0F8-0xE0FF */
	/* codebase=0xe140 rawbase=0x4580 */
	0x9145,0x9147,0x9148,0x9151,0x9153,0x9154,0x9155,0x9156, /* 0xE140-0xE147 */
	0x9158,0x9159,0x915b,0x915c,0x915f,0x9160,0x9166,0x9167, /* 0xE148-0xE14F */
	0x9168,0x916b,0x916d,0x9173,0x917a,0x917b,0x917c,0x9180, /* 0xE150-0xE157 */
	0x9181,0x9182,0x9183,0x9184,0x9186,0x9188,0x918a,0x918e, /* 0xE158-0xE15F */
	0x918f,0x9193,0x9194,0x9195,0x9196,0x9197,0x9198,0x9199, /* 0xE160-0xE167 */
	0x919c,0x919d,0x919e,0x919f,0x91a0,0x91a1,0x91a4,0x91a5, /* 0xE168-0xE16F */
	0x91a6,0x91a7,0x91a8,0x91a9,0x91ab,0x91ac,0x91b0,0x91b1, /* 0xE170-0xE177 */
	0x91b2,0x91b3,0x91b6,0x91b7,0x91b8,0x91b9,0x91bb,0x0000, /* 0xE178-0xE17F */
	/* codebase=0xe180 rawbase=0x45c0 */
	0x91bc,0x91bd,0x91be,0x91bf,0x91c0,0x91c1,0x91c2,0x91c3, /* 0xE180-0xE187 */
	0x91c4,0x91c5,0x91c6,0x91c8,0x91cb,0x91d0,0x91d2,0x91d3, /* 0xE188-0xE18F */
	0x91d4,0x91d5,0x91d6,0x91d7,0x91d8,0x91d9,0x91da,0x91db, /* 0xE190-0xE197 */
	0x91dd,0x91de,0x91df,0x91e0,0x91e1,0x91e2,0x91e3,0x91e4, /* 0xE198-0xE19F */
	0x91e5,0x5e37,0x5e44,0x5e54,0x5e5b,0x5e5e,0x5e61,0x5c8c, /* 0xE1A0-0xE1A7 */
	0x5c7a,0x5c8d,0x5c90,0x5c96,0x5c88,0x5c98,0x5c99,0x5c91, /* 0xE1A8-0xE1AF */
	0x5c9a,0x5c9c,0x5cb5,0x5ca2,0x5cbd,0x5cac,0x5cab,0x5cb1, /* 0xE1B0-0xE1B7 */
	0x5ca3,0x5cc1,0x5cb7,0x5cc4,0x5cd2,0x5ce4,0x5ccb,0x5ce5, /* 0xE1B8-0xE1BF */
	/* codebase=0xe1c0 rawbase=0x4600 */
	0x5d02,0x5d03,0x5d27,0x5d26,0x5d2e,0x5d24,0x5d1e,0x5d06, /* 0xE1C0-0xE1C7 */
	0x5d1b,0x5d58,0x5d3e,0x5d34,0x5d3d,0x5d6c,0x5d5b,0x5d6f, /* 0xE1C8-0xE1CF */
	0x5d5d,0x5d6b,0x5d4b,0x5d4a,0x5d69,0x5d74,0x5d82,0x5d99, /* 0xE1D0-0xE1D7 */
	0x5d9d,0x8c73,0x5db7,0x5dc5,0x5f73,0x5f77,0x5f82,0x5f87, /* 0xE1D8-0xE1DF */
	0x5f89,0x5f8c,0x5f95,0x5f99,0x5f9c,0x5fa8,0x5fad,0x5fb5, /* 0xE1E0-0xE1E7 */
	0x5fbc,0x8862,0x5f61,0x72ad,0x72b0,0x72b4,0x72b7,0x72b8, /* 0xE1E8-0xE1EF */
	0x72c3,0x72c1,0x72ce,0x72cd,0x72d2,0x72e8,0x72ef,0x72e9, /* 0xE1F0-0xE1F7 */
	0x72f2,0x72f4,0x72f7,0x7301,0x72f3,0x7303,0x72fa,0x0000, /* 0xE1F8-0xE1FF */
	/* codebase=0xe240 rawbase=0x4640 */
	0x91e6,0x91e7,0x91e8,0x91e9,0x91ea,0x91eb,0x91ec,0x91ed, /* 0xE240-0xE247 */
	0x91ee,0x91ef,0x91f0,0x91f1,0x91f2,0x91f3,0x91f4,0x91f5, /* 0xE248-0xE24F */
	0x91f6,0x91f7,0x91f8,0x91f9,0x91fa,0x91fb,0x91fc,0x91fd, /* 0xE250-0xE257 */
	0x91fe,0x91ff,0x9200,0x9201,0x9202,0x9203,0x9204,0x9205, /* 0xE258-0xE25F */
	0x9206,0x9207,0x9208,0x9209,0x920a,0x920b,0x920c,0x920d, /* 0xE260-0xE267 */
	0x920e,0x920f,0x9210,0x9211,0x9212,0x9213,0x9214,0x9215, /* 0xE268-0xE26F */
	0x9216,0x9217,0x9218,0x9219,0x921a,0x921b,0x921c,0x921d, /* 0xE270-0xE277 */
	0x921e,0x921f,0x9220,0x9221,0x9222,0x9223,0x9224,0x0000, /* 0xE278-0xE27F */
	/* codebase=0xe280 rawbase=0x4680 */
	0x9225,0x9226,0x9227,0x9228,0x9229,0x922a,0x922b,0x922c, /* 0xE280-0xE287 */
	0x922d,0x922e,0x922f,0x9230,0x9231,0x9232,0x9233,0x9234, /* 0xE288-0xE28F */
	0x9235,0x9236,0x9237,0x9238,0x9239,0x923a,0x923b,0x923c, /* 0xE290-0xE297 */
	0x923d,0x923e,0x923f,0x9240,0x9241,0x9242,0x9243,0x9244, /* 0xE298-0xE29F */
	0x9245,0x72fb,0x7317,0x7313,0x7321,0x730a,0x731e,0x731d, /* 0xE2A0-0xE2A7 */
	0x7315,0x7322,0x7339,0x7325,0x732c,0x7338,0x7331,0x7350, /* 0xE2A8-0xE2AF */
	0x734d,0x7357,0x7360,0x736c,0x736f,0x737e,0x821b,0x5925, /* 0xE2B0-0xE2B7 */
	0x98e7,0x5924,0x5902,0x9963,0x9967,0x9968,0x9969,0x996a, /* 0xE2B8-0xE2BF */
	/* codebase=0xe2c0 rawbase=0x46c0 */
	0x996b,0x996c,0x9974,0x9977,0x997d,0x9980,0x9984,0x9987, /* 0xE2C0-0xE2C7 */
	0x998a,0x998d,0x9990,0x9991,0x9993,0x9994,0x9995,0x5e80, /* 0xE2C8-0xE2CF */
	0x5e91,0x5e8b,0x5e96,0x5ea5,0x5ea0,0x5eb9,0x5eb5,0x5ebe, /* 0xE2D0-0xE2D7 */
	0x5eb3,0x8d53,0x5ed2,0x5ed1,0x5edb,0x5ee8,0x5eea,0x81ba, /* 0xE2D8-0xE2DF */
	0x5fc4,0x5fc9,0x5fd6,0x5fcf,0x6003,0x5fee,0x6004,0x5fe1, /* 0xE2E0-0xE2E7 */
	0x5fe4,0x5ffe,0x6005,0x6006,0x5fea,0x5fed,0x5ff8,0x6019, /* 0xE2E8-0xE2EF */
	0x6035,0x6026,0x601b,0x600f,0x600d,0x6029,0x602b,0x600a, /* 0xE2F0-0xE2F7 */
	0x603f,0x6021,0x6078,0x6079,0x607b,0x607a,0x6042,0x0000, /* 0xE2F8-0xE2FF */
	/* codebase=0xe340 rawbase=0x4700 */
	0x9246,0x9247,0x9248,0x9249,0x924a,0x924b,0x924c,0x924d, /* 0xE340-0xE347 */
	0x924e,0x924f,0x9250,0x9251,0x9252,0x9253,0x9254,0x9255, /* 0xE348-0xE34F */
	0x9256,0x9257,0x9258,0x9259,0x925a,0x925b,0x925c,0x925d, /* 0xE350-0xE357 */
	0x925e,0x925f,0x9260,0x9261,0x9262,0x9263,0x9264,0x9265, /* 0xE358-0xE35F */
	0x9266,0x9267,0x9268,0x9269,0x926a,0x926b,0x926c,0x926d, /* 0xE360-0xE367 */
	0x926e,0x926f,0x9270,0x9271,0x9272,0x9273,0x9275,0x9276, /* 0xE368-0xE36F */
	0x9277,0x9278,0x9279,0x927a,0x927b,0x927c,0x927d,0x927e, /* 0xE370-0xE377 */
	0x927f,0x9280,0x9281,0x9282,0x9283,0x9284,0x9285,0x0000, /* 0xE378-0xE37F */
	/* codebase=0xe380 rawbase=0x4740 */
	0x9286,0x9287,0x9288,0x9289,0x928a,0x928b,0x928c,0x928d, /* 0xE380-0xE387 */
	0x928f,0x9290,0x9291,0x9292,0x9293,0x9294,0x9295,0x9296, /* 0xE388-0xE38F */
	0x9297,0x9298,0x9299,0x929a,0x929b,0x929c,0x929d,0x929e, /* 0xE390-0xE397 */
	0x929f,0x92a0,0x92a1,0x92a2,0x92a3,0x92a4,0x92a5,0x92a6, /* 0xE398-0xE39F */
	0x92a7,0x606a,0x607d,0x6096,0x609a,0x60ad,0x609d,0x6083, /* 0xE3A0-0xE3A7 */
	0x6092,0x608c,0x609b,0x60ec,0x60bb,0x60b1,0x60dd,0x60d8, /* 0xE3A8-0xE3AF */
	0x60c6,0x60da,0x60b4,0x6120,0x6126,0x6115,0x6123,0x60f4, /* 0xE3B0-0xE3B7 */
	0x6100,0x610e,0x612b,0x614a,0x6175,0x61ac,0x6194,0x61a7, /* 0xE3B8-0xE3BF */
	/* codebase=0xe3c0 rawbase=0x4780 */
	0x61b7,0x61d4,0x61f5,0x5fdd,0x96b3,0x95e9,0x95eb,0x95f1, /* 0xE3C0-0xE3C7 */
	0x95f3,0x95f5,0x95f6,0x95fc,0x95fe,0x9603,0x9604,0x9606, /* 0xE3C8-0xE3CF */
	0x9608,0x960a,0x960b,0x960c,0x960d,0x960f,0x9612,0x9615, /* 0xE3D0-0xE3D7 */
	0x9616,0x9617,0x9619,0x961a,0x4e2c,0x723f,0x6215,0x6c35, /* 0xE3D8-0xE3DF */
	0x6c54,0x6c5c,0x6c4a,0x6ca3,0x6c85,0x6c90,0x6c94,0x6c8c, /* 0xE3E0-0xE3E7 */
	0x6c68,0x6c69,0x6c74,0x6c76,0x6c86,0x6ca9,0x6cd0,0x6cd4, /* 0xE3E8-0xE3EF */
	0x6cad,0x6cf7,0x6cf8,0x6cf1,0x6cd7,0x6cb2,0x6ce0,0x6cd6, /* 0xE3F0-0xE3F7 */
	0x6cfa,0x6ceb,0x6cee,0x6cb1,0x6cd3,0x6cef,0x6cfe,0x0000, /* 0xE3F8-0xE3FF */
	/* codebase=0xe440 rawbase=0x47c0 */
	0x92a8,0x92a9,0x92aa,0x92ab,0x92ac,0x92ad,0x92af,0x92b0, /* 0xE440-0xE447 */
	0x92b1,0x92b2,0x92b3,0x92b4,0x92b5,0x92b6,0x92b7,0x92b8, /* 0xE448-0xE44F */
	0x92b9,0x92ba,0x92bb,0x92bc,0x92bd,0x92be,0x92bf,0x92c0, /* 0xE450-0xE457 */
	0x92c1,0x92c2,0x92c3,0x92c4,0x92c5,0x92c6,0x92c7,0x92c9, /* 0xE458-0xE45F */
	0x92ca,0x92cb,0x92cc,0x92cd,0x92ce,0x92cf,0x92d0,0x92d1, /* 0xE460-0xE467 */
	0x92d2,0x92d3,0x92d4,0x92d5,0x92d6,0x92d7,0x92d8,0x92d9, /* 0xE468-0xE46F */
	0x92da,0x92db,0x92dc,0x92dd,0x92de,0x92df,0x92e0,0x92e1, /* 0xE470-0xE477 */
	0x92e2,0x92e3,0x92e4,0x92e5,0x92e6,0x92e7,0x92e8,0x0000, /* 0xE478-0xE47F */
	/* codebase=0xe480 rawbase=0x4800 */
	0x92e9,0x92ea,0x92eb,0x92ec,0x92ed,0x92ee,0x92ef,0x92f0, /* 0xE480-0xE487 */
	0x92f1,0x92f2,0x92f3,0x92f4,0x92f5,0x92f6,0x92f7,0x92f8, /* 0xE488-0xE48F */
	0x92f9,0x92fa,0x92fb,0x92fc,0x92fd,0x92fe,0x92ff,0x9300, /* 0xE490-0xE497 */
	0x9301,0x9302,0x9303,0x9304,0x9305,0x9306,0x9307,0x9308, /* 0xE498-0xE49F */
	0x9309,0x6d39,0x6d27,0x6d0c,0x6d43,0x6d48,0x6d07,0x6d04, /* 0xE4A0-0xE4A7 */
	0x6d19,0x6d0e,0x6d2b,0x6d4d,0x6d2e,0x6d35,0x6d1a,0x6d4f, /* 0xE4A8-0xE4AF */
	0x6d52,0x6d54,0x6d33,0x6d91,0x6d6f,0x6d9e,0x6da0,0x6d5e, /* 0xE4B0-0xE4B7 */
	0x6d93,0x6d94,0x6d5c,0x6d60,0x6d7c,0x6d63,0x6e1a,0x6dc7, /* 0xE4B8-0xE4BF */
	/* codebase=0xe4c0 rawbase=0x4840 */
	0x6dc5,0x6dde,0x6e0e,0x6dbf,0x6de0,0x6e11,0x6de6,0x6ddd, /* 0xE4C0-0xE4C7 */
	0x6dd9,0x6e16,0x6dab,0x6e0c,0x6dae,0x6e2b,0x6e6e,0x6e4e, /* 0xE4C8-0xE4CF */
	0x6e6b,0x6eb2,0x6e5f,0x6e86,0x6e53,0x6e54,0x6e32,0x6e25, /* 0xE4D0-0xE4D7 */
	0x6e44,0x6edf,0x6eb1,0x6e98,0x6ee0,0x6f2d,0x6ee2,0x6ea5, /* 0xE4D8-0xE4DF */
	0x6ea7,0x6ebd,0x6ebb,0x6eb7,0x6ed7,0x6eb4,0x6ecf,0x6e8f, /* 0xE4E0-0xE4E7 */
	0x6ec2,0x6e9f,0x6f62,0x6f46,0x6f47,0x6f24,0x6f15,0x6ef9, /* 0xE4E8-0xE4EF */
	0x6f2f,0x6f36,0x6f4b,0x6f74,0x6f2a,0x6f09,0x6f29,0x6f89, /* 0xE4F0-0xE4F7 */
	0x6f8d,0x6f8c,0x6f78,0x6f72,0x6f7c,0x6f7a,0x6fd1,0x0000, /* 0xE4F8-0xE4FF */
	/* codebase=0xe540 rawbase=0x4880 */
	0x930a,0x930b,0x930c,0x930d,0x930e,0x930f,0x9310,0x9311, /* 0xE540-0xE547 */
	0x9312,0x9313,0x9314,0x9315,0x9316,0x9317,0x9318,0x9319, /* 0xE548-0xE54F */
	0x931a,0x931b,0x931c,0x931d,0x931e,0x931f,0x9320,0x9321, /* 0xE550-0xE557 */
	0x9322,0x9323,0x9324,0x9325,0x9326,0x9327,0x9328,0x9329, /* 0xE558-0xE55F */
	0x932a,0x932b,0x932c,0x932d,0x932e,0x932f,0x9330,0x9331, /* 0xE560-0xE567 */
	0x9332,0x9333,0x9334,0x9335,0x9336,0x9337,0x9338,0x9339, /* 0xE568-0xE56F */
	0x933a,0x933b,0x933c,0x933d,0x933f,0x9340,0x9341,0x9342, /* 0xE570-0xE577 */
	0x9343,0x9344,0x9345,0x9346,0x9347,0x9348,0x9349,0x0000, /* 0xE578-0xE57F */
	/* codebase=0xe580 rawbase=0x48c0 */
	0x934a,0x934b,0x934c,0x934d,0x934e,0x934f,0x9350,0x9351, /* 0xE580-0xE587 */
	0x9352,0x9353,0x9354,0x9355,0x9356,0x9357,0x9358,0x9359, /* 0xE588-0xE58F */
	0x935a,0x935b,0x935c,0x935d,0x935e,0x935f,0x9360,0x9361, /* 0xE590-0xE597 */
	0x9362,0x9363,0x9364,0x9365,0x9366,0x9367,0x9368,0x9369, /* 0xE598-0xE59F */
	0x936b,0x6fc9,0x6fa7,0x6fb9,0x6fb6,0x6fc2,0x6fe1,0x6fee, /* 0xE5A0-0xE5A7 */
	0x6fde,0x6fe0,0x6fef,0x701a,0x7023,0x701b,0x7039,0x7035, /* 0xE5A8-0xE5AF */
	0x704f,0x705e,0x5b80,0x5b84,0x5b95,0x5b93,0x5ba5,0x5bb8, /* 0xE5B0-0xE5B7 */
	0x752f,0x9a9e,0x6434,0x5be4,0x5bee,0x8930,0x5bf0,0x8e47, /* 0xE5B8-0xE5BF */
	/* codebase=0xe5c0 rawbase=0x4900 */
	0x8b07,0x8fb6,0x8fd3,0x8fd5,0x8fe5,0x8fee,0x8fe4,0x8fe9, /* 0xE5C0-0xE5C7 */
	0x8fe6,0x8ff3,0x8fe8,0x9005,0x9004,0x900b,0x9026,0x9011, /* 0xE5C8-0xE5CF */
	0x900d,0x9016,0x9021,0x9035,0x9036,0x902d,0x902f,0x9044, /* 0xE5D0-0xE5D7 */
	0x9051,0x9052,0x9050,0x9068,0x9058,0x9062,0x905b,0x66b9, /* 0xE5D8-0xE5DF */
	0x9074,0x907d,0x9082,0x9088,0x9083,0x908b,0x5f50,0x5f57, /* 0xE5E0-0xE5E7 */
	0x5f56,0x5f58,0x5c3b,0x54ab,0x5c50,0x5c59,0x5b71,0x5c63, /* 0xE5E8-0xE5EF */
	0x5c66,0x7fbc,0x5f2a,0x5f29,0x5f2d,0x8274,0x5f3c,0x9b3b, /* 0xE5F0-0xE5F7 */
	0x5c6e,0x5981,0x5983,0x598d,0x59a9,0x59aa,0x59a3,0x0000, /* 0xE5F8-0xE5FF */
	/* codebase=0xe640 rawbase=0x4940 */
	0x936c,0x936d,0x936e,0x936f,0x9370,0x9371,0x9372,0x9373, /* 0xE640-0xE647 */
	0x9374,0x9375,0x9376,0x9377,0x9378,0x9379,0x937a,0x937b, /* 0xE648-0xE64F */
	0x937c,0x937d,0x937e,0x937f,0x9380,0x9381,0x9382,0x9383, /* 0xE650-0xE657 */
	0x9384,0x9385,0x9386,0x9387,0x9388,0x9389,0x938a,0x938b, /* 0xE658-0xE65F */
	0x938c,0x938d,0x938e,0x9390,0x9391,0x9392,0x9393,0x9394, /* 0xE660-0xE667 */
	0x9395,0x9396,0x9397,0x9398,0x9399,0x939a,0x939b,0x939c, /* 0xE668-0xE66F */
	0x939d,0x939e,0x939f,0x93a0,0x93a1,0x93a2,0x93a3,0x93a4, /* 0xE670-0xE677 */
	0x93a5,0x93a6,0x93a7,0x93a8,0x93a9,0x93aa,0x93ab,0x0000, /* 0xE678-0xE67F */
	/* codebase=0xe680 rawbase=0x4980 */
	0x93ac,0x93ad,0x93ae,0x93af,0x93b0,0x93b1,0x93b2,0x93b3, /* 0xE680-0xE687 */
	0x93b4,0x93b5,0x93b6,0x93b7,0x93b8,0x93b9,0x93ba,0x93bb, /* 0xE688-0xE68F */
	0x93bc,0x93bd,0x93be,0x93bf,0x93c0,0x93c1,0x93c2,0x93c3, /* 0xE690-0xE697 */
	0x93c4,0x93c5,0x93c6,0x93c7,0x93c8,0x93c9,0x93cb,0x93cc, /* 0xE698-0xE69F */
	0x93cd,0x5997,0x59ca,0x59ab,0x599e,0x59a4,0x59d2,0x59b2, /* 0xE6A0-0xE6A7 */
	0x59af,0x59d7,0x59be,0x5a05,0x5a06,0x59dd,0x5a08,0x59e3, /* 0xE6A8-0xE6AF */
	0x59d8,0x59f9,0x5a0c,0x5a09,0x5a32,0x5a34,0x5a11,0x5a23, /* 0xE6B0-0xE6B7 */
	0x5a13,0x5a40,0x5a67,0x5a4a,0x5a55,0x5a3c,0x5a62,0x5a75, /* 0xE6B8-0xE6BF */
	/* codebase=0xe6c0 rawbase=0x49c0 */
	0x80ec,0x5aaa,0x5a9b,0x5a77,0x5a7a,0x5abe,0x5aeb,0x5ab2, /* 0xE6C0-0xE6C7 */
	0x5ad2,0x5ad4,0x5ab8,0x5ae0,0x5ae3,0x5af1,0x5ad6,0x5ae6, /* 0xE6C8-0xE6CF */
	0x5ad8,0x5adc,0x5b09,0x5b17,0x5b16,0x5b32,0x5b37,0x5b40, /* 0xE6D0-0xE6D7 */
	0x5c15,0x5c1c,0x5b5a,0x5b65,0x5b73,0x5b51,0x5b53,0x5b62, /* 0xE6D8-0xE6DF */
	0x9a75,0x9a77,0x9a78,0x9a7a,0x9a7f,0x9a7d,0x9a80,0x9a81, /* 0xE6E0-0xE6E7 */
	0x9a85,0x9a88,0x9a8a,0x9a90,0x9a92,0x9a93,0x9a96,0x9a98, /* 0xE6E8-0xE6EF */
	0x9a9b,0x9a9c,0x9a9d,0x9a9f,0x9aa0,0x9aa2,0x9aa3,0x9aa5, /* 0xE6F0-0xE6F7 */
	0x9aa7,0x7e9f,0x7ea1,0x7ea3,0x7ea5,0x7ea8,0x7ea9,0x0000, /* 0xE6F8-0xE6FF */
	/* codebase=0xe740 rawbase=0x4a00 */
	0x93ce,0x93cf,0x93d0,0x93d1,0x93d2,0x93d3,0x93d4,0x93d5, /* 0xE740-0xE747 */
	0x93d7,0x93d8,0x93d9,0x93da,0x93db,0x93dc,0x93dd,0x93de, /* 0xE748-0xE74F */
	0x93df,0x93e0,0x93e1,0x93e2,0x93e3,0x93e4,0x93e5,0x93e6, /* 0xE750-0xE757 */
	0x93e7,0x93e8,0x93e9,0x93ea,0x93eb,0x93ec,0x93ed,0x93ee, /* 0xE758-0xE75F */
	0x93ef,0x93f0,0x93f1,0x93f2,0x93f3,0x93f4,0x93f5,0x93f6, /* 0xE760-0xE767 */
	0x93f7,0x93f8,0x93f9,0x93fa,0x93fb,0x93fc,0x93fd,0x93fe, /* 0xE768-0xE76F */
	0x93ff,0x9400,0x9401,0x9402,0x9403,0x9404,0x9405,0x9406, /* 0xE770-0xE777 */
	0x9407,0x9408,0x9409,0x940a,0x940b,0x940c,0x940d,0x0000, /* 0xE778-0xE77F */
	/* codebase=0xe780 rawbase=0x4a40 */
	0x940e,0x940f,0x9410,0x9411,0x9412,0x9413,0x9414,0x9415, /* 0xE780-0xE787 */
	0x9416,0x9417,0x9418,0x9419,0x941a,0x941b,0x941c,0x941d, /* 0xE788-0xE78F */
	0x941e,0x941f,0x9420,0x9421,0x9422,0x9423,0x9424,0x9425, /* 0xE790-0xE797 */
	0x9426,0x9427,0x9428,0x9429,0x942a,0x942b,0x942c,0x942d, /* 0xE798-0xE79F */
	0x942e,0x7ead,0x7eb0,0x7ebe,0x7ec0,0x7ec1,0x7ec2,0x7ec9, /* 0xE7A0-0xE7A7 */
	0x7ecb,0x7ecc,0x7ed0,0x7ed4,0x7ed7,0x7edb,0x7ee0,0x7ee1, /* 0xE7A8-0xE7AF */
	0x7ee8,0x7eeb,0x7eee,0x7eef,0x7ef1,0x7ef2,0x7f0d,0x7ef6, /* 0xE7B0-0xE7B7 */
	0x7efa,0x7efb,0x7efe,0x7f01,0x7f02,0x7f03,0x7f07,0x7f08, /* 0xE7B8-0xE7BF */
	/* codebase=0xe7c0 rawbase=0x4a80 */
	0x7f0b,0x7f0c,0x7f0f,0x7f11,0x7f12,0x7f17,0x7f19,0x7f1c, /* 0xE7C0-0xE7C7 */
	0x7f1b,0x7f1f,0x7f21,0x7f22,0x7f23,0x7f24,0x7f25,0x7f26, /* 0xE7C8-0xE7CF */
	0x7f27,0x7f2a,0x7f2b,0x7f2c,0x7f2d,0x7f2f,0x7f30,0x7f31, /* 0xE7D0-0xE7D7 */
	0x7f32,0x7f33,0x7f35,0x5e7a,0x757f,0x5ddb,0x753e,0x9095, /* 0xE7D8-0xE7DF */
	0x738e,0x7391,0x73ae,0x73a2,0x739f,0x73cf,0x73c2,0x73d1, /* 0xE7E0-0xE7E7 */
	0x73b7,0x73b3,0x73c0,0x73c9,0x73c8,0x73e5,0x73d9,0x987c, /* 0xE7E8-0xE7EF */
	0x740a,0x73e9,0x73e7,0x73de,0x73ba,0x73f2,0x740f,0x742a, /* 0xE7F0-0xE7F7 */
	0x745b,0x7426,0x7425,0x7428,0x7430,0x742e,0x742c,0x0000, /* 0xE7F8-0xE7FF */
	/* codebase=0xe840 rawbase=0x4ac0 */
	0x942f,0x9430,0x9431,0x9432,0x9433,0x9434,0x9435,0x9436, /* 0xE840-0xE847 */
	0x9437,0x9438,0x9439,0x943a,0x943b,0x943c,0x943d,0x943f, /* 0xE848-0xE84F */
	0x9440,0x9441,0x9442,0x9443,0x9444,0x9445,0x9446,0x9447, /* 0xE850-0xE857 */
	0x9448,0x9449,0x944a,0x944b,0x944c,0x944d,0x944e,0x944f, /* 0xE858-0xE85F */
	0x9450,0x9451,0x9452,0x9453,0x9454,0x9455,0x9456,0x9457, /* 0xE860-0xE867 */
	0x9458,0x9459,0x945a,0x945b,0x945c,0x945d,0x945e,0x945f, /* 0xE868-0xE86F */
	0x9460,0x9461,0x9462,0x9463,0x9464,0x9465,0x9466,0x9467, /* 0xE870-0xE877 */
	0x9468,0x9469,0x946a,0x946c,0x946d,0x946e,0x946f,0x0000, /* 0xE878-0xE87F */
	/* codebase=0xe880 rawbase=0x4b00 */
	0x9470,0x9471,0x9472,0x9473,0x9474,0x9475,0x9476,0x9477, /* 0xE880-0xE887 */
	0x9478,0x9479,0x947a,0x947b,0x947c,0x947d,0x947e,0x947f, /* 0xE888-0xE88F */
	0x9480,0x9481,0x9482,0x9483,0x9484,0x9491,0x9496,0x9498, /* 0xE890-0xE897 */
	0x94c7,0x94cf,0x94d3,0x94d4,0x94da,0x94e6,0x94fb,0x951c, /* 0xE898-0xE89F */
	0x9520,0x741b,0x741a,0x7441,0x745c,0x7457,0x7455,0x7459, /* 0xE8A0-0xE8A7 */
	0x7477,0x746d,0x747e,0x749c,0x748e,0x7480,0x7481,0x7487, /* 0xE8A8-0xE8AF */
	0x748b,0x749e,0x74a8,0x74a9,0x7490,0x74a7,0x74d2,0x74ba, /* 0xE8B0-0xE8B7 */
	0x97ea,0x97eb,0x97ec,0x674c,0x6753,0x675e,0x6748,0x6769, /* 0xE8B8-0xE8BF */
	/* codebase=0xe8c0 rawbase=0x4b40 */
	0x67a5,0x6787,0x676a,0x6773,0x6798,0x67a7,0x6775,0x67a8, /* 0xE8C0-0xE8C7 */
	0x679e,0x67ad,0x678b,0x6777,0x677c,0x67f0,0x6809,0x67d8, /* 0xE8C8-0xE8CF */
	0x680a,0x67e9,0x67b0,0x680c,0x67d9,0x67b5,0x67da,0x67b3, /* 0xE8D0-0xE8D7 */
	0x67dd,0x6800,0x67c3,0x67b8,0x67e2,0x680e,0x67c1,0x67fd, /* 0xE8D8-0xE8DF */
	0x6832,0x6833,0x6860,0x6861,0x684e,0x6862,0x6844,0x6864, /* 0xE8E0-0xE8E7 */
	0x6883,0x681d,0x6855,0x6866,0x6841,0x6867,0x6840,0x683e, /* 0xE8E8-0xE8EF */
	0x684a,0x6849,0x6829,0x68b5,0x688f,0x6874,0x6877,0x6893, /* 0xE8F0-0xE8F7 */
	0x686b,0x68c2,0x696e,0x68fc,0x691f,0x6920,0x68f9,0x0000, /* 0xE8F8-0xE8FF */
	/* codebase=0xe940 rawbase=0x4b80 */
	0x9527,0x9533,0x953d,0x9543,0x9548,0x954b,0x9555,0x955a, /* 0xE940-0xE947 */
	0x9560,0x956e,0x9574,0x9575,0x9577,0x9578,0x9579,0x957a, /* 0xE948-0xE94F */
	0x957b,0x957c,0x957d,0x957e,0x9580,0x9581,0x9582,0x9583, /* 0xE950-0xE957 */
	0x9584,0x9585,0x9586,0x9587,0x9588,0x9589,0x958a,0x958b, /* 0xE958-0xE95F */
	0x958c,0x958d,0x958e,0x958f,0x9590,0x9591,0x9592,0x9593, /* 0xE960-0xE967 */
	0x9594,0x9595,0x9596,0x9597,0x9598,0x9599,0x959a,0x959b, /* 0xE968-0xE96F */
	0x959c,0x959d,0x959e,0x959f,0x95a0,0x95a1,0x95a2,0x95a3, /* 0xE970-0xE977 */
	0x95a4,0x95a5,0x95a6,0x95a7,0x95a8,0x95a9,0x95aa,0x0000, /* 0xE978-0xE97F */
	/* codebase=0xe980 rawbase=0x4bc0 */
	0x95ab,0x95ac,0x95ad,0x95ae,0x95af,0x95b0,0x95b1,0x95b2, /* 0xE980-0xE987 */
	0x95b3,0x95b4,0x95b5,0x95b6,0x95b7,0x95b8,0x95b9,0x95ba, /* 0xE988-0xE98F */
	0x95bb,0x95bc,0x95bd,0x95be,0x95bf,0x95c0,0x95c1,0x95c2, /* 0xE990-0xE997 */
	0x95c3,0x95c4,0x95c5,0x95c6,0x95c7,0x95c8,0x95c9,0x95ca, /* 0xE998-0xE99F */
	0x95cb,0x6924,0x68f0,0x690b,0x6901,0x6957,0x68e3,0x6910, /* 0xE9A0-0xE9A7 */
	0x6971,0x6939,0x6960,0x6942,0x695d,0x6984,0x696b,0x6980, /* 0xE9A8-0xE9AF */
	0x6998,0x6978,0x6934,0x69cc,0x6987,0x6988,0x69ce,0x6989, /* 0xE9B0-0xE9B7 */
	0x6966,0x6963,0x6979,0x699b,0x69a7,0x69bb,0x69ab,0x69ad, /* 0xE9B8-0xE9BF */
	/* codebase=0xe9c0 rawbase=0x4c00 */
	0x69d4,0x69b1,0x69c1,0x69ca,0x69df,0x6995,0x69e0,0x698d, /* 0xE9C0-0xE9C7 */
	0x69ff,0x6a2f,0x69ed,0x6a17,0x6a18,0x6a65,0x69f2,0x6a44, /* 0xE9C8-0xE9CF */
	0x6a3e,0x6aa0,0x6a50,0x6a5b,0x6a35,0x6a8e,0x6a79,0x6a3d, /* 0xE9D0-0xE9D7 */
	0x6a28,0x6a58,0x6a7c,0x6a91,0x6a90,0x6aa9,0x6a97,0x6aab, /* 0xE9D8-0xE9DF */
	0x7337,0x7352,0x6b81,0x6b82,0x6b87,0x6b84,0x6b92,0x6b93, /* 0xE9E0-0xE9E7 */
	0x6b8d,0x6b9a,0x6b9b,0x6ba1,0x6baa,0x8f6b,0x8f6d,0x8f71, /* 0xE9E8-0xE9EF */
	0x8f72,0x8f73,0x8f75,0x8f76,0x8f78,0x8f77,0x8f79,0x8f7a, /* 0xE9F0-0xE9F7 */
	0x8f7c,0x8f7e,0x8f81,0x8f82,0x8f84,0x8f87,0x8f8b,0x0000, /* 0xE9F8-0xE9FF */
	/* codebase=0xea40 rawbase=0x4c40 */
	0x95cc,0x95cd,0x95ce,0x95cf,0x95d0,0x95d1,0x95d2,0x95d3, /* 0xEA40-0xEA47 */
	0x95d4,0x95d5,0x95d6,0x95d7,0x95d8,0x95d9,0x95da,0x95db, /* 0xEA48-0xEA4F */
	0x95dc,0x95dd,0x95de,0x95df,0x95e0,0x95e1,0x95e2,0x95e3, /* 0xEA50-0xEA57 */
	0x95e4,0x95e5,0x95e6,0x95e7,0x95ec,0x95ff,0x9607,0x9613, /* 0xEA58-0xEA5F */
	0x9618,0x961b,0x961e,0x9620,0x9623,0x9624,0x9625,0x9626, /* 0xEA60-0xEA67 */
	0x9627,0x9628,0x9629,0x962b,0x962c,0x962d,0x962f,0x9630, /* 0xEA68-0xEA6F */
	0x9637,0x9638,0x9639,0x963a,0x963e,0x9641,0x9643,0x964a, /* 0xEA70-0xEA77 */
	0x964e,0x964f,0x9651,0x9652,0x9653,0x9656,0x9657,0x0000, /* 0xEA78-0xEA7F */
	/* codebase=0xea80 rawbase=0x4c80 */
	0x9658,0x9659,0x965a,0x965c,0x965d,0x965e,0x9660,0x9663, /* 0xEA80-0xEA87 */
	0x9665,0x9666,0x966b,0x966d,0x966e,0x966f,0x9670,0x9671, /* 0xEA88-0xEA8F */
	0x9673,0x9678,0x9679,0x967a,0x967b,0x967c,0x967d,0x967e, /* 0xEA90-0xEA97 */
	0x967f,0x9680,0x9681,0x9682,0x9683,0x9684,0x9687,0x9689, /* 0xEA98-0xEA9F */
	0x968a,0x8f8d,0x8f8e,0x8f8f,0x8f98,0x8f9a,0x8ece,0x620b, /* 0xEAA0-0xEAA7 */
	0x6217,0x621b,0x621f,0x6222,0x6221,0x6225,0x6224,0x622c, /* 0xEAA8-0xEAAF */
	0x81e7,0x74ef,0x74f4,0x74ff,0x750f,0x7511,0x7513,0x6534, /* 0xEAB0-0xEAB7 */
	0x65ee,0x65ef,0x65f0,0x660a,0x6619,0x6772,0x6603,0x6615, /* 0xEAB8-0xEABF */
	/* codebase=0xeac0 rawbase=0x4cc0 */
	0x6600,0x7085,0x66f7,0x661d,0x6634,0x6631,0x6636,0x6635, /* 0xEAC0-0xEAC7 */
	0x8006,0x665f,0x6654,0x6641,0x664f,0x6656,0x6661,0x6657, /* 0xEAC8-0xEACF */
	0x6677,0x6684,0x668c,0x66a7,0x669d,0x66be,0x66db,0x66dc, /* 0xEAD0-0xEAD7 */
	0x66e6,0x66e9,0x8d32,0x8d33,0x8d36,0x8d3b,0x8d3d,0x8d40, /* 0xEAD8-0xEADF */
	0x8d45,0x8d46,0x8d48,0x8d49,0x8d47,0x8d4d,0x8d55,0x8d59, /* 0xEAE0-0xEAE7 */
	0x89c7,0x89ca,0x89cb,0x89cc,0x89ce,0x89cf,0x89d0,0x89d1, /* 0xEAE8-0xEAEF */
	0x726e,0x729f,0x725d,0x7266,0x726f,0x727e,0x727f,0x7284, /* 0xEAF0-0xEAF7 */
	0x728b,0x728d,0x728f,0x7292,0x6308,0x6332,0x63b0,0x0000, /* 0xEAF8-0xEAFF */
	/* codebase=0xeb40 rawbase=0x4d00 */
	0x968c,0x968e,0x9691,0x9692,0x9693,0x9695,0x9696,0x969a, /* 0xEB40-0xEB47 */
	0x969b,0x969d,0x969e,0x969f,0x96a0,0x96a1,0x96a2,0x96a3, /* 0xEB48-0xEB4F */
	0x96a4,0x96a5,0x96a6,0x96a8,0x96a9,0x96aa,0x96ab,0x96ac, /* 0xEB50-0xEB57 */
	0x96ad,0x96ae,0x96af,0x96b1,0x96b2,0x96b4,0x96b5,0x96b7, /* 0xEB58-0xEB5F */
	0x96b8,0x96ba,0x96bb,0x96bf,0x96c2,0x96c3,0x96c8,0x96ca, /* 0xEB60-0xEB67 */
	0x96cb,0x96d0,0x96d1,0x96d3,0x96d4,0x96d6,0x96d7,0x96d8, /* 0xEB68-0xEB6F */
	0x96d9,0x96da,0x96db,0x96dc,0x96dd,0x96de,0x96df,0x96e1, /* 0xEB70-0xEB77 */
	0x96e2,0x96e3,0x96e4,0x96e5,0x96e6,0x96e7,0x96eb,0x0000, /* 0xEB78-0xEB7F */
	/* codebase=0xeb80 rawbase=0x4d40 */
	0x96ec,0x96ed,0x96ee,0x96f0,0x96f1,0x96f2,0x96f4,0x96f5, /* 0xEB80-0xEB87 */
	0x96f8,0x96fa,0x96fb,0x96fc,0x96fd,0x96ff,0x9702,0x9703, /* 0xEB88-0xEB8F */
	0x9705,0x970a,0x970b,0x970c,0x9710,0x9711,0x9712,0x9714, /* 0xEB90-0xEB97 */
	0x9715,0x9717,0x9718,0x9719,0x971a,0x971b,0x971d,0x971f, /* 0xEB98-0xEB9F */
	0x9720,0x643f,0x64d8,0x8004,0x6bea,0x6bf3,0x6bfd,0x6bf5, /* 0xEBA0-0xEBA7 */
	0x6bf9,0x6c05,0x6c07,0x6c06,0x6c0d,0x6c15,0x6c18,0x6c19, /* 0xEBA8-0xEBAF */
	0x6c1a,0x6c21,0x6c29,0x6c24,0x6c2a,0x6c32,0x6535,0x6555, /* 0xEBB0-0xEBB7 */
	0x656b,0x724d,0x7252,0x7256,0x7230,0x8662,0x5216,0x809f, /* 0xEBB8-0xEBBF */
	/* codebase=0xebc0 rawbase=0x4d80 */
	0x809c,0x8093,0x80bc,0x670a,0x80bd,0x80b1,0x80ab,0x80ad, /* 0xEBC0-0xEBC7 */
	0x80b4,0x80b7,0x80e7,0x80e8,0x80e9,0x80ea,0x80db,0x80c2, /* 0xEBC8-0xEBCF */
	0x80c4,0x80d9,0x80cd,0x80d7,0x6710,0x80dd,0x80eb,0x80f1, /* 0xEBD0-0xEBD7 */
	0x80f4,0x80ed,0x810d,0x810e,0x80f2,0x80fc,0x6715,0x8112, /* 0xEBD8-0xEBDF */
	0x8c5a,0x8136,0x811e,0x812c,0x8118,0x8132,0x8148,0x814c, /* 0xEBE0-0xEBE7 */
	0x8153,0x8174,0x8159,0x815a,0x8171,0x8160,0x8169,0x817c, /* 0xEBE8-0xEBEF */
	0x817d,0x816d,0x8167,0x584d,0x5ab5,0x8188,0x8182,0x8191, /* 0xEBF0-0xEBF7 */
	0x6ed5,0x81a3,0x81aa,0x81cc,0x6726,0x81ca,0x81bb,0x0000, /* 0xEBF8-0xEBFF */
	/* codebase=0xec40 rawbase=0x4dc0 */
	0x9721,0x9722,0x9723,0x9724,0x9725,0x9726,0x9727,0x9728, /* 0xEC40-0xEC47 */
	0x9729,0x972b,0x972c,0x972e,0x972f,0x9731,0x9733,0x9734, /* 0xEC48-0xEC4F */
	0x9735,0x9736,0x9737,0x973a,0x973b,0x973c,0x973d,0x973f, /* 0xEC50-0xEC57 */
	0x9740,0x9741,0x9742,0x9743,0x9744,0x9745,0x9746,0x9747, /* 0xEC58-0xEC5F */
	0x9748,0x9749,0x974a,0x974b,0x974c,0x974d,0x974e,0x974f, /* 0xEC60-0xEC67 */
	0x9750,0x9751,0x9754,0x9755,0x9757,0x9758,0x975a,0x975c, /* 0xEC68-0xEC6F */
	0x975d,0x975f,0x9763,0x9764,0x9766,0x9767,0x9768,0x976a, /* 0xEC70-0xEC77 */
	0x976b,0x976c,0x976d,0x976e,0x976f,0x9770,0x9771,0x0000, /* 0xEC78-0xEC7F */
	/* codebase=0xec80 rawbase=0x4e00 */
	0x9772,0x9775,0x9777,0x9778,0x9779,0x977a,0x977b,0x977d, /* 0xEC80-0xEC87 */
	0x977e,0x977f,0x9780,0x9781,0x9782,0x9783,0x9784,0x9786, /* 0xEC88-0xEC8F */
	0x9787,0x9788,0x9789,0x978a,0x978c,0x978e,0x978f,0x9790, /* 0xEC90-0xEC97 */
	0x9793,0x9795,0x9796,0x9797,0x9799,0x979a,0x979b,0x979c, /* 0xEC98-0xEC9F */
	0x979d,0x81c1,0x81a6,0x6b24,0x6b37,0x6b39,0x6b43,0x6b46, /* 0xECA0-0xECA7 */
	0x6b59,0x98d1,0x98d2,0x98d3,0x98d5,0x98d9,0x98da,0x6bb3, /* 0xECA8-0xECAF */
	0x5f40,0x6bc2,0x89f3,0x6590,0x9f51,0x6593,0x65bc,0x65c6, /* 0xECB0-0xECB7 */
	0x65c4,0x65c3,0x65cc,0x65ce,0x65d2,0x65d6,0x7080,0x709c, /* 0xECB8-0xECBF */
	/* codebase=0xecc0 rawbase=0x4e40 */
	0x7096,0x709d,0x70bb,0x70c0,0x70b7,0x70ab,0x70b1,0x70e8, /* 0xECC0-0xECC7 */
	0x70ca,0x7110,0x7113,0x7116,0x712f,0x7131,0x7173,0x715c, /* 0xECC8-0xECCF */
	0x7168,0x7145,0x7172,0x714a,0x7178,0x717a,0x7198,0x71b3, /* 0xECD0-0xECD7 */
	0x71b5,0x71a8,0x71a0,0x71e0,0x71d4,0x71e7,0x71f9,0x721d, /* 0xECD8-0xECDF */
	0x7228,0x706c,0x7118,0x7166,0x71b9,0x623e,0x623d,0x6243, /* 0xECE0-0xECE7 */
	0x6248,0x6249,0x793b,0x7940,0x7946,0x7949,0x795b,0x795c, /* 0xECE8-0xECEF */
	0x7953,0x795a,0x7962,0x7957,0x7960,0x796f,0x7967,0x797a, /* 0xECF0-0xECF7 */
	0x7985,0x798a,0x799a,0x79a7,0x79b3,0x5fd1,0x5fd0,0x0000, /* 0xECF8-0xECFF */
	/* codebase=0xed40 rawbase=0x4e80 */
	0x979e,0x979f,0x97a1,0x97a2,0x97a4,0x97a5,0x97a6,0x97a7, /* 0xED40-0xED47 */
	0x97a8,0x97a9,0x97aa,0x97ac,0x97ae,0x97b0,0x97b1,0x97b3, /* 0xED48-0xED4F */
	0x97b5,0x97b6,0x97b7,0x97b8,0x97b9,0x97ba,0x97bb,0x97bc, /* 0xED50-0xED57 */
	0x97bd,0x97be,0x97bf,0x97c0,0x97c1,0x97c2,0x97c3,0x97c4, /* 0xED58-0xED5F */
	0x97c5,0x97c6,0x97c7,0x97c8,0x97c9,0x97ca,0x97cb,0x97cc, /* 0xED60-0xED67 */
	0x97cd,0x97ce,0x97cf,0x97d0,0x97d1,0x97d2,0x97d3,0x97d4, /* 0xED68-0xED6F */
	0x97d5,0x97d6,0x97d7,0x97d8,0x97d9,0x97da,0x97db,0x97dc, /* 0xED70-0xED77 */
	0x97dd,0x97de,0x97df,0x97e0,0x97e1,0x97e2,0x97e3,0x0000, /* 0xED78-0xED7F */
	/* codebase=0xed80 rawbase=0x4ec0 */
	0x97e4,0x97e5,0x97e8,0x97ee,0x97ef,0x97f0,0x97f1,0x97f2, /* 0xED80-0xED87 */
	0x97f4,0x97f7,0x97f8,0x97f9,0x97fa,0x97fb,0x97fc,0x97fd, /* 0xED88-0xED8F */
	0x97fe,0x97ff,0x9800,0x9801,0x9802,0x9803,0x9804,0x9805, /* 0xED90-0xED97 */
	0x9806,0x9807,0x9808,0x9809,0x980a,0x980b,0x980c,0x980d, /* 0xED98-0xED9F */
	0x980e,0x603c,0x605d,0x605a,0x6067,0x6041,0x6059,0x6063, /* 0xEDA0-0xEDA7 */
	0x60ab,0x6106,0x610d,0x615d,0x61a9,0x619d,0x61cb,0x61d1, /* 0xEDA8-0xEDAF */
	0x6206,0x8080,0x807f,0x6c93,0x6cf6,0x6dfc,0x77f6,0x77f8, /* 0xEDB0-0xEDB7 */
	0x7800,0x7809,0x7817,0x7818,0x7811,0x65ab,0x782d,0x781c, /* 0xEDB8-0xEDBF */
	/* codebase=0xedc0 rawbase=0x4f00 */
	0x781d,0x7839,0x783a,0x783b,0x781f,0x783c,0x7825,0x782c, /* 0xEDC0-0xEDC7 */
	0x7823,0x7829,0x784e,0x786d,0x7856,0x7857,0x7826,0x7850, /* 0xEDC8-0xEDCF */
	0x7847,0x784c,0x786a,0x789b,0x7893,0x789a,0x7887,0x789c, /* 0xEDD0-0xEDD7 */
	0x78a1,0x78a3,0x78b2,0x78b9,0x78a5,0x78d4,0x78d9,0x78c9, /* 0xEDD8-0xEDDF */
	0x78ec,0x78f2,0x7905,0x78f4,0x7913,0x7924,0x791e,0x7934, /* 0xEDE0-0xEDE7 */
	0x9f9b,0x9ef9,0x9efb,0x9efc,0x76f1,0x7704,0x770d,0x76f9, /* 0xEDE8-0xEDEF */
	0x7707,0x7708,0x771a,0x7722,0x7719,0x772d,0x7726,0x7735, /* 0xEDF0-0xEDF7 */
	0x7738,0x7750,0x7751,0x7747,0x7743,0x775a,0x7768,0x0000, /* 0xEDF8-0xEDFF */
	/* codebase=0xee40 rawbase=0x4f40 */
	0x980f,0x9810,0x9811,0x9812,0x9813,0x9814,0x9815,0x9816, /* 0xEE40-0xEE47 */
	0x9817,0x9818,0x9819,0x981a,0x981b,0x981c,0x981d,0x981e, /* 0xEE48-0xEE4F */
	0x981f,0x9820,0x9821,0x9822,0x9823,0x9824,0x9825,0x9826, /* 0xEE50-0xEE57 */
	0x9827,0x9828,0x9829,0x982a,0x982b,0x982c,0x982d,0x982e, /* 0xEE58-0xEE5F */
	0x982f,0x9830,0x9831,0x9832,0x9833,0x9834,0x9835,0x9836, /* 0xEE60-0xEE67 */
	0x9837,0x9838,0x9839,0x983a,0x983b,0x983c,0x983d,0x983e, /* 0xEE68-0xEE6F */
	0x983f,0x9840,0x9841,0x9842,0x9843,0x9844,0x9845,0x9846, /* 0xEE70-0xEE77 */
	0x9847,0x9848,0x9849,0x984a,0x984b,0x984c,0x984d,0x0000, /* 0xEE78-0xEE7F */
	/* codebase=0xee80 rawbase=0x4f80 */
	0x984e,0x984f,0x9850,0x9851,0x9852,0x9853,0x9854,0x9855, /* 0xEE80-0xEE87 */
	0x9856,0x9857,0x9858,0x9859,0x985a,0x985b,0x985c,0x985d, /* 0xEE88-0xEE8F */
	0x985e,0x985f,0x9860,0x9861,0x9862,0x9863,0x9864,0x9865, /* 0xEE90-0xEE97 */
	0x9866,0x9867,0x9868,0x9869,0x986a,0x986b,0x986c,0x986d, /* 0xEE98-0xEE9F */
	0x986e,0x7762,0x7765,0x777f,0x778d,0x777d,0x7780,0x778c, /* 0xEEA0-0xEEA7 */
	0x7791,0x779f,0x77a0,0x77b0,0x77b5,0x77bd,0x753a,0x7540, /* 0xEEA8-0xEEAF */
	0x754e,0x754b,0x7548,0x755b,0x7572,0x7579,0x7583,0x7f58, /* 0xEEB0-0xEEB7 */
	0x7f61,0x7f5f,0x8a48,0x7f68,0x7f74,0x7f71,0x7f79,0x7f81, /* 0xEEB8-0xEEBF */
	/* codebase=0xeec0 rawbase=0x4fc0 */
	0x7f7e,0x76cd,0x76e5,0x8832,0x9485,0x9486,0x9487,0x948b, /* 0xEEC0-0xEEC7 */
	0x948a,0x948c,0x948d,0x948f,0x9490,0x9494,0x9497,0x9495, /* 0xEEC8-0xEECF */
	0x949a,0x949b,0x949c,0x94a3,0x94a4,0x94ab,0x94aa,0x94ad, /* 0xEED0-0xEED7 */
	0x94ac,0x94af,0x94b0,0x94b2,0x94b4,0x94b6,0x94b7,0x94b8, /* 0xEED8-0xEEDF */
	0x94b9,0x94ba,0x94bc,0x94bd,0x94bf,0x94c4,0x94c8,0x94c9, /* 0xEEE0-0xEEE7 */
	0x94ca,0x94cb,0x94cc,0x94cd,0x94ce,0x94d0,0x94d1,0x94d2, /* 0xEEE8-0xEEEF */
	0x94d5,0x94d6,0x94d7,0x94d9,0x94d8,0x94db,0x94de,0x94df, /* 0xEEF0-0xEEF7 */
	0x94e0,0x94e2,0x94e4,0x94e5,0x94e7,0x94e8,0x94ea,0x0000, /* 0xEEF8-0xEEFF */
	/* codebase=0xef40 rawbase=0x5000 */
	0x986f,0x9870,0x9871,0x9872,0x9873,0x9874,0x988b,0x988e, /* 0xEF40-0xEF47 */
	0x9892,0x9895,0x9899,0x98a3,0x98a8,0x98a9,0x98aa,0x98ab, /* 0xEF48-0xEF4F */
	0x98ac,0x98ad,0x98ae,0x98af,0x98b0,0x98b1,0x98b2,0x98b3, /* 0xEF50-0xEF57 */
	0x98b4,0x98b5,0x98b6,0x98b7,0x98b8,0x98b9,0x98ba,0x98bb, /* 0xEF58-0xEF5F */
	0x98bc,0x98bd,0x98be,0x98bf,0x98c0,0x98c1,0x98c2,0x98c3, /* 0xEF60-0xEF67 */
	0x98c4,0x98c5,0x98c6,0x98c7,0x98c8,0x98c9,0x98ca,0x98cb, /* 0xEF68-0xEF6F */
	0x98cc,0x98cd,0x98cf,0x98d0,0x98d4,0x98d6,0x98d7,0x98db, /* 0xEF70-0xEF77 */
	0x98dc,0x98dd,0x98e0,0x98e1,0x98e2,0x98e3,0x98e4,0x0000, /* 0xEF78-0xEF7F */
	/* codebase=0xef80 rawbase=0x5040 */
	0x98e5,0x98e6,0x98e9,0x98ea,0x98eb,0x98ec,0x98ed,0x98ee, /* 0xEF80-0xEF87 */
	0x98ef,0x98f0,0x98f1,0x98f2,0x98f3,0x98f4,0x98f5,0x98f6, /* 0xEF88-0xEF8F */
	0x98f7,0x98f8,0x98f9,0x98fa,0x98fb,0x98fc,0x98fd,0x98fe, /* 0xEF90-0xEF97 */
	0x98ff,0x9900,0x9901,0x9902,0x9903,0x9904,0x9905,0x9906, /* 0xEF98-0xEF9F */
	0x9907,0x94e9,0x94eb,0x94ee,0x94ef,0x94f3,0x94f4,0x94f5, /* 0xEFA0-0xEFA7 */
	0x94f7,0x94f9,0x94fc,0x94fd,0x94ff,0x9503,0x9502,0x9506, /* 0xEFA8-0xEFAF */
	0x9507,0x9509,0x950a,0x950d,0x950e,0x950f,0x9512,0x9513, /* 0xEFB0-0xEFB7 */
	0x9514,0x9515,0x9516,0x9518,0x951b,0x951d,0x951e,0x951f, /* 0xEFB8-0xEFBF */
	/* codebase=0xefc0 rawbase=0x5080 */
	0x9522,0x952a,0x952b,0x9529,0x952c,0x9531,0x9532,0x9534, /* 0xEFC0-0xEFC7 */
	0x9536,0x9537,0x9538,0x953c,0x953e,0x953f,0x9542,0x9535, /* 0xEFC8-0xEFCF */
	0x9544,0x9545,0x9546,0x9549,0x954c,0x954e,0x954f,0x9552, /* 0xEFD0-0xEFD7 */
	0x9553,0x9554,0x9556,0x9557,0x9558,0x9559,0x955b,0x955e, /* 0xEFD8-0xEFDF */
	0x955f,0x955d,0x9561,0x9562,0x9564,0x9565,0x9566,0x9567, /* 0xEFE0-0xEFE7 */
	0x9568,0x9569,0x956a,0x956b,0x956c,0x956f,0x9571,0x9572, /* 0xEFE8-0xEFEF */
	0x9573,0x953a,0x77e7,0x77ec,0x96c9,0x79d5,0x79ed,0x79e3, /* 0xEFF0-0xEFF7 */
	0x79eb,0x7a06,0x5d47,0x7a03,0x7a02,0x7a1e,0x7a14,0x0000, /* 0xEFF8-0xEFFF */
	/* codebase=0xf040 rawbase=0x50c0 */
	0x9908,0x9909,0x990a,0x990b,0x990c,0x990e,0x990f,0x9911, /* 0xF040-0xF047 */
	0x9912,0x9913,0x9914,0x9915,0x9916,0x9917,0x9918,0x9919, /* 0xF048-0xF04F */
	0x991a,0x991b,0x991c,0x991d,0x991e,0x991f,0x9920,0x9921, /* 0xF050-0xF057 */
	0x9922,0x9923,0x9924,0x9925,0x9926,0x9927,0x9928,0x9929, /* 0xF058-0xF05F */
	0x992a,0x992b,0x992c,0x992d,0x992f,0x9930,0x9931,0x9932, /* 0xF060-0xF067 */
	0x9933,0x9934,0x9935,0x9936,0x9937,0x9938,0x9939,0x993a, /* 0xF068-0xF06F */
	0x993b,0x993c,0x993d,0x993e,0x993f,0x9940,0x9941,0x9942, /* 0xF070-0xF077 */
	0x9943,0x9944,0x9945,0x9946,0x9947,0x9948,0x9949,0x0000, /* 0xF078-0xF07F */
	/* codebase=0xf080 rawbase=0x5100 */
	0x994a,0x994b,0x994c,0x994d,0x994e,0x994f,0x9950,0x9951, /* 0xF080-0xF087 */
	0x9952,0x9953,0x9956,0x9957,0x9958,0x9959,0x995a,0x995b, /* 0xF088-0xF08F */
	0x995c,0x995d,0x995e,0x995f,0x9960,0x9961,0x9962,0x9964, /* 0xF090-0xF097 */
	0x9966,0x9973,0x9978,0x9979,0x997b,0x997e,0x9982,0x9983, /* 0xF098-0xF09F */
	0x9989,0x7a39,0x7a37,0x7a51,0x9ecf,0x99a5,0x7a70,0x7688, /* 0xF0A0-0xF0A7 */
	0x768e,0x7693,0x7699,0x76a4,0x74de,0x74e0,0x752c,0x9e20, /* 0xF0A8-0xF0AF */
	0x9e22,0x9e28,0x9e29,0x9e2a,0x9e2b,0x9e2c,0x9e32,0x9e31, /* 0xF0B0-0xF0B7 */
	0x9e36,0x9e38,0x9e37,0x9e39,0x9e3a,0x9e3e,0x9e41,0x9e42, /* 0xF0B8-0xF0BF */
	/* codebase=0xf0c0 rawbase=0x5140 */
	0x9e44,0x9e46,0x9e47,0x9e48,0x9e49,0x9e4b,0x9e4c,0x9e4e, /* 0xF0C0-0xF0C7 */
	0x9e51,0x9e55,0x9e57,0x9e5a,0x9e5b,0x9e5c,0x9e5e,0x9e63, /* 0xF0C8-0xF0CF */
	0x9e66,0x9e67,0x9e68,0x9e69,0x9e6a,0x9e6b,0x9e6c,0x9e71, /* 0xF0D0-0xF0D7 */
	0x9e6d,0x9e73,0x7592,0x7594,0x7596,0x75a0,0x759d,0x75ac, /* 0xF0D8-0xF0DF */
	0x75a3,0x75b3,0x75b4,0x75b8,0x75c4,0x75b1,0x75b0,0x75c3, /* 0xF0E0-0xF0E7 */
	0x75c2,0x75d6,0x75cd,0x75e3,0x75e8,0x75e6,0x75e4,0x75eb, /* 0xF0E8-0xF0EF */
	0x75e7,0x7603,0x75f1,0x75fc,0x75ff,0x7610,0x7600,0x7605, /* 0xF0F0-0xF0F7 */
	0x760c,0x7617,0x760a,0x7625,0x7618,0x7615,0x7619,0x0000, /* 0xF0F8-0xF0FF */
	/* codebase=0xf140 rawbase=0x5180 */
	0x998c,0x998e,0x999a,0x999b,0x999c,0x999d,0x999e,0x999f, /* 0xF140-0xF147 */
	0x99a0,0x99a1,0x99a2,0x99a3,0x99a4,0x99a6,0x99a7,0x99a9, /* 0xF148-0xF14F */
	0x99aa,0x99ab,0x99ac,0x99ad,0x99ae,0x99af,0x99b0,0x99b1, /* 0xF150-0xF157 */
	0x99b2,0x99b3,0x99b4,0x99b5,0x99b6,0x99b7,0x99b8,0x99b9, /* 0xF158-0xF15F */
	0x99ba,0x99bb,0x99bc,0x99bd,0x99be,0x99bf,0x99c0,0x99c1, /* 0xF160-0xF167 */
	0x99c2,0x99c3,0x99c4,0x99c5,0x99c6,0x99c7,0x99c8,0x99c9, /* 0xF168-0xF16F */
	0x99ca,0x99cb,0x99cc,0x99cd,0x99ce,0x99cf,0x99d0,0x99d1, /* 0xF170-0xF177 */
	0x99d2,0x99d3,0x99d4,0x99d5,0x99d6,0x99d7,0x99d8,0x0000, /* 0xF178-0xF17F */
	/* codebase=0xf180 rawbase=0x51c0 */
	0x99d9,0x99da,0x99db,0x99dc,0x99dd,0x99de,0x99df,0x99e0, /* 0xF180-0xF187 */
	0x99e1,0x99e2,0x99e3,0x99e4,0x99e5,0x99e6,0x99e7,0x99e8, /* 0xF188-0xF18F */
	0x99e9,0x99ea,0x99eb,0x99ec,0x99ed,0x99ee,0x99ef,0x99f0, /* 0xF190-0xF197 */
	0x99f1,0x99f2,0x99f3,0x99f4,0x99f5,0x99f6,0x99f7,0x99f8, /* 0xF198-0xF19F */
	0x99f9,0x761b,0x763c,0x7622,0x7620,0x7640,0x762d,0x7630, /* 0xF1A0-0xF1A7 */
	0x763f,0x7635,0x7643,0x763e,0x7633,0x764d,0x765e,0x7654, /* 0xF1A8-0xF1AF */
	0x765c,0x7656,0x766b,0x766f,0x7fca,0x7ae6,0x7a78,0x7a79, /* 0xF1B0-0xF1B7 */
	0x7a80,0x7a86,0x7a88,0x7a95,0x7aa6,0x7aa0,0x7aac,0x7aa8, /* 0xF1B8-0xF1BF */
	/* codebase=0xf1c0 rawbase=0x5200 */
	0x7aad,0x7ab3,0x8864,0x8869,0x8872,0x887d,0x887f,0x8882, /* 0xF1C0-0xF1C7 */
	0x88a2,0x88c6,0x88b7,0x88bc,0x88c9,0x88e2,0x88ce,0x88e3, /* 0xF1C8-0xF1CF */
	0x88e5,0x88f1,0x891a,0x88fc,0x88e8,0x88fe,0x88f0,0x8921, /* 0xF1D0-0xF1D7 */
	0x8919,0x8913,0x891b,0x890a,0x8934,0x892b,0x8936,0x8941, /* 0xF1D8-0xF1DF */
	0x8966,0x897b,0x758b,0x80e5,0x76b2,0x76b4,0x77dc,0x8012, /* 0xF1E0-0xF1E7 */
	0x8014,0x8016,0x801c,0x8020,0x8022,0x8025,0x8026,0x8027, /* 0xF1E8-0xF1EF */
	0x8029,0x8028,0x8031,0x800b,0x8035,0x8043,0x8046,0x804d, /* 0xF1F0-0xF1F7 */
	0x8052,0x8069,0x8071,0x8983,0x9878,0x9880,0x9883,0x0000, /* 0xF1F8-0xF1FF */
	/* codebase=0xf240 rawbase=0x5240 */
	0x99fa,0x99fb,0x99fc,0x99fd,0x99fe,0x99ff,0x9a00,0x9a01, /* 0xF240-0xF247 */
	0x9a02,0x9a03,0x9a04,0x9a05,0x9a06,0x9a07,0x9a08,0x9a09, /* 0xF248-0xF24F */
	0x9a0a,0x9a0b,0x9a0c,0x9a0d,0x9a0e,0x9a0f,0x9a10,0x9a11, /* 0xF250-0xF257 */
	0x9a12,0x9a13,0x9a14,0x9a15,0x9a16,0x9a17,0x9a18,0x9a19, /* 0xF258-0xF25F */
	0x9a1a,0x9a1b,0x9a1c,0x9a1d,0x9a1e,0x9a1f,0x9a20,0x9a21, /* 0xF260-0xF267 */
	0x9a22,0x9a23,0x9a24,0x9a25,0x9a26,0x9a27,0x9a28,0x9a29, /* 0xF268-0xF26F */
	0x9a2a,0x9a2b,0x9a2c,0x9a2d,0x9a2e,0x9a2f,0x9a30,0x9a31, /* 0xF270-0xF277 */
	0x9a32,0x9a33,0x9a34,0x9a35,0x9a36,0x9a37,0x9a38,0x0000, /* 0xF278-0xF27F */
	/* codebase=0xf280 rawbase=0x5280 */
	0x9a39,0x9a3a,0x9a3b,0x9a3c,0x9a3d,0x9a3e,0x9a3f,0x9a40, /* 0xF280-0xF287 */
	0x9a41,0x9a42,0x9a43,0x9a44,0x9a45,0x9a46,0x9a47,0x9a48, /* 0xF288-0xF28F */
	0x9a49,0x9a4a,0x9a4b,0x9a4c,0x9a4d,0x9a4e,0x9a4f,0x9a50, /* 0xF290-0xF297 */
	0x9a51,0x9a52,0x9a53,0x9a54,0x9a55,0x9a56,0x9a57,0x9a58, /* 0xF298-0xF29F */
	0x9a59,0x9889,0x988c,0x988d,0x988f,0x9894,0x989a,0x989b, /* 0xF2A0-0xF2A7 */
	0x989e,0x989f,0x98a1,0x98a2,0x98a5,0x98a6,0x864d,0x8654, /* 0xF2A8-0xF2AF */
	0x866c,0x866e,0x867f,0x867a,0x867c,0x867b,0x86a8,0x868d, /* 0xF2B0-0xF2B7 */
	0x868b,0x86ac,0x869d,0x86a7,0x86a3,0x86aa,0x8693,0x86a9, /* 0xF2B8-0xF2BF */
	/* codebase=0xf2c0 rawbase=0x52c0 */
	0x86b6,0x86c4,0x86b5,0x86ce,0x86b0,0x86ba,0x86b1,0x86af, /* 0xF2C0-0xF2C7 */
	0x86c9,0x86cf,0x86b4,0x86e9,0x86f1,0x86f2,0x86ed,0x86f3, /* 0xF2C8-0xF2CF */
	0x86d0,0x8713,0x86de,0x86f4,0x86df,0x86d8,0x86d1,0x8703, /* 0xF2D0-0xF2D7 */
	0x8707,0x86f8,0x8708,0x870a,0x870d,0x8709,0x8723,0x873b, /* 0xF2D8-0xF2DF */
	0x871e,0x8725,0x872e,0x871a,0x873e,0x8748,0x8734,0x8731, /* 0xF2E0-0xF2E7 */
	0x8729,0x8737,0x873f,0x8782,0x8722,0x877d,0x877e,0x877b, /* 0xF2E8-0xF2EF */
	0x8760,0x8770,0x874c,0x876e,0x878b,0x8753,0x8763,0x877c, /* 0xF2F0-0xF2F7 */
	0x8764,0x8759,0x8765,0x8793,0x87af,0x87a8,0x87d2,0x0000, /* 0xF2F8-0xF2FF */
	/* codebase=0xf340 rawbase=0x5300 */
	0x9a5a,0x9a5b,0x9a5c,0x9a5d,0x9a5e,0x9a5f,0x9a60,0x9a61, /* 0xF340-0xF347 */
	0x9a62,0x9a63,0x9a64,0x9a65,0x9a66,0x9a67,0x9a68,0x9a69, /* 0xF348-0xF34F */
	0x9a6a,0x9a6b,0x9a72,0x9a83,0x9a89,0x9a8d,0x9a8e,0x9a94, /* 0xF350-0xF357 */
	0x9a95,0x9a99,0x9aa6,0x9aa9,0x9aaa,0x9aab,0x9aac,0x9aad, /* 0xF358-0xF35F */
	0x9aae,0x9aaf,0x9ab2,0x9ab3,0x9ab4,0x9ab5,0x9ab9,0x9abb, /* 0xF360-0xF367 */
	0x9abd,0x9abe,0x9abf,0x9ac3,0x9ac4,0x9ac6,0x9ac7,0x9ac8, /* 0xF368-0xF36F */
	0x9ac9,0x9aca,0x9acd,0x9ace,0x9acf,0x9ad0,0x9ad2,0x9ad4, /* 0xF370-0xF377 */
	0x9ad5,0x9ad6,0x9ad7,0x9ad9,0x9ada,0x9adb,0x9adc,0x0000, /* 0xF378-0xF37F */
	/* codebase=0xf380 rawbase=0x5340 */
	0x9add,0x9ade,0x9ae0,0x9ae2,0x9ae3,0x9ae4,0x9ae5,0x9ae7, /* 0xF380-0xF387 */
	0x9ae8,0x9ae9,0x9aea,0x9aec,0x9aee,0x9af0,0x9af1,0x9af2, /* 0xF388-0xF38F */
	0x9af3,0x9af4,0x9af5,0x9af6,0x9af7,0x9af8,0x9afa,0x9afc, /* 0xF390-0xF397 */
	0x9afd,0x9afe,0x9aff,0x9b00,0x9b01,0x9b02,0x9b04,0x9b05, /* 0xF398-0xF39F */
	0x9b06,0x87c6,0x8788,0x8785,0x87ad,0x8797,0x8783,0x87ab, /* 0xF3A0-0xF3A7 */
	0x87e5,0x87ac,0x87b5,0x87b3,0x87cb,0x87d3,0x87bd,0x87d1, /* 0xF3A8-0xF3AF */
	0x87c0,0x87ca,0x87db,0x87ea,0x87e0,0x87ee,0x8816,0x8813, /* 0xF3B0-0xF3B7 */
	0x87fe,0x880a,0x881b,0x8821,0x8839,0x883c,0x7f36,0x7f42, /* 0xF3B8-0xF3BF */
	/* codebase=0xf3c0 rawbase=0x5380 */
	0x7f44,0x7f45,0x8210,0x7afa,0x7afd,0x7b08,0x7b03,0x7b04, /* 0xF3C0-0xF3C7 */
	0x7b15,0x7b0a,0x7b2b,0x7b0f,0x7b47,0x7b38,0x7b2a,0x7b19, /* 0xF3C8-0xF3CF */
	0x7b2e,0x7b31,0x7b20,0x7b25,0x7b24,0x7b33,0x7b3e,0x7b1e, /* 0xF3D0-0xF3D7 */
	0x7b58,0x7b5a,0x7b45,0x7b75,0x7b4c,0x7b5d,0x7b60,0x7b6e, /* 0xF3D8-0xF3DF */
	0x7b7b,0x7b62,0x7b72,0x7b71,0x7b90,0x7ba6,0x7ba7,0x7bb8, /* 0xF3E0-0xF3E7 */
	0x7bac,0x7b9d,0x7ba8,0x7b85,0x7baa,0x7b9c,0x7ba2,0x7bab, /* 0xF3E8-0xF3EF */
	0x7bb4,0x7bd1,0x7bc1,0x7bcc,0x7bdd,0x7bda,0x7be5,0x7be6, /* 0xF3F0-0xF3F7 */
	0x7bea,0x7c0c,0x7bfe,0x7bfc,0x7c0f,0x7c16,0x7c0b,0x0000, /* 0xF3F8-0xF3FF */
	/* codebase=0xf440 rawbase=0x53c0 */
	0x9b07,0x9b09,0x9b0a,0x9b0b,0x9b0c,0x9b0d,0x9b0e,0x9b10, /* 0xF440-0xF447 */
	0x9b11,0x9b12,0x9b14,0x9b15,0x9b16,0x9b17,0x9b18,0x9b19, /* 0xF448-0xF44F */
	0x9b1a,0x9b1b,0x9b1c,0x9b1d,0x9b1e,0x9b20,0x9b21,0x9b22, /* 0xF450-0xF457 */
	0x9b24,0x9b25,0x9b26,0x9b27,0x9b28,0x9b29,0x9b2a,0x9b2b, /* 0xF458-0xF45F */
	0x9b2c,0x9b2d,0x9b2e,0x9b30,0x9b31,0x9b33,0x9b34,0x9b35, /* 0xF460-0xF467 */
	0x9b36,0x9b37,0x9b38,0x9b39,0x9b3a,0x9b3d,0x9b3e,0x9b3f, /* 0xF468-0xF46F */
	0x9b40,0x9b46,0x9b4a,0x9b4b,0x9b4c,0x9b4e,0x9b50,0x9b52, /* 0xF470-0xF477 */
	0x9b53,0x9b55,0x9b56,0x9b57,0x9b58,0x9b59,0x9b5a,0x0000, /* 0xF478-0xF47F */
	/* codebase=0xf480 rawbase=0x5400 */
	0x9b5b,0x9b5c,0x9b5d,0x9b5e,0x9b5f,0x9b60,0x9b61,0x9b62, /* 0xF480-0xF487 */
	0x9b63,0x9b64,0x9b65,0x9b66,0x9b67,0x9b68,0x9b69,0x9b6a, /* 0xF488-0xF48F */
	0x9b6b,0x9b6c,0x9b6d,0x9b6e,0x9b6f,0x9b70,0x9b71,0x9b72, /* 0xF490-0xF497 */
	0x9b73,0x9b74,0x9b75,0x9b76,0x9b77,0x9b78,0x9b79,0x9b7a, /* 0xF498-0xF49F */
	0x9b7b,0x7c1f,0x7c2a,0x7c26,0x7c38,0x7c41,0x7c40,0x81fe, /* 0xF4A0-0xF4A7 */
	0x8201,0x8202,0x8204,0x81ec,0x8844,0x8221,0x8222,0x8223, /* 0xF4A8-0xF4AF */
	0x822d,0x822f,0x8228,0x822b,0x8238,0x823b,0x8233,0x8234, /* 0xF4B0-0xF4B7 */
	0x823e,0x8244,0x8249,0x824b,0x824f,0x825a,0x825f,0x8268, /* 0xF4B8-0xF4BF */
	/* codebase=0xf4c0 rawbase=0x5440 */
	0x887e,0x8885,0x8888,0x88d8,0x88df,0x895e,0x7f9d,0x7f9f, /* 0xF4C0-0xF4C7 */
	0x7fa7,0x7faf,0x7fb0,0x7fb2,0x7c7c,0x6549,0x7c91,0x7c9d, /* 0xF4C8-0xF4CF */
	0x7c9c,0x7c9e,0x7ca2,0x7cb2,0x7cbc,0x7cbd,0x7cc1,0x7cc7, /* 0xF4D0-0xF4D7 */
	0x7ccc,0x7ccd,0x7cc8,0x7cc5,0x7cd7,0x7ce8,0x826e,0x66a8, /* 0xF4D8-0xF4DF */
	0x7fbf,0x7fce,0x7fd5,0x7fe5,0x7fe1,0x7fe6,0x7fe9,0x7fee, /* 0xF4E0-0xF4E7 */
	0x7ff3,0x7cf8,0x7d77,0x7da6,0x7dae,0x7e47,0x7e9b,0x9eb8, /* 0xF4E8-0xF4EF */
	0x9eb4,0x8d73,0x8d84,0x8d94,0x8d91,0x8db1,0x8d67,0x8d6d, /* 0xF4F0-0xF4F7 */
	0x8c47,0x8c49,0x914a,0x9150,0x914e,0x914f,0x9164,0x0000, /* 0xF4F8-0xF4FF */
	/* codebase=0xf540 rawbase=0x5480 */
	0x9b7c,0x9b7d,0x9b7e,0x9b7f,0x9b80,0x9b81,0x9b82,0x9b83, /* 0xF540-0xF547 */
	0x9b84,0x9b85,0x9b86,0x9b87,0x9b88,0x9b89,0x9b8a,0x9b8b, /* 0xF548-0xF54F */
	0x9b8c,0x9b8d,0x9b8e,0x9b8f,0x9b90,0x9b91,0x9b92,0x9b93, /* 0xF550-0xF557 */
	0x9b94,0x9b95,0x9b96,0x9b97,0x9b98,0x9b99,0x9b9a,0x9b9b, /* 0xF558-0xF55F */
	0x9b9c,0x9b9d,0x9b9e,0x9b9f,0x9ba0,0x9ba1,0x9ba2,0x9ba3, /* 0xF560-0xF567 */
	0x9ba4,0x9ba5,0x9ba6,0x9ba7,0x9ba8,0x9ba9,0x9baa,0x9bab, /* 0xF568-0xF56F */
	0x9bac,0x9bad,0x9bae,0x9baf,0x9bb0,0x9bb1,0x9bb2,0x9bb3, /* 0xF570-0xF577 */
	0x9bb4,0x9bb5,0x9bb6,0x9bb7,0x9bb8,0x9bb9,0x9bba,0x0000, /* 0xF578-0xF57F */
	/* codebase=0xf580 rawbase=0x54c0 */
	0x9bbb,0x9bbc,0x9bbd,0x9bbe,0x9bbf,0x9bc0,0x9bc1,0x9bc2, /* 0xF580-0xF587 */
	0x9bc3,0x9bc4,0x9bc5,0x9bc6,0x9bc7,0x9bc8,0x9bc9,0x9bca, /* 0xF588-0xF58F */
	0x9bcb,0x9bcc,0x9bcd,0x9bce,0x9bcf,0x9bd0,0x9bd1,0x9bd2, /* 0xF590-0xF597 */
	0x9bd3,0x9bd4,0x9bd5,0x9bd6,0x9bd7,0x9bd8,0x9bd9,0x9bda, /* 0xF598-0xF59F */
	0x9bdb,0x9162,0x9161,0x9170,0x9169,0x916f,0x917d,0x917e, /* 0xF5A0-0xF5A7 */
	0x9172,0x9174,0x9179,0x918c,0x9185,0x9190,0x918d,0x9191, /* 0xF5A8-0xF5AF */
	0x91a2,0x91a3,0x91aa,0x91ad,0x91ae,0x91af,0x91b5,0x91b4, /* 0xF5B0-0xF5B7 */
	0x91ba,0x8c55,0x9e7e,0x8db8,0x8deb,0x8e05,0x8e59,0x8e69, /* 0xF5B8-0xF5BF */
	/* codebase=0xf5c0 rawbase=0x5500 */
	0x8db5,0x8dbf,0x8dbc,0x8dba,0x8dc4,0x8dd6,0x8dd7,0x8dda, /* 0xF5C0-0xF5C7 */
	0x8dde,0x8dce,0x8dcf,0x8ddb,0x8dc6,0x8dec,0x8df7,0x8df8, /* 0xF5C8-0xF5CF */
	0x8de3,0x8df9,0x8dfb,0x8de4,0x8e09,0x8dfd,0x8e14,0x8e1d, /* 0xF5D0-0xF5D7 */
	0x8e1f,0x8e2c,0x8e2e,0x8e23,0x8e2f,0x8e3a,0x8e40,0x8e39, /* 0xF5D8-0xF5DF */
	0x8e35,0x8e3d,0x8e31,0x8e49,0x8e41,0x8e42,0x8e51,0x8e52, /* 0xF5E0-0xF5E7 */
	0x8e4a,0x8e70,0x8e76,0x8e7c,0x8e6f,0x8e74,0x8e85,0x8e8f, /* 0xF5E8-0xF5EF */
	0x8e94,0x8e90,0x8e9c,0x8e9e,0x8c78,0x8c82,0x8c8a,0x8c85, /* 0xF5F0-0xF5F7 */
	0x8c98,0x8c94,0x659b,0x89d6,0x89de,0x89da,0x89dc,0x0000, /* 0xF5F8-0xF5FF */
	/* codebase=0xf640 rawbase=0x5540 */
	0x9bdc,0x9bdd,0x9bde,0x9bdf,0x9be0,0x9be1,0x9be2,0x9be3, /* 0xF640-0xF647 */
	0x9be4,0x9be5,0x9be6,0x9be7,0x9be8,0x9be9,0x9bea,0x9beb, /* 0xF648-0xF64F */
	0x9bec,0x9bed,0x9bee,0x9bef,0x9bf0,0x9bf1,0x9bf2,0x9bf3, /* 0xF650-0xF657 */
	0x9bf4,0x9bf5,0x9bf6,0x9bf7,0x9bf8,0x9bf9,0x9bfa,0x9bfb, /* 0xF658-0xF65F */
	0x9bfc,0x9bfd,0x9bfe,0x9bff,0x9c00,0x9c01,0x9c02,0x9c03, /* 0xF660-0xF667 */
	0x9c04,0x9c05,0x9c06,0x9c07,0x9c08,0x9c09,0x9c0a,0x9c0b, /* 0xF668-0xF66F */
	0x9c0c,0x9c0d,0x9c0e,0x9c0f,0x9c10,0x9c11,0x9c12,0x9c13, /* 0xF670-0xF677 */
	0x9c14,0x9c15,0x9c16,0x9c17,0x9c18,0x9c19,0x9c1a,0x0000, /* 0xF678-0xF67F */
	/* codebase=0xf680 rawbase=0x5580 */
	0x9c1b,0x9c1c,0x9c1d,0x9c1e,0x9c1f,0x9c20,0x9c21,0x9c22, /* 0xF680-0xF687 */
	0x9c23,0x9c24,0x9c25,0x9c26,0x9c27,0x9c28,0x9c29,0x9c2a, /* 0xF688-0xF68F */
	0x9c2b,0x9c2c,0x9c2d,0x9c2e,0x9c2f,0x9c30,0x9c31,0x9c32, /* 0xF690-0xF697 */
	0x9c33,0x9c34,0x9c35,0x9c36,0x9c37,0x9c38,0x9c39,0x9c3a, /* 0xF698-0xF69F */
	0x9c3b,0x89e5,0x89eb,0x89ef,0x8a3e,0x8b26,0x9753,0x96e9, /* 0xF6A0-0xF6A7 */
	0x96f3,0x96ef,0x9706,0x9701,0x9708,0x970f,0x970e,0x972a, /* 0xF6A8-0xF6AF */
	0x972d,0x9730,0x973e,0x9f80,0x9f83,0x9f85,0x9f86,0x9f87, /* 0xF6B0-0xF6B7 */
	0x9f88,0x9f89,0x9f8a,0x9f8c,0x9efe,0x9f0b,0x9f0d,0x96b9, /* 0xF6B8-0xF6BF */
	/* codebase=0xf6c0 rawbase=0x55c0 */
	0x96bc,0x96bd,0x96ce,0x96d2,0x77bf,0x96e0,0x928e,0x92ae, /* 0xF6C0-0xF6C7 */
	0x92c8,0x933e,0x936a,0x93ca,0x938f,0x943e,0x946b,0x9c7f, /* 0xF6C8-0xF6CF */
	0x9c82,0x9c85,0x9c86,0x9c87,0x9c88,0x7a23,0x9c8b,0x9c8e, /* 0xF6D0-0xF6D7 */
	0x9c90,0x9c91,0x9c92,0x9c94,0x9c95,0x9c9a,0x9c9b,0x9c9e, /* 0xF6D8-0xF6DF */
	0x9c9f,0x9ca0,0x9ca1,0x9ca2,0x9ca3,0x9ca5,0x9ca6,0x9ca7, /* 0xF6E0-0xF6E7 */
	0x9ca8,0x9ca9,0x9cab,0x9cad,0x9cae,0x9cb0,0x9cb1,0x9cb2, /* 0xF6E8-0xF6EF */
	0x9cb3,0x9cb4,0x9cb5,0x9cb6,0x9cb7,0x9cba,0x9cbb,0x9cbc, /* 0xF6F0-0xF6F7 */
	0x9cbd,0x9cc4,0x9cc5,0x9cc6,0x9cc7,0x9cca,0x9ccb,0x0000, /* 0xF6F8-0xF6FF */
	/* codebase=0xf740 rawbase=0x5600 */
	0x9c3c,0x9c3d,0x9c3e,0x9c3f,0x9c40,0x9c41,0x9c42,0x9c43, /* 0xF740-0xF747 */
	0x9c44,0x9c45,0x9c46,0x9c47,0x9c48,0x9c49,0x9c4a,0x9c4b, /* 0xF748-0xF74F */
	0x9c4c,0x9c4d,0x9c4e,0x9c4f,0x9c50,0x9c51,0x9c52,0x9c53, /* 0xF750-0xF757 */
	0x9c54,0x9c55,0x9c56,0x9c57,0x9c58,0x9c59,0x9c5a,0x9c5b, /* 0xF758-0xF75F */
	0x9c5c,0x9c5d,0x9c5e,0x9c5f,0x9c60,0x9c61,0x9c62,0x9c63, /* 0xF760-0xF767 */
	0x9c64,0x9c65,0x9c66,0x9c67,0x9c68,0x9c69,0x9c6a,0x9c6b, /* 0xF768-0xF76F */
	0x9c6c,0x9c6d,0x9c6e,0x9c6f,0x9c70,0x9c71,0x9c72,0x9c73, /* 0xF770-0xF777 */
	0x9c74,0x9c75,0x9c76,0x9c77,0x9c78,0x9c79,0x9c7a,0x0000, /* 0xF778-0xF77F */
	/* codebase=0xf780 rawbase=0x5640 */
	0x9c7b,0x9c7d,0x9c7e,0x9c80,0x9c83,0x9c84,0x9c89,0x9c8a, /* 0xF780-0xF787 */
	0x9c8c,0x9c8f,0x9c93,0x9c96,0x9c97,0x9c98,0x9c99,0x9c9d, /* 0xF788-0xF78F */
	0x9caa,0x9cac,0x9caf,0x9cb9,0x9cbe,0x9cbf,0x9cc0,0x9cc1, /* 0xF790-0xF797 */
	0x9cc2,0x9cc8,0x9cc9,0x9cd1,0x9cd2,0x9cda,0x9cdb,0x9ce0, /* 0xF798-0xF79F */
	0x9ce1,0x9ccc,0x9ccd,0x9cce,0x9ccf,0x9cd0,0x9cd3,0x9cd4, /* 0xF7A0-0xF7A7 */
	0x9cd5,0x9cd7,0x9cd8,0x9cd9,0x9cdc,0x9cdd,0x9cdf,0x9ce2, /* 0xF7A8-0xF7AF */
	0x977c,0x9785,0x9791,0x9792,0x9794,0x97af,0x97ab,0x97a3, /* 0xF7B0-0xF7B7 */
	0x97b2,0x97b4,0x9ab1,0x9ab0,0x9ab7,0x9e58,0x9ab6,0x9aba, /* 0xF7B8-0xF7BF */
	/* codebase=0xf7c0 rawbase=0x5680 */
	0x9abc,0x9ac1,0x9ac0,0x9ac5,0x9ac2,0x9acb,0x9acc,0x9ad1, /* 0xF7C0-0xF7C7 */
	0x9b45,0x9b43,0x9b47,0x9b49,0x9b48,0x9b4d,0x9b51,0x98e8, /* 0xF7C8-0xF7CF */
	0x990d,0x992e,0x9955,0x9954,0x9adf,0x9ae1,0x9ae6,0x9aef, /* 0xF7D0-0xF7D7 */
	0x9aeb,0x9afb,0x9aed,0x9af9,0x9b08,0x9b0f,0x9b13,0x9b1f, /* 0xF7D8-0xF7DF */
	0x9b23,0x9ebd,0x9ebe,0x7e3b,0x9e82,0x9e87,0x9e88,0x9e8b, /* 0xF7E0-0xF7E7 */
	0x9e92,0x93d6,0x9e9d,0x9e9f,0x9edb,0x9edc,0x9edd,0x9ee0, /* 0xF7E8-0xF7EF */
	0x9edf,0x9ee2,0x9ee9,0x9ee7,0x9ee5,0x9eea,0x9eef,0x9f22, /* 0xF7F0-0xF7F7 */
	0x9f2c,0x9f2f,0x9f39,0x9f37,0x9f3d,0x9f3e,0x9f44,0x0000, /* 0xF7F8-0xF7FF */
	/* codebase=0xf840 rawbase=0x56c0 */
	0x9ce3,0x9ce4,0x9ce5,0x9ce6,0x9ce7,0x9ce8,0x9ce9,0x9cea, /* 0xF840-0xF847 */
	0x9ceb,0x9cec,0x9ced,0x9cee,0x9cef,0x9cf0,0x9cf1,0x9cf2, /* 0xF848-0xF84F */
	0x9cf3,0x9cf4,0x9cf5,0x9cf6,0x9cf7,0x9cf8,0x9cf9,0x9cfa, /* 0xF850-0xF857 */
	0x9cfb,0x9cfc,0x9cfd,0x9cfe,0x9cff,0x9d00,0x9d01,0x9d02, /* 0xF858-0xF85F */
	0x9d03,0x9d04,0x9d05,0x9d06,0x9d07,0x9d08,0x9d09,0x9d0a, /* 0xF860-0xF867 */
	0x9d0b,0x9d0c,0x9d0d,0x9d0e,0x9d0f,0x9d10,0x9d11,0x9d12, /* 0xF868-0xF86F */
	0x9d13,0x9d14,0x9d15,0x9d16,0x9d17,0x9d18,0x9d19,0x9d1a, /* 0xF870-0xF877 */
	0x9d1b,0x9d1c,0x9d1d,0x9d1e,0x9d1f,0x9d20,0x9d21,0x0000, /* 0xF878-0xF87F */
	/* codebase=0xf880 rawbase=0x5700 */
	0x9d22,0x9d23,0x9d24,0x9d25,0x9d26,0x9d27,0x9d28,0x9d29, /* 0xF880-0xF887 */
	0x9d2a,0x9d2b,0x9d2c,0x9d2d,0x9d2e,0x9d2f,0x9d30,0x9d31, /* 0xF888-0xF88F */
	0x9d32,0x9d33,0x9d34,0x9d35,0x9d36,0x9d37,0x9d38,0x9d39, /* 0xF890-0xF897 */
	0x9d3a,0x9d3b,0x9d3c,0x9d3d,0x9d3e,0x9d3f,0x9d40,0x9d41, /* 0xF898-0xF89F */
	0x9d42,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF8A0-0xF8A7 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF8A8-0xF8AF */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF8B0-0xF8B7 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF8B8-0xF8BF */
	/* codebase=0xf940 rawbase=0x5740 */
	0x9d43,0x9d44,0x9d45,0x9d46,0x9d47,0x9d48,0x9d49,0x9d4a, /* 0xF940-0xF947 */
	0x9d4b,0x9d4c,0x9d4d,0x9d4e,0x9d4f,0x9d50,0x9d51,0x9d52, /* 0xF948-0xF94F */
	0x9d53,0x9d54,0x9d55,0x9d56,0x9d57,0x9d58,0x9d59,0x9d5a, /* 0xF950-0xF957 */
	0x9d5b,0x9d5c,0x9d5d,0x9d5e,0x9d5f,0x9d60,0x9d61,0x9d62, /* 0xF958-0xF95F */
	0x9d63,0x9d64,0x9d65,0x9d66,0x9d67,0x9d68,0x9d69,0x9d6a, /* 0xF960-0xF967 */
	0x9d6b,0x9d6c,0x9d6d,0x9d6e,0x9d6f,0x9d70,0x9d71,0x9d72, /* 0xF968-0xF96F */
	0x9d73,0x9d74,0x9d75,0x9d76,0x9d77,0x9d78,0x9d79,0x9d7a, /* 0xF970-0xF977 */
	0x9d7b,0x9d7c,0x9d7d,0x9d7e,0x9d7f,0x9d80,0x9d81,0x0000, /* 0xF978-0xF97F */
	/* codebase=0xf980 rawbase=0x5780 */
	0x9d82,0x9d83,0x9d84,0x9d85,0x9d86,0x9d87,0x9d88,0x9d89, /* 0xF980-0xF987 */
	0x9d8a,0x9d8b,0x9d8c,0x9d8d,0x9d8e,0x9d8f,0x9d90,0x9d91, /* 0xF988-0xF98F */
	0x9d92,0x9d93,0x9d94,0x9d95,0x9d96,0x9d97,0x9d98,0x9d99, /* 0xF990-0xF997 */
	0x9d9a,0x9d9b,0x9d9c,0x9d9d,0x9d9e,0x9d9f,0x9da0,0x9da1, /* 0xF998-0xF99F */
	0x9da2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF9A0-0xF9A7 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF9A8-0xF9AF */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF9B0-0xF9B7 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF9B8-0xF9BF */
	/* codebase=0xfa40 rawbase=0x57c0 */
	0x9da3,0x9da4,0x9da5,0x9da6,0x9da7,0x9da8,0x9da9,0x9daa, /* 0xFA40-0xFA47 */
	0x9dab,0x9dac,0x9dad,0x9dae,0x9daf,0x9db0,0x9db1,0x9db2, /* 0xFA48-0xFA4F */
	0x9db3,0x9db4,0x9db5,0x9db6,0x9db7,0x9db8,0x9db9,0x9dba, /* 0xFA50-0xFA57 */
	0x9dbb,0x9dbc,0x9dbd,0x9dbe,0x9dbf,0x9dc0,0x9dc1,0x9dc2, /* 0xFA58-0xFA5F */
	0x9dc3,0x9dc4,0x9dc5,0x9dc6,0x9dc7,0x9dc8,0x9dc9,0x9dca, /* 0xFA60-0xFA67 */
	0x9dcb,0x9dcc,0x9dcd,0x9dce,0x9dcf,0x9dd0,0x9dd1,0x9dd2, /* 0xFA68-0xFA6F */
	0x9dd3,0x9dd4,0x9dd5,0x9dd6,0x9dd7,0x9dd8,0x9dd9,0x9dda, /* 0xFA70-0xFA77 */
	0x9ddb,0x9ddc,0x9ddd,0x9dde,0x9ddf,0x9de0,0x9de1,0x0000, /* 0xFA78-0xFA7F */
	/* codebase=0xfa80 rawbase=0x5800 */
	0x9de2,0x9de3,0x9de4,0x9de5,0x9de6,0x9de7,0x9de8,0x9de9, /* 0xFA80-0xFA87 */
	0x9dea,0x9deb,0x9dec,0x9ded,0x9dee,0x9def,0x9df0,0x9df1, /* 0xFA88-0xFA8F */
	0x9df2,0x9df3,0x9df4,0x9df5,0x9df6,0x9df7,0x9df8,0x9df9, /* 0xFA90-0xFA97 */
	0x9dfa,0x9dfb,0x9dfc,0x9dfd,0x9dfe,0x9dff,0x9e00,0x9e01, /* 0xFA98-0xFA9F */
	0x9e02,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xFAA0-0xFAA7 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xFAA8-0xFAAF */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xFAB0-0xFAB7 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xFAB8-0xFABF */
	/* codebase=0xfb40 rawbase=0x5840 */
	0x9e03,0x9e04,0x9e05,0x9e06,0x9e07,0x9e08,0x9e09,0x9e0a, /* 0xFB40-0xFB47 */
	0x9e0b,0x9e0c,0x9e0d,0x9e0e,0x9e0f,0x9e10,0x9e11,0x9e12, /* 0xFB48-0xFB4F */
	0x9e13,0x9e14,0x9e15,0x9e16,0x9e17,0x9e18,0x9e19,0x9e1a, /* 0xFB50-0xFB57 */
	0x9e1b,0x9e1c,0x9e1d,0x9e1e,0x9e24,0x9e27,0x9e2e,0x9e30, /* 0xFB58-0xFB5F */
	0x9e34,0x9e3b,0x9e3c,0x9e40,0x9e4d,0x9e50,0x9e52,0x9e53, /* 0xFB60-0xFB67 */
	0x9e54,0x9e56,0x9e59,0x9e5d,0x9e5f,0x9e60,0x9e61,0x9e62, /* 0xFB68-0xFB6F */
	0x9e65,0x9e6e,0x9e6f,0x9e72,0x9e74,0x9e75,0x9e76,0x9e77, /* 0xFB70-0xFB77 */
	0x9e78,0x9e79,0x9e7a,0x9e7b,0x9e7c,0x9e7d,0x9e80,0x0000, /* 0xFB78-0xFB7F */
	/* codebase=0xfb80 rawbase=0x5880 */
	0x9e81,0x9e83,0x9e84,0x9e85,0x9e86,0x9e89,0x9e8a,0x9e8c, /* 0xFB80-0xFB87 */
	0x9e8d,0x9e8e,0x9e8f,0x9e90,0x9e91,0x9e94,0x9e95,0x9e96, /* 0xFB88-0xFB8F */
	0x9e97,0x9e98,0x9e99,0x9e9a,0x9e9b,0x9e9c,0x9e9e,0x9ea0, /* 0xFB90-0xFB97 */
	0x9ea1,0x9ea2,0x9ea3,0x9ea4,0x9ea5,0x9ea7,0x9ea8,0x9ea9, /* 0xFB98-0xFB9F */
	0x9eaa,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xFBA0-0xFBA7 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xFBA8-0xFBAF */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xFBB0-0xFBB7 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xFBB8-0xFBBF */
	/* codebase=0xfc40 rawbase=0x58c0 */
	0x9eab,0x9eac,0x9ead,0x9eae,0x9eaf,0x9eb0,0x9eb1,0x9eb2, /* 0xFC40-0xFC47 */
	0x9eb3,0x9eb5,0x9eb6,0x9eb7,0x9eb9,0x9eba,0x9ebc,0x9ebf, /* 0xFC48-0xFC4F */
	0x9ec0,0x9ec1,0x9ec2,0x9ec3,0x9ec5,0x9ec6,0x9ec7,0x9ec8, /* 0xFC50-0xFC57 */
	0x9eca,0x9ecb,0x9ecc,0x9ed0,0x9ed2,0x9ed3,0x9ed5,0x9ed6, /* 0xFC58-0xFC5F */
	0x9ed7,0x9ed9,0x9eda,0x9ede,0x9ee1,0x9ee3,0x9ee4,0x9ee6, /* 0xFC60-0xFC67 */
	0x9ee8,0x9eeb,0x9eec,0x9eed,0x9eee,0x9ef0,0x9ef1,0x9ef2, /* 0xFC68-0xFC6F */
	0x9ef3,0x9ef4,0x9ef5,0x9ef6,0x9ef7,0x9ef8,0x9efa,0x9efd, /* 0xFC70-0xFC77 */
	0x9eff,0x9f00,0x9f01,0x9f02,0x9f03,0x9f04,0x9f05,0x0000, /* 0xFC78-0xFC7F */
	/* codebase=0xfc80 rawbase=0x5900 */
	0x9f06,0x9f07,0x9f08,0x9f09,0x9f0a,0x9f0c,0x9f0f,0x9f11, /* 0xFC80-0xFC87 */
	0x9f12,0x9f14,0x9f15,0x9f16,0x9f18,0x9f1a,0x9f1b,0x9f1c, /* 0xFC88-0xFC8F */
	0x9f1d,0x9f1e,0x9f1f,0x9f21,0x9f23,0x9f24,0x9f25,0x9f26, /* 0xFC90-0xFC97 */
	0x9f27,0x9f28,0x9f29,0x9f2a,0x9f2b,0x9f2d,0x9f2e,0x9f30, /* 0xFC98-0xFC9F */
	0x9f31,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xFCA0-0xFCA7 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xFCA8-0xFCAF */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xFCB0-0xFCB7 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xFCB8-0xFCBF */
	/* codebase=0xfd40 rawbase=0x5940 */
	0x9f32,0x9f33,0x9f34,0x9f35,0x9f36,0x9f38,0x9f3a,0x9f3c, /* 0xFD40-0xFD47 */
	0x9f3f,0x9f40,0x9f41,0x9f42,0x9f43,0x9f45,0x9f46,0x9f47, /* 0xFD48-0xFD4F */
	0x9f48,0x9f49,0x9f4a,0x9f4b,0x9f4c,0x9f4d,0x9f4e,0x9f4f, /* 0xFD50-0xFD57 */
	0x9f52,0x9f53,0x9f54,0x9f55,0x9f56,0x9f57,0x9f58,0x9f59, /* 0xFD58-0xFD5F */
	0x9f5a,0x9f5b,0x9f5c,0x9f5d,0x9f5e,0x9f5f,0x9f60,0x9f61, /* 0xFD60-0xFD67 */
	0x9f62,0x9f63,0x9f64,0x9f65,0x9f66,0x9f67,0x9f68,0x9f69, /* 0xFD68-0xFD6F */
	0x9f6a,0x9f6b,0x9f6c,0x9f6d,0x9f6e,0x9f6f,0x9f70,0x9f71, /* 0xFD70-0xFD77 */
	0x9f72,0x9f73,0x9f74,0x9f75,0x9f76,0x9f77,0x9f78,0x0000, /* 0xFD78-0xFD7F */
	/* codebase=0xfd80 rawbase=0x5980 */
	0x9f79,0x9f7a,0x9f7b,0x9f7c,0x9f7d,0x9f7e,0x9f81,0x9f82, /* 0xFD80-0xFD87 */
	0x9f8d,0x9f8e,0x9f8f,0x9f90,0x9f91,0x9f92,0x9f93,0x9f94, /* 0xFD88-0xFD8F */
	0x9f95,0x9f96,0x9f97,0x9f98,0x9f9c,0x9f9d,0x9f9e,0x9fa1, /* 0xFD90-0xFD97 */
	0x9fa2,0x9fa3,0x9fa4,0x9fa5,0xf92c,0xf979,0xf995,0xf9e7, /* 0xFD98-0xFD9F */
	0xf9f1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xFDA0-0xFDA7 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xFDA8-0xFDAF */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xFDB0-0xFDB7 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xFDB8-0xFDBF */
	/* codebase=0xfe40 rawbase=0x59c0 */
	0xfa0c,0xfa0d,0xfa0e,0xfa0f,0xfa11,0xfa13,0xfa14,0xfa18, /* 0xFE40-0xFE47 */
	0xfa1f,0xfa20,0xfa21,0xfa23,0xfa24,0xfa27,0xfa28,0xfa29, /* 0xFE48-0xFE4F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xFE50-0xFE57 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xFE58-0xFE5F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xFE60-0xFE67 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xFE68-0xFE6F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xFE70-0xFE77 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xFE78-0xFE7F */
};
const uint16_t cp936_to_unicode_hitbl[1024] = {
	0x0000, /* 0x0000-0x003F */
	0x0040, /* 0x0040-0x007F */
	0x0080, /* 0x0080-0x00BF */
	0xffff, /* 0x00c0-0x00FF NOT PRESENT */
	0xffff, /* 0x0100-0x013F NOT PRESENT */
	0xffff, /* 0x0140-0x017F NOT PRESENT */
	0xffff, /* 0x0180-0x01BF NOT PRESENT */
	0xffff, /* 0x01c0-0x01FF NOT PRESENT */
	0xffff, /* 0x0200-0x023F NOT PRESENT */
	0xffff, /* 0x0240-0x027F NOT PRESENT */
	0xffff, /* 0x0280-0x02BF NOT PRESENT */
	0xffff, /* 0x02c0-0x02FF NOT PRESENT */
	0xffff, /* 0x0300-0x033F NOT PRESENT */
	0xffff, /* 0x0340-0x037F NOT PRESENT */
	0xffff, /* 0x0380-0x03BF NOT PRESENT */
	0xffff, /* 0x03c0-0x03FF NOT PRESENT */
	0xffff, /* 0x0400-0x043F NOT PRESENT */
	0xffff, /* 0x0440-0x047F NOT PRESENT */
	0xffff, /* 0x0480-0x04BF NOT PRESENT */
	0xffff, /* 0x04c0-0x04FF NOT PRESENT */
	0xffff, /* 0x0500-0x053F NOT PRESENT */
	0xffff, /* 0x0540-0x057F NOT PRESENT */
	0xffff, /* 0x0580-0x05BF NOT PRESENT */
	0xffff, /* 0x05c0-0x05FF NOT PRESENT */
	0xffff, /* 0x0600-0x063F NOT PRESENT */
	0xffff, /* 0x0640-0x067F NOT PRESENT */
	0xffff, /* 0x0680-0x06BF NOT PRESENT */
	0xffff, /* 0x06c0-0x06FF NOT PRESENT */
	0xffff, /* 0x0700-0x073F NOT PRESENT */
	0xffff, /* 0x0740-0x077F NOT PRESENT */
	0xffff, /* 0x0780-0x07BF NOT PRESENT */
	0xffff, /* 0x07c0-0x07FF NOT PRESENT */
	0xffff, /* 0x0800-0x083F NOT PRESENT */
	0xffff, /* 0x0840-0x087F NOT PRESENT */
	0xffff, /* 0x0880-0x08BF NOT PRESENT */
	0xffff, /* 0x08c0-0x08FF NOT PRESENT */
	0xffff, /* 0x0900-0x093F NOT PRESENT */
	0xffff, /* 0x0940-0x097F NOT PRESENT */
	0xffff, /* 0x0980-0x09BF NOT PRESENT */
	0xffff, /* 0x09c0-0x09FF NOT PRESENT */
	0xffff, /* 0x0a00-0x0A3F NOT PRESENT */
	0xffff, /* 0x0a40-0x0A7F NOT PRESENT */
	0xffff, /* 0x0a80-0x0ABF NOT PRESENT */
	0xffff, /* 0x0ac0-0x0AFF NOT PRESENT */
	0xffff, /* 0x0b00-0x0B3F NOT PRESENT */
	0xffff, /* 0x0b40-0x0B7F NOT PRESENT */
	0xffff, /* 0x0b80-0x0BBF NOT PRESENT */
	0xffff, /* 0x0bc0-0x0BFF NOT PRESENT */
	0xffff, /* 0x0c00-0x0C3F NOT PRESENT */
	0xffff, /* 0x0c40-0x0C7F NOT PRESENT */
	0xffff, /* 0x0c80-0x0CBF NOT PRESENT */
	0xffff, /* 0x0cc0-0x0CFF NOT PRESENT */
	0xffff, /* 0x0d00-0x0D3F NOT PRESENT */
	0xffff, /* 0x0d40-0x0D7F NOT PRESENT */
	0xffff, /* 0x0d80-0x0DBF NOT PRESENT */
	0xffff, /* 0x0dc0-0x0DFF NOT PRESENT */
	0xffff, /* 0x0e00-0x0E3F NOT PRESENT */
	0xffff, /* 0x0e40-0x0E7F NOT PRESENT */
	0xffff, /* 0x0e80-0x0EBF NOT PRESENT */
	0xffff, /* 0x0ec0-0x0EFF NOT PRESENT */
	0xffff, /* 0x0f00-0x0F3F NOT PRESENT */
	0xffff, /* 0x0f40-0x0F7F NOT PRESENT */
	0xffff, /* 0x0f80-0x0FBF NOT PRESENT */
	0xffff, /* 0x0fc0-0x0FFF NOT PRESENT */
	0xffff, /* 0x1000-0x103F NOT PRESENT */
	0xffff, /* 0x1040-0x107F NOT PRESENT */
	0xffff, /* 0x1080-0x10BF NOT PRESENT */
	0xffff, /* 0x10c0-0x10FF NOT PRESENT */
	0xffff, /* 0x1100-0x113F NOT PRESENT */
	0xffff, /* 0x1140-0x117F NOT PRESENT */
	0xffff, /* 0x1180-0x11BF NOT PRESENT */
	0xffff, /* 0x11c0-0x11FF NOT PRESENT */
	0xffff, /* 0x1200-0x123F NOT PRESENT */
	0xffff, /* 0x1240-0x127F NOT PRESENT */
	0xffff, /* 0x1280-0x12BF NOT PRESENT */
	0xffff, /* 0x12c0-0x12FF NOT PRESENT */
	0xffff, /* 0x1300-0x133F NOT PRESENT */
	0xffff, /* 0x1340-0x137F NOT PRESENT */
	0xffff, /* 0x1380-0x13BF NOT PRESENT */
	0xffff, /* 0x13c0-0x13FF NOT PRESENT */
	0xffff, /* 0x1400-0x143F NOT PRESENT */
	0xffff, /* 0x1440-0x147F NOT PRESENT */
	0xffff, /* 0x1480-0x14BF NOT PRESENT */
	0xffff, /* 0x14c0-0x14FF NOT PRESENT */
	0xffff, /* 0x1500-0x153F NOT PRESENT */
	0xffff, /* 0x1540-0x157F NOT PRESENT */
	0xffff, /* 0x1580-0x15BF NOT PRESENT */
	0xffff, /* 0x15c0-0x15FF NOT PRESENT */
	0xffff, /* 0x1600-0x163F NOT PRESENT */
	0xffff, /* 0x1640-0x167F NOT PRESENT */
	0xffff, /* 0x1680-0x16BF NOT PRESENT */
	0xffff, /* 0x16c0-0x16FF NOT PRESENT */
	0xffff, /* 0x1700-0x173F NOT PRESENT */
	0xffff, /* 0x1740-0x177F NOT PRESENT */
	0xffff, /* 0x1780-0x17BF NOT PRESENT */
	0xffff, /* 0x17c0-0x17FF NOT PRESENT */
	0xffff, /* 0x1800-0x183F NOT PRESENT */
	0xffff, /* 0x1840-0x187F NOT PRESENT */
	0xffff, /* 0x1880-0x18BF NOT PRESENT */
	0xffff, /* 0x18c0-0x18FF NOT PRESENT */
	0xffff, /* 0x1900-0x193F NOT PRESENT */
	0xffff, /* 0x1940-0x197F NOT PRESENT */
	0xffff, /* 0x1980-0x19BF NOT PRESENT */
	0xffff, /* 0x19c0-0x19FF NOT PRESENT */
	0xffff, /* 0x1a00-0x1A3F NOT PRESENT */
	0xffff, /* 0x1a40-0x1A7F NOT PRESENT */
	0xffff, /* 0x1a80-0x1ABF NOT PRESENT */
	0xffff, /* 0x1ac0-0x1AFF NOT PRESENT */
	0xffff, /* 0x1b00-0x1B3F NOT PRESENT */
	0xffff, /* 0x1b40-0x1B7F NOT PRESENT */
	0xffff, /* 0x1b80-0x1BBF NOT PRESENT */
	0xffff, /* 0x1bc0-0x1BFF NOT PRESENT */
	0xffff, /* 0x1c00-0x1C3F NOT PRESENT */
	0xffff, /* 0x1c40-0x1C7F NOT PRESENT */
	0xffff, /* 0x1c80-0x1CBF NOT PRESENT */
	0xffff, /* 0x1cc0-0x1CFF NOT PRESENT */
	0xffff, /* 0x1d00-0x1D3F NOT PRESENT */
	0xffff, /* 0x1d40-0x1D7F NOT PRESENT */
	0xffff, /* 0x1d80-0x1DBF NOT PRESENT */
	0xffff, /* 0x1dc0-0x1DFF NOT PRESENT */
	0xffff, /* 0x1e00-0x1E3F NOT PRESENT */
	0xffff, /* 0x1e40-0x1E7F NOT PRESENT */
	0xffff, /* 0x1e80-0x1EBF NOT PRESENT */
	0xffff, /* 0x1ec0-0x1EFF NOT PRESENT */
	0xffff, /* 0x1f00-0x1F3F NOT PRESENT */
	0xffff, /* 0x1f40-0x1F7F NOT PRESENT */
	0xffff, /* 0x1f80-0x1FBF NOT PRESENT */
	0xffff, /* 0x1fc0-0x1FFF NOT PRESENT */
	0xffff, /* 0x2000-0x203F NOT PRESENT */
	0xffff, /* 0x2040-0x207F NOT PRESENT */
	0xffff, /* 0x2080-0x20BF NOT PRESENT */
	0xffff, /* 0x20c0-0x20FF NOT PRESENT */
	0xffff, /* 0x2100-0x213F NOT PRESENT */
	0xffff, /* 0x2140-0x217F NOT PRESENT */
	0xffff, /* 0x2180-0x21BF NOT PRESENT */
	0xffff, /* 0x21c0-0x21FF NOT PRESENT */
	0xffff, /* 0x2200-0x223F NOT PRESENT */
	0xffff, /* 0x2240-0x227F NOT PRESENT */
	0xffff, /* 0x2280-0x22BF NOT PRESENT */
	0xffff, /* 0x22c0-0x22FF NOT PRESENT */
	0xffff, /* 0x2300-0x233F NOT PRESENT */
	0xffff, /* 0x2340-0x237F NOT PRESENT */
	0xffff, /* 0x2380-0x23BF NOT PRESENT */
	0xffff, /* 0x23c0-0x23FF NOT PRESENT */
	0xffff, /* 0x2400-0x243F NOT PRESENT */
	0xffff, /* 0x2440-0x247F NOT PRESENT */
	0xffff, /* 0x2480-0x24BF NOT PRESENT */
	0xffff, /* 0x24c0-0x24FF NOT PRESENT */
	0xffff, /* 0x2500-0x253F NOT PRESENT */
	0xffff, /* 0x2540-0x257F NOT PRESENT */
	0xffff, /* 0x2580-0x25BF NOT PRESENT */
	0xffff, /* 0x25c0-0x25FF NOT PRESENT */
	0xffff, /* 0x2600-0x263F NOT PRESENT */
	0xffff, /* 0x2640-0x267F NOT PRESENT */
	0xffff, /* 0x2680-0x26BF NOT PRESENT */
	0xffff, /* 0x26c0-0x26FF NOT PRESENT */
	0xffff, /* 0x2700-0x273F NOT PRESENT */
	0xffff, /* 0x2740-0x277F NOT PRESENT */
	0xffff, /* 0x2780-0x27BF NOT PRESENT */
	0xffff, /* 0x27c0-0x27FF NOT PRESENT */
	0xffff, /* 0x2800-0x283F NOT PRESENT */
	0xffff, /* 0x2840-0x287F NOT PRESENT */
	0xffff, /* 0x2880-0x28BF NOT PRESENT */
	0xffff, /* 0x28c0-0x28FF NOT PRESENT */
	0xffff, /* 0x2900-0x293F NOT PRESENT */
	0xffff, /* 0x2940-0x297F NOT PRESENT */
	0xffff, /* 0x2980-0x29BF NOT PRESENT */
	0xffff, /* 0x29c0-0x29FF NOT PRESENT */
	0xffff, /* 0x2a00-0x2A3F NOT PRESENT */
	0xffff, /* 0x2a40-0x2A7F NOT PRESENT */
	0xffff, /* 0x2a80-0x2ABF NOT PRESENT */
	0xffff, /* 0x2ac0-0x2AFF NOT PRESENT */
	0xffff, /* 0x2b00-0x2B3F NOT PRESENT */
	0xffff, /* 0x2b40-0x2B7F NOT PRESENT */
	0xffff, /* 0x2b80-0x2BBF NOT PRESENT */
	0xffff, /* 0x2bc0-0x2BFF NOT PRESENT */
	0xffff, /* 0x2c00-0x2C3F NOT PRESENT */
	0xffff, /* 0x2c40-0x2C7F NOT PRESENT */
	0xffff, /* 0x2c80-0x2CBF NOT PRESENT */
	0xffff, /* 0x2cc0-0x2CFF NOT PRESENT */
	0xffff, /* 0x2d00-0x2D3F NOT PRESENT */
	0xffff, /* 0x2d40-0x2D7F NOT PRESENT */
	0xffff, /* 0x2d80-0x2DBF NOT PRESENT */
	0xffff, /* 0x2dc0-0x2DFF NOT PRESENT */
	0xffff, /* 0x2e00-0x2E3F NOT PRESENT */
	0xffff, /* 0x2e40-0x2E7F NOT PRESENT */
	0xffff, /* 0x2e80-0x2EBF NOT PRESENT */
	0xffff, /* 0x2ec0-0x2EFF NOT PRESENT */
	0xffff, /* 0x2f00-0x2F3F NOT PRESENT */
	0xffff, /* 0x2f40-0x2F7F NOT PRESENT */
	0xffff, /* 0x2f80-0x2FBF NOT PRESENT */
	0xffff, /* 0x2fc0-0x2FFF NOT PRESENT */
	0xffff, /* 0x3000-0x303F NOT PRESENT */
	0xffff, /* 0x3040-0x307F NOT PRESENT */
	0xffff, /* 0x3080-0x30BF NOT PRESENT */
	0xffff, /* 0x30c0-0x30FF NOT PRESENT */
	0xffff, /* 0x3100-0x313F NOT PRESENT */
	0xffff, /* 0x3140-0x317F NOT PRESENT */
	0xffff, /* 0x3180-0x31BF NOT PRESENT */
	0xffff, /* 0x31c0-0x31FF NOT PRESENT */
	0xffff, /* 0x3200-0x323F NOT PRESENT */
	0xffff, /* 0x3240-0x327F NOT PRESENT */
	0xffff, /* 0x3280-0x32BF NOT PRESENT */
	0xffff, /* 0x32c0-0x32FF NOT PRESENT */
	0xffff, /* 0x3300-0x333F NOT PRESENT */
	0xffff, /* 0x3340-0x337F NOT PRESENT */
	0xffff, /* 0x3380-0x33BF NOT PRESENT */
	0xffff, /* 0x33c0-0x33FF NOT PRESENT */
	0xffff, /* 0x3400-0x343F NOT PRESENT */
	0xffff, /* 0x3440-0x347F NOT PRESENT */
	0xffff, /* 0x3480-0x34BF NOT PRESENT */
	0xffff, /* 0x34c0-0x34FF NOT PRESENT */
	0xffff, /* 0x3500-0x353F NOT PRESENT */
	0xffff, /* 0x3540-0x357F NOT PRESENT */
	0xffff, /* 0x3580-0x35BF NOT PRESENT */
	0xffff, /* 0x35c0-0x35FF NOT PRESENT */
	0xffff, /* 0x3600-0x363F NOT PRESENT */
	0xffff, /* 0x3640-0x367F NOT PRESENT */
	0xffff, /* 0x3680-0x36BF NOT PRESENT */
	0xffff, /* 0x36c0-0x36FF NOT PRESENT */
	0xffff, /* 0x3700-0x373F NOT PRESENT */
	0xffff, /* 0x3740-0x377F NOT PRESENT */
	0xffff, /* 0x3780-0x37BF NOT PRESENT */
	0xffff, /* 0x37c0-0x37FF NOT PRESENT */
	0xffff, /* 0x3800-0x383F NOT PRESENT */
	0xffff, /* 0x3840-0x387F NOT PRESENT */
	0xffff, /* 0x3880-0x38BF NOT PRESENT */
	0xffff, /* 0x38c0-0x38FF NOT PRESENT */
	0xffff, /* 0x3900-0x393F NOT PRESENT */
	0xffff, /* 0x3940-0x397F NOT PRESENT */
	0xffff, /* 0x3980-0x39BF NOT PRESENT */
	0xffff, /* 0x39c0-0x39FF NOT PRESENT */
	0xffff, /* 0x3a00-0x3A3F NOT PRESENT */
	0xffff, /* 0x3a40-0x3A7F NOT PRESENT */
	0xffff, /* 0x3a80-0x3ABF NOT PRESENT */
	0xffff, /* 0x3ac0-0x3AFF NOT PRESENT */
	0xffff, /* 0x3b00-0x3B3F NOT PRESENT */
	0xffff, /* 0x3b40-0x3B7F NOT PRESENT */
	0xffff, /* 0x3b80-0x3BBF NOT PRESENT */
	0xffff, /* 0x3bc0-0x3BFF NOT PRESENT */
	0xffff, /* 0x3c00-0x3C3F NOT PRESENT */
	0xffff, /* 0x3c40-0x3C7F NOT PRESENT */
	0xffff, /* 0x3c80-0x3CBF NOT PRESENT */
	0xffff, /* 0x3cc0-0x3CFF NOT PRESENT */
	0xffff, /* 0x3d00-0x3D3F NOT PRESENT */
	0xffff, /* 0x3d40-0x3D7F NOT PRESENT */
	0xffff, /* 0x3d80-0x3DBF NOT PRESENT */
	0xffff, /* 0x3dc0-0x3DFF NOT PRESENT */
	0xffff, /* 0x3e00-0x3E3F NOT PRESENT */
	0xffff, /* 0x3e40-0x3E7F NOT PRESENT */
	0xffff, /* 0x3e80-0x3EBF NOT PRESENT */
	0xffff, /* 0x3ec0-0x3EFF NOT PRESENT */
	0xffff, /* 0x3f00-0x3F3F NOT PRESENT */
	0xffff, /* 0x3f40-0x3F7F NOT PRESENT */
	0xffff, /* 0x3f80-0x3FBF NOT PRESENT */
	0xffff, /* 0x3fc0-0x3FFF NOT PRESENT */
	0xffff, /* 0x4000-0x403F NOT PRESENT */
	0xffff, /* 0x4040-0x407F NOT PRESENT */
	0xffff, /* 0x4080-0x40BF NOT PRESENT */
	0xffff, /* 0x40c0-0x40FF NOT PRESENT */
	0xffff, /* 0x4100-0x413F NOT PRESENT */
	0xffff, /* 0x4140-0x417F NOT PRESENT */
	0xffff, /* 0x4180-0x41BF NOT PRESENT */
	0xffff, /* 0x41c0-0x41FF NOT PRESENT */
	0xffff, /* 0x4200-0x423F NOT PRESENT */
	0xffff, /* 0x4240-0x427F NOT PRESENT */
	0xffff, /* 0x4280-0x42BF NOT PRESENT */
	0xffff, /* 0x42c0-0x42FF NOT PRESENT */
	0xffff, /* 0x4300-0x433F NOT PRESENT */
	0xffff, /* 0x4340-0x437F NOT PRESENT */
	0xffff, /* 0x4380-0x43BF NOT PRESENT */
	0xffff, /* 0x43c0-0x43FF NOT PRESENT */
	0xffff, /* 0x4400-0x443F NOT PRESENT */
	0xffff, /* 0x4440-0x447F NOT PRESENT */
	0xffff, /* 0x4480-0x44BF NOT PRESENT */
	0xffff, /* 0x44c0-0x44FF NOT PRESENT */
	0xffff, /* 0x4500-0x453F NOT PRESENT */
	0xffff, /* 0x4540-0x457F NOT PRESENT */
	0xffff, /* 0x4580-0x45BF NOT PRESENT */
	0xffff, /* 0x45c0-0x45FF NOT PRESENT */
	0xffff, /* 0x4600-0x463F NOT PRESENT */
	0xffff, /* 0x4640-0x467F NOT PRESENT */
	0xffff, /* 0x4680-0x46BF NOT PRESENT */
	0xffff, /* 0x46c0-0x46FF NOT PRESENT */
	0xffff, /* 0x4700-0x473F NOT PRESENT */
	0xffff, /* 0x4740-0x477F NOT PRESENT */
	0xffff, /* 0x4780-0x47BF NOT PRESENT */
	0xffff, /* 0x47c0-0x47FF NOT PRESENT */
	0xffff, /* 0x4800-0x483F NOT PRESENT */
	0xffff, /* 0x4840-0x487F NOT PRESENT */
	0xffff, /* 0x4880-0x48BF NOT PRESENT */
	0xffff, /* 0x48c0-0x48FF NOT PRESENT */
	0xffff, /* 0x4900-0x493F NOT PRESENT */
	0xffff, /* 0x4940-0x497F NOT PRESENT */
	0xffff, /* 0x4980-0x49BF NOT PRESENT */
	0xffff, /* 0x49c0-0x49FF NOT PRESENT */
	0xffff, /* 0x4a00-0x4A3F NOT PRESENT */
	0xffff, /* 0x4a40-0x4A7F NOT PRESENT */
	0xffff, /* 0x4a80-0x4ABF NOT PRESENT */
	0xffff, /* 0x4ac0-0x4AFF NOT PRESENT */
	0xffff, /* 0x4b00-0x4B3F NOT PRESENT */
	0xffff, /* 0x4b40-0x4B7F NOT PRESENT */
	0xffff, /* 0x4b80-0x4BBF NOT PRESENT */
	0xffff, /* 0x4bc0-0x4BFF NOT PRESENT */
	0xffff, /* 0x4c00-0x4C3F NOT PRESENT */
	0xffff, /* 0x4c40-0x4C7F NOT PRESENT */
	0xffff, /* 0x4c80-0x4CBF NOT PRESENT */
	0xffff, /* 0x4cc0-0x4CFF NOT PRESENT */
	0xffff, /* 0x4d00-0x4D3F NOT PRESENT */
	0xffff, /* 0x4d40-0x4D7F NOT PRESENT */
	0xffff, /* 0x4d80-0x4DBF NOT PRESENT */
	0xffff, /* 0x4dc0-0x4DFF NOT PRESENT */
	0xffff, /* 0x4e00-0x4E3F NOT PRESENT */
	0xffff, /* 0x4e40-0x4E7F NOT PRESENT */
	0xffff, /* 0x4e80-0x4EBF NOT PRESENT */
	0xffff, /* 0x4ec0-0x4EFF NOT PRESENT */
	0xffff, /* 0x4f00-0x4F3F NOT PRESENT */
	0xffff, /* 0x4f40-0x4F7F NOT PRESENT */
	0xffff, /* 0x4f80-0x4FBF NOT PRESENT */
	0xffff, /* 0x4fc0-0x4FFF NOT PRESENT */
	0xffff, /* 0x5000-0x503F NOT PRESENT */
	0xffff, /* 0x5040-0x507F NOT PRESENT */
	0xffff, /* 0x5080-0x50BF NOT PRESENT */
	0xffff, /* 0x50c0-0x50FF NOT PRESENT */
	0xffff, /* 0x5100-0x513F NOT PRESENT */
	0xffff, /* 0x5140-0x517F NOT PRESENT */
	0xffff, /* 0x5180-0x51BF NOT PRESENT */
	0xffff, /* 0x51c0-0x51FF NOT PRESENT */
	0xffff, /* 0x5200-0x523F NOT PRESENT */
	0xffff, /* 0x5240-0x527F NOT PRESENT */
	0xffff, /* 0x5280-0x52BF NOT PRESENT */
	0xffff, /* 0x52c0-0x52FF NOT PRESENT */
	0xffff, /* 0x5300-0x533F NOT PRESENT */
	0xffff, /* 0x5340-0x537F NOT PRESENT */
	0xffff, /* 0x5380-0x53BF NOT PRESENT */
	0xffff, /* 0x53c0-0x53FF NOT PRESENT */
	0xffff, /* 0x5400-0x543F NOT PRESENT */
	0xffff, /* 0x5440-0x547F NOT PRESENT */
	0xffff, /* 0x5480-0x54BF NOT PRESENT */
	0xffff, /* 0x54c0-0x54FF NOT PRESENT */
	0xffff, /* 0x5500-0x553F NOT PRESENT */
	0xffff, /* 0x5540-0x557F NOT PRESENT */
	0xffff, /* 0x5580-0x55BF NOT PRESENT */
	0xffff, /* 0x55c0-0x55FF NOT PRESENT */
	0xffff, /* 0x5600-0x563F NOT PRESENT */
	0xffff, /* 0x5640-0x567F NOT PRESENT */
	0xffff, /* 0x5680-0x56BF NOT PRESENT */
	0xffff, /* 0x56c0-0x56FF NOT PRESENT */
	0xffff, /* 0x5700-0x573F NOT PRESENT */
	0xffff, /* 0x5740-0x577F NOT PRESENT */
	0xffff, /* 0x5780-0x57BF NOT PRESENT */
	0xffff, /* 0x57c0-0x57FF NOT PRESENT */
	0xffff, /* 0x5800-0x583F NOT PRESENT */
	0xffff, /* 0x5840-0x587F NOT PRESENT */
	0xffff, /* 0x5880-0x58BF NOT PRESENT */
	0xffff, /* 0x58c0-0x58FF NOT PRESENT */
	0xffff, /* 0x5900-0x593F NOT PRESENT */
	0xffff, /* 0x5940-0x597F NOT PRESENT */
	0xffff, /* 0x5980-0x59BF NOT PRESENT */
	0xffff, /* 0x59c0-0x59FF NOT PRESENT */
	0xffff, /* 0x5a00-0x5A3F NOT PRESENT */
	0xffff, /* 0x5a40-0x5A7F NOT PRESENT */
	0xffff, /* 0x5a80-0x5ABF NOT PRESENT */
	0xffff, /* 0x5ac0-0x5AFF NOT PRESENT */
	0xffff, /* 0x5b00-0x5B3F NOT PRESENT */
	0xffff, /* 0x5b40-0x5B7F NOT PRESENT */
	0xffff, /* 0x5b80-0x5BBF NOT PRESENT */
	0xffff, /* 0x5bc0-0x5BFF NOT PRESENT */
	0xffff, /* 0x5c00-0x5C3F NOT PRESENT */
	0xffff, /* 0x5c40-0x5C7F NOT PRESENT */
	0xffff, /* 0x5c80-0x5CBF NOT PRESENT */
	0xffff, /* 0x5cc0-0x5CFF NOT PRESENT */
	0xffff, /* 0x5d00-0x5D3F NOT PRESENT */
	0xffff, /* 0x5d40-0x5D7F NOT PRESENT */
	0xffff, /* 0x5d80-0x5DBF NOT PRESENT */
	0xffff, /* 0x5dc0-0x5DFF NOT PRESENT */
	0xffff, /* 0x5e00-0x5E3F NOT PRESENT */
	0xffff, /* 0x5e40-0x5E7F NOT PRESENT */
	0xffff, /* 0x5e80-0x5EBF NOT PRESENT */
	0xffff, /* 0x5ec0-0x5EFF NOT PRESENT */
	0xffff, /* 0x5f00-0x5F3F NOT PRESENT */
	0xffff, /* 0x5f40-0x5F7F NOT PRESENT */
	0xffff, /* 0x5f80-0x5FBF NOT PRESENT */
	0xffff, /* 0x5fc0-0x5FFF NOT PRESENT */
	0xffff, /* 0x6000-0x603F NOT PRESENT */
	0xffff, /* 0x6040-0x607F NOT PRESENT */
	0xffff, /* 0x6080-0x60BF NOT PRESENT */
	0xffff, /* 0x60c0-0x60FF NOT PRESENT */
	0xffff, /* 0x6100-0x613F NOT PRESENT */
	0xffff, /* 0x6140-0x617F NOT PRESENT */
	0xffff, /* 0x6180-0x61BF NOT PRESENT */
	0xffff, /* 0x61c0-0x61FF NOT PRESENT */
	0xffff, /* 0x6200-0x623F NOT PRESENT */
	0xffff, /* 0x6240-0x627F NOT PRESENT */
	0xffff, /* 0x6280-0x62BF NOT PRESENT */
	0xffff, /* 0x62c0-0x62FF NOT PRESENT */
	0xffff, /* 0x6300-0x633F NOT PRESENT */
	0xffff, /* 0x6340-0x637F NOT PRESENT */
	0xffff, /* 0x6380-0x63BF NOT PRESENT */
	0xffff, /* 0x63c0-0x63FF NOT PRESENT */
	0xffff, /* 0x6400-0x643F NOT PRESENT */
	0xffff, /* 0x6440-0x647F NOT PRESENT */
	0xffff, /* 0x6480-0x64BF NOT PRESENT */
	0xffff, /* 0x64c0-0x64FF NOT PRESENT */
	0xffff, /* 0x6500-0x653F NOT PRESENT */
	0xffff, /* 0x6540-0x657F NOT PRESENT */
	0xffff, /* 0x6580-0x65BF NOT PRESENT */
	0xffff, /* 0x65c0-0x65FF NOT PRESENT */
	0xffff, /* 0x6600-0x663F NOT PRESENT */
	0xffff, /* 0x6640-0x667F NOT PRESENT */
	0xffff, /* 0x6680-0x66BF NOT PRESENT */
	0xffff, /* 0x66c0-0x66FF NOT PRESENT */
	0xffff, /* 0x6700-0x673F NOT PRESENT */
	0xffff, /* 0x6740-0x677F NOT PRESENT */
	0xffff, /* 0x6780-0x67BF NOT PRESENT */
	0xffff, /* 0x67c0-0x67FF NOT PRESENT */
	0xffff, /* 0x6800-0x683F NOT PRESENT */
	0xffff, /* 0x6840-0x687F NOT PRESENT */
	0xffff, /* 0x6880-0x68BF NOT PRESENT */
	0xffff, /* 0x68c0-0x68FF NOT PRESENT */
	0xffff, /* 0x6900-0x693F NOT PRESENT */
	0xffff, /* 0x6940-0x697F NOT PRESENT */
	0xffff, /* 0x6980-0x69BF NOT PRESENT */
	0xffff, /* 0x69c0-0x69FF NOT PRESENT */
	0xffff, /* 0x6a00-0x6A3F NOT PRESENT */
	0xffff, /* 0x6a40-0x6A7F NOT PRESENT */
	0xffff, /* 0x6a80-0x6ABF NOT PRESENT */
	0xffff, /* 0x6ac0-0x6AFF NOT PRESENT */
	0xffff, /* 0x6b00-0x6B3F NOT PRESENT */
	0xffff, /* 0x6b40-0x6B7F NOT PRESENT */
	0xffff, /* 0x6b80-0x6BBF NOT PRESENT */
	0xffff, /* 0x6bc0-0x6BFF NOT PRESENT */
	0xffff, /* 0x6c00-0x6C3F NOT PRESENT */
	0xffff, /* 0x6c40-0x6C7F NOT PRESENT */
	0xffff, /* 0x6c80-0x6CBF NOT PRESENT */
	0xffff, /* 0x6cc0-0x6CFF NOT PRESENT */
	0xffff, /* 0x6d00-0x6D3F NOT PRESENT */
	0xffff, /* 0x6d40-0x6D7F NOT PRESENT */
	0xffff, /* 0x6d80-0x6DBF NOT PRESENT */
	0xffff, /* 0x6dc0-0x6DFF NOT PRESENT */
	0xffff, /* 0x6e00-0x6E3F NOT PRESENT */
	0xffff, /* 0x6e40-0x6E7F NOT PRESENT */
	0xffff, /* 0x6e80-0x6EBF NOT PRESENT */
	0xffff, /* 0x6ec0-0x6EFF NOT PRESENT */
	0xffff, /* 0x6f00-0x6F3F NOT PRESENT */
	0xffff, /* 0x6f40-0x6F7F NOT PRESENT */
	0xffff, /* 0x6f80-0x6FBF NOT PRESENT */
	0xffff, /* 0x6fc0-0x6FFF NOT PRESENT */
	0xffff, /* 0x7000-0x703F NOT PRESENT */
	0xffff, /* 0x7040-0x707F NOT PRESENT */
	0xffff, /* 0x7080-0x70BF NOT PRESENT */
	0xffff, /* 0x70c0-0x70FF NOT PRESENT */
	0xffff, /* 0x7100-0x713F NOT PRESENT */
	0xffff, /* 0x7140-0x717F NOT PRESENT */
	0xffff, /* 0x7180-0x71BF NOT PRESENT */
	0xffff, /* 0x71c0-0x71FF NOT PRESENT */
	0xffff, /* 0x7200-0x723F NOT PRESENT */
	0xffff, /* 0x7240-0x727F NOT PRESENT */
	0xffff, /* 0x7280-0x72BF NOT PRESENT */
	0xffff, /* 0x72c0-0x72FF NOT PRESENT */
	0xffff, /* 0x7300-0x733F NOT PRESENT */
	0xffff, /* 0x7340-0x737F NOT PRESENT */
	0xffff, /* 0x7380-0x73BF NOT PRESENT */
	0xffff, /* 0x73c0-0x73FF NOT PRESENT */
	0xffff, /* 0x7400-0x743F NOT PRESENT */
	0xffff, /* 0x7440-0x747F NOT PRESENT */
	0xffff, /* 0x7480-0x74BF NOT PRESENT */
	0xffff, /* 0x74c0-0x74FF NOT PRESENT */
	0xffff, /* 0x7500-0x753F NOT PRESENT */
	0xffff, /* 0x7540-0x757F NOT PRESENT */
	0xffff, /* 0x7580-0x75BF NOT PRESENT */
	0xffff, /* 0x75c0-0x75FF NOT PRESENT */
	0xffff, /* 0x7600-0x763F NOT PRESENT */
	0xffff, /* 0x7640-0x767F NOT PRESENT */
	0xffff, /* 0x7680-0x76BF NOT PRESENT */
	0xffff, /* 0x76c0-0x76FF NOT PRESENT */
	0xffff, /* 0x7700-0x773F NOT PRESENT */
	0xffff, /* 0x7740-0x777F NOT PRESENT */
	0xffff, /* 0x7780-0x77BF NOT PRESENT */
	0xffff, /* 0x77c0-0x77FF NOT PRESENT */
	0xffff, /* 0x7800-0x783F NOT PRESENT */
	0xffff, /* 0x7840-0x787F NOT PRESENT */
	0xffff, /* 0x7880-0x78BF NOT PRESENT */
	0xffff, /* 0x78c0-0x78FF NOT PRESENT */
	0xffff, /* 0x7900-0x793F NOT PRESENT */
	0xffff, /* 0x7940-0x797F NOT PRESENT */
	0xffff, /* 0x7980-0x79BF NOT PRESENT */
	0xffff, /* 0x79c0-0x79FF NOT PRESENT */
	0xffff, /* 0x7a00-0x7A3F NOT PRESENT */
	0xffff, /* 0x7a40-0x7A7F NOT PRESENT */
	0xffff, /* 0x7a80-0x7ABF NOT PRESENT */
	0xffff, /* 0x7ac0-0x7AFF NOT PRESENT */
	0xffff, /* 0x7b00-0x7B3F NOT PRESENT */
	0xffff, /* 0x7b40-0x7B7F NOT PRESENT */
	0xffff, /* 0x7b80-0x7BBF NOT PRESENT */
	0xffff, /* 0x7bc0-0x7BFF NOT PRESENT */
	0xffff, /* 0x7c00-0x7C3F NOT PRESENT */
	0xffff, /* 0x7c40-0x7C7F NOT PRESENT */
	0xffff, /* 0x7c80-0x7CBF NOT PRESENT */
	0xffff, /* 0x7cc0-0x7CFF NOT PRESENT */
	0xffff, /* 0x7d00-0x7D3F NOT PRESENT */
	0xffff, /* 0x7d40-0x7D7F NOT PRESENT */
	0xffff, /* 0x7d80-0x7DBF NOT PRESENT */
	0xffff, /* 0x7dc0-0x7DFF NOT PRESENT */
	0xffff, /* 0x7e00-0x7E3F NOT PRESENT */
	0xffff, /* 0x7e40-0x7E7F NOT PRESENT */
	0xffff, /* 0x7e80-0x7EBF NOT PRESENT */
	0xffff, /* 0x7ec0-0x7EFF NOT PRESENT */
	0xffff, /* 0x7f00-0x7F3F NOT PRESENT */
	0xffff, /* 0x7f40-0x7F7F NOT PRESENT */
	0xffff, /* 0x7f80-0x7FBF NOT PRESENT */
	0xffff, /* 0x7fc0-0x7FFF NOT PRESENT */
	0xffff, /* 0x8000-0x803F NOT PRESENT */
	0xffff, /* 0x8040-0x807F NOT PRESENT */
	0xffff, /* 0x8080-0x80BF NOT PRESENT */
	0xffff, /* 0x80c0-0x80FF NOT PRESENT */
	0xffff, /* 0x8100-0x813F NOT PRESENT */
	0x00c0, /* 0x8140-0x817F */
	0x0100, /* 0x8180-0x81BF */
	0x0140, /* 0x81c0-0x81FF */
	0xffff, /* 0x8200-0x823F NOT PRESENT */
	0x0180, /* 0x8240-0x827F */
	0x01c0, /* 0x8280-0x82BF */
	0x0200, /* 0x82c0-0x82FF */
	0xffff, /* 0x8300-0x833F NOT PRESENT */
	0x0240, /* 0x8340-0x837F */
	0x0280, /* 0x8380-0x83BF */
	0x02c0, /* 0x83c0-0x83FF */
	0xffff, /* 0x8400-0x843F NOT PRESENT */
	0x0300, /* 0x8440-0x847F */
	0x0340, /* 0x8480-0x84BF */
	0x0380, /* 0x84c0-0x84FF */
	0xffff, /* 0x8500-0x853F NOT PRESENT */
	0x03c0, /* 0x8540-0x857F */
	0x0400, /* 0x8580-0x85BF */
	0x0440, /* 0x85c0-0x85FF */
	0xffff, /* 0x8600-0x863F NOT PRESENT */
	0x0480, /* 0x8640-0x867F */
	0x04c0, /* 0x8680-0x86BF */
	0x0500, /* 0x86c0-0x86FF */
	0xffff, /* 0x8700-0x873F NOT PRESENT */
	0x0540, /* 0x8740-0x877F */
	0x0580, /* 0x8780-0x87BF */
	0x05c0, /* 0x87c0-0x87FF */
	0xffff, /* 0x8800-0x883F NOT PRESENT */
	0x0600, /* 0x8840-0x887F */
	0x0640, /* 0x8880-0x88BF */
	0x0680, /* 0x88c0-0x88FF */
	0xffff, /* 0x8900-0x893F NOT PRESENT */
	0x06c0, /* 0x8940-0x897F */
	0x0700, /* 0x8980-0x89BF */
	0x0740, /* 0x89c0-0x89FF */
	0xffff, /* 0x8a00-0x8A3F NOT PRESENT */
	0x0780, /* 0x8a40-0x8A7F */
	0x07c0, /* 0x8a80-0x8ABF */
	0x0800, /* 0x8ac0-0x8AFF */
	0xffff, /* 0x8b00-0x8B3F NOT PRESENT */
	0x0840, /* 0x8b40-0x8B7F */
	0x0880, /* 0x8b80-0x8BBF */
	0x08c0, /* 0x8bc0-0x8BFF */
	0xffff, /* 0x8c00-0x8C3F NOT PRESENT */
	0x0900, /* 0x8c40-0x8C7F */
	0x0940, /* 0x8c80-0x8CBF */
	0x0980, /* 0x8cc0-0x8CFF */
	0xffff, /* 0x8d00-0x8D3F NOT PRESENT */
	0x09c0, /* 0x8d40-0x8D7F */
	0x0a00, /* 0x8d80-0x8DBF */
	0x0a40, /* 0x8dc0-0x8DFF */
	0xffff, /* 0x8e00-0x8E3F NOT PRESENT */
	0x0a80, /* 0x8e40-0x8E7F */
	0x0ac0, /* 0x8e80-0x8EBF */
	0x0b00, /* 0x8ec0-0x8EFF */
	0xffff, /* 0x8f00-0x8F3F NOT PRESENT */
	0x0b40, /* 0x8f40-0x8F7F */
	0x0b80, /* 0x8f80-0x8FBF */
	0x0bc0, /* 0x8fc0-0x8FFF */
	0xffff, /* 0x9000-0x903F NOT PRESENT */
	0x0c00, /* 0x9040-0x907F */
	0x0c40, /* 0x9080-0x90BF */
	0x0c80, /* 0x90c0-0x90FF */
	0xffff, /* 0x9100-0x913F NOT PRESENT */
	0x0cc0, /* 0x9140-0x917F */
	0x0d00, /* 0x9180-0x91BF */
	0x0d40, /* 0x91c0-0x91FF */
	0xffff, /* 0x9200-0x923F NOT PRESENT */
	0x0d80, /* 0x9240-0x927F */
	0x0dc0, /* 0x9280-0x92BF */
	0x0e00, /* 0x92c0-0x92FF */
	0xffff, /* 0x9300-0x933F NOT PRESENT */
	0x0e40, /* 0x9340-0x937F */
	0x0e80, /* 0x9380-0x93BF */
	0x0ec0, /* 0x93c0-0x93FF */
	0xffff, /* 0x9400-0x943F NOT PRESENT */
	0x0f00, /* 0x9440-0x947F */
	0x0f40, /* 0x9480-0x94BF */
	0x0f80, /* 0x94c0-0x94FF */
	0xffff, /* 0x9500-0x953F NOT PRESENT */
	0x0fc0, /* 0x9540-0x957F */
	0x1000, /* 0x9580-0x95BF */
	0x1040, /* 0x95c0-0x95FF */
	0xffff, /* 0x9600-0x963F NOT PRESENT */
	0x1080, /* 0x9640-0x967F */
	0x10c0, /* 0x9680-0x96BF */
	0x1100, /* 0x96c0-0x96FF */
	0xffff, /* 0x9700-0x973F NOT PRESENT */
	0x1140, /* 0x9740-0x977F */
	0x1180, /* 0x9780-0x97BF */
	0x11c0, /* 0x97c0-0x97FF */
	0xffff, /* 0x9800-0x983F NOT PRESENT */
	0x1200, /* 0x9840-0x987F */
	0x1240, /* 0x9880-0x98BF */
	0x1280, /* 0x98c0-0x98FF */
	0xffff, /* 0x9900-0x993F NOT PRESENT */
	0x12c0, /* 0x9940-0x997F */
	0x1300, /* 0x9980-0x99BF */
	0x1340, /* 0x99c0-0x99FF */
	0xffff, /* 0x9a00-0x9A3F NOT PRESENT */
	0x1380, /* 0x9a40-0x9A7F */
	0x13c0, /* 0x9a80-0x9ABF */
	0x1400, /* 0x9ac0-0x9AFF */
	0xffff, /* 0x9b00-0x9B3F NOT PRESENT */
	0x1440, /* 0x9b40-0x9B7F */
	0x1480, /* 0x9b80-0x9BBF */
	0x14c0, /* 0x9bc0-0x9BFF */
	0xffff, /* 0x9c00-0x9C3F NOT PRESENT */
	0x1500, /* 0x9c40-0x9C7F */
	0x1540, /* 0x9c80-0x9CBF */
	0x1580, /* 0x9cc0-0x9CFF */
	0xffff, /* 0x9d00-0x9D3F NOT PRESENT */
	0x15c0, /* 0x9d40-0x9D7F */
	0x1600, /* 0x9d80-0x9DBF */
	0x1640, /* 0x9dc0-0x9DFF */
	0xffff, /* 0x9e00-0x9E3F NOT PRESENT */
	0x1680, /* 0x9e40-0x9E7F */
	0x16c0, /* 0x9e80-0x9EBF */
	0x1700, /* 0x9ec0-0x9EFF */
	0xffff, /* 0x9f00-0x9F3F NOT PRESENT */
	0x1740, /* 0x9f40-0x9F7F */
	0x1780, /* 0x9f80-0x9FBF */
	0x17c0, /* 0x9fc0-0x9FFF */
	0xffff, /* 0xa000-0xA03F NOT PRESENT */
	0x1800, /* 0xa040-0xA07F */
	0x1840, /* 0xa080-0xA0BF */
	0x1880, /* 0xa0c0-0xA0FF */
	0xffff, /* 0xa100-0xA13F NOT PRESENT */
	0xffff, /* 0xa140-0xA17F NOT PRESENT */
	0x18c0, /* 0xa180-0xA1BF */
	0x1900, /* 0xa1c0-0xA1FF */
	0xffff, /* 0xa200-0xA23F NOT PRESENT */
	0xffff, /* 0xa240-0xA27F NOT PRESENT */
	0x1940, /* 0xa280-0xA2BF */
	0x1980, /* 0xa2c0-0xA2FF */
	0xffff, /* 0xa300-0xA33F NOT PRESENT */
	0xffff, /* 0xa340-0xA37F NOT PRESENT */
	0x19c0, /* 0xa380-0xA3BF */
	0x1a00, /* 0xa3c0-0xA3FF */
	0xffff, /* 0xa400-0xA43F NOT PRESENT */
	0xffff, /* 0xa440-0xA47F NOT PRESENT */
	0x1a40, /* 0xa480-0xA4BF */
	0x1a80, /* 0xa4c0-0xA4FF */
	0xffff, /* 0xa500-0xA53F NOT PRESENT */
	0xffff, /* 0xa540-0xA57F NOT PRESENT */
	0x1ac0, /* 0xa580-0xA5BF */
	0x1b00, /* 0xa5c0-0xA5FF */
	0xffff, /* 0xa600-0xA63F NOT PRESENT */
	0xffff, /* 0xa640-0xA67F NOT PRESENT */
	0x1b40, /* 0xa680-0xA6BF */
	0x1b80, /* 0xa6c0-0xA6FF */
	0xffff, /* 0xa700-0xA73F NOT PRESENT */
	0xffff, /* 0xa740-0xA77F NOT PRESENT */
	0x1bc0, /* 0xa780-0xA7BF */
	0x1c00, /* 0xa7c0-0xA7FF */
	0xffff, /* 0xa800-0xA83F NOT PRESENT */
	0x1c40, /* 0xa840-0xA87F */
	0x1c80, /* 0xa880-0xA8BF */
	0x1cc0, /* 0xa8c0-0xA8FF */
	0xffff, /* 0xa900-0xA93F NOT PRESENT */
	0x1d00, /* 0xa940-0xA97F */
	0x1d40, /* 0xa980-0xA9BF */
	0x1d80, /* 0xa9c0-0xA9FF */
	0xffff, /* 0xaa00-0xAA3F NOT PRESENT */
	0x1dc0, /* 0xaa40-0xAA7F */
	0x1e00, /* 0xaa80-0xAABF */
	0xffff, /* 0xaac0-0xAAFF NOT PRESENT */
	0xffff, /* 0xab00-0xAB3F NOT PRESENT */
	0x1e40, /* 0xab40-0xAB7F */
	0x1e80, /* 0xab80-0xABBF */
	0xffff, /* 0xabc0-0xABFF NOT PRESENT */
	0xffff, /* 0xac00-0xAC3F NOT PRESENT */
	0x1ec0, /* 0xac40-0xAC7F */
	0x1f00, /* 0xac80-0xACBF */
	0xffff, /* 0xacc0-0xACFF NOT PRESENT */
	0xffff, /* 0xad00-0xAD3F NOT PRESENT */
	0x1f40, /* 0xad40-0xAD7F */
	0x1f80, /* 0xad80-0xADBF */
	0xffff, /* 0xadc0-0xADFF NOT PRESENT */
	0xffff, /* 0xae00-0xAE3F NOT PRESENT */
	0x1fc0, /* 0xae40-0xAE7F */
	0x2000, /* 0xae80-0xAEBF */
	0xffff, /* 0xaec0-0xAEFF NOT PRESENT */
	0xffff, /* 0xaf00-0xAF3F NOT PRESENT */
	0x2040, /* 0xaf40-0xAF7F */
	0x2080, /* 0xaf80-0xAFBF */
	0xffff, /* 0xafc0-0xAFFF NOT PRESENT */
	0xffff, /* 0xb000-0xB03F NOT PRESENT */
	0x20c0, /* 0xb040-0xB07F */
	0x2100, /* 0xb080-0xB0BF */
	0x2140, /* 0xb0c0-0xB0FF */
	0xffff, /* 0xb100-0xB13F NOT PRESENT */
	0x2180, /* 0xb140-0xB17F */
	0x21c0, /* 0xb180-0xB1BF */
	0x2200, /* 0xb1c0-0xB1FF */
	0xffff, /* 0xb200-0xB23F NOT PRESENT */
	0x2240, /* 0xb240-0xB27F */
	0x2280, /* 0xb280-0xB2BF */
	0x22c0, /* 0xb2c0-0xB2FF */
	0xffff, /* 0xb300-0xB33F NOT PRESENT */
	0x2300, /* 0xb340-0xB37F */
	0x2340, /* 0xb380-0xB3BF */
	0x2380, /* 0xb3c0-0xB3FF */
	0xffff, /* 0xb400-0xB43F NOT PRESENT */
	0x23c0, /* 0xb440-0xB47F */
	0x2400, /* 0xb480-0xB4BF */
	0x2440, /* 0xb4c0-0xB4FF */
	0xffff, /* 0xb500-0xB53F NOT PRESENT */
	0x2480, /* 0xb540-0xB57F */
	0x24c0, /* 0xb580-0xB5BF */
	0x2500, /* 0xb5c0-0xB5FF */
	0xffff, /* 0xb600-0xB63F NOT PRESENT */
	0x2540, /* 0xb640-0xB67F */
	0x2580, /* 0xb680-0xB6BF */
	0x25c0, /* 0xb6c0-0xB6FF */
	0xffff, /* 0xb700-0xB73F NOT PRESENT */
	0x2600, /* 0xb740-0xB77F */
	0x2640, /* 0xb780-0xB7BF */
	0x2680, /* 0xb7c0-0xB7FF */
	0xffff, /* 0xb800-0xB83F NOT PRESENT */
	0x26c0, /* 0xb840-0xB87F */
	0x2700, /* 0xb880-0xB8BF */
	0x2740, /* 0xb8c0-0xB8FF */
	0xffff, /* 0xb900-0xB93F NOT PRESENT */
	0x2780, /* 0xb940-0xB97F */
	0x27c0, /* 0xb980-0xB9BF */
	0x2800, /* 0xb9c0-0xB9FF */
	0xffff, /* 0xba00-0xBA3F NOT PRESENT */
	0x2840, /* 0xba40-0xBA7F */
	0x2880, /* 0xba80-0xBABF */
	0x28c0, /* 0xbac0-0xBAFF */
	0xffff, /* 0xbb00-0xBB3F NOT PRESENT */
	0x2900, /* 0xbb40-0xBB7F */
	0x2940, /* 0xbb80-0xBBBF */
	0x2980, /* 0xbbc0-0xBBFF */
	0xffff, /* 0xbc00-0xBC3F NOT PRESENT */
	0x29c0, /* 0xbc40-0xBC7F */
	0x2a00, /* 0xbc80-0xBCBF */
	0x2a40, /* 0xbcc0-0xBCFF */
	0xffff, /* 0xbd00-0xBD3F NOT PRESENT */
	0x2a80, /* 0xbd40-0xBD7F */
	0x2ac0, /* 0xbd80-0xBDBF */
	0x2b00, /* 0xbdc0-0xBDFF */
	0xffff, /* 0xbe00-0xBE3F NOT PRESENT */
	0x2b40, /* 0xbe40-0xBE7F */
	0x2b80, /* 0xbe80-0xBEBF */
	0x2bc0, /* 0xbec0-0xBEFF */
	0xffff, /* 0xbf00-0xBF3F NOT PRESENT */
	0x2c00, /* 0xbf40-0xBF7F */
	0x2c40, /* 0xbf80-0xBFBF */
	0x2c80, /* 0xbfc0-0xBFFF */
	0xffff, /* 0xc000-0xC03F NOT PRESENT */
	0x2cc0, /* 0xc040-0xC07F */
	0x2d00, /* 0xc080-0xC0BF */
	0x2d40, /* 0xc0c0-0xC0FF */
	0xffff, /* 0xc100-0xC13F NOT PRESENT */
	0x2d80, /* 0xc140-0xC17F */
	0x2dc0, /* 0xc180-0xC1BF */
	0x2e00, /* 0xc1c0-0xC1FF */
	0xffff, /* 0xc200-0xC23F NOT PRESENT */
	0x2e40, /* 0xc240-0xC27F */
	0x2e80, /* 0xc280-0xC2BF */
	0x2ec0, /* 0xc2c0-0xC2FF */
	0xffff, /* 0xc300-0xC33F NOT PRESENT */
	0x2f00, /* 0xc340-0xC37F */
	0x2f40, /* 0xc380-0xC3BF */
	0x2f80, /* 0xc3c0-0xC3FF */
	0xffff, /* 0xc400-0xC43F NOT PRESENT */
	0x2fc0, /* 0xc440-0xC47F */
	0x3000, /* 0xc480-0xC4BF */
	0x3040, /* 0xc4c0-0xC4FF */
	0xffff, /* 0xc500-0xC53F NOT PRESENT */
	0x3080, /* 0xc540-0xC57F */
	0x30c0, /* 0xc580-0xC5BF */
	0x3100, /* 0xc5c0-0xC5FF */
	0xffff, /* 0xc600-0xC63F NOT PRESENT */
	0x3140, /* 0xc640-0xC67F */
	0x3180, /* 0xc680-0xC6BF */
	0x31c0, /* 0xc6c0-0xC6FF */
	0xffff, /* 0xc700-0xC73F NOT PRESENT */
	0x3200, /* 0xc740-0xC77F */
	0x3240, /* 0xc780-0xC7BF */
	0x3280, /* 0xc7c0-0xC7FF */
	0xffff, /* 0xc800-0xC83F NOT PRESENT */
	0x32c0, /* 0xc840-0xC87F */
	0x3300, /* 0xc880-0xC8BF */
	0x3340, /* 0xc8c0-0xC8FF */
	0xffff, /* 0xc900-0xC93F NOT PRESENT */
	0x3380, /* 0xc940-0xC97F */
	0x33c0, /* 0xc980-0xC9BF */
	0x3400, /* 0xc9c0-0xC9FF */
	0xffff, /* 0xca00-0xCA3F NOT PRESENT */
	0x3440, /* 0xca40-0xCA7F */
	0x3480, /* 0xca80-0xCABF */
	0x34c0, /* 0xcac0-0xCAFF */
	0xffff, /* 0xcb00-0xCB3F NOT PRESENT */
	0x3500, /* 0xcb40-0xCB7F */
	0x3540, /* 0xcb80-0xCBBF */
	0x3580, /* 0xcbc0-0xCBFF */
	0xffff, /* 0xcc00-0xCC3F NOT PRESENT */
	0x35c0, /* 0xcc40-0xCC7F */
	0x3600, /* 0xcc80-0xCCBF */
	0x3640, /* 0xccc0-0xCCFF */
	0xffff, /* 0xcd00-0xCD3F NOT PRESENT */
	0x3680, /* 0xcd40-0xCD7F */
	0x36c0, /* 0xcd80-0xCDBF */
	0x3700, /* 0xcdc0-0xCDFF */
	0xffff, /* 0xce00-0xCE3F NOT PRESENT */
	0x3740, /* 0xce40-0xCE7F */
	0x3780, /* 0xce80-0xCEBF */
	0x37c0, /* 0xcec0-0xCEFF */
	0xffff, /* 0xcf00-0xCF3F NOT PRESENT */
	0x3800, /* 0xcf40-0xCF7F */
	0x3840, /* 0xcf80-0xCFBF */
	0x3880, /* 0xcfc0-0xCFFF */
	0xffff, /* 0xd000-0xD03F NOT PRESENT */
	0x38c0, /* 0xd040-0xD07F */
	0x3900, /* 0xd080-0xD0BF */
	0x3940, /* 0xd0c0-0xD0FF */
	0xffff, /* 0xd100-0xD13F NOT PRESENT */
	0x3980, /* 0xd140-0xD17F */
	0x39c0, /* 0xd180-0xD1BF */
	0x3a00, /* 0xd1c0-0xD1FF */
	0xffff, /* 0xd200-0xD23F NOT PRESENT */
	0x3a40, /* 0xd240-0xD27F */
	0x3a80, /* 0xd280-0xD2BF */
	0x3ac0, /* 0xd2c0-0xD2FF */
	0xffff, /* 0xd300-0xD33F NOT PRESENT */
	0x3b00, /* 0xd340-0xD37F */
	0x3b40, /* 0xd380-0xD3BF */
	0x3b80, /* 0xd3c0-0xD3FF */
	0xffff, /* 0xd400-0xD43F NOT PRESENT */
	0x3bc0, /* 0xd440-0xD47F */
	0x3c00, /* 0xd480-0xD4BF */
	0x3c40, /* 0xd4c0-0xD4FF */
	0xffff, /* 0xd500-0xD53F NOT PRESENT */
	0x3c80, /* 0xd540-0xD57F */
	0x3cc0, /* 0xd580-0xD5BF */
	0x3d00, /* 0xd5c0-0xD5FF */
	0xffff, /* 0xd600-0xD63F NOT PRESENT */
	0x3d40, /* 0xd640-0xD67F */
	0x3d80, /* 0xd680-0xD6BF */
	0x3dc0, /* 0xd6c0-0xD6FF */
	0xffff, /* 0xd700-0xD73F NOT PRESENT */
	0x3e00, /* 0xd740-0xD77F */
	0x3e40, /* 0xd780-0xD7BF */
	0x3e80, /* 0xd7c0-0xD7FF */
	0xffff, /* 0xd800-0xD83F NOT PRESENT */
	0x3ec0, /* 0xd840-0xD87F */
	0x3f00, /* 0xd880-0xD8BF */
	0x3f40, /* 0xd8c0-0xD8FF */
	0xffff, /* 0xd900-0xD93F NOT PRESENT */
	0x3f80, /* 0xd940-0xD97F */
	0x3fc0, /* 0xd980-0xD9BF */
	0x4000, /* 0xd9c0-0xD9FF */
	0xffff, /* 0xda00-0xDA3F NOT PRESENT */
	0x4040, /* 0xda40-0xDA7F */
	0x4080, /* 0xda80-0xDABF */
	0x40c0, /* 0xdac0-0xDAFF */
	0xffff, /* 0xdb00-0xDB3F NOT PRESENT */
	0x4100, /* 0xdb40-0xDB7F */
	0x4140, /* 0xdb80-0xDBBF */
	0x4180, /* 0xdbc0-0xDBFF */
	0xffff, /* 0xdc00-0xDC3F NOT PRESENT */
	0x41c0, /* 0xdc40-0xDC7F */
	0x4200, /* 0xdc80-0xDCBF */
	0x4240, /* 0xdcc0-0xDCFF */
	0xffff, /* 0xdd00-0xDD3F NOT PRESENT */
	0x4280, /* 0xdd40-0xDD7F */
	0x42c0, /* 0xdd80-0xDDBF */
	0x4300, /* 0xddc0-0xDDFF */
	0xffff, /* 0xde00-0xDE3F NOT PRESENT */
	0x4340, /* 0xde40-0xDE7F */
	0x4380, /* 0xde80-0xDEBF */
	0x43c0, /* 0xdec0-0xDEFF */
	0xffff, /* 0xdf00-0xDF3F NOT PRESENT */
	0x4400, /* 0xdf40-0xDF7F */
	0x4440, /* 0xdf80-0xDFBF */
	0x4480, /* 0xdfc0-0xDFFF */
	0xffff, /* 0xe000-0xE03F NOT PRESENT */
	0x44c0, /* 0xe040-0xE07F */
	0x4500, /* 0xe080-0xE0BF */
	0x4540, /* 0xe0c0-0xE0FF */
	0xffff, /* 0xe100-0xE13F NOT PRESENT */
	0x4580, /* 0xe140-0xE17F */
	0x45c0, /* 0xe180-0xE1BF */
	0x4600, /* 0xe1c0-0xE1FF */
	0xffff, /* 0xe200-0xE23F NOT PRESENT */
	0x4640, /* 0xe240-0xE27F */
	0x4680, /* 0xe280-0xE2BF */
	0x46c0, /* 0xe2c0-0xE2FF */
	0xffff, /* 0xe300-0xE33F NOT PRESENT */
	0x4700, /* 0xe340-0xE37F */
	0x4740, /* 0xe380-0xE3BF */
	0x4780, /* 0xe3c0-0xE3FF */
	0xffff, /* 0xe400-0xE43F NOT PRESENT */
	0x47c0, /* 0xe440-0xE47F */
	0x4800, /* 0xe480-0xE4BF */
	0x4840, /* 0xe4c0-0xE4FF */
	0xffff, /* 0xe500-0xE53F NOT PRESENT */
	0x4880, /* 0xe540-0xE57F */
	0x48c0, /* 0xe580-0xE5BF */
	0x4900, /* 0xe5c0-0xE5FF */
	0xffff, /* 0xe600-0xE63F NOT PRESENT */
	0x4940, /* 0xe640-0xE67F */
	0x4980, /* 0xe680-0xE6BF */
	0x49c0, /* 0xe6c0-0xE6FF */
	0xffff, /* 0xe700-0xE73F NOT PRESENT */
	0x4a00, /* 0xe740-0xE77F */
	0x4a40, /* 0xe780-0xE7BF */
	0x4a80, /* 0xe7c0-0xE7FF */
	0xffff, /* 0xe800-0xE83F NOT PRESENT */
	0x4ac0, /* 0xe840-0xE87F */
	0x4b00, /* 0xe880-0xE8BF */
	0x4b40, /* 0xe8c0-0xE8FF */
	0xffff, /* 0xe900-0xE93F NOT PRESENT */
	0x4b80, /* 0xe940-0xE97F */
	0x4bc0, /* 0xe980-0xE9BF */
	0x4c00, /* 0xe9c0-0xE9FF */
	0xffff, /* 0xea00-0xEA3F NOT PRESENT */
	0x4c40, /* 0xea40-0xEA7F */
	0x4c80, /* 0xea80-0xEABF */
	0x4cc0, /* 0xeac0-0xEAFF */
	0xffff, /* 0xeb00-0xEB3F NOT PRESENT */
	0x4d00, /* 0xeb40-0xEB7F */
	0x4d40, /* 0xeb80-0xEBBF */
	0x4d80, /* 0xebc0-0xEBFF */
	0xffff, /* 0xec00-0xEC3F NOT PRESENT */
	0x4dc0, /* 0xec40-0xEC7F */
	0x4e00, /* 0xec80-0xECBF */
	0x4e40, /* 0xecc0-0xECFF */
	0xffff, /* 0xed00-0xED3F NOT PRESENT */
	0x4e80, /* 0xed40-0xED7F */
	0x4ec0, /* 0xed80-0xEDBF */
	0x4f00, /* 0xedc0-0xEDFF */
	0xffff, /* 0xee00-0xEE3F NOT PRESENT */
	0x4f40, /* 0xee40-0xEE7F */
	0x4f80, /* 0xee80-0xEEBF */
	0x4fc0, /* 0xeec0-0xEEFF */
	0xffff, /* 0xef00-0xEF3F NOT PRESENT */
	0x5000, /* 0xef40-0xEF7F */
	0x5040, /* 0xef80-0xEFBF */
	0x5080, /* 0xefc0-0xEFFF */
	0xffff, /* 0xf000-0xF03F NOT PRESENT */
	0x50c0, /* 0xf040-0xF07F */
	0x5100, /* 0xf080-0xF0BF */
	0x5140, /* 0xf0c0-0xF0FF */
	0xffff, /* 0xf100-0xF13F NOT PRESENT */
	0x5180, /* 0xf140-0xF17F */
	0x51c0, /* 0xf180-0xF1BF */
	0x5200, /* 0xf1c0-0xF1FF */
	0xffff, /* 0xf200-0xF23F NOT PRESENT */
	0x5240, /* 0xf240-0xF27F */
	0x5280, /* 0xf280-0xF2BF */
	0x52c0, /* 0xf2c0-0xF2FF */
	0xffff, /* 0xf300-0xF33F NOT PRESENT */
	0x5300, /* 0xf340-0xF37F */
	0x5340, /* 0xf380-0xF3BF */
	0x5380, /* 0xf3c0-0xF3FF */
	0xffff, /* 0xf400-0xF43F NOT PRESENT */
	0x53c0, /* 0xf440-0xF47F */
	0x5400, /* 0xf480-0xF4BF */
	0x5440, /* 0xf4c0-0xF4FF */
	0xffff, /* 0xf500-0xF53F NOT PRESENT */
	0x5480, /* 0xf540-0xF57F */
	0x54c0, /* 0xf580-0xF5BF */
	0x5500, /* 0xf5c0-0xF5FF */
	0xffff, /* 0xf600-0xF63F NOT PRESENT */
	0x5540, /* 0xf640-0xF67F */
	0x5580, /* 0xf680-0xF6BF */
	0x55c0, /* 0xf6c0-0xF6FF */
	0xffff, /* 0xf700-0xF73F NOT PRESENT */
	0x5600, /* 0xf740-0xF77F */
	0x5640, /* 0xf780-0xF7BF */
	0x5680, /* 0xf7c0-0xF7FF */
	0xffff, /* 0xf800-0xF83F NOT PRESENT */
	0x56c0, /* 0xf840-0xF87F */
	0x5700, /* 0xf880-0xF8BF */
	0xffff, /* 0xf8c0-0xF8FF NOT PRESENT */
	0xffff, /* 0xf900-0xF93F NOT PRESENT */
	0x5740, /* 0xf940-0xF97F */
	0x5780, /* 0xf980-0xF9BF */
	0xffff, /* 0xf9c0-0xF9FF NOT PRESENT */
	0xffff, /* 0xfa00-0xFA3F NOT PRESENT */
	0x57c0, /* 0xfa40-0xFA7F */
	0x5800, /* 0xfa80-0xFABF */
	0xffff, /* 0xfac0-0xFAFF NOT PRESENT */
	0xffff, /* 0xfb00-0xFB3F NOT PRESENT */
	0x5840, /* 0xfb40-0xFB7F */
	0x5880, /* 0xfb80-0xFBBF */
	0xffff, /* 0xfbc0-0xFBFF NOT PRESENT */
	0xffff, /* 0xfc00-0xFC3F NOT PRESENT */
	0x58c0, /* 0xfc40-0xFC7F */
	0x5900, /* 0xfc80-0xFCBF */
	0xffff, /* 0xfcc0-0xFCFF NOT PRESENT */
	0xffff, /* 0xfd00-0xFD3F NOT PRESENT */
	0x5940, /* 0xfd40-0xFD7F */
	0x5980, /* 0xfd80-0xFDBF */
	0xffff, /* 0xfdc0-0xFDFF NOT PRESENT */
	0xffff, /* 0xfe00-0xFE3F NOT PRESENT */
	0x59c0, /* 0xfe40-0xFE7F */
	0xffff, /* 0xfe80-0xFEBF NOT PRESENT */
	0xffff, /* 0xfec0-0xFEFF NOT PRESENT */
	0xffff, /* 0xff00-0xFF3F NOT PRESENT */
	0xffff, /* 0xff40-0xFF7F NOT PRESENT */
	0xffff, /* 0xff80-0xFFBF NOT PRESENT */
	0xffff  /* 0xffc0-0xFFFF NOT PRESENT */
};
