/* This file is part of the db4o object database http://www.db4o.com

Copyright (C) 2004 - 2010  Versant Corporation http://www.versant.com

db4o is free software; you can redistribute it and/or modify it under
the terms of version 3 of the GNU General Public License as published
by the Free Software Foundation.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program.  If not, see http://www.gnu.org/licenses/. */
using Db4oUnit;
using Db4oUnit.Extensions;
using Db4objects.Db4o.Tests.Common.Assorted;

namespace Db4objects.Db4o.Tests.Common.Assorted
{
	public class SimplestPossibleNullMemberTestCase : AbstractDb4oTestCase
	{
		public class Item
		{
			public SimplestPossibleNullMemberTestCase.Item _item;
		}

		/// <exception cref="System.Exception"></exception>
		protected override void Store()
		{
			Store(new SimplestPossibleNullMemberTestCase.Item());
		}

		public virtual void Test()
		{
			SimplestPossibleNullMemberTestCase.Item item = (SimplestPossibleNullMemberTestCase.Item
				)((SimplestPossibleNullMemberTestCase.Item)RetrieveOnlyInstance(typeof(SimplestPossibleNullMemberTestCase.Item
				)));
			Assert.IsNull(item._item);
		}
	}
}
