<!--
### How to use
Leave the headings unless they don't apply to your PR, replace commented out text (surrounded with <!–– and ––>) with text describing your PR.
NOTE: Please grant permission for repository maintainers to edit your PR.
It is EXTREMELY common for PRs to be held up due to trivial changes being requested and the author being unavailable to make them.
-->

#### Summary
<!--
A one-line description of your change that will be extracted and added to the [project changelog](https://github.com/CleverRaven/Cataclysm-DDA/blob/master/data/changelog.txt).

The format is (ignore the square brackets): ```SUMMARY: [Category] "[description]"```

The categories to choose from are:

* Features
* Content
* Interface
* Mods
* Balance
* Bugfixes
* Performance
* Infrastructure
* Build
* I18N

Example: ```SUMMARY: Content "Adds new mutation category 'Mouse'"```

See the [Changelog Guidelines](https://github.com/CleverRaven/Cataclysm-DDA/blob/master/doc/CHANGELOG_GUIDELINES.md) for explanations of the categories.
-->

#### Purpose of change
<!--
If there's an existing issue describing the problem this PR addresses or the feature it adds, please link it like: ```#1234```
If it *fully* resolves an issue, link it like: Fixes #1234
Even if the issue describes the problem, please provide a few-sentence summary here.
Example: Fixes #1234 - XL mutants cannot wear arm/leg splints due to missing OVERSIZE flag.
If there is no related issue, please describe the issue you are addressing, including how to trigger a bug if this is a bugfix.
Don't put the backticks around the `#` and issue or pull request number to allow the GitHub automatically reference to it.
-->

#### Describe the solution
<!--
How does the feature work, or how does this fix a bug?
The easier you make your solution to understand, the faster it can get merged.
-->

#### Describe alternatives you've considered
<!--
A clear and concise description of any alternative solutions or features you've considered.
-->

#### Testing
<!--
Describe what steps you took to test that this PR resolved the bug or added the feature, and what tests you performed to make sure it didn't cause any regressions.
Also include testing suggestions for reviewers and maintainers.
-->

#### Additional context
<!--
Add any other context (such as mock-ups, proof of concepts or screenshots) about the feature or bugfix here.
-->
