/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.binpack;

import com.kreative.binpack.BitInputStream;
import com.kreative.binpack.ColorFormat;
import com.kreative.binpack.DataField;
import com.kreative.binpack.DateFormat;
import com.kreative.binpack.MapStack;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataReader {
    private List<DataField> format;

    public DataReader(List<DataField> format) {
        this.format = format;
    }

    public List<Object> unpack(byte[] b) throws IOException {
        return this.unpack(new ByteArrayInputStream(b), (long)b.length);
    }

    public List<Object> unpack(File f) throws IOException {
        return this.unpack(new FileInputStream(f), f.length());
    }

    public List<Object> unpack(InputStream in, long length) throws IOException {
        return this.unpack(new BitInputStream(in), length);
    }

    public List<Object> unpack(BitInputStream in, long length) throws IOException {
        return DataReader.unpack(this.format, new MapStack<String, Object>(), (BitInputStream)in, (long)length, (boolean)false).listed;
    }

    public Map<String, Object> unpackNamed(byte[] b) throws IOException {
        return this.unpackNamed(new ByteArrayInputStream(b), (long)b.length);
    }

    public Map<String, Object> unpackNamed(File f) throws IOException {
        return this.unpackNamed(new FileInputStream(f), f.length());
    }

    public Map<String, Object> unpackNamed(InputStream in, long length) throws IOException {
        return this.unpackNamed(new BitInputStream(in), length);
    }

    public Map<String, Object> unpackNamed(BitInputStream in, long length) throws IOException {
        return DataReader.unpack(this.format, new MapStack<String, Object>(), (BitInputStream)in, (long)length, (boolean)true).named;
    }

    private static UnpackResult unpack(List<DataField> format, MapStack<String, Object> map, BitInputStream in, long length, boolean named) throws IOException {
        UnpackResult res = new UnpackResult();
        map.push(res.named);
        for (DataField df : format) {
            if (df.type().returns()) {
                Object o = DataReader.unpackFieldWithCount(df, map, in, length, named);
                res.listed.add(o);
                if (df.name() == null) continue;
                res.named.put(df.name(), o);
                continue;
            }
            DataReader.unpackFieldWithCount(df, map, in, length, named);
        }
        map.pop();
        return res;
    }

    /*
     * Unable to fully structure code
     */
    private static Object unpackFieldWithCount(DataField df, MapStack<String, Object> map, BitInputStream in, long length, boolean named) throws IOException {
        if (df.count() == null || df.type().usesCustomCount()) {
            return DataReader.unpackFieldWithoutCount(df, map, in, length, named);
        }
        count = df.count().evaluate(map, in, length);
        if (!df.type().returns()) ** GOTO lbl13
        res = new ArrayList<Object>(count < 10 ? 10 : count);
        while (count-- > 0) {
            res.add(DataReader.unpackFieldWithoutCount(df, map, in, length, named));
        }
        return res;
lbl-1000:
        // 1 sources

        {
            DataReader.unpackFieldWithoutCount(df, map, in, length, named);
lbl13:
            // 2 sources

            ** while (count-- > 0)
        }
lbl14:
        // 1 sources

        return null;
    }

    private static Object unpackFieldWithoutCount(DataField df, MapStack<String, Object> map, BitInputStream in, long length, boolean named) throws IOException {
        switch (df.type()) {
            case BOOLEAN: {
                return !in.readBits(df.size()).isEmpty();
            }
            case ENUM: {
                BigInteger ev = df.littleEndian() ? in.readUnsignedIntegerLE(df.size()) : in.readUnsignedInteger(df.size());
                Map em = (Map)df.elaboration();
                if (em.containsKey(ev)) {
                    return em.get(ev);
                }
                return ev;
            }
            case BITFIELD: {
                BitSet bfv = df.littleEndian() ? in.readBitsLE(df.size()) : in.readBits(df.size());
                ArrayList bfl = new ArrayList();
                Map bfm = (Map)df.elaboration();
                int i = 0;
                while (i < df.size()) {
                    if (bfv.get(i)) {
                        BigInteger bi = BigInteger.valueOf(i);
                        if (bfm.containsKey(bi)) {
                            bfl.add(bfm.get(bi));
                        } else if (bfm.containsKey(i)) {
                            bfl.add(bfm.get(i));
                        }
                    }
                    ++i;
                }
                return bfl;
            }
            case BINT: {
                if (df.littleEndian()) {
                    return in.readUnsignedIntegerLE(df.size()).toString(2);
                }
                return in.readUnsignedInteger(df.size()).toString(2);
            }
            case OINT: {
                if (df.littleEndian()) {
                    return in.readUnsignedIntegerLE(df.size()).toString(8);
                }
                return in.readUnsignedInteger(df.size()).toString(8);
            }
            case HINT: {
                if (df.littleEndian()) {
                    return in.readUnsignedIntegerLE(df.size()).toString(16).toUpperCase();
                }
                return in.readUnsignedInteger(df.size()).toString(16).toUpperCase();
            }
            case UINT: {
                if (df.littleEndian()) {
                    return in.readUnsignedIntegerLE(df.size());
                }
                return in.readUnsignedInteger(df.size());
            }
            case SINT: {
                if (df.littleEndian()) {
                    return in.readIntegerLE(df.size());
                }
                return in.readInteger(df.size());
            }
            case UFIXED: {
                if (df.littleEndian()) {
                    return new BigDecimal(in.readUnsignedIntegerLE(df.size()), MathContext.DECIMAL128).divide(BigDecimal.valueOf(2L).pow(df.size() / 2), MathContext.DECIMAL128);
                }
                return new BigDecimal(in.readUnsignedInteger(df.size()), MathContext.DECIMAL128).divide(BigDecimal.valueOf(2L).pow(df.size() / 2), MathContext.DECIMAL128);
            }
            case SFIXED: {
                if (df.littleEndian()) {
                    return new BigDecimal(in.readIntegerLE(df.size()), MathContext.DECIMAL128).divide(BigDecimal.valueOf(2L).pow(df.size() / 2), MathContext.DECIMAL128);
                }
                return new BigDecimal(in.readInteger(df.size()), MathContext.DECIMAL128).divide(BigDecimal.valueOf(2L).pow(df.size() / 2), MathContext.DECIMAL128);
            }
            case FLOAT: {
                int[] fpfmt = (int[])df.elaboration();
                if (df.littleEndian()) {
                    return in.readFloatLE(fpfmt[0], fpfmt[1], fpfmt[2], fpfmt[3], MathContext.DECIMAL128);
                }
                return in.readFloat(fpfmt[0], fpfmt[1], fpfmt[2], fpfmt[3], MathContext.DECIMAL128);
            }
            case COMPLEX: {
                int[] fpfmt1 = (int[])df.elaboration();
                if (df.littleEndian()) {
                    Number r = in.readFloatLE(fpfmt1[0], fpfmt1[1], fpfmt1[2], fpfmt1[3], MathContext.DECIMAL128);
                    Number i = in.readFloatLE(fpfmt1[0], fpfmt1[1], fpfmt1[2], fpfmt1[3], MathContext.DECIMAL128);
                    return new Number[]{r, i};
                }
                Number r = in.readFloat(fpfmt1[0], fpfmt1[1], fpfmt1[2], fpfmt1[3], MathContext.DECIMAL128);
                Number i = in.readFloat(fpfmt1[0], fpfmt1[1], fpfmt1[2], fpfmt1[3], MathContext.DECIMAL128);
                return new Number[]{r, i};
            }
            case CHAR: {
                if ((df.size() & 7) != 0) {
                    throw new IOException("Character values must be of a byte-multiple width");
                }
                int chwidth = df.size() >> 3;
                byte[] chb = new byte[chwidth];
                in.readFully(chb);
                if (df.littleEndian()) {
                    int i = 0;
                    int j = chb.length - 1;
                    while (i < chb.length / 2) {
                        byte k = chb[i];
                        chb[i] = chb[j];
                        chb[j] = k;
                        ++i;
                        --j;
                    }
                }
                return new String(chb, df.elaboration().toString());
            }
            case PSTRING: {
                int pstrwidth = (df.littleEndian() ? in.readUnsignedIntegerLE(df.size()) : in.readUnsignedInteger(df.size())).intValue();
                byte[] pstrb = new byte[pstrwidth];
                in.readFully(pstrb);
                return new String(pstrb, df.elaboration().toString());
            }
            case CSTRING: {
                if ((df.size() & 7) != 0) {
                    throw new IOException("C-string values must be of a byte-multiple width");
                }
                int cstrwidth = df.size() >> 3;
                byte[] cstrb = new byte[cstrwidth];
                in.readFully(cstrb);
                ByteArrayOutputStream cstrout = new ByteArrayOutputStream();
                while (true) {
                    boolean end = true;
                    byte[] byArray = cstrb;
                    int n = cstrb.length;
                    int n2 = 0;
                    while (n2 < n) {
                        byte b = byArray[n2];
                        if (b != 0) {
                            end = false;
                        }
                        ++n2;
                    }
                    if (end) break;
                    cstrout.write(cstrb[0]);
                    int i = 1;
                    while (i < cstrb.length) {
                        cstrb[i - 1] = cstrb[i];
                        ++i;
                    }
                    cstrb[cstrb.length - 1] = in.readByte();
                }
                return new String(cstrout.toByteArray(), df.elaboration().toString());
            }
            case DATE: {
                DateFormat datefmt = (DateFormat)df.elaboration();
                if (df.littleEndian()) {
                    return datefmt.longToCalendar(in.readIntegerLE(df.size()).longValue());
                }
                return datefmt.longToCalendar(in.readInteger(df.size()).longValue());
            }
            case COLOR: {
                ColorFormat colorfmt = (ColorFormat)df.elaboration();
                BigInteger colorval = df.littleEndian() ? in.readUnsignedIntegerLE(df.size()) : in.readUnsignedInteger(df.size());
                Number[] colorvals = new Number[colorfmt.channelCount()];
                int colorshift = 0;
                int i = colorfmt.channelCount() - 1;
                while (i >= 0) {
                    colorvals[i] = colorval.shiftRight(colorshift).and(BigInteger.ONE.shiftLeft(colorfmt.channelWidth(i)).subtract(BigInteger.ONE));
                    colorshift += colorfmt.channelWidth(i);
                    --i;
                }
                return colorfmt.toRGBAFloatArray(colorfmt.toFloatArray(colorvals));
            }
            case FILLER: {
                in.skipBits(df.size());
                return null;
            }
            case MAGIC: {
                BigInteger magicBullet;
                BigInteger magicMask = BigInteger.ONE.shiftLeft(df.size()).subtract(BigInteger.ONE);
                BigInteger magicTarget = ((BigInteger)df.elaboration()).and(magicMask);
                BigInteger bigInteger = magicBullet = df.littleEndian() ? in.readUnsignedIntegerLE(df.size()) : in.readUnsignedInteger(df.size());
                if (magicBullet.compareTo(magicTarget) != 0) {
                    throw new IOException("Magic numbers do not match");
                }
                return null;
            }
            case ALIGN: {
                while (!in.atBitBoundary(df.size())) {
                    in.skipBit();
                }
                return null;
            }
            case BINARY: {
                if (df.count() != null) {
                    int len = df.count().evaluate(map, in, length);
                    byte[] b = new byte[len];
                    in.readFully(b);
                    return b;
                }
                return new byte[0];
            }
            case STRUCT: {
                List format = (List)df.elaboration();
                UnpackResult ur = DataReader.unpack(format, map, in, length, named);
                return named ? ur.named : ur.listed;
            }
            case OFFSET: {
                if (df.count() != null) {
                    int offset = df.count().evaluate(map, in, length);
                    in.reset();
                    in.skipBytes(offset);
                }
                return null;
            }
        }
        throw new RuntimeException("Unknown data type: " + df.type().toString());
    }

    private static class UnpackResult {
        public List<Object> listed = new ArrayList<Object>();
        public Map<String, Object> named = new HashMap<String, Object>();

        private UnpackResult() {
        }
    }
}

