/*
    YPS-0.2, NIS-Server for Linux
    Copyright (C) 1994  Tobias Reber

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
static char rcsid[]="@(#)$Id: ypcat.c,v 1.7 1994/01/02 23:23:24 root Exp $";
/*
 * 	$Author: root $
 *	$Log: ypcat.c,v $
 * Revision 1.7  1994/01/02  23:23:24  root
 * *** empty log message ***
 *
 * Revision 1.6  1994/01/02  23:03:27  root
 * Print status only in case of error
 *
 * Revision 1.5  1994/01/02  22:09:15  root
 * Added strict prototypes
 *
 * Revision 1.4  1994/01/02  20:08:15  root
 * Added GPL notice
 *
 * Revision 1.3  1993/06/12  10:47:24  root
 * Align with include-4.4
 *
 * Revision 1.2  1993/06/11  21:30:24  root
 * Initial revision
 *
*/

#include <rpcsvc/yp_prot.h>
#include <rpcsvc/ypclnt.h>

#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

#include <stdio.h>
#include <unistd.h>
#include "yp_xlate.h"
 
extern int optind;
extern char *optarg;

void
Usage(void)
{
	fprintf(stderr, "Usage: ypcat [-k] [-d domain] [-t] map\n");
	fprintf(stderr, "       ypcat [-x]\n");
	exit(1);
}

void
main( int argc, char **argv)
{
   char *DomainName=NULL;
   char *MapName;
   char *Key, *OutKey;
   int KeyLength, OutKeyLength;
   char *OutArea;
   int OutAreaLength;
   int status;

   int PrintKeys=FALSE;
   int TranslateMaps=TRUE;

   int c;
   int i;
 
   while((c=getopt(argc, argv, "xkd:t"))!=EOF) {
      switch(c) {
      case 'x':
         for(i=0; ypXlateFrom[i]; i++) 
	    fprintf(stderr, "Use \"%s\" for map \"%s\"\n", ypXlateFrom[i],
	       ypXlateTo[i]);
         exit(0);
      case 'k':
         PrintKeys=TRUE;
         break;
      case 'd':
         DomainName=optarg;
         break;
      case 't':
         TranslateMaps=FALSE;
         break;
      case '?':
         Usage();
      }
   }
   argc-=optind;
   argv+=optind;
   if (argc<1) Usage();

   MapName=argv[0];
   if (TranslateMaps)
      for(i=0; ypXlateFrom[i]; i++) {
         if (strcmp(MapName, ypXlateFrom[i])) continue;
         MapName=ypXlateTo[i];
      }

   if (!DomainName)
      yp_get_default_domain(&DomainName);
   status=yp_first(DomainName, MapName, &OutKey, &OutKeyLength,
      &OutArea, &OutAreaLength);
   while(!status) {
      if (PrintKeys) {
         fwrite(OutKey, OutKeyLength, 1, stdout);
         printf(" ");
      }
      printf("%s", OutArea);
      Key=OutKey;
      KeyLength=OutKeyLength;
      status=yp_next(DomainName, MapName, Key, KeyLength,
	 &OutKey, &OutKeyLength, &OutArea, &OutAreaLength);
   }
   if (status && status!=YPERR_NOMORE)
      printf("%d %s\n", status, yperr_string(status));
}
