/*
** nislib.h              NIS+ client access function definitions
**
** Copyright (c) 1993 Signum Support AB, Sweden
**
** This file is part of the NYS Library.
**
** The NYS Library is free software; you can redistribute it and/or
** modify it under the terms of the GNU Library General Public License as
** published by the Free Software Foundation; either version 2 of the
** License, or (at your option) any later version.
**
** The NYS Library is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** Library General Public License for more details.
** 
** You should have received a copy of the GNU Library General Public
** License along with the NYS Library; see the file COPYING.LIB.  If
** not, write to the Free Software Foundation, Inc., 675 Mass Ave,
** Cambridge, MA 02139, USA.
**
** Author: Peter Eriksson <pen@signum.se>
*/

#ifndef __NISLIB_NISLIB_H__
#define __NISLIB_NISLIB_H__

/*
** Standard NIS+ client access functions
*/
extern nis_result *nis_lookup(nis_name name, u_long flags);
extern nis_result *nis_first_entry(nis_name name);
extern nis_result *nis_next_entry(nis_name name, netobj *key);
extern void nis_freeresult(nis_result *res);


/*
** NYS-specific NIS+ client functions, you should
** probably not use these in your programs if you care
** at all for portability
*/
extern int nis_get_default_domain(char **outdomain);
extern nis_name nis_mkfullname(nis_name name, char **outdomain);

#endif

