/*
** nsw_rpc.h       RPC services cover routines for the Name Service Switch
**
** Copyright (c) 1993 Signum Support AB, Sweden
**
** This file is part of the NYS Library.
**
** The NYS Library is free software; you can redistribute it and/or
** modify it under the terms of the GNU Library General Public License as
** published by the Free Software Foundation; either version 2 of the
** License, or (at your option) any later version.
**
** The NYS Library is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** Library General Public License for more details.
** 
** You should have received a copy of the GNU Library General Public
** License along with the NYS Library; see the file COPYING.LIB.  If
** not, write to the Free Software Foundation, Inc., 675 Mass Ave,
** Cambridge, MA 02139, USA.
**
** Author: Peter Eriksson <pen@signum.se>
*/

#ifndef __NSSWITCH_RPC_H__
#define __NSSWITCH_RPC_H__

#include <sys/types.h>
#include <netdb.h>

#ifdef ENABLE_NIS
#include "../../nis/src/nis_rpc.h"
#endif

#ifdef ENABLE_YP
#include "../../yp/src/yp_rpc.h"
#endif

#ifdef ENABLE_DNS
#include "../../dns/src/dns_rpc.h"
#endif

void _ENSWF(_setrpcent)(int stayopen);
void _ENSWF(_endrpcent)(void);
struct rpcent * _ENSWF(_getrpcent)(void);
struct rpcent * _ENSWF(_getrpcbyname)(char *name);
struct rpcent * _ENSWF(_getrpcbynumber)(int number);

#endif
