
/*
** grp.h           Group "map" handling functions and structures
**
** Copyright (c) 1993 Signum Support AB, Sweden
**
** This file is part of the NYS Library.
**
** The NYS Library is free software; you can redistribute it and/or
** modify it under the terms of the GNU Library General Public License as
** published by the Free Software Foundation; either version 2 of the
** License, or (at your option) any later version.
**
** The NYS Library is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** Library General Public License for more details.
** 
** You should have received a copy of the GNU Library General Public
** License along with the NYS Library; see the file COPYING.LIB.  If
** not, write to the Free Software Foundation, Inc., 675 Mass Ave,
** Cambridge, MA 02139, USA.
**
** Author: Peter Eriksson <pen@signum.se>
*/

#ifndef __GRP_H__
#define __GRP_H__

#include <sys/types.h>

#define _PATH_GROUP "/etc/group"

struct group
{
    char *gr_name;
    char *gr_passwd;
    gid_t gr_gid;
    char **gr_mem;
};

extern struct group *sgetgrent(const char *str);
extern struct group *fgetgrent(FILE *fp);

extern void _setgrent(void);
extern void _endgrent(void);
extern struct group *_getgrent(void);
extern struct group *_getgrnam(const char *name);
extern struct group *_getgrgid(gid_t gid);

extern void yp_setgrent(void);
extern void yp_endgrent(void);
extern struct group *yp_getgrent(void);
extern struct group *yp_getgrnam(const char *name);
extern struct group *yp_getgrgid(gid_t gid);

extern void nis_setgrent(void);
extern void nis_endgrent(void);
extern struct group *nis_getgrent(void);
extern struct group *nis_getgrnam(const char *name);
extern struct group *nis_getgrgid(gid_t gid);

extern void dns_setgrent(void);
extern void dns_endgrent(void);
extern struct group *dns_getgrent(void);
extern struct group *dns_getgrnam(const char *name);
extern struct group *dns_getgrgid(gid_t gid);

extern void setgrent(void);
extern void endgrent(void);
extern struct group *getgrent(void);
extern struct group *getgrnam(const char *name);
extern struct group *getgrgid(gid_t gid);

#endif

