#include <stdio.h>
#include <rpcsvc/nis.h>

int main(int argc, char *argv[])
{
     nis_result *nres;


     nres = nis_list(argv[1], EXPAND_NAME+FOLLOW_LINKS+FOLLOW_PATH,
		     NULL, NULL);

     if (nres == NULL)
     {
	 perror("nis_list");
	 exit(1);
     }

     if (nres->status == NIS_SUCCESS ||
	 nres->status == NIS_S_SUCCESS ||
	 nres->status == NIS_PARTIAL)
     {
	 if (nres->status == NIS_PARTIAL)
	     printf("************ Only partial result **************\n");
	 nis_print_result(nres);
     }
     else
	 printf("Object not found: %s\n", nis_sperrno(nres->status));

     exit(0);
}
