/*
** group_misc.c
**
** Copyright (c) 1993 Signum Support AB, Sweden
**
** This file is part of the NYS Library.
**
** The NYS Library is free software; you can redistribute it and/or
** modify it under the terms of the GNU Library General Public License as
** published by the Free Software Foundation; either version 2 of the
** License, or (at your option) any later version.
**
** The NYS Library is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** Library General Public License for more details.
** 
** You should have received a copy of the GNU Library General Public
** License along with the NYS Library; see the file COPYING.LIB.  If
** not, write to the Free Software Foundation, Inc., 675 Mass Ave,
** Cambridge, MA 02139, USA.
**
** Author: Peter Eriksson <pen@signum.se>
*/

#include <stdio.h>
#include <grp.h>


void print_group(struct group *gr)
{
   int member_index;
      
   printf("%s:%s:%d:",
	   gr->gr_name,
	   gr->gr_passwd,
	   gr->gr_gid);

   for (member_index = 0 ;
	gr->gr_mem && gr->gr_mem[member_index] ;
	++member_index)
      if (member_index == 0)
	 printf("%s", gr->gr_mem[member_index]);
      else
         printf(",%s", gr->gr_mem[member_index]);
   printf("\n");
	     
}

