/*
** yp_group.h              YP group map access definitions
**
** Copyright (c) 1993 Signum Support AB, Sweden
**
** This file is part of the NYS Library.
**
** The NYS Library is free software; you can redistribute it and/or
** modify it under the terms of the GNU Library General Public License as
** published by the Free Software Foundation; either version 2 of the
** License, or (at your option) any later version.
**
** The NYS Library is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** Library General Public License for more details.
** 
** You should have received a copy of the GNU Library General Public
** License along with the NYS Library; see the file COPYING.LIB.  If
** not, write to the Free Software Foundation, Inc., 675 Mass Ave,
** Cambridge, MA 02139, USA.
**
** Authors: Peter Eriksson <pen@signum.se>
**          Michael A. Griffith <grif@cs.ucr.edu>
*/

#ifndef __YPLIB_GROUP_H__
#define __YPLIB_GROUP_H__

#include <sys/types.h>
#include <grp.h>

#define YP_MAX_GROUP_MEMBERS 512
extern void yp_setgrent(char *opts);
extern void yp_endgrent(char *opts);
extern struct group *yp_getgrent(char *opts);
extern struct group *yp_getgrgid(gid_t gid, char *opts);
extern struct group *yp_getgrnam(const char *name, char *opts);

#endif



