/*
** networks_addr.c
**
** Copyright (c) 1993 Signum Support AB, Sweden
**
** This file is part of the NYS Library.
**
** The NYS Library is free software; you can redistribute it and/or
** modify it under the terms of the GNU Library General Public License as
** published by the Free Software Foundation; either version 2 of the
** License, or (at your option) any later version.
**
** The NYS Library is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** Library General Public License for more details.
** 
** You should have received a copy of the GNU Library General Public
** License along with the NYS Library; see the file COPYING.LIB.  If
** not, write to the Free Software Foundation, Inc., 675 Mass Ave,
** Cambridge, MA 02139, USA.
**
** Authors: Peter Eriksson <pen@signum.se>
**          Michael A. Griffith <grif@cs.ucr.edu>  
*/

#include "config.h"


#include <stdio.h>
#include <stdlib.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include "yp_networks.h"
#include "yp_misc.h"

extern void print_network(struct netent *);

#ifdef HAVE_BUGGY_INET_NETWORK
static int _inet_network(char *cp)
{
    int v[4];
    int res;
    int len;
    int i;

    
    v[0] = v[1] = v[2] = v[3] = 0;

    len = sscanf(cp, "%d.%d.%d.%d", &v[0], &v[1], &v[2], &v[3]);
    if (len <= 0)
	return -1;
    
    res = 0;

    
    for (i = 0; i < len; i++)
    {
	res <<= 8;
	res += v[i];
    }
    
    return res;
}

#ifdef inet_network
#undef inet_network
#endif
#define inet_network _inet_network


static struct in_addr _inet_makeaddr(int net, int host)
{
    struct in_addr in;
    long addr;

    
    addr = net;
    if (addr != 0)
    {
	while ((addr & (0xFF << 24)) == 0)
	    addr <<= 8;
    }

    addr |= host;

    in.s_addr = htonl(addr);
    return in;
}

#ifdef inet_makeaddr
#undef inet_makeaddr
#endif
#define inet_makeaddr _inet_makeaddr
#endif


int
main(int argc, char *argv[])
{
   struct netent *net;
   unsigned long test;
   struct in_addr in;

   
   if (argc < 2)
       exit(1);
   
   test = inet_network(argv[1]);
   printf("%04x\n", test);
   
   in = inet_makeaddr(test, 0);
   puts(inet_ntoa(in));
   
   net = yp_getnetbyaddr(test, AF_INET, NULL);

   if (net)
       print_network(net);
   else
       printf("No entry found\n");
   
   exit(0);
}
