/* sgi_audio.c */

/* elf
 * sgi_audio.c,v 1.1.1.1 1993/01/21 01:04:04 elf Exp
 * 1.1.1.1
 * sgi_audio.c,v
 * Revision 1.1.1.1  1993/01/21  01:04:04  elf
 * New Tracker Amiga MOD player.
 *
 * Revision 2.5  1991/12/04  08:28:53  espie
 * Separated mix/stereo stuff.
 *
 * Revision 2.4  1991/12/03  21:24:53  espie
 * Checked buffer size.
 *
 * Revision 2.3  1991/12/03  20:43:46  espie
 * Added possibility to get back to MONO for the sgi.
 *
 * Revision 2.2  1991/12/03  18:07:38  espie
 * Added stereo capabilities to the indigo version.
 *
 * Revision 2.1  1991/11/18  01:10:45  espie
 * Minor corrections.
 *
 * Revision 2.0  1991/11/17  21:42:08  espie
 * New version.
 *
 * Revision 1.9  1991/11/17  17:09:53  espie
 * Added missing prototypes.
 *
 * Revision 1.8  1991/11/16  15:42:43  espie
 * Can't remember what.
 *
 * Revision 1.7  1991/11/08  14:25:55  espie
 * Ask the frequency to the audio device.
 *
 * Revision 1.6  1991/11/07  20:12:34  espie
 * Minor problem with version id.
 *
 * Revision 1.5  1991/11/07  20:11:10  espie
 * Added embedded version id.
 *
 * Revision 1.4  1991/11/07  15:27:02  espie
 * Corrected bug: when closing audio,
 * we know wait for the samples queue to be empty.
 *
 * Revision 1.3  1991/11/05  22:49:03  espie
 * Added a #define. We can now be non commited as
 * far as the sampling rate is concerned.
 *
 * Revision 1.2  1991/11/04  13:23:59  espie
 * Use HZ macro.
 *
 * Revision 1.1  1991/11/03  22:46:33  espie
 * Initial revision
 *
 *
 */

#include <audio.h>
#include <malloc.h>
#include <stdio.h>
#include "defs.h"

extern int sginap (long ticks);

static char *id = "sgi_audio.c,v 1.1.1.1 1993/01/21 01:04:04 elf Exp";

signed short *buffer;
int index;


ALport audio;
ALconfig config;

long chpars[]=
{AL_OUTPUT_RATE, 0};

static int stereo;		/* are we playing stereo or not ? */

/* 256th of primary/secondary source for that side. */
static int primary, secondary;

void
set_mix (percent)
     int percent;
{
  percent *= 256;
  percent /= 100;
  primary = percent;
  secondary = 512 - percent;
}

int
open_audio (frequency)
     int frequency;
{
  int number;

  chpars[1] = frequency;
  if (frequency == 0)
    ALgetparams (AL_DEFAULT_DEVICE, chpars, 2);
  else
    ALsetparams (AL_DEFAULT_DEVICE, chpars, 2);
  config = ALnewconfig ();
  if (stereo = !getenv ("MONO"))
    {
      ALsetchannels (config, AL_STEREO);
      number = 2;
      set_mix (30);
    }
  else
    {
      ALsetchannels (config, AL_MONO);
      number = 1;
    }
  ALsetwidth (config, AL_SAMPLE_16);
  audio = ALopenport ("soundtracker mono", "w", config);
  index = 0;
  buffer = malloc (sizeof (signed short) * number * chpars[1]);

  return chpars[1];
}

void
output_samples (int left, int right)
{
  if (stereo)
    {
      buffer[index++] = (left * primary + right * secondary) / 256;
      buffer[index++] = (right * primary + left * secondary) / 256;
    }
  else
    buffer[index++] = left + right;
}

void
flush_buffer (void)
{
  ALwritesamps (audio, buffer, index);
  index = 0;
}

void
close_audio (void)
{
  while (ALgetfilled (audio) != 0)
    sginap (1);
  ALcloseport (audio);
  ALfreeconfig (config);
}
