/*
 *	etherd.c
 *
 * Changes:
 * V0.4 - use syslog(3) instead of stderr (S.P.)
 * V0.3 - clean up machine-specific vs. machine-dependant code for
 *	  the packet counting stuff (S.P.)
 * V0.2 - ports for Linux and FreeBSD, port to SunOS unfinished (S.P.)
 *      - added -d option
 * V0.1 - the original from Guy Cardwell
 */

#include <stdio.h>
#include <rpc/rpc.h>
#include <sys/time.h>
#include <sys/types.h>
#include <errno.h>
#include <signal.h>
#include <syslog.h>
#include "etherd.h"

static char version[] = "@(#)rpc.etherd V0.4 Jun '95 S.P.";
static char *ifname;

void etherprog_1();

static void death() {
  pmap_unset(ETHERPROG, ETHERVERS);
  packet_shutdown();
  exit(0);
}

#ifdef DEBUG
int debug = 0;
#endif

static void usage(s) char *s; {
#ifdef DEBUG
  fprintf(stderr, "usage: %s interface\n", s);
#else
  fprintf(stderr, "usage: %s [-d] interface\n", s);
#endif
  exit(1);
}
  

int main(argc, argv)
int argc;
char *argv[];
{
  int n;
  register SVCXPRT *transp;
  fd_set readfds;
  int dtbsz = getdtablesize();
  
  for (n = 1; n < argc; n++) {
    if ('-' == *argv[n]) switch(argv[n][1]) {
    case '?':
    case 'h': usage(*argv); break;
    case 'd': 
#ifdef DEBUG
      debug++;
#else
      fprintf(stderr, "%s compiled w/o DEBUG: -d ignored\n", *argv);
#endif
      break;
    default: 
      fprintf(stderr, "%s: unknown option %s\n", *argv, argv[n]);
      usage(*argv);
      break;
    }
    else break;
  }
  if (n == argc) {
    fprintf(stderr, "no interface name given\n");
    usage(*argv);
  }
  ifname = argv[n];

  if (getuid() != 0) {
    fprintf(stderr, "You must be root to run %s\n", argv[0]);
    exit(2);
  }

  /* TODO: go into background */
  signal(SIGINT, death);

#ifdef LOG_DAEMON
  openlog(*argv, LOG_PID|LOG_NOWAIT, LOG_DAEMON);
#else
  openlog(*argv, LOG_PID|LOG_NOWAIT);
#endif

  /* this just checks to see if the interface is valid, etc */
  /* etherproc_on_1 actually turns the whole thing on.  This just
     checks the interface */
  packet_setup(ifname);
  packet_shutdown();
  (void) pmap_unset(ETHERPROG, ETHERVERS);
  
  transp = svcudp_create(RPC_ANYSOCK);
  if (transp == NULL) {
    syslog(LOG_ERR, "cannot create udp service");
    exit(1);
  }
  if (!svc_register(transp, ETHERPROG, ETHERVERS, etherprog_1, IPPROTO_UDP)) {
    syslog(LOG_ERR, "unable to register (ETHERPROG, ETHERVERS, udp)");
    exit(1);
  }
  
  transp = svctcp_create(RPC_ANYSOCK, 0, 0);
  if (transp == NULL) {
    syslog(LOG_ERR, "cannot create tcp service.");
    exit(1);
  }
  if (!svc_register(transp, ETHERPROG, ETHERVERS, etherprog_1, IPPROTO_TCP)) {
    syslog(LOG_ERR, "unable to register (ETHERPROG, ETHERVERS, tcp).");
    exit(1);
  }
  /* this is code from svc_run */
  for (;;) {
    readfds = svc_fdset;
    if (pffd != -1) {
      FD_SET(pffd,&readfds);
    }
    switch ((n=select(dtbsz,&readfds,NULL,NULL,NULL))) {
    case -1:
      if (errno!=EBADF) continue;
      syslog(LOG_ERR, "select: %m");
      perror("rpc.etherd: select");
      exit(1);
    case 0:
      continue;
    default: 
      if (pffd != -1 && FD_ISSET(pffd,&readfds)) {
	FD_CLR(pffd, &readfds);
	process_packet();
      }
      svc_getreqset(&readfds);
    }
  }
  /* NOTREACHED */
}

etherstat *etherproc_getdata_1() {
  struct timeval tp;
  struct timezone tzp;
  static etherstat data;
#ifdef DEBUG
  if (debug) fprintf(stderr, "getdata_1\n");
#endif
  /* set the time in the structure */
  data = estatdata;
  gettimeofday(&tp, &tzp);
  data.e_time.tv_seconds=tp.tv_sec;
  data.e_time.tv_useconds=tp.tv_usec;
  return (&data);
}



etheraddrs *etherproc_getsrcdata_1() {
  struct timeval tp;
  struct timezone tzp;
  static etheraddrs data;
#ifdef DEBUG
  if (debug) fprintf(stderr, "getsrcdata_1\n");
#endif
  data = srcaddrs;
  /* set the time in the structure */
  gettimeofday(&tp, &tzp);
  data.e_time.tv_seconds = tp.tv_sec;
  data.e_time.tv_useconds = tp.tv_usec;
  data.e_bytes = estatdata.e_bytes;
  data.e_packets = estatdata.e_packets;
  data.e_bcast = estatdata.e_bcast;
  return(&data);
}


etheraddrs *etherproc_getdstdata_1()
{
  struct timeval tp;
  struct timezone tzp;
  static etheraddrs data;
#ifdef DEBUG
  if (debug) fprintf(stderr, "getdstdata_1\n");
#endif
  data = destaddrs;
  /* set the time in the structure */
  gettimeofday(&tp, &tzp);
  data.e_time.tv_seconds = tp.tv_sec;
  data.e_time.tv_useconds = tp.tv_usec;
  data.e_bytes = estatdata.e_bytes;
  data.e_packets = estatdata.e_packets;
  data.e_bcast = estatdata.e_bcast;
  return(&data);
}  

void *etherproc_on_1() {
#ifdef DEBUG
  if (debug) fprintf(stderr, "on_1\n");
#endif
  if (pffd == -1) packet_setup(ifname);
  return ((void *) 1);
}

void *etherproc_off_1() {
#ifdef DEBUG
  if (debug) fprintf(stderr, "off_1\n");
#endif
  if (pffd != -1) packet_shutdown();
  return ((void *)1);
}

void *etherproc_selectsrc_1(mask)
addrmask *mask;
{
  syslog(LOG_INFO, "selectsrc_1: mask=%d srcmask=0x%x\n",
	mask->a_mask, mask->a_addr);
  if (mask->a_mask) srcmask = mask->a_addr;
  else srcmask = 0;
  return ((void *)1);
}

void *etherproc_selectdst_1(mask)
addrmask *mask;
{
  syslog(LOG_INFO, "selectdst_1: mask=%d destmask=0x%x\n",
	mask->a_mask, mask->a_addr);
  if (mask->a_mask) destmask = mask->a_addr;
  else destmask = 0;
  return ((void *)1);
}

void *etherproc_selectproto_1(mask)
addrmask *mask;
{
  syslog(LOG_INFO, "selectproto_1: mask=%d proto=%d\n",
	mask->a_mask, mask->a_addr);
  if (mask->a_mask) prot_mask = mask->a_addr;
  else prot_mask = 0;
  return ((void *)1);
}

void *etherproc_selectlnth_1(mask)
addrmask *mask;
{
  syslog(LOG_INFO, "selectlnth_1: small=%d large=%d\n",
	mask->a_addr, mask->a_mask);
  if (mask->a_mask) {
    small_size = mask->a_addr;
    large_size = mask->a_mask;
  } else {
    small_size = 0;
    large_size = 0;
  }
  return ((void *)1);
}
