#include <stdio.h>
#include <rpc/rpc.h>
#include "ether.h"

void
etherprog_1(rqstp, transp)
	struct svc_req *rqstp;
	SVCXPRT *transp;
{
	union {
		addrmask etherproc_selectsrc_1_arg;
		addrmask etherproc_selectdst_1_arg;
		addrmask etherproc_selectproto_1_arg;
		addrmask etherproc_selectlnth_1_arg;
	} argument;
	char *result;
	bool_t (*xdr_argument)(), (*xdr_result)();
	char *(*local)();

	switch (rqstp->rq_proc) {
	case NULLPROC:
		(void)svc_sendreply(transp, xdr_void, (char *)NULL);
		return;

	case ETHERPROC_GETDATA:
		xdr_argument = xdr_void;
		xdr_result = xdr_etherstat;
		local = (char *(*)()) etherproc_getdata_1;
		break;

	case ETHERPROC_ON:
		xdr_argument = xdr_void;
		xdr_result = xdr_void;
		local = (char *(*)()) etherproc_on_1;
		break;

	case ETHERPROC_OFF:
		xdr_argument = xdr_void;
		xdr_result = xdr_void;
		local = (char *(*)()) etherproc_off_1;
		break;

	case ETHERPROC_GETSRCDATA:
		xdr_argument = xdr_void;
		xdr_result = xdr_etheraddrs;
		local = (char *(*)()) etherproc_getsrcdata_1;
		break;

	case ETHERPROC_GETDSTDATA:
		xdr_argument = xdr_void;
		xdr_result = xdr_etheraddrs;
		local = (char *(*)()) etherproc_getdstdata_1;
		break;

	case ETHERPROC_SELECTSRC:
		xdr_argument = xdr_addrmask;
		xdr_result = xdr_void;
		local = (char *(*)()) etherproc_selectsrc_1;
		break;

	case ETHERPROC_SELECTDST:
		xdr_argument = xdr_addrmask;
		xdr_result = xdr_void;
		local = (char *(*)()) etherproc_selectdst_1;
		break;

	case ETHERPROC_SELECTPROTO:
		xdr_argument = xdr_addrmask;
		xdr_result = xdr_void;
		local = (char *(*)()) etherproc_selectproto_1;
		break;

	case ETHERPROC_SELECTLNTH:
		xdr_argument = xdr_addrmask;
		xdr_result = xdr_void;
		local = (char *(*)()) etherproc_selectlnth_1;
		break;

	default:
		svcerr_noproc(transp);
		return;
	}
	bzero((char *)&argument, sizeof(argument));
	if (!svc_getargs(transp, xdr_argument, &argument)) {
		svcerr_decode(transp);
		return;
	}
	result = (*local)(&argument, rqstp);
	if (result != NULL && !svc_sendreply(transp, xdr_result, result)) {
		svcerr_systemerr(transp);
	}
	if (!svc_freeargs(transp, xdr_argument, &argument)) {
		(void)fprintf(stderr, "unable to free arguments\n");
		exit(1);
	}
}

