/* WIDE AREA INFORMATION SERVER SOFTWARE
   No guarantees or restrictions.  See the readme file for the full standard
   disclaimer.  
*/

/* Copyright (c) CNIDR (see ../doc/CNIDR/COPYRIGHT) */

 
#ifndef docid_h
#define docid_h

#include "cdialect.h"
#include "zprot.h"

#define COPY_WITHOUT_RESTRICTION        0
#define ALL_RIGHTS_RESERVED             1
#define DISTRIBUTION_RESTRICTIONS_APPLY 2

/*---------------------------------------------------------------------------*/

typedef struct DocID{
   any* originalServer;
   any* originalDatabase;
   any* originalLocalID;
   any* distributorServer;
   any* distributorDatabase;
   any* distributorLocalID;
   long copyrightDisposition;
} DocID;

#ifdef __cplusplus
/* declare these as C style functions */
extern "C"
	{
#endif /* def __cplusplus */

DocID* makeDocID (void);

DocID* copyDocID (DocID* doc);

void freeDocID (DocID* doc);

any* GetServer (DocID* doc);

DocID* docIDFromAny (any* rawDocID);

any* anyFromDocID (DocID* docID);

any* GetDatabase (DocID* doc);

any* GetLocalID (DocID* doc);

long GetCopyrightDisposition (DocID* doc);

long ReadDocID (DocID* doc, FILE* file);

long WriteDocID (DocID* doc, FILE* file);

Boolean cmpDocIDs (DocID* d1,DocID* d2);

/*---------------------------------------------------------------------------*/

#ifdef __cplusplus
	}
#endif /* def __cplusplus */

#endif /* ifndef docid_h */

