#ifndef _SCREENHACK_H_
#define _SCREENHACK_H_

#include <X11/Xlib.h>
#include <X11/Xresource.h>
#include <X11/Xos.h>
#include "vroot.h"

extern Bool mono_p;
extern char *progname;
extern char *progclass;
extern XrmDatabase db;
extern XrmOptionDescRec options [];
extern int options_size;
extern char *defaults [];

#if __STDC__
# define P(x)x
#else
# define P(x)()
#endif

extern void screenhack P((Display*,Window));

#define usleep screenhack_usleep

extern void screenhack_usleep P((unsigned long));
extern char *get_string_resource P((char*,char*));
extern Bool get_boolean_resource P((char*,char*));
extern int get_integer_resource P((char*,char*));
extern double get_float_resource P((char*,char*));
extern unsigned int get_pixel_resource P((char*,char*,Display*,Colormap));

void hsv_to_rgb P((int,double,double,unsigned short*,
		   unsigned short*,unsigned short*));
void rgb_to_hsv P((unsigned short,unsigned short,unsigned short,
		   int*,double*,double*));
void cycle_hue P((XColor*,int));

static double _frand_tmp_;
#define frand(f)						\
 (_frand_tmp_ = (((double) random()) / 				\
		 (((unsigned int)~0) / ((double) (f+f)))),	\
  _frand_tmp_ < 0 ? -_frand_tmp_ : _frand_tmp_)

#undef P
#endif /* _SCREENHACK_H_ */
