/*
 * read the master list from the ~/.schedule file. This file is also
 * linked into the daemon program (file_w.c is not).
 *
 *	readfile(list, path)		Read a file into the list.
 */

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#ifdef MIPS
#include <sys/types.h>
#include <sys/fcntl.h>
#else
#include <stdlib.h>
#endif
#include <time.h>
#include "conf.h"

#ifdef MIPS
extern char		*getenv();
extern char		*malloc();
#endif
extern char		*mystrdup();
extern time_t		tm_to_time();
extern char		*resolve_tilde();	/* evaluates path with ~ */
extern char		*progname;		/* argv[0] */
extern struct config	config;			/* global configuration data */
struct user		*user;			/* user list for week view */
int			nusers;			/* # of users in user list */
char			Print_Spooler[100];	/* print spooling command */


/*
 * read a list from a file. If <list> points to a non-null pointer, the
 * list in the file is merged into the list. As with add_entry(), <list>
 * is a pointer to a pointer to the list because the list might grow and
 * must be re-allocated. If the file is empty, no new list is allocated,
 * and <list> continues to point to a null pointer.
 * If conf is TRUE, read the config parameters too, otherwise ignore them.
 * This is used when other user's .dayplan files are read for the week view.
 * Returns FALSE if the file could not be read.
 */

BOOL readfile(list, path, conf)
	struct list		**list;		/* list to add to */
	char			*path;		/* file to read list from */
	BOOL			conf;		/* if TRUE, config stuff too */
{
	register struct config	*c = &config;
	FILE			*fp;		/* open file */
	BOOL			writable;	/* can we lock the file? */
	char			line[1024];	/* line buffer */
	register char		*p;		/* line scan pointer */
	register struct entry	*ep = 0;	/* list entry being read */
	int			n;		/* tmp entry # of ep in list */
	struct entry		entry;		/* temp entry before adding */
	struct tm		tm;		/* m/d/y h:m:s to time conv */
	int			tmp[9];		/* temps for sscanf */
	char			sflag, pflag;	/* more temps for sscanf */
	char			nflag;		/* more temps for sscanf */
	char			**string;	/* string to add to */
	int			len;		/* new length of string */
	int			user_i = 0;	/* next user to read */
	char			buf1[256], buf2[1024];

	path = resolve_tilde(path);
	writable = !access(path, W_OK);
	if (!(fp = fopen(path, writable ? "r+" : "r")))
		return(FALSE);
	if (conf)		/* defaults for 't' line */
		guess_tzone();
	if (writable)
		lockfile(fp, TRUE);
	for (;;) {
		if (!fgets(line, 1024, fp))
			break;
		if (!conf && strchr("otelapmUu", *line))
			continue;
		switch(*line) {
		  case '\n':
		  case '#':
			continue;

		  case 'o':
			c->sunday_first = line[2]  != '-';
			c->ampm         = line[3]  != '-';
			c->mmddyy       = line[4]  != '-';
			c->autodel      = line[5]  != '-';
			c->julian       = line[6]  != '-';
			c->weeknum      = line[7]  != '-';
			c->nopast       = line[8]  != '-';
			c->bigwarning   = line[9]  != '-';
			c->weekwarn     = line[10] != '-';
			c->weekuser     = line[11] != '-';
			c->smallmonth   = line[12] != '-';
			sscanf(line+16, "%d %d %d %d %d",
						(int *)&c->early_time,
						(int *)&c->late_time,
						(int *)&c->wintimeout,
						(int *)&c->week_minhour,
						(int *)&c->week_maxhour);
			if (c->week_minhour >= c->week_maxhour) {
				c->week_minhour = 8;
				c->week_maxhour = 20;
			}
			break;

		  case 't':
			sscanf(line+2, "%d %d %d %d %d",
						(int *)&c->adjust_time,
						(int *)&c->raw_tzone,
						(int *)&c->dst_flag,
						(int *)&c->dst_begin,
						(int *)&c->dst_end);
			break;

		  case 'e':
			c->ewarn_window = line[2] != '-';
			c->ewarn_mail   = line[3] != '-';
			c->ewarn_exec   = line[4] != '-';
			line[strlen(line)-1] = 0;
			if (c->ewarn_prog)
				free(c->ewarn_prog);
			c->ewarn_prog = 0;
			if (line[5] && line[6])
				c->ewarn_prog = mystrdup(line+6);
			break;

		  case 'l':
			c->lwarn_window = line[2] != '-';
			c->lwarn_mail   = line[3] != '-';
			c->lwarn_exec   = line[4] != '-';
			line[strlen(line)-1] = 0;
			if (c->lwarn_prog)
				free(c->lwarn_prog);
			c->lwarn_prog = 0;
			if (line[5] && line[6])
				c->lwarn_prog = mystrdup(line+6);
			break;

		  case 'a':
			c->alarm_window = line[2] != '-';
			c->alarm_mail   = line[3] != '-';
			c->alarm_exec   = line[4] != '-';
			line[strlen(line)-1] = 0;
			if (c->alarm_prog)
				free(c->alarm_prog);
			c->alarm_prog = 0;
			if (line[5] && line[6])
				c->alarm_prog = mystrdup(line+6);
			break;

		  case 'p':
			strncpy(Print_Spooler, (const char *)line + 2,
						sizeof(Print_Spooler));
			Print_Spooler[sizeof(Print_Spooler)-1] = 0;
			Print_Spooler[strlen(Print_Spooler)-1] = 0;
			break;

		  case 'm':
			line[strlen(line)-1] = 0;
			if (line[1] && line[2])
				c->mailer = mystrdup(line+2);
			break;

		  case 'U':
			if (user) {
				for (n=0; n < nusers; n++)
					if (user[n].list)
						free((char *)user[n].list);
				free((char *)user);
				user = 0;
			}
			sscanf(line+2, "%d", &nusers);
			if (nusers) {
				if (!(user = (struct user *)malloc(
						nusers * sizeof(struct user))))
					fatal("no memory for %d users",nusers);
				for (n=0; n < nusers; n++) {
					user[n].name	  = 0;
					user[n].home	  = 0;
					user[n].suspended = 0;
					user[n].color     = 0;
					user[n].time	  = 0;
					user[n].list	  = 0;
				}
			}
			break;

		  case 'u':
			if (user_i >= nusers)
				fatal("too many u stmts in %s", path);
			sscanf(line+2, "%s %s %d %d\n", buf1, buf2,
					&user[user_i].suspended,
					&user[user_i].color);
			user[user_i].name = mystrdup(buf1);
			user[user_i].home = mystrdup(buf2);
			user_i++;
			break;

		  case '0':
		  case '1':
		  case '2':
		  case '3':
		  case '4':
		  case '5':
		  case '6':
		  case '7':
		  case '8':
		  case '9':
			clone_entry(&entry, (struct entry *)0);
			sscanf(line,
			 "%d/%d/%d %d:%d:%d %d:%d:%d %d:%d:%d %d:%d:%d %c%c%c",
				&tm.tm_mon, &tm.tm_mday, &tm.tm_year,
				&tm.tm_hour, &tm.tm_min, &tm.tm_sec,
				tmp+0, tmp+1, tmp+2,
				tmp+3, tmp+4, tmp+5,
				tmp+6, tmp+7, tmp+8,
				&sflag, &pflag, &nflag);
			tm.tm_mon--;
			if (tm.tm_year < 70)
				tm.tm_year += 100;
			if (tm.tm_year > 1900)
				tm.tm_year -= 1900;
			if (entry.notime = tm.tm_hour > 23)
				tm.tm_hour = tm.tm_min = tm.tm_sec = 0;
			entry.time         = tm_to_time(&tm);
			entry.length       = tmp[0]*3600 + tmp[1]*60 + tmp[2];
			entry.early_warn   = tmp[3]*3600 + tmp[4]*60 + tmp[5];
			entry.late_warn    = tmp[6]*3600 + tmp[7]*60 + tmp[8];
			entry.suspended    = sflag == 'S';
			entry.private      = pflag == 'P';
			entry.noalarm      = nflag == 'N';
			n = add_entry(list, &entry);	/* sets <list> */
			ep = &(*list)->entry[n];
			break;

		  case 'R':
			sscanf(line+2, "%d %d %d %d %d",
				(int *)&ep->rep_every,
				(int *)&ep->rep_last,
				(int *)&ep->rep_weekdays,
				(int *)&ep->rep_days,
				(int *)&ep->rep_yearly);
			break;

		  case 'N':
			string = &ep->note;
			goto add;
		  case 'M':
			string = &ep->message;
			goto add;
		  case 'S':
			string = &ep->script;
			goto add;
		  case 'G':
			string = &ep->meeting;
add:			len  = *string ? strlen(*string) : 0;
			len += strlen(line+2) + 2;
			if (!(p = malloc(len))) {
				fprintf(stderr, "%s: no memory", progname);
				exit(1);
			}
			if (*string) {
				strcpy(p, *string);
				strcat(p, line+2);
				free(*string);
			} else
				strcpy(p, line+2);
			*string = p;
			break;
		
		  default:
			fprintf(stderr, "%s: %s: illegal line:\n%s",
							progname, path, line);
		}
	}
	if (writable)
		lockfile(fp, FALSE);
	fclose(fp);
	if (conf)
		set_tzone();
	if (*list)
		(*list)->modified = FALSE;
	rebuild_repeat_chain(*list);
	return(TRUE);
}
