/*
 * These routines make using the international messages facilities easier.
 * 
 * Note if you use this stuff you'll need to add a global variable
 * 
 *    nl_catd Gcatd; 
 *
 * to your source.
 *
 * This interface could be applied to methods other than X/Open coding
 * (VMS etc..)
 *
 * Copyright (c) 1994 University of Minnesota
 */

#ifndef GLOCALE_H
#define GLOCALE_H

#if defined(VMS) || defined(_AUX_SOURCE) 
#  define setlocale(a,b)
#  define Gtxt(a,b) a
#  define Gtxtopen(a,b,c)
#else
#  include <locale.h>

   /** Figure out which systems have catopen() etal **/

#  if defined(__svr4__) || defined(_XOPEN_SOURCE) || defined (GINTERNATIONAL)

#    undef  GINTERNATIONAL
#    define GINTERNATIONAL
#  endif

#  if !defined(GINTERNATIONAL)	/* Only use i18n routines if we're sure */
#    define Gtxtopen(a,b,c)
#    define Gtxt(a,b) a

#  else
     /*** Define some nice convenience routines ***/
     /**  It would sure be nice to use gettext() routines... oh well...***/
#    include <nl_types.h>

#    ifndef NL_SETD
#      define NL_SETD 0		/* SunOS 4.1.3 with xpg2bin/cc compiler */
#    endif


#    define Gtxt(a,b)       (catgets(Gcatd,NL_SETD,b,a))
#    define Gtxtopen(a,b,c) (a=catopen(b,c))
#  endif
#endif


#endif /* GLOCALE_H */
