/*
    Gn: A Server for the Internet Gopher Protocol(*).
    File: uncache/init.c
    Version: 1.0
    
    Copyright (C) 1993  <by John Franks>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    (*) Gopher is a registered trademark of the Univ. of Minn.
*/
#include <stdio.h>
#include "uncache.h"

int	recurse = FALSE,
	indexing = FALSE;

char	myhost[MAXLEN],
	mfname[MAXLEN],
	cfname[MAXLEN],
	ifname[MAXLEN];
	
extern char *optarg;
extern int optind;


void
init( argc, argv)
int	argc;
char	*argv[];
{
	int	c,
		dflg = 0,
		errflg = 0;
	char	*dir,
		*unknownopt = NULL;


	ifname[0] = '\0';
	strcpy( mfname, MENUFNAME);
	strcpy( cfname, CACHEFNAME);
	strcpy( myhost, GN_HOSTNAME);

	while ((c = getopt(argc, argv, "rd:m:c:h:i:")) != -1) {
		switch ((char) c) {
			case 'r':
				recurse++;
				break;
			case 'd':
				dflg++;
				dir = optarg;
				break;
			case 'm':
				strcpy( mfname, optarg);
				break;
			case 'c':
				strcpy( cfname, optarg);
				break;
			case 'h':
				strcpy( myhost, optarg);
				break;
			case 'i':
				indexing = TRUE;
				strcpy( ifname, optarg);
				break;
			case '?':
				errflg++;
		}
	}

	if (errflg) {
		fprintf( stderr, 
	"Usage: %s [-r] [-d dir] [-m menu] [-c cache] [-h host] [-i indexfile]\n",
		argv[0]);
		exit (2);
	}

	if ( dflg ) {
		sprintf( mfpath, "%s/%s", dir, mfname);
		sprintf( cfpath, "%s/%s", dir, cfname);
	} else {
		sprintf( mfpath, "./%s", mfname);
		sprintf( cfpath, "./%s", cfname);
	}
}

