/* -- AIX/6000 System monitor 
**
**     uptime.c
**
** Copyright (c) 1991-1995 Jussi Maki, All Rights Reserved.
** Copyright (c) 1993-1998 Marcel Mol, All Rights Reserved.
** NON-COMMERCIAL USE ALLOWED. YOU ARE FREE TO DISTRIBUTE
** THIS PROGRAM AND MODIFY IT AS LONG AS YOU KEEP ORIGINAL
** COPYRIGHTS.
*/

/*
 * Implemention of uptime to aix3.1 with using loadavgd to
 * get real load-values. 
 * Jussi M{ki, Helsinki Univ. of Technology, Computing Centre
 * jmaki@hut.fi, 3.7.1991
 */

#include <sys/types.h>
#include <sys/times.h>
#include <sys/stat.h>
#include <sys/param.h>
#include <time.h>
#include <utmp.h>
#include <stdio.h>


#define UTMP_FILENAME "/etc/utmp"

/*
 * Function Declarations
 */
void convsectime(time_t secs, int *days, int *hours, int *minutes);
int getnusers();


main()
{
    int nusers;
    struct tms tbuf;
    struct tm *tm;
    time_t uptime;
    time_t timeofday;
    int days, hours, minutes;
    double loads[3];

    uptime = times(&tbuf) / HZ;
    timeofday = time((long *)0);
    tm = localtime(&timeofday);

    nusers = getnusers();
    getloadavg(loads, 3);

    convsectime(uptime, &days, &hours, &minutes);
    printf(" %2d:%02d%s  up %2d days,  %2d:%02d,  %d users,"
           "  load average: %5.2f,%5.2f,%5.2f\n",
	 tm->tm_hour, tm->tm_min, (tm->tm_hour<12)? "am" : "pm",
	 days, hours, minutes, nusers,
	 loads[0], loads[1], loads[2]);
    exit(0);

    exit(0);

} /* main */



int getnusers()
{
    FILE *utmpf;
    int nusers;
    struct utmp utmp;
    struct stat stat_buf;
    char device[12+5+1] = "/dev/";
    time_t now;
  
    nusers = 0;
    if (!(utmpf = fopen(UTMP_FILENAME, "r"))) {
      perror(UTMP_FILENAME);
      exit(1);
    }

    now = time(0);
    while (fread((char *)&utmp, sizeof(utmp), 1, utmpf) == 1)
        if (*utmp.ut_name && utmp.ut_type == USER_PROCESS)  {
            nusers++;
/*
            memset(device+5, '\0', 12+1);
            strcat(device+5, utmp.ut_line);
            if (stat(device, &stat_buf))
                perror(device);
            printf("terminal: %-12s, %-16s, a=%d, m=%d, c=%d, time %s",
	            utmp.ut_line,
	            *utmp.ut_host ? utmp.ut_host :  "local",
                    now - stat_buf.st_atime,
                    now - stat_buf.st_mtime,
                    now - stat_buf.st_ctime,
	            ctime(&utmp.ut_time));
*/
        }
    fclose(utmpf);

    return (nusers);

} /* getnusers */


#define	MINUTES	60
#define HOURS	(MINUTES * 60)
#define DAYS	(HOURS * 24)

void
convsectime(time_t secs, int *days, int *hours, int *minutes)
{

    secs -= (*days = secs / DAYS) * DAYS;
    secs -= (*hours = secs / HOURS) * HOURS;
    secs -= (*minutes = secs / MINUTES) * MINUTES;

    return;

} /* convsectime */
