#############################################################################
#                                                                           #
# AWK SCRIPT           M.J.E. Mol    (C) 1994, 1998                         #
#                      marcel@mesa.nl                                       #
#                                                                           #
# Date:     16apr1998                                                       #
# File:     users_extract.awk                                               #
# Version:  1.1                                                             #
#                                                                           #
# Description                                                               #
#    Extract interval and users records from monitor log and create a       #
#    input file for further processing. Output is a single record per       #
#    interval.                                                              #
#    Sample records are ignored.                                            #
#                                                                           #
# Version Date      Name            Comments                                #
# ------- -------   --------------  --------------------------------------  #
#  1.0    07jul94   M.J.E. Mol      Initial version                         #
#  1.1    16apr1998 M.J.E. Mol      Renamed scripts. Add comment to output  #
#                                                                           #
#############################################################################
#############################################################################
#
# Expected Inputs:
# 
#    interval <hostname> <interval_length> <interval_start_time> 
#             <interval_end_time> <dayname> <daynumber_of_month>
#             <monthnumber> <year> <monthname> <daynumber_of_week> 
#             <weeknumber_of_year>                  (sunday is day 0)
#
#    users     <number_of_users> <active_users> <network_remote>
#              <total_inactive_secs>
#              <number_of_rootusers> <active_rootusers>
#              <network_rootremote> <total_rootinactive_secs>
#
#    users_max <max_number_of_users> <max_active_users> <max_network_remote>
#              <max_total_inactive_secs>
#              <max_number_of_rootusers> <max_active_rootusers>
#              <max_network_rootremote> <max_total_rootinactive_secs>
#
# From the interval record, only the following fields are used:
#
#     <hostname> <interval_length> <interval_start_time> <daynumber_of_month>
#     <year> <monthname> <daynumber_of_week> <weeknumber_of_year>
#
# From the users and max_users record, only the following fields are used:
#
#     <number_of_users> <max_number_of_users>
#
# Outputs records with the following format:
#
#     <hostname> <weeknumber_of_year> <daynumber_of_month><monthname><year>
#         <daynumber_of_week> <interval_start_time> <interval_length>
#         <number_of_users> <max_number_of_users>
#
#############################################################################

BEGIN {
    firsttime = 1
    print "#     Logged on User statistics"
    print "#Host Weeknum Date Daynum Intervalstart Intervallength Users Maxusers"

}
/^sample/ {     # skip sample data
		while ($1 != "interval") {
			if (getline == 0) {
				break
                        }
                }
		# fall through
}
/^interval/ {
		if (firsttime)
			firsttime = 0
                else 
	            print host, week, day month year, daynum, time, interval,
                          users, maxusers
		host     = $2
   		interval = $3
		time     = $4
                day      = $7
                year     = $9
                month    = $10       
                daynum   = $11
                week     = $12
		
}
/^users / 	{ users    = $2 }
/^users_max/	{ maxusers = $2 }
