#############################################################################
#                                                                           #
# AWK SCRIPT           M.J.E. Mol    (C) 1994, 1998                         #
#                      marcel@mesa.nl                                       #
#                                                                           #
# Date:     16apr1998                                                       #
# File:     paging_extract.awk                                              #
# Version:  1.1                                                             #
#                                                                           #
# Description                                                               #
#    Extract interval and paging records from monitor log and create a      #
#    input file for further processing. Output is a single record per       #
#    interval. Sample records are ignored.                                  #
#                                                                           #
# Version Date      Name            Comments                                #
# ------- -------   --------------  --------------------------------------  #
#  1.0    07jul94   M.J.E. Mol      Initial version                         #
#  1.1    16apr1998 M.J.E. Mol      Renamed script. Add comment to output   #
#                                                                           #
#############################################################################
#############################################################################
#
# Expected Inputs:
# 
#    interval <hostname> <interval_length> <interval_start_time> 
#             <interval_end_time> <dayname> <daynumber_of_month>
#             <monthnumber> <year> <monthname> <daynumber_of_week> 
#             <weeknumber_of_year>                  (sunday is day 0)
#
#    vmpaging <pgexct> <pgrclm> <lockexct> <backtrks> <pageins>
#             <pageouts> <pgspgins> <pgspgouts>
#
# Where:
#             pgexct    cnt of page faults
#             pgrclm    cnt of page reclaims
#             lockexct  cnt of lockmisses
#             backtrks  cnt of backtracks
#             pageins   cnt of pages paged in
#             pageouts  cnt of pages paged out
#             pgspgins  cnt of page ins from paging space
#             pgspgouts cnt of page outs from paging space
#
# From the interval record, only the following fields are used:
#
#     <hostname> <interval_length> <interval_start_time> <daynumber_of_month>
#     <year> <monthname> <daynumber_of_week> <weeknumber_of_year>
#
# From the vmpaging record, only the following fields are used:
#
#     <pageins> <pageouts>
#
# Outputs records with the following format:
#
#     <hostname> <weeknumber_of_year> <daynumber_of_month><monthname><year>
#         <daynumber_of_week> <interval_start_time> <interval_length>
#         <pageins> <pageouts>
#
#############################################################################

BEGIN {
    print "#    Paging statistics"
    print "#Host Weeknum Date Daynum Intervalstart Intervallength Pageins Pageouts"

}

/^sample/ {     # skip sample data
		while ($1 != "interval") {
			if (getline == 0) {
				break
                        }
                }
		# fall through
}
/^interval/ {
		host     = $2
   		interval = $3
		time     = $4
                day      = $7
                year     = $9
                month    = $10       
                daynum   = $11
                week     = $12
		
}
/^vmpaging / 	{ 
	            print host, week, day month year, daynum, time, interval,
                          $6, $7
}
