#############################################################################
#                                                                           #
# AWK SCRIPT           M.J.E. Mol    (C) 1994, 1998                         #
#                      marcel@mesa.nl                                       #
#                                                                           #
# Date:     16apr1998                                                       #
# File:     cpu_extract.awk                                                 #
# Version:  1.1                                                             #
#                                                                           #
# Description                                                               #
#    Extract interval and cpubusy records from monitor log and create a     #
#    input file for further processing. Output is a single record per       #
#    interval.                                                              #
#    Sample records are ignored.                                            #
#                                                                           #
# Version Date      Name             Comments                               #
# ------- --------- --------------   -------------------------------------- #
#  1.0    07jul94   M.J.E. Mol       Initial version                        #
#  1.1    16apr1998 M.J.E. Mol       Script has meaningful name now.        #
#                                    Introduced comments in output file.    #
#                                                                           #
#############################################################################
#############################################################################
#
# Expected Inputs:
# 
#    interval <hostname> <interval_length> <interval_start_time> 
#             <interval_end_time> <dayname> <daynumber_of_month>
#             <monthnumber> <year> <monthname> <daynumber_of_week> 
#             <weeknumber_of_year>                  (sunday is day 0)
#
#    cpubusy  <system> <iowait> <user> <idle> 
#
# From the interval record, only the following fields are used:
#
#     <hostname> <interval_length> <interval_start_time> <daynumber_of_month>
#     <year> <monthname> <daynumber_of_week> <weeknumber_of_year>
#
# Outputs records with the following format:
#
#     <hostname> <weeknumber_of_year> <daynumber_of_month><monthname><year>
#         <daynumber_of_week> <interval_start_time> <interval_length>
#         <cpu_system> <cpu_iowait> <cpu_user> <cpu_idle> 
#
#############################################################################
BEGIN {
    print "#    CPU busy figures"
    print "#Host Weeknum Date Daynum Intervalstart Intervallength System Wait User Idle"

}

/^sample/ {     # skip sample data
		while ($1 != "interval") {
			if (getline == 0) {
				break
                        }

                }
		# fall through
}
/^interval/ {	host     = $2
   		interval = $3
		time     = $4
                day      = $7
                year     = $9
                month    = $10
                daynum   = $11
                week     = $12
		
}
/^cpubusy /  {
	        print host, week, day month year, daynum, time, interval,
                      $2, $3, $4, $5
}
