/* -- AIX/6000 System monitor 
**
**     monprint.h
**
** Copyright (c) 1991-1995 Jussi Maki, All Rights Reserved.
** Copyright (c) 1993-1998 Marcel Mol, All Rights Reserved.
** NON-COMMERCIAL USE ALLOWED. YOU ARE FREE TO DISTRIBUTE
** THIS PROGRAM AND MODIFY IT AS LONG AS YOU KEEP ORIGINAL
** COPYRIGHTS.
*/

/*
 * function declarations 
 */
void initscreen();
void calc_sysinfo(double refresh_time, 
                   struct sysinfo *si1, struct sysinfo *si2, struct vmker *vmk,
                   struct vminfo *vm1, struct vminfo *vm2);
void print_sysinfo(double refresh_time, time_t now,
                   struct sysinfo *si1, struct sysinfo *si2, struct vmker *vmk,
                   struct vminfo *vm1, struct vminfo *vm2);
void print_summary(double refresh_time, time_t now,
                   struct sysinfo *si1, struct sysinfo *si2, struct vmker *vmk,
                   struct vminfo *vm1, struct vminfo *vm2);
void calc_dkstat(double refresh_time,
                  struct dkstat *dk1[], struct dkstat *dk2[]);
void print_dkstat(double refresh_time,
                  struct dkstat *dk1[], struct dkstat *dk2[]);
void print_dkstat_full(double refresh_time,
                       struct dkstat *dk1[], struct dkstat *dk2[]);
void calc_ifnet(double refresh_time, struct ifnet *if1[], struct ifnet *if2[]);
void print_ifnet(double refresh_time, struct ifnet *if1[], struct ifnet *if2[]);
void print_log_header();
void print_log(double refresh_time, struct sysinfo *si1, struct sysinfo *si2,
               struct vmker *vmk, struct vminfo *vm1, struct vminfo *vm2,
               struct cpuinfo *cpus1, struct cpuinfo *cpus2,
               struct dkstat *dk1[], struct dkstat *dk2[],
               struct ifnet *if1[], struct ifnet *if2[],
               t_nfs_stats *nfs1, t_nfs_stats *nfs2,
#if defined(HAVE_AFS)
               afsstat_t *afs1, afsstat_t *afs2,
#endif
               topcpu_t *top, int nprocs);
void print_log_max(struct dkstat *dk1[], struct ifnet *if1[]);
void init_max_values(struct dkstat **dk_new, struct ifnet **ifnets_new);
