/* -- AIX/6000 System monitor 
**
**     getkmemdata.c
**
** Copyright (c) 1991-1995 Jussi Maki, All Rights Reserved.
** Copyright (c) 1993-1998 Marcel Mol, All Rights Reserved.
** NON-COMMERCIAL USE ALLOWED. YOU ARE FREE TO DISTRIBUTE
** THIS PROGRAM AND MODIFY IT AS LONG AS YOU KEEP ORIGINAL
** COPYRIGHTS.
*/

#include <unistd.h>
#include <stdio.h>
#include <fcntl.h>
#include "getkmemdata.h"

int kmemfd = -1;

/*********************************************************************/

int getkmemdata(void *buf, int bufsize, caddr_t address)
{
    int n;

    /*
     * Do stuff we only need to do once per invocation, like opening
     * the kmem file and fetching the parts of the symbol table.
     */
    if (kmemfd < 0) {
	if ((kmemfd = open("/dev/kmem", O_RDONLY)) < 0) {
	    perror("kmem");
	    exit(1);
	}
        /*
         * We only need to be root for getting access to kmem, so give up
         * root permissions now!
         */
        setuid(getuid());
        setgid(getgid());
    }
    /*
     * Get the structure from the running kernel.
     */
    lseek(kmemfd, (off_t) address, SEEK_SET);
    n = read(kmemfd, buf, bufsize);

    return(n);

} /* getkmemdata */
