/* -- AIX/6000 System monitor 
**
**     get_nfsstat.h
**
** Copyright (c) 1991-1995 Jussi Maki, All Rights Reserved.
** Copyright (c) 1993-1998 Marcel Mol, All Rights Reserved.
** NON-COMMERCIAL USE ALLOWED. YOU ARE FREE TO DISTRIBUTE
** THIS PROGRAM AND MODIFY IT AS LONG AS YOU KEEP ORIGINAL
** COPYRIGHTS.
*/

#include <sys/types.h>

#if AIX_VERSION == 4

#include <sys/errno.h>
#include <rpc/rpc.h>
#include <nfs/nfs_fscntl.h>
#include <nfs/nfs.h>

#else

/*
 * Remote file service routines, From /usr/include/nfs/nfs.h AIX 4
 */
#define RFS_NULL        0
#define RFS_GETATTR     1
#define RFS_SETATTR     2
#define RFS_ROOT        3
#define RFS_LOOKUP      4
#define RFS_READLINK    5
#define RFS_READ        6
#define RFS_WRITECACHE  7
#define RFS_WRITE       8
#define RFS_CREATE      9
#define RFS_REMOVE      10
#define RFS_RENAME      11
#define RFS_LINK        12
#define RFS_SYMLINK     13
#define RFS_MKDIR       14
#define RFS_RMDIR       15
#define RFS_READDIR     16
#define RFS_STATFS      17
#define RFS_NPROC       18


typedef struct { /* Client nfs: AIX 4:include/nfs/nfs_fscntl.h */
    uint nclsleeps;
    uint nclgets;      /* and this one should be swapped... */
    uint ncalls;       /* From AIX 4 include file, it seems this member */
    uint nbadcalls;
    uint reqs[32];
} t_clstat;


typedef struct {/* Server nfs: AIX 4:include/nfs/nfs_fscntl.h */
    uint ncalls;
    uint nbadcalls;
    uint reqs[32];
} t_svstat;


/* 
 * Following nfs kernel statistics structures are uncodumented in PRE AIX 4.
 * The approximate content of the structure was solved using 
 * the output and the manual page of the /usr/etc/nfsstat command.
 */
typedef struct { /* Client rpc:  AIX 4:include/rpc/clnt.h */
    uint rccalls;
    uint rcbadcalls;
    uint rcretrans;
    uint rcbadxids;
    uint rctimeouts;
    uint rcwaits;
    uint rcnewcreds;
    uint rcbadverfs; /* FROM AIX 4.3 include file */
    uint rctimers;   /* FROM AIX 4.3 include file */
} t_rcstat;


typedef struct { /* Server rpc: AIX 4:include/rpc/svc.h */
    uint rscalls;
    uint rsbadcalls;
    uint rsnullrecv;
    uint rsbadlen;
    uint rsxdrcall;
} t_rsstat;


typedef struct {
    t_clstat clstat;
    t_svstat svstat;
    t_rcstat rcstat;
    t_rsstat rsstat;
} t_nfs_stats;

#endif

void get_nfsstat(t_nfs_stats *nfsstatp);

extern int show_nfs; /* true if nfs is available and wanted*/
