/* -- AIX/6000 System monitor 
**
**     get_nfsstat.c
**
** Copyright (c) 1991-1995 Jussi Maki, All Rights Reserved.
** Copyright (c) 1993-1998 Marcel Mol, All Rights Reserved.
** NON-COMMERCIAL USE ALLOWED. YOU ARE FREE TO DISTRIBUTE
** THIS PROGRAM AND MODIFY IT AS LONG AS YOU KEEP ORIGINAL
** COPYRIGHTS.
*/

#include <stdio.h>	/* for perror */
#include <nlist.h>
#include "get_nfsstat.h"
#include "getkmemdata.h"


#define NFS_VALUE(index) (nfsnames[index].n_value)
#define NUMBER_NFS_NLISTS 4
#define NLIST_NFS_RCSTAT  0
#define NLIST_NFS_RSSTAT  1
#define NLIST_NFS_CLSTAT  2
#define NLIST_NFS_SVSTAT  3

struct nlist nfsnames[] = {
    {"rcstat", 0, 0, 0, 0, 0},
    {"rsstat", 0, 0, 0, 0, 0},
    {"clstat", 0, 0, 0, 0, 0},
    {"svstat", 0, 0, 0, 0, 0},
    {NULL,     0, 0, 0, 0, 0},
};

int nfsinit  = 0;



void
get_nfsstat(t_nfs_stats *nfsstat)
{

#if 0
# define USE_NFS_CNTL
#endif

#if AIX_VERSION == 4 && defined(USE_NFS_CNTL)
    nfs_cntl(NFS_CNTL_GET_ALL_STAT, &nfsstat, NFS_CNTL_ALL_SIZE);
#else
    if (!nfsinit) {
        if (show_nfs &&
            (knlist(nfsnames, NUMBER_NFS_NLISTS, sizeof(struct nlist)) == -1)) {
	    perror("get_nfsstat: nfs not configured");
	    show_nfs = 0;
        }
        nfsinit = 1;
    }

    getkmemdata((char *) &nfsstat->rcstat, sizeof(t_rcstat),
                (caddr_t) NFS_VALUE(NLIST_NFS_RCSTAT));
    getkmemdata((char *) &nfsstat->rsstat, sizeof(t_rsstat),
                (caddr_t) NFS_VALUE(NLIST_NFS_RSSTAT));
    getkmemdata((char *) &nfsstat->clstat, sizeof(t_clstat),
                (caddr_t) NFS_VALUE(NLIST_NFS_CLSTAT));
    getkmemdata((char *) &nfsstat->svstat, sizeof(t_svstat),
                (caddr_t) NFS_VALUE(NLIST_NFS_SVSTAT));

#endif
    return;

} /* get_nfsstat */
