#
#       @(#)Makefile	1.4 89/01/13 NFS Rev 2 Testsuite
#
# to make tests, use 'make'
# to copy tests to another directory, use 'make copy DESTDIR=dir'
# to copy source to another directory, use 'make dist DESTDIR=dir'

CC = cl
TESTS = test1$(EXE) test2$(EXE) test3$(EXE) test4$(EXE) test5$(EXE) \
	test6$(EXE) test7$(EXE) test8$(EXE) test9$(EXE)
AUXTESTS = test4a$(EXE) test5a$(EXE) test5b$(EXE) test7a$(EXE) test7b$(EXE)
DESTDIR = /no/such/path
#  Define NFS3_2 for NFS 3.2 compatibility - Comment out if not NFS 3.2
#COMPAT = -DNFS3_2
DEBUG = /Zi /Od
CFLAGS = $(COMPAT) $(DEBUG) -DDOS -DANSI -F 4000 /Fm /W3 /Ze
LINKFLAGS = /link /NOE
OBJ = .obj	# .o for Unix
EXE = .exe	# null for Unix
COMMONOBJ = subr$(OBJ) d:\msc\5.1\lib\binmode.obj
all: origtests auxtests

origtests: $(TESTS)
auxtests: $(AUXTESTS)

subr$(OBJ): subr.c unixdos.h tests.h
	$(CC) $(CFLAGS) -c $*.c

test1.exe: $*.c $(COMMONOBJ)
	$(CC) $(CFLAGS) -o $*$(EXE) $*.c $(COMMONOBJ) $(LINKFLAGS)

test2.exe: $*.c $(COMMONOBJ)
	$(CC) $(CFLAGS) -o $*$(EXE) $*.c $(COMMONOBJ) $(LINKFLAGS)

test3.exe: $*.c $(COMMONOBJ)
	$(CC) $(CFLAGS) -o $*$(EXE) $*.c $(COMMONOBJ) $(LINKFLAGS)

test4.exe: $*.c $(COMMONOBJ)
	$(CC) $(CFLAGS) -o $*$(EXE) $*.c $(COMMONOBJ) $(LINKFLAGS)

test4a.exe: $*.c $(COMMONOBJ)
	$(CC) $(CFLAGS) -o $*$(EXE) $*.c $(COMMONOBJ) $(LINKFLAGS)

test5.exe: $*.c $(COMMONOBJ)
	$(CC) $(CFLAGS) -o $*$(EXE) $*.c $(COMMONOBJ) $(LINKFLAGS)

test5a.exe: $*.c $(COMMONOBJ)
	$(CC) $(CFLAGS) -o $*$(EXE) $*.c $(COMMONOBJ) $(LINKFLAGS)

test5b.exe: $*.c $(COMMONOBJ)
	$(CC) $(CFLAGS) -o $*$(EXE) $*.c $(COMMONOBJ) $(LINKFLAGS)

test6.exe: $*.c $(COMMONOBJ)
	$(CC) $(CFLAGS) -o $*$(EXE) $*.c $(COMMONOBJ) $(LINKFLAGS)

test7.exe: $*.c $(COMMONOBJ)
	$(CC) $(CFLAGS) -o $*$(EXE) $*.c $(COMMONOBJ) $(LINKFLAGS)

test7a.exe: $*.c $(COMMONOBJ)
	$(CC) $(CFLAGS) -o $*$(EXE) $*.c $(COMMONOBJ) $(LINKFLAGS)

test7b.exe: $*.c $(COMMONOBJ)
	$(CC) $(CFLAGS) -o $*$(EXE) $*.c $(COMMONOBJ) $(LINKFLAGS)

test8.exe: $*.c $(COMMONOBJ)
	$(CC) $(CFLAGS) -o $*$(EXE) $*.c $(COMMONOBJ) $(LINKFLAGS)

test9.exe: $*.c $(COMMONOBJ)
	$(CC) $(CFLAGS) -o $*$(EXE) $*.c $(COMMONOBJ) $(LINKFLAGS)

clean:
	-rm *$(OBJ) $(TESTS) $(AUXTESTS)

copy: $(TESTS)
	cp runtests $(TESTS) $(AUXTESTS) $(DESTDIR)

dist:
	cp runtests Makefile *.c *.h $(DESTDIR)
