/*
 * Copyright (c) 1994, 1995.  Netscape Communications Corporation.  All
 * rights reserved.
 * 
 * Use of this software is governed by the terms of the license agreement for
 * the Netscape FastTrack or Netscape Enterprise Server between the
 * parties.
 */


/* ------------------------------------------------------------------------ */


/*
 * Standard defs for NetSite servers.
 */


#ifndef NETSITE_H
#define NETSITE_H

#include "base/systems.h"  /* NSAPI_PUBLIC def */

#include "version.h"

#ifdef MCC_PROXY
#define MAGNUS_VERSION PROXY_VERSION_DEF
#define MAGNUS_VERSION_STRING PROXY_VERSION_STRING

#elif defined(NS_CMS)
#define MAGNUS_VERSION CMS_VERSION_DEF
#define MAGNUS_VERSION_STRING CMS_VERSION_STRING

#elif defined(NS_DS)
#define MAGNUS_VERSION DS_VERSION_DEF
#define MAGNUS_VERSION_STRING DS_VERSION_STRING

#elif defined(MCC_ADMSERV)
#define MAGNUS_VERSION ADMSERV_VERSION_DEF
#define MAGNUS_VERSION_STRING ADMSERV_VERSION_STRING

#elif defined(NS_CATALOG)
#define MAGNUS_VERSION CATALOG_VERSION_DEF
#define MAGNUS_VERSION_STRING CATALOG_VERSION_STRING

#elif defined(NS_RDS)
#define MAGNUS_VERSION RDS_VERSION_DEF
#define MAGNUS_VERSION_STRING RDS_VERSION_STRING

#elif defined(MCC_HTTPD)

#ifdef NS_PERSONAL
#define MAGNUS_VERSION PERSONAL_VERSION_DEF
#else
#define MAGNUS_VERSION ENTERPRISE_VERSION_DEF
#endif

#if defined(XP_UNIX) || defined(USE_ADMSERV)
#if defined(NS_DS)
#define MAGNUS_VERSION_STRING DS_VERSION_STRING
#elif defined(NS_PERSONAL)
#define MAGNUS_VERSION_STRING PERSONAL_VERSION_STRING
#elif defined(NS_CATALOG)
#define MAGNUS_VERSION_STRING CATALOG_VERSION_STRING
#elif defined(NS_RDS)
#define MAGNUS_VERSION_STRING RDS_VERSION_STRING
#elif defined(NS_CMS)
#define MAGNUS_VERSION_STRING CMS_VERSION_STRING
#else
#define MAGNUS_VERSION_STRING ENTERPRISE_VERSION_STRING
#endif
#endif /* XP_UNIX */

#elif defined(MCC_NEWS)
#define MAGNUS_VERSION_STRING NEWS_VERSION_STRING

#elif defined(NS_MAIL)
#define MAGNUS_VERSION MAIL_VERSION_DEF
#define MAGNUS_VERSION_STRING MAIL_VERSION_STRING

#elif defined(MCC_BATMAN)
#define MAGNUS_VERSION BATMAN_VERSION_DEF
#define MAGNUS_VERSION_STRING BATMAN_VERSION_STRING

#endif

/* Used in some places as a length limit on error messages */
#define MAGNUS_ERROR_LEN 8192

/* Carraige return and line feed */
#define CR 13
#define LF 10
#ifdef XP_WIN32
#define ENDLINE "\r\n"
#else
#define ENDLINE "\n"
#endif

/* -------------------------- System version on NT------------------------- */

/* Encode the server version as a number to be able to provide inexpensive
 * dynamic checks on server version - this isn't added in yet. */

#define ENTERPRISE_VERSION 1  
#define PERSONAL_VERSION 2       
#define CATALOG_VERSION 3      
#define RDS_VERSION 4       
#define CMS_VERSION 5
#define DS_VERSION 6

/* Return server version */
NSAPI_PUBLIC char *system_version();

#define server_fasttrack (!strcmp(MAGNUS_VERSION_STRING, PERSONAL_VERSION_STRING))
#define server_enterprise (!strcmp(MAGNUS_VERSION_STRING, ENTERPRISE_VERSION_STRING))

/* This definition of MAGNUS_VERSION_STRING on NT should be used
 * only when building the ns-http DLL */

#if defined(MCC_HTTPD) && defined(XP_WIN32) && !defined(USE_ADMSERV) && !defined(MCC_ADMSERV)
#define MAGNUS_VERSION_STRING system_version()
#endif /* XP_WIN32 */

/* Set server's version dynamically */
NSAPI_PUBLIC void system_version_set(char *ptr);

/* -------------------------- Memory allocation --------------------------- */


#include <stdlib.h>

/*
   Depending on the system, memory allocated via these macros may come from 
   an arena. If these functions are called from within an Init function, they 
   will be allocated from permanent storage. Otherwise, they will be freed 
   when the current request is finished.
 */

#define MALLOC(size) system_malloc(size)
NSAPI_PUBLIC void *system_malloc(int size);

#define CALLOC(size) system_calloc(size)
NSAPI_PUBLIC void *system_calloc(int size);

#define REALLOC(ptr, size) system_realloc(ptr, size)
NSAPI_PUBLIC void *system_realloc(void *ptr, int size);

#define FREE(ptr) system_free((void *) ptr)
NSAPI_PUBLIC void system_free(void *ptr);

#define STRDUP(ptr) system_strdup(ptr)
NSAPI_PUBLIC char *system_strdup(char *ptr);

/*
   These macros always provide permanent storage, for use in global variables
   and such. They are checked at runtime to prevent them from returning NULL.
 */

#ifndef MALLOC_DEBUG
#define PERM_MALLOC(size) system_malloc_perm(size)
NSAPI_PUBLIC void *system_malloc_perm(int size);

#define PERM_CALLOC(size) system_calloc_perm(size)
NSAPI_PUBLIC void *system_calloc_perm(int size);

#define PERM_REALLOC(ptr, size) system_realloc_perm(ptr, size)
NSAPI_PUBLIC void *system_realloc_perm(void *ptr, int size);

#define PERM_FREE(ptr) system_free_perm((void *) ptr)
NSAPI_PUBLIC void system_free_perm(void *ptr);

#define PERM_STRDUP(ptr) system_strdup_perm(ptr)
NSAPI_PUBLIC char *system_strdup_perm(char *ptr);
#else
#define PERM_MALLOC(size) system_malloc_perm(size, __LINE__, __FILE__)
NSAPI_PUBLIC void *system_malloc_perm(int size, int line, char *file);

#define PERM_CALLOC(size) system_calloc_perm(size, __LINE__, __FILE__)
NSAPI_PUBLIC void *system_calloc_perm(int size, int line, char *file);

#define PERM_REALLOC(ptr, size) system_realloc_perm(ptr, size, __LINE__, __FILE__)
NSAPI_PUBLIC void *system_realloc_perm(void *ptr, int size, int line, char *file);

#define PERM_FREE(ptr) system_free_perm((void *) ptr, __LINE__, __FILE__)
NSAPI_PUBLIC void system_free_perm(void *ptr, int line, char *file);

#define PERM_STRDUP(ptr) system_strdup_perm(ptr, __LINE__, __FILE__)
NSAPI_PUBLIC char *system_strdup_perm(char *ptr, int line, char *file);
#endif


/* Not sure where to put this. */
NSAPI_PUBLIC void magnus_atrestart(void (*fn)(void *), void *data);

#endif
