/*
 * Copyright (c) 1994, 1995.  Netscape Communications Corporation.  All
 * rights reserved.
 * 
 * Use of this software is governed by the terms of the license agreement for
 * the Netscape FastTrack or Netscape Enterprise Server between the
 * parties.
 */


/* ------------------------------------------------------------------------ */


/*
 * conf.h: Deals with the server configuration file.
 * 
 * Object configuration is an entirely different matter. This deals with
 * things like what port the server runs on, how many children it spawns,
 * and other server-related issues. Information related configuration is
 * handled by the object conf.
 * 
 * Rob McCool
 */


#ifndef CONF_H
#define CONF_H

#include "netsite.h"
#include "frame/objset.h"
#include "base/daemon.h"		/* daemon struct */


#ifdef XP_UNIX
#include <pwd.h>      /* struct passwd */
#endif /* XP_UNIX */

/* ------------------------------ Constants ------------------------------- */


/* The longest line in the configuration file */
#define CONF_MAXLEN 16384

#define LF 10
#define CR 13


#if defined(DAEMON_ANY)
#ifdef MCC_PROXY
#define DEFAULT_PORT 8080
#else
#define DEFAULT_PORT 80
#endif
#endif

#if defined(DAEMON_UNIX_MOBRULE) || defined(DAEMON_WIN32)
#define DEFAULT_POOL_MAX 50
#endif



/* ------------------------------- Globals -------------------------------- */



/*
 * These server parameters are made global because they really don't
 * belong anywhere else. 
 */


#include <sys/types.h>

/* These can't be macros because they're used in daemon.h. */
extern char *pidfn;
extern int port;
extern char *chr;

#ifdef NET_SSL
extern char *secure_keyfn;
extern char *secure_certfn;
extern int secure_auth;
#endif

typedef struct {

    /* What port we listen to */
    int Vport;

    /* What address to bind to */
    char *Vaddr;

    /* User to run as */
#define userpw conf_getglobals()->Vuserpw
    struct passwd *Vuserpw;

    /* Directory to chroot to */
    char *Vchr;

    /* Where to log our pid to */
    char *Vpidfn;

#if defined(DAEMON_UNIX_MOBRULE) || defined(DAEMON_WIN32)
    /* The maximum number of processes to keep in the pool */
#define pool_max conf_getglobals()->Vpool_max
    int Vpool_max;
    /* The minimum number of processes to keep in the pool */
#define pool_min conf_getglobals()->Vpool_min
    int Vpool_min;
    /* The maximum number of requests each process should handle. -1=default */
#define pool_life conf_getglobals()->Vpool_life
    int Vpool_life;
#endif /* DAEMON_UNIX_MOBRULE || DAEMON_WIN32 */
#ifdef THREAD_ANY
    /* For multiprocess UNIX servers, the maximum threads per process */
#define pool_maxthreads conf_getglobals()->Vpool_maxthreads
    int Vpool_maxthreads;
    /* For multiprocess UNIX servers, the minimum threads per process */
#define pool_minthreads conf_getglobals()->Vpool_minthreads
    int Vpool_minthreads;
#endif
#ifdef NET_SSL

    char *Vsecure_keyfn;
    char *Vsecure_certfn;

#define security_active conf_getglobals()->Vsecurity_active
    int Vsecurity_active;
#define ssl3_active conf_getglobals()->Vssl3_active
    int Vssl3_active;
#define ssl2_active conf_getglobals()->Vssl2_active
    int Vssl2_active;
    int Vsecure_auth;
#define security_session_timeout conf_getglobals()->Vsecurity_session_timeout
    int Vsecurity_session_timeout;
#define ssl3_session_timeout conf_getglobals()->Vssl3_session_timeout
    long Vssl3_session_timeout;

#endif /* NET_SSL */

    /* The server's hostname as should be reported in self-ref URLs */
#define server_hostname conf_getglobals()->Vserver_hostname
    char *Vserver_hostname;

    /* The main object from which all are derived */
#define root_object conf_getglobals()->Vroot_object
    char *Vroot_object;

    /* The object set the administrator has asked us to load */
#define std_os conf_getglobals()->Vstd_os
    httpd_objset *Vstd_os;

    /* The root of ACL data structures */
    void *Vacl_root;
#define acl_root conf_getglobals()->Vacl_root

    /* The main error log, where all errors are logged */
#define master_error_log conf_getglobals()->Vmaster_error_log
    char *Vmaster_error_log;

#ifdef XP_WIN32
    /* The server root ( in which the server sits while executing ) */
#define server_root conf_getglobals()->Vserver_root
    char *Vserver_root;

    /* This server's id */
#define server_id conf_getglobals()->Vserver_id
    char *Vserver_id;

#endif /* XP_WIN32 */

    int single_accept;		/* daemon mode  Internal use only */
    int num_keep_alives;	/* number of KA threads Internal use only */
    int log_verbose;		/* Flag to log LOG_VERBOSE messages */
    int mmap_flags;		/* mmap flags for file cache mmaping - internal use only */
    int mmap_prots;		/* mmap prots for file cache mmaping - internal use only */
    int mp_optimization;	/* let nscp do mp optimizations - internal use only */
    int concurrency;		/* set concurrency for threading system */

} conf_global_vars_s;



/* ------------------------------ Prototypes ------------------------------ */


/*
 * conf_init reads the given configuration file and sets any non-default
 * parameters to their given setting.
 */

NSAPI_PUBLIC char *conf_init(char *cfn);
/*
 * conf_terminate frees any data the conf routines may be holding.
 */

NSAPI_PUBLIC void conf_terminate(void);


/*
 * Get a structure with the global variables for this server.
 */
NSAPI_PUBLIC conf_global_vars_s *conf_getglobals(void);


/*
 * conf_vars2daemon transfers these globals to a daemon structure 
 */
NSAPI_PUBLIC void conf_vars2daemon(daemon_s *d);

#ifdef XP_WIN32

NSAPI_PUBLIC BOOLEAN GetDomainAddresses(PCHAR ErrMsg);

#endif /* XP_WIN32 */

#endif
