/*
 * defines for the malloc-leap routines.
 *
 * Copyright 1993 by the Antaire Corporation
 *
 * This file is part of the malloc-debug package.
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose and without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies, and that
 * the name of Antaire not be used in advertising or publicity pertaining to
 * distribution of the document or software without specific, written prior
 * permission.
 *
 * The Antaire Corporation makes no representations about the suitability of
 * the software described herein for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * The author may be contacted at gray.watson@antaire.com
 *
 * $Id: malloc_lp.h,v 1.13 1994/03/21 14:58:56 gray Exp $
 */

#ifndef __MALLOC_LP_H__
#define __MALLOC_LP_H__

#include "malloc_loc.h"			/* for IMPORT */

#define DEBUG_PRE_NONE		(-1)	/* no pre debug call */

/*<<<<<<<<<<  The below prototypes are auto-generated by fillproto */

/* to inform the malloc-debug library from which file the call comes from */
IMPORT	char		*_malloc_file;

/* to inform the library from which line-number the call comes from */
IMPORT	unsigned int	_malloc_line;

/* pre-set malloc_debug() value before the library is setup */
IMPORT	int		_malloc_debug_preset;

/* pointers to shutdown function to allow calls without linked routine */
IMPORT	void		(*_malloc_shutdown_func)();

/* pointers to log_heap_map function to allow calls without linked routine */
IMPORT	void		(*_malloc_log_heap_map_func)();

/* pointers to log_stats function to allow calls without linked routine */
IMPORT	void		(*_malloc_log_stats_func)();

/* pointers to log_unfreed function to allow calls without linked routine */
IMPORT	void		(*_malloc_log_unfreed_func)();

/* pointers to verify function to allow calls without linked routine */
IMPORT	int		(*_malloc_verify_func)();

/* pointers to debug function to allow calls without linked routine */
IMPORT	void		(*_malloc_debug_func)();

/* pointers to debug_current function to allow calls without linked routine */
IMPORT	int		(*_malloc_debug_current_func)();

/* pointers to examine function to allow calls without linked routine */
IMPORT	int		(*_malloc_examine_func)();

/* pointers to strerror function to allow calls without linked routine */
IMPORT	char		*(*_malloc_strerror_func)();

/*
 * leap routine to calloc
 */
IMPORT	void	*_calloc_leap(const char * file, const int line,
			      MALLOC_SIZE elen, MALLOC_SIZE size);

/*
 * leap routine to free
 */
#if defined(__STDC__) && __STDC__ == 1
EXPORT	void	_free_leap(const char * file, const int line, void * pnt);
#else
EXPORT	int	_free_leap(const char * file, const int line, void * pnt);
#endif

/*
 * leap routine to malloc
 */
IMPORT	void	*_malloc_leap(const char * file, const int line,
			      MALLOC_SIZE size);

/*
 * leap routine to realloc
 */
IMPORT	void	*_realloc_leap(const char * file, const int line, void * oldp,
			       MALLOC_SIZE new_size);

/*
 * leap routine to calloc with error checking
 */
EXPORT	void	*_xcalloc_leap(const char * file, const int line,
			       MALLOC_SIZE elen, MALLOC_SIZE size);

/*
 * leap routine to free
 */
#if defined(__STDC__) && __STDC__ == 1
EXPORT	void	_xfree_leap(const char * file, const int line, void * pnt);
#else
EXPORT	int	_xfree_leap(const char * file, const int line, void * pnt);
#endif

/*
 * leap routine to malloc with error checking
 */
EXPORT	void	*_xmalloc_leap(const char * file, const int line,
			      MALLOC_SIZE size);

/*
 * leap routine to realloc with error checking
 */
EXPORT	void	*_xrealloc_leap(const char * file, const int line, void * oldp,
				MALLOC_SIZE new_size);

/*
 * routine to call malloc_shutdown when linked in
 */
IMPORT	void	malloc_shutdown(void);

/*
 * routine to call malloc_verify when linked in
 */
#if defined(__STDC__) && __STDC__ == 1
IMPORT	int	malloc_verify(const void * pnt);
#else
IMPORT	int	malloc_verify(const char * pnt);
#endif

/*
 * routine to call malloc_log_unfreed when linked in
 */
IMPORT	void	malloc_log_unfreed(void);

/*
 * routine to call malloc_log_stats when linked in
 */
IMPORT	void	malloc_log_stats(void);

/*
 * routine to call malloc_log_heap_map when linked in
 */
IMPORT	void	malloc_log_heap_map(void);

/*
 * routine to call malloc_debug when linked in
 */
IMPORT	void	malloc_debug(const int debug);

/*
 * routine to call malloc_debug_current when linked in
 */
IMPORT	int	malloc_debug_current(void);

/*
 * routine to call malloc_examine when linked in
 */
#if defined(__STDC__) && __STDC__ == 1
IMPORT	int	malloc_examine(const void * pnt, MALLOC_SIZE * size,
			       char ** file, unsigned int * line,
			       void ** ret_attr);
#else
IMPORT	int	malloc_examine(const char * pnt, MALLOC_SIZE * size,
			       char ** file, unsigned int * line,
			       char ** ret_attr);
#endif

/*
 * routine to call malloc_strerror when linked in
 */
IMPORT	char	*malloc_strerror(const int errnum);

/*<<<<<<<<<<   This is end of the auto-generated output from fillproto. */

#endif /* ! __MALLOC_LP_H__ */
