/*
 * header file for compatibility functions.
 *
 * Copyright 1993 by the Antaire Corporation
 *
 * This file is part of the malloc-debug package.
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose and without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies, and that
 * the name of Antaire not be used in advertising or publicity pertaining to
 * distribution of the document or software without specific, written prior
 * permission.
 *
 * The Antaire Corporation makes no representations about the suitability of
 * the software described herein for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * The author may be contacted at gray.watson@antaire.com
 *
 * $Id: compat.h,v 1.17 1993/11/23 03:26:00 gray Exp $
 */

#ifndef __COMPAT_H__
#define __COMPAT_H__

#include "conf.h"				/* for HAVE... */
#include "malloc_loc.h"				/* for IMPORT ... */

/*<<<<<<<<<<  The below prototypes are auto-generated by fillproto */

/*
 * return a fake pid for brain-dead systems without getpid()
 */
#if HAVE_GETPID == 0
IMPORT	int	getpid(void);
#endif

/*
 * return a fake time for brain-dead systems without time()
 */
#if HAVE_TIME == 0
IMPORT	long	time(long * timep);
#endif

/*
 * copy LEN characters from SRC to DEST
 */
#if HAVE_BCOPY == 0
IMPORT	void	bcopy(const char * src, char * dest, MALLOC_SIZE len);
#endif

/*
 * compare LEN characters, return -1,0,1 if STR1 is <,==,> STR2
 */
#if HAVE_BCMP == 0
IMPORT	int	bcmp(const char * str1, const char * str2, MALLOC_SIZE len);
#endif

/*
 * set LEN characters in STR to character CH
 */
#if HAVE_MEMSET == 0
IMPORT	char	*memset(char * str, int ch, MALLOC_SIZE len);
#endif

/*
 * find CH in STR by searching backwards through the string
 */
#if HAVE_INDEX == 0
IMPORT	char	*index(const char * str, int ch);
#endif

/*
 * find CH in STR by searching backwards through the string
 */
#if HAVE_RINDEX == 0
IMPORT	char	*rindex(const char * str, int ch);
#endif

/*
 * concatenate STR2 onto the end of STR1
 */
#if HAVE_STRCAT == 0
IMPORT	char	*strcat(char * str1, const char * str2);
#endif

/*
 * returns -1,0,1 on whether STR1 is <,==,> STR2
 */
#if HAVE_STRCMP == 0
IMPORT	int	strcmp(const char * str1, const char * str2);
#endif

/*
 * return the length in characters of STR
 */
#if HAVE_STRLEN == 0
IMPORT	MALLOC_SIZE	strlen(const char * str);
#endif

/*
 * get the next token from STR (pass in NULL on the 2nd, 3rd, etc. calls),
 * tokens are a list of characters deliminated by a character from DELIM.
 * writes null into STR to end token.
 */
#if HAVE_STRTOK == 0
IMPORT	char	*strtok(char * str, char * delim);
#endif

/*<<<<<<<<<<   This is end of the auto-generated output from fillproto. */

#endif /* ! __COMPAT_H__ */
