#!/usr/local/bin/perl
# checklinks - barr@math.psu.edu (David Barr)  Aug 1995
# go through a history file, for each article crossposted verify that
# the files are linked and not a copy.  If not, add link/symlink.

open(HISTORY,"</home/news/history");
chdir("/home/news/spool") || die "Cant cd to spool: $!\n";

while (<HISTORY>) {
	split(/\t/);
	next unless ($_[2]);	# skip expired articles
	@file=split(" ",$_[2]);
	next if ($#file == 0);	# skip non-crossposted articles
	$mfile=shift(@file);
	$mfile=~ tr-.-/-;
	($mdev,$mino,$mnlink,$j,$j,$j,$j,$j,$j,$j,$j,$j)=stat($mfile);
	next unless ($mdev);			# skip if missing
	next if ($mnlink == ($#file+1));	# skip if link count is OK
	foreach $f (@file) {
		$f=~ tr-.-/-;
		($dev,$ino,$nlink,$j,$j,$j,$j,$j,$j,$j,$j,$j)=stat($f);
		unless ($dev) {
			&makelink($mfile,$f);	# link if not exists
			next;
		}
		next if ($ino == $mino);	# skip if already linked
		&makelink($mfile,$f) if (readlink($f) ne "/home/news/spool/$mfile");
	}
}

sub makelink {
	unlink($_[1]);
	unless (link($_[0],$_[1])) {
		symlink("/home/news/spool/" . $_[0],"/home/news/spool/" . $_[1]);
		print "symlinked /home/news/spool/$_[0] to /home/news/spool/$_[1]\n";
		return 0;
	}
	print "linked $_[0] to $_[1]\n";
	return 0;
}
