/* WIDE AREA INFORMATION SERVER SOFTWARE	
   No guarantees or restrictions.  See the readme file for the full standard 
   disclaimer.
   5.29.90	Harry Morris, morris@think.com
*/

/* Copyright (c) CNIDR (see ../doc/CNIDR/COPYRIGHT) */


/* this file is a server process for a unix machine that takes input from 
   standard in or from a socket and searches the local search engine on the 
   unix box.
   originally written by harry morris.
   modified by brewster kahle. 7/90
   6.xx.90	Brewster - initial implementation of stdio interface
   7.xx.90	Patrick Bray - support for headers and forking processes
   90.07.31	Ephraim - support for logging 

   91.03.03     Jonathan - set searchLog to log_out.
   91.05.23	Jonathan - added fork process for indexer.
                           Fixed version display so it exits.
   91.05.25     Jonathan - added setuid.
   
   Tue Jul  9 12:11:02 1991 -- Michael Haberler mah@wu-wien.ac.at

                Added semi-intelligent INFO database indexing (only done if
		any of the .src files is newer than INFO.dct)
		
		Locking against multiple concurrent INFO rebuilds if 
		running under inetd

		Use scandir() for directory operations

		Works under inetd as well as standalone. Here are my inetd.conf
   		entries (not the missing userid in the Ultrix inetd.conf!):

   hpux 7.0/800, Interactive/386 2.2.1:
	z3950 stream tcp nowait root /usr/local/etc/waisserver waisserver -s \
		-d /usr/logins/mah/wais-sources

   Ultrix 4.1:
	z3950 stream tcp nowait /usr/local/etc/waisserver waisserver -s \
		-d /usr/logins/mah/wais-sources

   Also, add the next line to /etc/services, and tickle your YP server:
	z3950           210/tcp         # wide area information server (wais)

 * $Log: waisserver.c,v $
 * Revision 1.2  1996/06/04 23:37:09  julia
 * Fixed warnings
 *
 * Revision 1.1.1.1  1996/06/04 20:36:52  julia
 * autoconf baseline
 *
 * Revision 1.1.1.1  1996/04/30 18:22:34  dmitriy
 * Version 2.1 -- autoconf baseline
 *
 * Revision 1.1.1.2  1996/04/23  19:44:09  dmitriy
 * autoconf baseline
 *
 * Revision 2.0.1.8  1995/12/06 11:05:25  pfeifer
 * patch53: Replaced include of <sys/file.h> by "cdialect.h" (Patch from
 * patch53: Rodney Barnett).
 *
 * Revision 2.0.1.7  1995/10/20  17:10:19  pfeifer
 * patch40: Fixed the sys_errlist stuff (for the last time?).
 *
 * Revision 2.0.1.6  1995/10/10  19:03:45  pfeifer
 * patch35: Not all compilers know elseif :-(
 *
 * Revision 2.0.1.6  1995/10/10  19:03:45  pfeifer
 * patch35: Not all compilers know elseif :-(
 *
 * Revision 2.0.1.5  1995/10/06  07:25:17  pfeifer
 * patch22: Added sys_errlist hack for BSD.
 *
 * Revision 2.0.1.4  1995/10/04  17:23:55  pfeifer
 * patch20: replaced HAVE_SYS_SELECT_H by I_SYS_SELECT.
 *
 * Revision 2.0.1.3  1995/09/15  09:49:45  pfeifer
 * patch7: Fixed CNIDR copyright line.
 *
 * Revision 2.0.1.2  1995/09/11  12:58:06  pfeifer
 * patch4: Streamlined sys/file.h, fcntl.h, and sys/fcntl.h stuff. Set
 * patch4: return type of signal handlers to Signal_t.
 *
 * Revision 2.0.1.1  1995/09/08  19:23:11  pfeifer
 * patch1: Gcc did not accept struct sigcontext* in prototype. Added a
 * patch1: typedef struct sigcontext sigcontext_t and it magically
 * patch1: worked!
 *
 * Revision 2.0  1995/09/08  08:02:34  pfeifer
 * Metaconfig baseline
 *
 * Revision 1.21  1995/02/21  14:13:48  pfeifer
 * From: Alberto Accomazzi <alberto@cfa0.harvard.edu>
 *
 * here's a patch to allow waisserver to fork off and become a session
 * leader.  This becomes important on some systems when you want to start
 * the server at boot time.  For example, on my HP, after executing
 * /etc/rc the system kills all child processes generated by the script,
 * so without this option I wouldn't be able to start up the server.
 *
 * The fix relies on a small portion of code that I stole from the NCSA
 * httpd source.  It seems to work fine on suns (4.1.3 and solaris 2.3)
 * and HP 9000 (HP-UX 9.01).  I left the #ifdefs in the code for detach()
 * but as far as I can tell from the original HTTP code they there is no
 * need to define NO_SETSID except on the NEXT and SEQUENT, and since I
 * didn't find any ifdefs for these architectures in the rest of the
 * code, I didn't bother with setting the flag at all.
 *
 * Revision 1.20  1994/12/13  18:52:45  pfeifer
 * chip@chinacat.unicom.com (Chip Rosenthal) patches.
 * Excluding the merge of libinv and libwais
 *
 * Revision 1.19  1994/11/28  14:00:21  pfeifer
 * typo
 *
 * Revision 1.18  1994/11/22  16:39:56  pfeifer
 * "matthew (m.) holiday" <holiday@bnr.ca>: There's an fflush() call
 * missing in file waisserver.c just before the call to rewind(in).  This
 * was a reported issue in freeWais 0.3 with respect to HPUX, that
 * doesn't seem to have made it across to freeWais-sf.
 *
 * Revision 1.17  1994/09/09  09:00:32  pfeifer
 * Fixed the MAX_OCCURANCES - STOP_WORD_FLAG bug
 *
 * Revision 1.16  1994/09/05  10:18:59  pfeifer
 * Removed buggy init_add_word call
 *
 * Revision 1.15  1994/09/05  10:17:32  pfeifer
 * shm patch
 *
 * Revision 1.14  1994/08/23  12:34:00  pfeifer
 * Made client fork #undef'able
 * Fixed umr bug
 *
 * Revision 1.13  1994/08/13  16:55:21  pfeifer
 * added call to sayiamhere
 *
 * Revision 1.12  1994/08/12  17:46:29  pfeifer
 * initialize dataops in main with zeroes.
 *
 * Revision 1.11  1994/08/08  07:33:01  pfeifer
 * Moved wais_log_file_name and waislogfile to cutil.[ch]
 *
 * Revision 1.10  1994/08/05  07:12:58  pfeifer
 * Release beta 04
 *
 * Revision 1.8  1994/05/20  12:58:39  pfeifer
 * beta
 *
 * Revision 1.7  1994/03/23  12:57:16  huynh1
 * calling of openDatabase and init_add_word modified.
 * patchlevel 07.
 *
 * Revision 1.6  1994/03/21  17:27:40  huynh1
 * patchlevel 07.
 *
 * Revision 1.5  1994/03/11  15:29:34  huynh1
 * write_src_structure modified.
 * Patchlevel 05.
 *
 * Revision 1.4  1994/03/08  21:07:12  pfeifer
 * Patchlevel 04
 *
 * Revision 1.3  93/07/21  18:52:39  warnock
 * Renamed from server.c.
 * Added STELAR-specific patches
 * 
 * Revision 1.2  93/07/01  19:19:53  warnock
 * gethostname -> mygethostname
 * 
 * Revision 1.1  1993/02/16  15:05:35  freewais
 * Initial revision
 *
 * Revision 1.48  92/05/10  14:47:39  jonathan
 * Update for release.
 * 
 * Revision 1.47  92/05/06  17:34:01  jonathan
 * Changed auto-indexing of .src files to use filename_finish_header_function.
 * 
 * Revision 1.46  92/05/04  17:18:32  jonathan
 * Fixed use of merge_pathname in creating INFO database.
 * 
 * Revision 1.45  92/04/28  15:19:18  jonathan
 * Added decoding of IP address to DNS name in init message handler.
 * 
 * Revision 1.44  92/03/26  18:26:41  jonathan
 * Added extra arguments to index_text_file call.
 * 
 * Revision 1.43  92/03/07  19:41:47  jonathan
 * Added IBM defines, courtesy mycroft@hal.gnu.ai.mit.edu,
 * 
 * Revision 1.42  92/03/05  07:07:58  shen
 * add two more dummy arguments to call to init_search_engine
 * 
 * Revision 1.41  92/02/27  09:58:50  jonathan
 * Put back in setting of core limit to max value, when SET_LIMIT is defined.
 * 
 * Revision 1.40  92/02/24  10:07:41  jonathan
 * Removed reporting functions.
 * 
 * Revision 1.39  92/02/21  12:27:15  jonathan
 * Changed logging of segmentation violation and bus errors to mark log with
 * an error code, and close code.
 * 
 * Revision 1.38  92/02/21  11:00:45  jonathan
 * Added wais_log_level
 * 
 * Revision 1.37  92/02/19  10:16:25  jonathan
 * Added build_catalog to auto-indexer.
 * 
 * Revision 1.36  92/02/16  12:33:21  jonathan
 * Removed code refering to NOINETNTOA, since we should use inet_ntoa.
 * 
 * Revision 1.35  92/02/16  12:05:18  jonathan
 * Added code for GCC incompatibility in inet_ntoa (passing structure as
 * pointer).
 * 
 * Revision 1.34  92/02/14  09:07:34  jonathan
 * Set MAXNAPTIME to 0 so it won't sleep.  Changed the WLOG_ERROR to
 * WLOG_WARNING in the log entry.
 * 
 * Revision 1.33  92/02/12  13:44:20  jonathan
 * Added "$Log" so RCS will put the log message in the header
 * 
 * 
 */

#define SERVER_DATE "Fri April 9 1993"

#ifndef lint
static char *RCSid = "$Header: /usr/local/cvs/wais/freeWAIS-sf-2.1/ir/waisserver.c,v 1.2 1996/06/04 23:37:09 julia Exp $";
#endif

#define INFO_DICT    "INFO.dct"
#define LOCKFILE    "/tmp/INFO.lock" /* while re-indexing INFO */
#define NAPTIME     1		     /* seconds */
#define MAXNAPTIME  0		/* Don't wait, just go on. */

#include "server.h"
#include "sockets.h"
#include <sys/stat.h>
#include "cdialect.h"

#ifdef HAVE_FCNTL_H
#include <fcntl.h>
#else 
#include <sys/fcntl.h>
#endif 

#ifdef SYSV			
#define SIGCHLD SIGCLD
#endif
#include <signal.h>

#ifdef HAVE_SYS_SELECT
#include <sys/select.h>
#endif
#include "cdialect.h"
#include "panic.h"
#include "ustubs.h"
#include "transprt.h"
#include "wmessage.h"
#include "ir.h"
#include "wprot.h"
#include "cutil.h"
#include "futil.h"
#include "irext.h"
#include "irsearch.h"

/* to create the INFO index */
#include "irtfiles.h"
#include "irfiles.h"
#include "irhash.h"

#include <errno.h>
#ifdef Mach 
extern int errno;
#endif

static long bufferSize = BUFSZ; /* how much we are using
                                   (we get one of these per process) */


/* Bitmap association table -- LEB/HSTX 8/5/92 */
#ifdef STELAR
#define LOOKUP_TABLE /archives/stelar/abs/wais/bitmap.table

char *bitmap_table = "LOOKUP_TABLE";

/* char *bitmap_table = "/archives/stelar/abs/wais/bitmap.table"; */
#endif /* STELAR */

/*---------------------------------------------------------------------------*/

#define TIMEOUT_LENGTH 3600 /* one hour timeout. */
#define IDLE_TIME "1 hour"

void
serve_client(in,out, index_directory)
FILE* in;
FILE* out;
char *index_directory;
{ 
  char buf[BUFSZ];		/* contains the message and header */
  char *bufPtr ;		/* points at the begining of the z3950 */
  long size;			/* bytes in the z3950 message */
  WAISMessage header;		/* for storing the header */
  long i;
  long bytesLeft;
  struct itimerval new, old;
  long nextChar;

  new.it_interval.tv_sec = 0;
  new.it_interval.tv_usec = 0;
  new.it_value.tv_sec = TIMEOUT_LENGTH;
  new.it_value.tv_usec = 0;

  bzero(buf, BUFSZ*sizeof(char)); /* avoid umr (up)/8/94 */
  getitimer(ITIMER_REAL, &old);
  while (TRUE)
    {
      /* try to read the header */
      for (i = 0; i < HEADER_LENGTH; i++)
	{ 
	  setitimer(ITIMER_REAL, &new, NULL);
	  nextChar = fgetc(in);
	  if (nextChar == EOF)	/* my connection exited, so will I */
	    { 
	      return;
	    }
	  else
	    buf[i] = (char)nextChar;
	}

      setitimer(ITIMER_REAL, &old, NULL);
      /* parse the header */
      readWAISPacketHeader(buf,&header);

      /* make sure we have the right version.  
	 If we dont, we dont know what to do. */
      if (header.hdr_vers > HEADER_VERSION)
	panic("Incompatable header versions (Current version: %c, supplied version: %c.", 
	      HEADER_VERSION, header.hdr_vers) ;

      /* determine the size of the z3950 message */
      {
	char length_array[11];
	strncpy(length_array, header.msg_len, 10);
	length_array[10] = '\0';
	size = atol(length_array);
      }

      /* set bufPtr to start the z3950 message */
      bufPtr = buf + HEADER_LENGTH ;

      /* read the z3950 message */
      for (i = 0; i < size ; i++) {
	setitimer(ITIMER_REAL, &new, NULL);
	buf[i + HEADER_LENGTH] = (char)fgetc(in) ;
      }

      fflush(in);
      rewind(in);

      /* decode the z3950 if necessary */
      transportDecode((long)header.encoding,bufPtr,&size);
     
      /* XXX handle compression options */

      /* process it the z3950 */
      bytesLeft = bufferSize;

      size = interpret_buffer(bufPtr,size,bufPtr,bytesLeft,
			      &bufferSize,(long)header.hdr_vers,
			      index_directory); 

      /* re-encode the message if necessary */
      transportCode((long)header.encoding,bufPtr,&size); 

      /* XXX handle compression options */

      /* write the new header */
      writeWAISPacketHeader(buf,size,
			    (long)header.msg_type,header.server,
			    (long)header.compression,(long)header.encoding,
			    (long)header.hdr_vers);

      /* write the whole response to the output file */
      for (i = 0; i < size + HEADER_LENGTH; i++)
	fputc(buf[i],out) ;

      fflush(out);		/* flush any file buffers */
      rewind(out);		/* reset the file for read */

    }
}

/*---------------------------------------------------------------------------*/

typedef struct sigcontext sigcontext_t;
#ifndef ISC
static void breakKey (long s1,long s2, sigcontext_t *s3,char* s4);
#endif

static void
breakKey (s1,s2,s3,s4)
long s1;
long s2;
struct sigcontext *s3;
char *s4;
{
  if(0 != finished_search_engine())
    panic("unable to close search engine");
  panic ("got a ^c");
}

/*---------------------------------------------------------------------------*/

void
childhandler(sig, code, scp, addr)
long sig, code;
struct sigcontext *scp;
char *addr;
{
  wait(NULL);			/* give the kid a decent burial */
  signal (SIGCHLD, childhandler);  /* Dave Judd - IRIX requires resetting signal */
}

/*---------------------------------------------------------------------------*/

void
alarmhandler(sig, code, scp, addr)
long sig, code;
struct sigcontext *scp;
char *addr;
{
  waislog(WLOG_HIGH, WLOG_CLOSE,
	  "Server idle longer %s. Closing server and exiting.", IDLE_TIME);
  if(0 != finished_search_engine())
    panic("unable to close search engine");
  exit(0);
}

/*---------------------------------------------------------------------------*/

void
seghandler(sig, code, scp, addr)
long sig, code;
struct sigcontext *scp;
char *addr;
{
  waislog(WLOG_HIGH, WLOG_ERROR, "Segmentation violation.");
  waislog(WLOG_HIGH, WLOG_CLOSE, "Bummer. Closing server and exiting.");
#ifdef DUMPCORE
    abort();
#else
  exit(-1);
#endif
}

/*---------------------------------------------------------------------------*/

void
bushandler(sig, code, scp, addr)
long sig, code;
struct sigcontext *scp;
char *addr;
{
  waislog(WLOG_HIGH, WLOG_ERROR, "Bus error.");
  waislog(WLOG_HIGH, WLOG_CLOSE, "Bummer. Closing server and exiting.");
#ifdef DUMPCORE
    abort();
#else
  exit(-1);
#endif
}

/*---------------------------------------------------------------------------*/

#include <pwd.h>

int finduid(name)
char *name;
{
  struct passwd *pwent;

  if ((pwent = getpwnam(name)) == NULL) {
    return -1;
  }

  return(pwent->pw_uid);
}

static  char *index_dir = NULL;
static  time_t info_change_time;
static  int indexing_needed = 0;
static  char *info_dict = INFO_DICT;

extern int alphasort();

/* selecttion function for scandir()
 * trigger on ".src" extension, regular file, and != "INFO.src"
 * Indexing is needed if any of the .src files is younger than 
 * INFO.dct
 */
static int
srcfiles(e)
	Direntry_t *e;
{
	struct stat sb;
	char *lastdot = strrchr(e->d_name,'.');
	int candidate;

	candidate =	lastdot && 
	      (stat(merge_pathnames(e->d_name,index_dir), &sb) >= 0) && 
	      ((sb.st_mode & S_IFMT) == S_IFREG) &&
	      !strcmp(lastdot,source_ext) && 
	      strcmp(e->d_name,info_dict); /* whew */

        if (candidate) {
	    indexing_needed |= (sb.st_mtime > info_change_time);
	    return 1;
	}
	return 0;
}

/*---------------------------------------------------------------------------*/

#ifdef HAVE_SYS_ERRLIST
#ifdef EXTERN_SYS_ERRLIST
extern char *sys_errlist[];
#endif
extern int      errno;
extern int      sys_nerr;
#endif

#ifdef HAVE_SETSID 
pid_t pgrp;
#else
int pgrp;
#endif

/* detach() was stolen right off of NCSA's httpd */
static void 
detach() {
    int x;

    if((x = fork()) > 0)
        exit(0);
    else if(x == -1) {
	waislog(WLOG_HIGH, WLOG_ERROR, "Error: fork(): %s", 
		Strerror(errno));
        exit(1);
    }
#ifdef HAVE_SETSID
    if((pgrp=setsid()) == -1) {
	waislog(WLOG_HIGH, WLOG_ERROR, "Error: setsid(): %s", 
		Strerror(errno));
        exit(1);
    }
#else
    if((pgrp=setpgrp(getpid(),0)) == -1) {
	waislog(WLOG_HIGH, WLOG_ERROR, "Error: setpgrp(): %s", 
		Strerror(errno));
        exit(1);
    }
#endif    
}


/*---------------------------------------------------------------------------*/

#ifdef SET_LIMIT
#include <sys/resource.h>
#endif

#define INDEX_FORK

extern char *inet_ntoa ();
extern char *syslog_name;

void
main(argc,argv)
int argc;
char* argv[];
{ FILE *file;
  long socket;
  char *next_argument = next_arg(&argc, &argv), *command_name;
  boolean use_stdio = TRUE;		/* default is true */
  /* char *wais_log_file_name = NULL; */	/* name of file for error output */
  int child_proc;		/* for the child process id */
  char *uid_name = "root";	/* user id so setuid if root */
  int uid = 0;		/* if not specified, leave as root. */
  int child;
  long cm_mem_percent = 0;  /* default */
  struct stat statbuf;
  Direntry_t **list;
  int naptime = 0;
  extern void filename_finish_header_function();
  dataopsrec	dataops;  
  int detach_flag = 0;	/* if specified, fork and setsid() */

#ifdef CACHE_SYN
  int cachesyn = 0;
#endif

#ifdef SET_LIMIT
  struct rlimit rlp;

  getrlimit(RLIMIT_CORE, &rlp);
  rlp.rlim_cur = rlp.rlim_max;
  setrlimit(RLIMIT_CORE, &rlp);
  getrlimit(RLIMIT_DATA, &rlp);
  rlp.rlim_cur = rlp.rlim_max;
  setrlimit(RLIMIT_DATA, &rlp);
#endif

/* dgg -- must duplicate mods to irbuild.c, here is mini-build of INFO.src */
  bzero(&dataops,sizeof(dataops));
  dataops.separator_function= NULL;
  dataops.header_function= NULL;
  dataops.date_function= NULL;
  dataops.finish_header_function= filename_finish_header_function;
  dataops.type= "WSRC";
  dataops.wordDelimiter= wordbreak_notalnum;
  dataops.addseparatorwords= false;
  dataops.extraheaderweight= true;
  dataops.repeat_weight= 1;
  dataops.minwordlen= 2;
  stop_list_file("\0");
  gDelimiters[0]= '\0';  
  wordDelimiter= wordbreak_notalnum;   
/* dgg -- end new inits */

  tcp_port = 210;			/* tcp_port to use */
  command_name = next_argument;
  syslog_name = (syslog_name = (char *)rindex(command_name, '/')) ? (syslog_name + 1) : command_name;
  host_name[0] = 0;
  host_address[0] = 0;

  server_name = s_malloc(255);
  mygethostname(server_name, 255);

  wais_pid = getpid();

  if (!strcmp(command_name, "waisserver.d")) {
    struct sockaddr_in source;
    int sourcelen;

    sourcelen = sizeof(struct sockaddr_in);

    if (!getpeername(fileno(stdout),(struct sockaddr *)&source,&sourcelen)) {
      struct hostent *peer = NULL;

#ifdef __DGUX__
      peer = gethostbyaddr((char *)&source.sin_addr.s_addr, 4, AF_INET);
#else
      peer = gethostbyaddr((char *)&source.sin_addr, 4, AF_INET);
#endif

      if(peer != NULL) {
	sprintf(host_name, "%s", peer->h_name);

	sprintf(host_address, "%s",
#if defined(sparc) && defined(__GNUC__) && defined(INET_NTOA_WITH_POINTER)
		inet_ntoa(&source.sin_addr)
#else
		inet_ntoa(source.sin_addr)
#endif				/* sparc */
		);
      }
    }
    else sprintf(host_address, "Error getting socket: %d, %s.", errno, Strerror(errno));

   use_stdio = TRUE;
  }

  if (argc == 0){
#ifdef CACHE_SYN
    fprintf(stderr,"Usage: %s [-p [port_number]] [-s] [-d directory] [-u user] [-cmmem number] [-cachesyn] [-detach] [-v]\n",
#else
    fprintf(stderr,"Usage: %s [-p [port_number]] [-s] [-d directory] [-u user] [-cmmem number] [-detach] [-v]\n",
#endif
	   command_name);
    fprintf(stderr," -p [port] listen to the port.  If the port is supplied, then\n");
    fprintf(stderr,"    that tcp_port number is used.  If it is not supplied \n");
    fprintf(stderr,"    then the Z39.50 port (210) is used.\n");
    fprintf(stderr," -d directory: means to use the directory as the source of databases.\n");
    fprintf(stderr,"    Defaults to the current directory.\n");
    fprintf(stderr," -e [file]: set log output to file, or /dev/null if not specified.\n");
    fprintf(stderr," -l log_level: set log level.  0 means log nothing,\n");
    fprintf(stderr,"    10 [the default] means log everything.\n");
    fprintf(stderr," -s means listen to standard I/O for queries.  This is the default\n");
    fprintf(stderr," -u user: if started as root, setuid to user after startup.\n");
    fprintf(stderr," -cmmem number: percentage of CM memory to use (CM code only).\n");
#ifdef CACHE_SYN
    fprintf(stderr," -cachesyn: cache synonym table in shared memory (default is don't cache)\n");
#endif
    fprintf(stderr," -detach: fork off a new process and make it the session leader.\n");
    fprintf(stderr,"          (useful when starting from boot scripts)\n");
    fprintf(stderr," -v prints the version.\n");
    exit(1);
  }
  if(NULL == (next_argument = next_arg(&argc, &argv))){
    fprintf(stderr,"No arguments specified\n");
    exit(0);
  }
  while((next_argument != NULL) &&
	('-' == next_argument[0])){

    /* then we have an argument to process */
    if (0 == strcmp("-p", next_argument)){
      char *peek_argument = peek_arg(&argc, &argv);
      use_stdio = FALSE;
      if ((NULL != peek_argument) && /* if we are not out of args */
	  ('-' != peek_argument[0])){ { /* and the next isn't an option... */
	    /* get the port number */
	    tcp_port = atoi(next_arg(&argc, &argv));
	  }			/* end if (explicit tcp_port) */
				    }
    }				/* end if (-p) */
    else if (0 == strcmp("-s", next_argument)){
      use_stdio = TRUE;
    }				/* end if (-s) */

    else if (0 == strcmp("-e", next_argument)) {
      char *peek_argument = peek_arg(&argc, &argv);
      wais_log_file_name = "/dev/null"; /* default to /dev/null */
      if ((peek_argument != NULL) &&
	  ('-' != peek_argument[0])) {
	wais_log_file_name = next_arg(&argc, &argv);
      }				/* end if (explicit log file) */
    }				/* end if (-e) */
    else if (0 == strcmp("-l", next_argument)) {
      wais_log_level = atol(next_arg(&argc, &argv));
    }				/* end if (-l) */
    else if (0 == strcmp("-d", next_argument)) {
      index_dir = next_arg(&argc, &argv);
    }
    else if (0 == strcmp("-v", next_argument)) {
      fprintf(stderr,"%s: %s, %s\n", command_name, VERSION_STRING, SERVER_DATE);
    }
    else if (0 == strcmp("-u", next_argument)) {
      uid_name = next_arg(&argc, &argv);
      if((uid = finduid(uid_name)) < 0)
	panic("Couldn't find user %s.", uid_name);
    }
    else if(0 == strcmp("-cmmem", next_argument)){
      if(NULL == (next_argument = next_arg(&argc, &argv)))
	panic("Expected a number (1-100) for percentage of memory to use");
      cm_mem_percent = atol(next_argument);
      if(cm_mem_percent < 1)
	panic("The -cmmem argument should not be less than 1 and less than 100");
      if(cm_mem_percent > 100)
	panic("Warning: The -cmmem parameter was %ld%%. It should be between 1-100.", cm_mem_percent);
    }
#ifdef CACHE_SYN
    else if (0 == strcmp("-cachesyn", next_argument)) {
      cachesyn = 1;
    }
#endif
    else if (0 == strcmp("-detach", next_argument)) {
      detach_flag = 1;
    }
    else{
      panic("Don't recognize the %s option", next_argument);
    }
    next_argument = next_arg(&argc, &argv);
  }				/* end while (more arguments) */

  if (use_stdio && wais_log_file_name == NULL) 
    wais_log_file_name = "/dev/null";

  if (detach_flag)
    detach();

  if (wais_log_file_name == NULL) 
    waislogfile = stderr;
  else waislogfile = NULL;

  index_dir = index_dir ? index_dir : ".";  
  info_dict = s_strdup(merge_pathnames(info_dict,index_dir));

  if(0 != init_search_engine(index_dir, false, true, cm_mem_percent,0,0))
    panic("unable to initialize search engine");
  
  /* remember timestamp on INFO.dct if rebuilding needed 
   * If it doesnt exist, it's assumed to be *very* old, to force
   * re-indexing
   */
  info_change_time = (stat(info_dict,&statbuf) == -1) ? 0 : statbuf.st_mtime;
  
  /* compare with candidates */

  if (scandir(index_dir, &list, srcfiles, alphasort) < 0) {
      waislog(WLOG_HIGH, WLOG_ERROR, 
	      "Error: reading directory %s, %s", 
	      index_dir, Strerror(errno));
      indexing_needed = FALSE;
  }
  
  /* ok. we know if we need indexing, 
   * and have all the filenames. 
   */
  
  if (info_change_time == 0) indexing_needed = TRUE;
  if (indexing_needed) {
#ifndef DO_NOT_TELL_ABOUT_ME
    extern int sayiamhere ();
    sayiamhere();
#endif

    /* Time to re-index,
     * aquire the lock 
     */
    waislog(WLOG_MEDIUM, WLOG_INDEX,
	    "re-indexing needed, info_change_time=%d",info_change_time); 

    if (open(LOCKFILE, O_WRONLY|O_CREAT|O_EXCL,0666) == -1) {
	  
      /* already locked by somebody else
       * spin  till she finishes
       */
      while (!(stat(LOCKFILE,&statbuf) == -1)) {
	sleep(NAPTIME);
	naptime += NAPTIME;
	waislog(WLOG_MEDIUM, WLOG_INFO,
		"INFO locked, waiting since %d seconds", naptime);
	if (naptime  > MAXNAPTIME)  {

	  waislog(WLOG_HIGH, WLOG_WARNING,
		  "Warning - lockfile %s won't go away after %d seconds, not reindexing.", 
		  LOCKFILE, naptime);
	  break;
	}
      }
      /* if lockfile went away, assume INFO.* build finished
       * so just use it
       */
    } else {			/* we aquired the lock, so rebuild database  */
	  
#ifdef INDEX_FORK
      if (!(child = fork())) {
#endif
	database *db;
	Direntry_t **s = list;
	char filename[MAX_FILENAME_LEN], *dbname;

	waislog(WLOG_MEDIUM, WLOG_INDEX,
		"Creating INFO database, pid=%d",getpid());
	dbname = s_strdup(merge_pathnames("INFO",	index_dir));
#ifdef FIELDS /* tung, 3/94 */
	db = openDatabase(dbname, true, false, false); 
#else
        db = openDatabase(dbname, true, false);
#endif
	s_free(dbname);

	init_add_word(db, 0, 100000L);

	while (*s) {		/* index it */
	  strncpy(filename, index_dir, MAX_FILENAME_LEN);
	  if(index_dir[strlen(index_dir) -1] != '/')
	    strncat(filename, "/", MAX_FILENAME_LEN);
	  strncat(filename, (*s)->d_name, MAX_FILENAME_LEN);
	  waislog(WLOG_MEDIUM, WLOG_INDEX,
		  "Indexing %s", filename);
	  index_text_file(filename, &dataops, db, true, false,
			  false, true
#ifdef FIELDS /* tung, 5/94 */ 
			  ,-1
#endif
			  );    
	  s++;
	}
	freedir(list);		/* array of filenames */
	      
	if(!probe_file(source_filename(filename, db)))
	  write_src_structure(source_filename(filename, db),
			      "INFO", "WSRC", NULL, 0L, true, 
#ifdef FIELDS /* tung, 3/94 */                              
                              tcp_port, db);
#else
                              tcp_port);
#endif
	finished_add_word(db);
	build_catalog(db);
	closeDatabase(db);
	if (unlink(LOCKFILE))
	  panic("Indexer: cant unlink lockfile!\n");
	waislog(WLOG_MEDIUM, WLOG_INDEX,
		"Indexer pid=%d done", getpid());
	      
#ifdef INDEX_FORK
	exit(0);		/* indexing child */
      }
      else if (child == -1) {
	waislog(WLOG_HIGH, WLOG_ERROR,
		"Unable to fork for indexer.");
	exit(1);
      }
      /* wait for child process */
      else while (wait(0) != child) ; /* do nothing */
#endif      
    }
  }


  if (use_stdio == TRUE) {
    if(host_address[0] != 0){
      waislog(WLOG_MEDIUM, WLOG_CONNECT,
	      "Accepted connection from: %s [%s], %s",
	      host_name, host_address, VERSION_STRING);
    }
    else{
      waislog(WLOG_MEDIUM, WLOG_CONNECT,
	      "Couldn't determine peer connection. %s", VERSION_STRING);
    }

    if ( server_security(index_dir,NULL) != true ){
      waislog(WLOG_HIGH, WLOG_INFO,"Closing down server");
      exit(-1);
     }

  }
  else{
    waislog(WLOG_MEDIUM, WLOG_INFO, "Running server %s", VERSION_STRING);
  }

  signal(SIGINT, (void (*)())breakKey);

  signal(SIGCHLD, childhandler);  	/* XXX dont really need this any more */
  signal(SIGALRM, alarmhandler);

  signal(SIGSEGV, seghandler);

  signal(SIGBUS, bushandler);

  if(use_stdio == FALSE)
   { 
     if (tcp_port < 1024 && getuid() != 0) {
       waislog(WLOG_HIGH, WLOG_ERROR,
	       "Error opening port %d:  Must be superuser to use a port < 1024",
	       tcp_port);
       exit(-1);
     }

     open_server(tcp_port,&socket,BUFSZ);

#ifdef SECURE_SERVER
     /* if root, setuid to user specified id. */
     if (uid > 0 && getuid() == 0)  {
       waislog(WLOG_MEDIUM, WLOG_INFO,
	       "Setting uid to %s.", uid_name);
        if (wais_log_file_name && *wais_log_file_name &&
 	   chown(wais_log_file_name,uid,getgid()) < 0)
	 waislog(WLOG_HIGH, WLOG_ERROR,
		 "Unable to chown log file to %s!", uid_name);
       if ( 0 > setuid(uid)) {
	 waislog(WLOG_HIGH, WLOG_ERROR,
		 "Unable to setuid to %s!  Exiting.", uid_name);
	 exit(-1);
       }
     }
#endif

#ifdef CACHE_SYN
     if (cachesyn) {
       /* create and attach master shared memory segment containing info
	* on cached synonyms (see synonym.c) */
       int shm_key = 1, shm_cnt = 0;
       char *pcs = NULL;
       t_cacheSyn *cs = NULL;
       cacheSynId = -1;
       while (cacheSynId == (-1)) {
	 cacheSynId = shmget (shm_key, MAX_SYN_CACHE * sizeof(t_cacheSyn), 
			      0644 | IPC_CREAT | IPC_EXCL);
	 if (cacheSynId == (-1) && errno != EEXIST) 
	    break;
	 shm_key++;
       }
       if (cacheSynId <= 0) {
	 cacheSynId = 0;
	 waislog (WLOG_HIGH, WLOG_WARNING, 
		  "Warning: cannot get shared memory area for synonyms, caching disabled");
       }
       else {
	 /* get shared memory for and initialize t_cacheSyn structure */
	 if ((pcs = (char *) shmat (cacheSynId, 0, 0)) == ((char *)-1)) {
	   cacheSynId = 0;
	   waislog (WLOG_HIGH, WLOG_WARNING, 
		    "Warning: cannot attatch shared memory segment for synonyms, caching disabled");
	 }
	 else {
	   for (shm_cnt = 0; shm_cnt < MAX_SYN_CACHE; 
		shm_cnt++, pcs += sizeof(t_cacheSyn)) {
	     cs = (t_cacheSyn *) pcs;
	     cs->id = 0;
	     (cs->synfile)[0] = '\0';
	   }
	 }
       }
     }
#endif

     while (TRUE) { /* be a server for several connections */
       accept_client_connection(socket,&file);
	  
#ifdef QUERY_FORK
       if ((child_proc = fork()) == 0) {
#endif	      
	      /* grandson handles this connection
	       * double-fork takes care of zombies 
	       */
#ifdef QUERY_FORK
	      if ((child_proc = fork()) == 0) { 
#endif
		wais_pid = getpid();
		log_line = 0;
		serve_client(file, file, index_dir);
		/* but leaves server up */
		close_client_connection(file);
		close_server(socket);
		/* just exits this child */
		waislog(WLOG_MEDIUM, WLOG_CLOSE,
			"Done handling client");
#ifdef QUERY_FORK
		exit(0);
	      } else {
		/* son: orphans the grandchild, so init picks up 
		 * the exit status
		 */
		exit(0);
	      }
          } else {
	      waislog(WLOG_MEDIUM, WLOG_INFO,
		      "Child PID = %d", child_proc);
	      close_client_connection(file);     /* parent shouldn't keep the file */
	  }
#endif
      }
   }
  else if(use_stdio == TRUE)
   { /* connections on stdio don't use child processes yet */
     serve_client(stdin, stdout, index_dir);
     waislog(WLOG_MEDIUM, WLOG_CLOSE,
	     "Done handling client");
      /* close the whole thing */
     if(0 != finished_search_engine())
       panic("unable to close search engine");
     exit(0);
   }
}

/*---------------------------------------------------------------------------*/

