
/* Copyright (c) CNIDR (see ../doc/CNIDR/COPYRIGHT) */

#ifndef __SYNONYM_H
#  define _SYNONYM_H
#include "cdialect.h"
struct s_Synonym {
  char *root;
  char *key;
};

typedef struct s_Synonym t_Synonym;

#define synptr( elem ) syn_Table[*syn_Table_Size-1].elem
#define SYN_FILE_LINE_LENGTH 2048

#ifdef CACHE_SYN
/* use shared memory to keep around synonym tables */
#ifdef HAVE_SYS_IPC_H
#include <sys/ipc.h>
#endif
#ifdef HAVE_SYS_SHM_H
#include <sys/shm.h>
#endif

#define MAX_SYN_CACHE 16

/* key to master shmem area */
extern int cacheSynId;

struct s_cacheSyn {
  int id;
  char synfile [256];
  int table_size;
};
typedef struct s_cacheSyn t_cacheSyn;

#endif /* CACHE_SYN */

/* prototypes */

int syn_compare (const void*,const  void* );
char* lookup_Synonym ( char*, t_Synonym*, int );
void syn_ReadFile ( char*, t_Synonym**, int* );
void syn_Free ( t_Synonym*,int* );
#endif
