/* WIDE AREA INFORMATION SERVER SOFTWARE:
   No guarantees or restrictions.  See the readme file for the full standard
   disclaimer.

   5.29.90	Harry Morris, morris@think.com
*/

/* Copyright (c) CNIDR (see ../doc/CNIDR/COPYRIGHT) */


#ifndef sockets_h
#define sockets_h

#include "cdialect.h"
#include "cutil.h"

#include <sys/socket.h>

#ifdef HAVE_NETDB_H
#include <netdb.h>
#endif

#ifdef HAVE_NETINET_IN_H
#include <netinet/in.h>
#endif

#ifdef HAVE_ARPA_INET_H
#include <arpa/inet.h>
#endif

#ifndef THINK_C
#include <sys/types.h>
#endif /* THINK_C */

/*---------------------------------------------------------------------------*/

#ifdef __cplusplus
/* declare these as C style functions */
extern "C"
	{
#endif /* def __cplusplus */

extern char host_name[255], host_address[255];

void open_server (long port,long* socket,long size);
void accept_client_connection (long socket,FILE** file);
void close_client_connection (FILE* file);
void close_server (long socket);
FILE *connect_to_server (char* hname,long port);
void close_connection_to_server (FILE* file);
char *mygethostname (char *hostname, long len);

#ifdef __cplusplus
	}
#endif /* def __cplusplus */

/*---------------------------------------------------------------------------*/

#endif




