/* WIDE AREA INFORMATION SERVER SOFTWARE:
   No guarentees or restrictions.  See the readme file for the full standard
   disclaimer.

   5.29.90	Harry Morris, morris@think.com
*/

/* Copyright (c) CNIDR (see ../COPYRIGHT) */


#ifndef C_DIALECT
#define C_DIALECT

/*----------------------------------------------------------------------*/

#include "../config.h"

/* AIX requires this to be the first thing in the file.  */
#ifdef __GNUC__
#define alloca __builtin_alloca
#else /* not __GNUC__ */
#if HAVE_ALLOCA_H
#include <alloca.h>
#else /* not HAVE_ALLOCA_H */
#ifdef _AIX
 #pragma alloca
#else /* not _AIX */
char *alloca ();
#endif /* not _AIX */
#endif /* not HAVE_ALLOCA_H */
#endif /* not __GNUC__ */

#ifndef HAVE_USTUBS_H
#include <stdlib.h>
#endif 

#ifdef NeXT
#include <libc.h>
#endif

#ifdef TIME_WITH_SYS_TIME 
#include <sys/time.h>
#include <time.h>
#else
#ifdef HAVE_SYS_TIME_H
#include <sys/time.h>
#else
#include <time.h>
#endif
#endif

#include <sys/types.h>          /* does this line any harm? (up) */

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

/* What do we need to include for DIR and direct or dirent */
#ifdef HAVE_SYS_DIR_H
#include <sys/dir.h>
#endif
#ifdef HAVE_NDIR_H
#include <ndir.h>
#endif
#ifdef HAVE_SYS_NDIR_H
#include <sys/ndir.h>
#endif
#ifdef HAVE_DIRENT_H
#include <dirent.h>
#endif


#if STDC_HEADERS || HAVE_STRING_H
#include <string.h>
/* An ANSI string.h and pre-ANSI memory.h might conflict.  */
#if !STDC_HEADERS && HAVE_MEMORY_H
#include <memory.h>
#endif /* not STDC_HEADERS and HAVE_MEMORY_H */
#ifdef index
#undef index
#endif
#define index strchr
#ifdef rindex
#undef rindex
#endif
#define rindex strrchr
#ifndef bcmp
#define bcmp(s1, s2, n) memcmp ((s1), (s2), (n))
#endif
#ifndef bzero
#define bzero(s, n) memset ((s), 0, (n)) 
#endif
#else /* not STDC_HEADERS and not HAVE_STRING_H */
#include <strings.h>
/* memory.h and strings.h conflict on some systems.  */
#endif /* not STDC_HEADERS and not HAVE_STRING_H */

#include <ctype.h>    /* local version redefines string functions */          

/*
 * How about the memory copy routines ?
 */
#if HAVE_BCOPY && BCOPY_OVERLAP
/* ok: have bcopy() and it does overlapping copies */
#else  /* HAVE_BCOPY && BCOPY_OVERLAP */
#if HAVE_MEMCPY && MEMCOPY_OVERLAP
/* ok: have memcpy() and it does overlapping copies */
#define bcopy(s, d, n) memcpy ((d), (s), (n))
#else /* HAVE_MEMCPY && MEMCPY_OVERLAP */

/* Neither bcopy() nor memcopy() do overlapping copies */
#define bcopy(d, s, n) mybcopy ((d), (s), (n))
#define NEED_MYBCOPY
#endif /* HAVE_MEMCPY && MEMCPY_OVERLAP */
#endif /* HAVEHAVE_BCOPY && BCOPY_OVERLAP */

#ifdef undef
extern double	atof(/* const char *nptr */);
extern int	atoi(/* const char *nptr */);
extern long int	atol(/* const char *nptr */);
#endif

/* set up the function prototyping convention */


#endif /* ndef C_DIALECT */

/*----------------------------------------------------------------------*/


