/**************************************************************************
Version identification:
@(#)standalone.c	1.2 11/25/92

Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY
		       
 Programmer: J. Buck
 Date of creation: 7/17/92

main() for standalone version of Gantt chart utility, ported from
Gabriel version.
 
**************************************************************************/
#include <stdio.h>

char* xDisplay;
char* getenv();

static int zap;
static char* inputFile;

main (argc, argv)
int argc;
char** argv;
{
	int zap = 0;
	if (argc > 1 && strcmp(argv[1], "-z") == 0) {
		zap++;
		argc--;
		argv++;
	}
	if (argc != 2) {
		fprintf (stderr, "Usage: gantt [-z] filename\n");
		exit (1);
	}
	inputFile = argv[1];
	xDisplay = getenv("DISPLAY");
	if (xDisplay == 0) {
		fprintf (stderr, "DISPLAY not set\n");
		exit (1);
	}
	display_schedule(xDisplay, 0, inputFile, "/tmp/gantt.out");
	if (zap) unlink(inputFile);
	return 0;
}

void
GanttErr(msg)
char *msg;
{
	fprintf(stderr, "Gantt error: %s\n");
	if (zap) unlink(inputFile);
	exit (1);
}

void err(msg) { GanttErr(msg);}

int
GanttMan(name)			/* ARGSUSED */
char *name;
{
	fprintf(stderr,"Gantt chart help not yet implemented\nFor more information, see the file ~ptolemy/lib/gantt.help");
    return 0;
}

int CreateFrames() {return 0;}
int Frame() {return 0;}
int ClearFrames() { return 0;}
int DestroyFrames() { return 0;}

