/**************************************************************************
Version identification:
@(#)read_sched.c	2.4	1/22/93

Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY

 Programmer:  S. Bhattacharyya

 This file was originally part of the Gabriel system.

**************************************************************************/
#ifndef lint
static char sccsid[] = "@(#)read_sched.c	2.4	1/22/93";
#endif /* not lint */

#include <stdio.h>
#include <strings.h>
#include "displaysched.h"
#include "highlight.h"

FILE *inp=NULL;

extern int max_end_time;
extern char *calloc(), *malloc();
extern struct processor *proc_table;
extern int no_procs;
extern struct starnode *alloc_node();
#ifndef USG
extern char *sprintf();
#endif
extern Colormap cmap;

#define BUFSIZE 1024      /* size in bytes of read buffers */

   /* statistics of the schedule */
int min, runtime;
double percentage, optimum;
char *nops = "nops";   /* name field of nops "star" */
char *mem_msg = "displaysched: out of memory";

/* new declarations for X11 version */
int screen;    /* global : the display screen being used */
int depth;
Display *display;  /* global */

void init_framing();
unsigned long* get_colors();

void read_err(msg)
char *msg;
{
    if (inp!=NULL) (void)fclose(inp);
    err(msg);
}

#define CLOSE_AND_RETURN(v) (void)fclose(inp); return(v)

/*
 * The following macro
 * does all the work, including pointer manipulation, to
 * insert a new star into the processor list data structure.
 *
 */
#define INSERT_STARNODE(name, inst, start, stop) \
      new_star = alloc_node(name,inst,start,stop);  \
      new_star->next = star_list_head; \
      star_list_head = new_star; \
      no_nodes++

/* name is string to look for
   type is a format string to read one value, e.g. "%d"
   var is a variable to read into
   msg is an error message.
 */

#define read_stat(name,type,var,msg) \
if (fscanf(inp,"%s",buff)!=1) read_err(msg); \
if (strcmp(buff,name)!=0) read_err(msg); \
if (fscanf(inp,type,&var)!=1) read_err(msg)



/*
 * read_sched
 *
 *
 * This function reads a schedule from file "infile"  and fills the
 * processor list data structure.
 *
 * Also, if "display_name" is nonnull, the specified display is opened.
 *
 * See file "doc.input_format" for the specification of the input format
 * accepted by this routine. This is the format that the gabriel
 * scheduler must generate output in when it prints to "sched.dis".
 *
 * RETURN VALUE :
 *   (a) if a fatal error is detected, an error message is printed,
 *       and the program exits.
 *   (b) if the display was successfully opened,  1 is returned
 *   (c) if the display is not open at the time of return, the return value
 *       is 0.
 *
 */

int read_sched(infile, display_name)
     char *infile;
     char *display_name;
{
    register struct starnode *star_list_head;
    register int proc_no;
    register unsigned no_nodes;
    register int time;
    register struct starnode *new_star;
    register struct starnode *star, *tmp;
    register int i;
    int start, stop;
    char junk1, junk2, junk3;
    char buff[BUFSIZE];
    char *name, *inst;
    char instance[BUFSIZE];
    char msgbuf[BUFSIZE];

    /* open the input file */

    if ((inp=fopen(infile,"r"))==NULL)
	read_err("displaysched: could not open input file");

    /* read number of processors */

    read_stat("no_processors","%d",no_procs,
	      "displaysched: couldn't read number of processors");
#if DEBUG
    printf("Number of processors read by read_sched = %d\n", no_procs);
#endif
    if (no_procs<=0) read_err("displaysched: Invalid processor count");

    /* read the maximum end time (period of the schedule) */

    read_stat("period","%d",max_end_time,
	      "displaysched: couldn't read schedule period");
    if (max_end_time <= 0) read_err("displaysched: Bad schedule period\n");

    /* allocate processor table */

    if ((proc_table = (struct processor*)
	 (calloc((unsigned)no_procs, sizeof(struct processor))))==NULL)
	read_err(mem_msg);

    /* read in the schedule for each processor -- */

    for (proc_no=0; proc_no<no_procs; proc_no++) {

	proc_table[proc_no].star_table = NULL;
	proc_table[proc_no].color = NULL;

	/* initialize head node of the star list we are about to create */

	star_list_head = NULL;

	time = max_end_time;
	no_nodes = 0;

	/* read the list of stars for this processor's schedule */

	while(1) {

	    /* read the name of the star and the instance specifier */

	    if (fscanf(inp,"%s %s",buff,instance)!=2)
		read_err("displaysched: could not read star name");
#if DEBUG
	    fprintf(stderr, "read_sched: read star name %s, instance %s\n",
		    buff, instance);
#endif /* DEBUG */

	    if (strcmp(buff,"$end")==0) break;

	    /* buff must be the name of a star */

	    /* read (start stop) */
	    if (fscanf(inp, "%c %c %d %d %c", &junk1, &junk2, &start, &stop,
		       &junk3 )!=5) {
		sprintf(msgbuf,"displaysched: could not read data for [%s]", buff);
		read_err(msgbuf);
	    }
	    /* check the validity of this star */
	    /* permits zero runtime stars      */
	    if (!( (stop>=start) && (stop<=time) && (start>=0) )) {
		sprintf(msgbuf,"displaysched: invalid star : %s", buff);
		read_err(msgbuf);
	    }
	    /* if there's a gap between the last star and this one, insert "nops" */

	    if (stop < time) {
		INSERT_STARNODE(nops,(char*)NULL,stop,time);
	    }


	    /* add the new star */
	    if ((name=STRING_COPY(buff))==NULL) read_err(mem_msg);
	    if ((inst=STRING_COPY(instance))==NULL) read_err(mem_msg);
	    INSERT_STARNODE(name,inst,start,stop);

	    time = start;     /* update current time */
	} /*while*/

	/* insert nops from time zero, to the start time
	   of the first scheduled star */

	if (time > 0) {
	    INSERT_STARNODE(nops,(char*)NULL,0,time);
	}

	/* now, transfer the schedule to a table of stars.
	   allocate an extra node at the end of the table to
	   hold a NULL star (to indicate end of table). NULL
	   star is marked with -1 in the start field. */

	if ((proc_table[proc_no].star_table=
	     (struct star *)(calloc((unsigned)(no_nodes+1),
				    sizeof(struct star)))) == NULL)
	    read_err(mem_msg);
	proc_table[proc_no].star_table[no_nodes].start = -1;

	for (star = star_list_head, i=0; star!=NULL; star=star->next, i++)
	    proc_table[proc_no].star_table[i] = star->data;

	/* free the list of star nodes */
	for (star = star_list_head; star!=NULL; (void)free((char*)tmp)) {
	    tmp = star;
	    star = star->next;
	}

	/* set the length of this processor's schedule */

	proc_table[proc_no].length = (int)no_nodes;

    } /* for */



    /* read in the summary statistics of the schedule */

    read_stat("min","%d",min,"displaysched: could not read MIN");
    read_stat("percentage","%lf",percentage,
	      "displaysched: could not read PERCENTAGE");
    read_stat("optimum","%lf",optimum,
	      "displaysched: could not read OPTIMUM");
    read_stat("runtime","%d",runtime,
	      "displaysched: could not read RUNTIME");

    /* try to open the display */



    /*
     * Attempt to open display "display_name".
     */

    if (strcmp(display_name,"")==0) { CLOSE_AND_RETURN(0); }
    else {
	if ((display=XOpenDisplay(display_name))==NULL) {
	    (void)fprintf(stdout,"displaysched : Could not open display '%s',\n",
			  display_name);
	    (void)fprintf(stdout,"so only textual output will be given.\n");
	    CLOSE_AND_RETURN(0);
	}
	else {
	    /* allocate colors and initialize framing of stars */
	    screen = XDefaultScreen(display);
	    depth = DisplayPlanes(display, screen);
	    if (depth > 1) cmap = DefaultColormap(display, screen);
#if DEBUG
	    printf("Calling init framing, no_procs = %d\n", no_procs);
#endif
	    init_framing(get_colors(no_procs), no_procs);
	    CLOSE_AND_RETURN(1);     /* display was successfully opened */
	}
    }
}  /* read_sched */
