/**************************************************************************
Version identification:
@(#)highlight.c	2.4	11/25/92

Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY

 Programmer:  S. Bhattacharyya

 This file was originally part of the Gabriel system.

**************************************************************************/
#ifndef lint
static char sccsid[] = "@(#)highlight.c	2.4 11/25/92";
#endif /* not lint */

#include "displaysched.h"
#include "ganttIfc.h"
#include <stdio.h>
#include <strings.h>

extern int PIGI_GABRIEL_RPC;
extern Window w;     /* display window */
extern int top_proc;
extern int no_procs_dis;
extern int max_end_time;
extern int start;
extern int pix_per_time_unit;
extern struct processor *proc_table;
extern Display *display;
extern char *calloc();
Pixmap w_pixmap;
GC pixmap_gc;
int simplebar;

GC w_gc_bar;
RgbValue *processor_rgb_values;


/* minimum number of pixels between the bar and either
   (right or left) edge of the display */
#define BAR_PAD 2

/* minimum x coordinate of the bar */
#define MIN_BAR_X  (X_MARGIN+BAR_PAD)



/* array of strings to pass to Frame */
char **stars=NULL;

/* Array of strings which were previously highlighted/listed;
   these are compared with the stars currently touched by
   the bar. Highlighting/listing is performed iff the current
   set differs from the previous set */

char **previous_stars=NULL;
char **instances=NULL;

int bar_x=MIN_BAR_X;     /* x position of bar */
int max_bar_x;           /* max x coord of bar */
int max_bar_y;           /* max y coord of bar */
int frames_available=0;

/*
 * init_framing
 *
 * Initialization routine for highlighting stars.
 *
 * Note: Argument "ctable" is used only when PIGI is present.
 * This function assumes that the display has been opened.
 *
 */

/*ARGSUSED*/
void init_framing(ctable, no_procs)
     unsigned long ctable[];
     int no_procs;
{

    register int i;
    extern int depth;

#if DEBUG
    printf("Calling init_framing with no_procs = %d\n", no_procs);
#endif

    if (PIGI_GABRIEL_RPC) {

	frames_available = 0;
	if ((depth>1) && (ctable!=NULL)) {
	    if (!CreateFrames(processor_rgb_values, no_procs))
		(void)fprintf(stderr,"displaysched: Could not create frames\n");
	    else frames_available = 1;
	}
	else {
	    if (depth<=1) {
		(void)printf("The graphics interface is available, but on this display,\n");
		(void)printf("color is not available, so no highlighting will be done.\n");
	    }
	}
    }

    instances = (char **)(calloc((unsigned)no_procs, sizeof(char*)));
    if (instances==NULL)
	err("displaysched: ran out of memory");
    stars = (char **)(calloc((unsigned)no_procs, sizeof(char*)));
    previous_stars = (char **)(calloc((unsigned)no_procs, sizeof(char*)));

    if ((stars==NULL)||(previous_stars==NULL))
	err("displaysched: ran out of memory");
    for (i=0; i<no_procs; i++) previous_stars[i] = NULL;
}

/*
 *
 * erase_bar
 *
 * Erase the vertical bar.
 *
 */

void erase_bar()
{
    if (simplebar)
	XDrawLine(display, w, w_gc_bar, bar_x, AXIS_HT, bar_x,  max_bar_y);
    else {
	XCopyArea(display, w_pixmap, w, pixmap_gc,
		  0, 0, 1, max_bar_y-AXIS_HT, bar_x,
		  AXIS_HT);
    }
}

/*
 *
 * move_mouse_to_bar
 *
 * move the mouse so its x coordinate equals
 * that of the bar and its y coordinate is
 * argument "y".
 *
 */

void move_mouse_to_bar(mouse_y)
     int mouse_y;
{
    XWarpPointer(display, None, w, 0, 0, 0, 0, bar_x, mouse_y);
}

/*
 * move_bar_to_mouse
 *
 * Move the mouse so its x coordinate equals that of
 * the mouse. The x coordinate of the mouse is passed
 * as an argument.
 *
 */

void move_bar_to_mouse(mouse_x)
int mouse_x;
{
    void set_bar(), erase_bar(), draw_bar();

    erase_bar();
    set_bar(mouse_x);
    draw_bar();
}

/*
 *
 * set_bar_limits
 *
 * set maximum x and y coordinates for the bar
 *
 */

void set_bar_limits(x,y)
     int x, y;
{
    max_bar_x = x-BAR_PAD;
    max_bar_y = y;
}

/*
 *
 * set_bar
 *
 * move the bar to position x
 *
 */

void set_bar(x)
     int x;
{
    ASSIGN(bar_x, x, MIN_BAR_X, max_bar_x);
}

/*
 *
 * bar_position
 *
 * return the x coordinate of the bar
 *
 */

int bar_position()
{
    return(bar_x);
}

/*
 * draw_bar
 *
 * This function draws the bar at its current position,
 * which is specified by the variable bar_x.
 * If the graphics interface is being used, the stars
 * which the bar passes through are highlighted ;
 * otherwise, those stars are listed in the standard output.
 * It is undesirable to keep listing/highlighting stars
 * when the bar moves a small distance through a region
 * where the set of stars it touches doesn't change. The
 * set of listed/highlighted stars is updated only
 * at star boundaries -- when the set of stars touched by
 * the bar changes.
 *
 */

void draw_bar()
{

    register int low, high;
    register int i;
    register int len;
    register double time;
    register int pno;
    register struct star *s_tab;
    register int bottom_proc = top_proc + no_procs_dis - 1;
    register int unchanged=1; char **tmp;

    /* Calculate the time corresponding to this position */

    ASSIGN(time,
           (double)start + (double)(bar_x-X_MARGIN) / (double)pix_per_time_unit,
           (double)0,
           (double)max_end_time);

    /* initialize the stars array to pass to FRAME */

    for (pno=0; pno<no_procs_dis; pno++) stars[pno]=NULL;

    /* Fill the stars array with the stars to be highlighted.
       Binary search is used on each processor's star table to
       find which stars the bar is touching. */

    for (pno=top_proc; pno<=bottom_proc; pno++) {

	low = 0;
	high = len = proc_table[pno].length;
	s_tab = proc_table[pno].star_table;

	i=(low+high)>>1;
	while (1) {
	    if ((double)(s_tab[i].start) > time) high = i;
	    else if ((double)(s_tab[i].stop) < time) low = i;
	    else break;
	    i=(low+high)>>1;
	}

	/* skip over zero runtime stars */

	while ((i<len)&&(s_tab[i].stop == s_tab[i].start)) i++;

	if (PIGI_GABRIEL_RPC) {

	    if (frames_available) {
		if (s_tab[i].instance == NULL)
			stars[pno] = NULL;
		else {
			char* tempN = s_tab[i].name;
			if (strcmp(tempN, "snd") && strcmp(tempN, "rcv"))
				stars[pno] = tempN;
			else
				stars[pno] = NULL;
		}
	    } else  {
		stars[pno] = s_tab[i].name;
		instances[pno] = s_tab[i].instance;
	    }
	}

	else  {

	    stars[pno] = s_tab[i].name;
	    instances[pno] = s_tab[i].instance;
	}

	unchanged &= (stars[pno] == previous_stars[pno]);

    } /* for */


    if (!unchanged) {

	if (PIGI_GABRIEL_RPC) {

	    /* Highlight these stars */

	    if (frames_available) {
		(void) ClearFrames();
		if (!Frame(stars)) {
		    (void)fprintf(stderr,"displaysched: warning : framing of stars failed\n");
		    (void)fflush(stderr);
		}
	    }

	    else {
		/* List these stars */

		(void)fprintf(stdout, "\n\n");
		for (pno=top_proc; pno<=bottom_proc; pno++) {
		    (void)fprintf(stdout,"processor %d :	%s",pno, stars[pno]);
		    if (instances[pno] != NULL)
			(void)fprintf(stdout,"%s", instances[pno]);
		    (void)fprintf(stdout,"\n");
		}
	    }
	}
	else {

	    /* List these stars */

	    (void)fprintf(stdout, "\n\n");
	    for (pno=top_proc; pno<=bottom_proc; pno++) {
		(void)fprintf(stdout,"processor %d :	%s",pno, stars[pno]);
		if (instances[pno] != NULL)
		    (void)fprintf(stdout,"%s", instances[pno]);
		(void)fprintf(stdout,"\n");
	    }
	}

    }  /* if not unchanged */

    tmp = previous_stars;
    previous_stars = stars;
    stars = tmp;

    /* Draw the bar at its new position */

    if (!simplebar) {
	/* save the area over which the bar will be drawn */
	XCopyArea(display, w, w_pixmap, pixmap_gc,
		  bar_x, AXIS_HT, 1, max_bar_y-AXIS_HT, 0, 0);
    }

    XDrawLine(display, w, w_gc_bar, bar_x, AXIS_HT, bar_x,  max_bar_y);

}  /* draw_bar */

/*
 * close frames
 *
 * free all data structures associated with framing of stars.
 *
 */

void close_frames()
{
    if (PIGI_GABRIEL_RPC) {
	if (frames_available) (void)DestroyFrames();
    }

    if (stars!=NULL) (void)free((char*)(stars));
    if (previous_stars!=NULL) (void)free((char*)(previous_stars));
    if (instances!=NULL) (void)free((char*)(instances));
}

