/**************************************************************************
Version identification:
@(#)draw.c	2.4	1/19/93

Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY

 Programmer:  S. Bhattacharyya

 This file was originally part of the Gabriel system.

**************************************************************************/
#ifndef lint
static char sccsid[] = "@(#)draw.c	2.4	1/19/93";
#endif /* not lint */

#include <stdio.h>
#include "displaysched.h"
#include <strings.h>
#include <math.h>
#include "highlight.h"

extern int pix_per_time_unit;
extern Window w;
extern int window_time;
extern int w_width, w_height;
extern int no_procs_dis;
extern int no_procs;
extern int depth, screen;
extern Display *display;

XFontStruct *w_box_fontinfo=NULL;
XFontStruct *w_axis_fontinfo=NULL;

#define UL0 (unsigned long)0
#define NULLXGC (XGCValues*)0

struct processor *proc_table;
int box_ht;          /* current height of boxes in the Gantt chart */
char stat_string[128];    /* summary statistics string */
char *hundred_plus_optimum_string =
    "More parallelism is in the algorithm than the architecture can exploit";
int stat_str_len;
int hundred_plus_optimum_str_len;
char *prompt_string;
int prompt_string_len;

GC current_gc;
GC rectangle_gc;

/* offset from the bottom of the display window for printing the
   statistics */
int stat_string_offset = STAT_STR_SPACING + PROMPT_STR_SPACING ;

/* a boolean to indicate whether we print the 100+ optimum
   message in the display window : */
int hundred_plus_opt=0;

XSegment box_segments[4];


/* constants for determining in which manner a box is
   to be drawn */
#define Closed 0
#define OpenAtLeft 1
#define OpenAtRight 2
#define OpenLeftAndRight 3

int nearest_int(x)
double x;
{
    if (x >= 0) return (int)(x+0.5);
    else return -(int)(-x+0.5);
}

GC  nop_gc;

void initialize_drawing() {

    extern int max_end_time, min;
    extern int bottom_margin;
    extern double percentage, optimum;
    char *itoa();
    extern GC w_gc_axis,
    w_gc_box,
    w_gc_stat;
    extern unsigned long display_bgnd;
    extern unsigned long display_fgnd;
    extern XFontStruct *w_box_fontinfo;


    rectangle_gc= XCreateGC(display, RootWindow(display, screen), UL0, NULLXGC);
    XSetForeground(display, rectangle_gc, display_fgnd);
    XSetBackground(display, rectangle_gc, display_bgnd);
    nop_gc = XCreateGC(display, RootWindow(display, screen), UL0, NULLXGC);
    nop_gc = XCreateGC(display, RootWindow(display, screen), UL0, NULLXGC);
    XSetForeground(display, nop_gc, BlackPixel(display,screen));
    XSetBackground(display, nop_gc, display_bgnd);
    XSetFont(display, nop_gc, w_box_fontinfo->fid);


    /* Construct the string which is to be used for summary statistics. The
       format is as follows :

       period = XX (vs. min. XX).  busy time = XX% (vs. max. XX%). */

    stat_string[0] = '\0';
    sprintf (stat_string, " period = %d (vs. min. %d), busy time = %d%%",
	     max_end_time, min, nearest_int(percentage));

    if (optimum <= 100) {
	char tmps[40];
	sprintf (tmps, "(vs. max. %d%%)", nearest_int(optimum));
	(void)strcat(stat_string, tmps);
    }
    /* if "optimum" is larger than 100% we need to make space for
       the explanatory string that will replace the statistic
       */
    else
    {
	bottom_margin +=  HUNDRED_PLUS_OPT_STR_SPACING;
	stat_string_offset += HUNDRED_PLUS_OPT_STR_SPACING;
	hundred_plus_opt = 1;
    }


    stat_str_len = strlen(stat_string);
    hundred_plus_optimum_str_len = strlen(hundred_plus_optimum_string);

    prompt_string = "Type 'cntrl-D' to exit, and 'h' for help";
    prompt_string_len = strlen(prompt_string);
}

close_draw_fonts()
{
    extern XFontStruct *w_axis_fontinfo;

    if (w_axis_fontinfo!=NULL) XFreeFont(display, w_axis_fontinfo);
    if (w_box_fontinfo!=NULL)  XFreeFont(display, w_box_fontinfo);
    return(1);
}

void update_box_height(new_height)
     int new_height;
{
    box_ht = new_height;
}


void DrawBox(time,mode,star)
/*
 * Draw a box spanning "time" time units and insert the string
 * found in the NAME field of the star pointed to by "star".
 * "mode" indicates whether to not draw the right edge, not draw
 * the left edge, or draw all edges. The flags in the vertices
 * of vlist, as well as everything but the x coordinates of the
 * the bottom left and top right must be set up before entering.
 * If either edge is omitted by "mode", the flags are restored
 * after the draw for drawing closed boxes again.
 *
 *
 * The box is filled with the pixel value in the Color structure
 * pointed to by "color". If "color" is NULL, black & white display
 * is assumed, and the box is not filled.
 * Also, NOP field of "star" is used to determine whether to
 * color the box black, to emphasize a NOPS.
 *
 *
 * SIDE EFFECT : vlist[0].x is incremented by the width of the
 * box, so we'll be ready to draw an adjacent block right away.
 *
 */


int mode,time;
register struct star *star;
{
    int width = time*pix_per_time_unit;
    GC label_gc;
    register XSegment *segments = &(box_segments[0]);
    int direction;
    int ascent;
    int descent;
    XCharStruct overall;
    extern GC w_gc_box;
    extern int box_font_height;

    if (width==0) return;

    /* all vertices except #0 have x,y coordinates
       specified relative to the previous vertex */

    segments[1].x2 = segments[1].x1 + width;
    segments[2].x1 = segments[1].x2;
    segments[2].x2 = segments[2].x1 - width;
    segments[0].x1 = segments[1].x1;
    segments[0].x2 = segments[1].x1;
    segments[3].x1 = segments[1].x2;
    segments[3].x2 = segments[1].x2;

       if ((star->instance) == NULL) {
	   XFillRectangle(display,w,nop_gc,segments[1].x1,
			  segments[1].y1,width,box_ht);
	   label_gc = nop_gc;
       }
       else {
	   XFillRectangle(display,w,current_gc,segments[1].x1,
			  segments[1].y1,width,box_ht);
	   label_gc = w_gc_box;
       }

    switch (mode) {
    case Closed      :
	XDrawSegments(display, w, rectangle_gc, segments, 4);
	break;
    case OpenAtLeft  :
	XDrawSegments(display, w, rectangle_gc, &(segments[1]), 3);
	break;
    case OpenAtRight :
	XDrawSegments(display, w, rectangle_gc, segments, 3);
	break;
    case OpenLeftAndRight :
	XDrawSegments(display, w, rectangle_gc, &(segments[1]), 2);
	break;
    }

    /* if the name fits in the box, print it */
    XQueryTextExtents(display, (XID)(w_box_fontinfo->fid), star->name,
		      star->name_length,
		      &direction, &ascent, &descent, &overall);
    if ( ((4+(overall.width)) <= width) &&
	((4+box_font_height) <= box_ht))
	XDrawImageString(display, w, label_gc, segments[1].x1+2,
			 segments[1].y1+2+(overall.ascent), star->name,
			 star->name_length);

    segments[1].x1 += width;     /* increment top left -> next box */
} /* DrawBox */




void display_stars(proc,start,stop)
/*
 * vlist[0] must be initialized to contain the coords of
 * the top left corner of the first box.
 *
 */
register int start, stop;
register int proc;
{
    register struct star *star;
    extern GC w_gc_box;

    current_gc = w_gc_box;
    if (depth>1)
	XSetForeground(display, current_gc, proc_table[proc].color);
    for (star = proc_table[proc].star_table; !NULLSTAR(star); star++) {
	if (star->start == start) break;
	if (star->stop > start) {
	    if (star->stop > stop)
		DrawBox(stop-start,OpenLeftAndRight,star);
	    else
		DrawBox(star->stop-start,OpenAtLeft,star);
	    star++;
	    break;
	}
    }  /* for */

    while (!NULLSTAR(star)) {
	if (star->start >= stop) break;
	if (star->stop > stop)
	    DrawBox(stop-(star->start),OpenAtRight,star);
	else
	    DrawBox(star->stop-star->start,Closed,star);
	star++;
    }
}  /* display_stars */






void draw_time_axis(start)
/* display the time axis horizontally on uppermost part of window
   from time start. the length of the time axis (in time units)
   is taken from global var. window_time */

int start;
{
    char s[12];
    register int i;
    register int x;
    /* number of time units in between labels on time axis */
    register int time_int;
    /* minimum number of pixels separating labels */
    int min_pix_per_int;
    int direction, ascent, descent;
    XCharStruct overall;
    register int axis_font_height = w_axis_fontinfo->max_bounds.ascent +
	w_axis_fontinfo->max_bounds.descent;
    register int axis_font_ascent = w_axis_fontinfo->max_bounds.ascent;
    register int len;
    extern GC w_gc_axis;



    /* draw a horizontal line for the time axis */
    XDrawLine(display, w, w_gc_axis, 0, 22, w_width, 22);

    /* compute the spacing between labels */
    sprintf (s, "%d", start+window_time);

    XQueryTextExtents(display, (XID)(w_axis_fontinfo->fid), s, strlen(s),
		      &direction, &ascent, &descent, &overall);

    min_pix_per_int = (overall.width) + AXIS_PADDING;
    if (pix_per_time_unit >= min_pix_per_int) time_int = 1;
    else time_int = min_pix_per_int / pix_per_time_unit + 1;

    /* draw the labels */
    for (x=X_MARGIN, i=0; (i<=window_time); i++) {
	if ((i%time_int)==0) {
	    sprintf (s , "%d", start + i);
	    XDrawLine(display, w, w_gc_axis, x, 17, x, 27);
	    XQueryTextExtents(display, (XID)(w_axis_fontinfo->fid), s, (len=strlen(s)),
			      &direction, &ascent, &descent, &overall);
	    XDrawString(display, w, w_gc_axis, x - overall.width/2,
			15-axis_font_height+axis_font_ascent,s,len);
	}
	x+= pix_per_time_unit;
    } /* for */

    XFlush(display);
} /* draw_time_axis */






void draw_gantt_chart(start, top_proc)
/*
  -- display the Gantt chart from time start to (start+window_time)
  -- start with processor "top_proc"
 */
register int start;
int top_proc;
{
    register int max_proc = MIN(top_proc+no_procs_dis, no_procs);
    register int proc_no;
    register int i;
    extern XFontStruct *w_prompt_fontinfo,
    	*w_100plus_fontinfo,
    	*w_stat_fontinfo;
    extern GC w_gc_100plus, w_gc_prompt, w_gc_stat;


    XClearWindow(display, w);
    draw_time_axis(start);
    box_segments[1].y1 = AXIS_HT;
    box_segments[1].y2 = AXIS_HT;
    box_segments[2].y1 = AXIS_HT + box_ht;
    box_segments[2].y2 = AXIS_HT + box_ht;
    box_segments[0].y1 = AXIS_HT + box_ht;
    box_segments[0].y2 = AXIS_HT;
    box_segments[0].y2 = AXIS_HT + box_ht;
    box_segments[0].y1 = AXIS_HT;
    for (proc_no = top_proc; proc_no<max_proc; proc_no++) {
	box_segments[1].x1 = X_MARGIN;
        display_stars(proc_no,start,start+window_time);
        for (i=0; (i<4); i++)  {
	    box_segments[i].y1 += box_ht;
	    box_segments[i].y2 += box_ht;
        }
    }
    set_bar_limits(box_segments[1].x1, box_segments[1].y1);
    set_bar(bar_position());
    XDrawString(display, w, w_gc_stat, 5,
		w_height - stat_string_offset +
		w_stat_fontinfo->max_bounds.ascent,
		stat_string, stat_str_len);
    if (hundred_plus_opt)
        XDrawString(display, w, w_gc_100plus, 5,
                    w_height - PROMPT_STR_SPACING -
		    HUNDRED_PLUS_OPT_STR_SPACING +
		    w_100plus_fontinfo->max_bounds.ascent,
                    hundred_plus_optimum_string,
                    hundred_plus_optimum_str_len);
    XDrawImageString(display, w, w_gc_prompt, 10,
		     w_height - PROMPT_STR_SPACING +
		     w_prompt_fontinfo->max_bounds.ascent,
		     prompt_string, prompt_string_len);
    draw_bar();
} /* draw_gantt_chart */

