/**************************************************************************
Version identification:
@(#)displaysched.h	2.2	11/25/92

Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY
		       
 Programmer:  S. Bhattacharyya

 This file was originally part of the Gabriel system.

 Constants for schedule display. 

**************************************************************************/

/* The following three include files are needed for most X11 
   library functions
 */

#include <X11/Xlib.h>    
#include <X11/Xutil.h>
#include <X11/Xos.h>


/* parameters concerning the boxes which represent stars in the 
   Gantt chart
*/
#define BOX_FONT "6x10"
#define MAX_BOX_HT 70   
#define MIN_BOX_HT 04    


  /* min number of pixels of blank space between labels on time axis */
#define AXIS_PADDING 10

  /* height of the time axis */
#define AXIS_HT 35


#define MIN_PIX 2     /* minimum number of pixels per time unit */
#define X_MARGIN 20   /* spacing on sides of the display window */

/* the following constants define the amount of vertical pixels
   of the Gantt chart window which are to be used for the 
   string to print statistics, the string for the prompt
   ("h" for help, etc.), and the string for indicating a 100+ "optimum"
   resource utilization percentage
*/

#define STAT_STR_SPACING 15
#define PROMPT_STR_SPACING 15
#define HUNDRED_PLUS_OPT_STR_SPACING 15


/* the minimum amount of space between the bottom of the Gantt
   chart and the statistics string 
*/
#define BOTTOM_SPACING 5

#define MIN_CONSOLEW_W 250
#define MIN_CONSOLEW_H 150
#define CONSOLEW_X 000
#define CONSOLEW_Y 000
#define CONSOLEW_W 300
#define CONSOLEW_H 150
#define CONSOLEW_BW 3
#define CONSOLEW_FONT "6x10"
#define CONSOLEW_BGND "yellow"
#define CONSOLEW_FGND "blue"
#define CONSOLEW_BRDR "violet"


#define MIN_DISPW_W 300
#define MIN_DISPW_H 150
#define DISPW_X 300
#define DISPW_Y 300
#define DISPW_W 500
#define DISPW_H 300
#define DISPW_BW 5
#define DISPW_BGND "white"
#define DISPW_BRDR "green"
#define DISPW_FGND "blue"


#define MIN_CNTRLW_W 150
#define MIN_CNTRLW_H 150
#define CNTRLW_X 000
#define CNTRLW_Y 400
#define CNTRLW_W 300
#define CNTRLW_H 200
#define CNTRLW_BW 3
#define CNTRLW_BGND "red"
#define CNTRLW_BRDR "violet"



/* The fonts for printing in the time axis, statistics report,
   prompt string, and the 100+ optimum message. MAKE SURE these
   fonts are compatable with the string spacings above. 
*/

#define AXIS_FONT "9x15"   
#define STAT_FONT "8x13" 
#define PROMPT_FONT "8x13bold"
#define HUNDRED_PLUS_FONT "6x10"


/* parameters for the "marker" in the display control window */
#define MIN_MARKER_HEIGHT 10
#define MIN_MARKER_WIDTH 10
#define MARKER_BGND "green"


   /*
    * how close the mouse has to be to the vertical bar to
    * be able to move it when the middle button is pressed:
    *
    */
#define BAR_SENSE 15  
 



/* structure definitions */ 

struct star {
       char *name;     /* label for star */
       int name_length;
       int start, stop;  /* start & stop time for the star */
       char *instance;  /* instance number string */
};

struct starnode {      /* store info about a star (or "nop")) */
       struct star data; 
       struct starnode *next;
};

struct processor {    /* structure for a single processor */
       unsigned long color;    /* color in which it's stars are filled */
       struct star *star_table;    /* list of stars */
       int length;       /* length of the star table */
};



/*
 * the following macro is used for drawing the outline,
 * which helps the user modifiy the marker window inside
 * the display control window.
 *
 */

#define DrawGrid(x1,y1,x2,y2) \
XDrawLine(display, cntrlW, gc_grid, x1, y1, x2, y1); \
XDrawLine(display, cntrlW, gc_grid, x1, y2, x2, y2); \
XDrawLine(display, cntrlW, gc_grid, x1, y1, x1, y2); \
XDrawLine(display, cntrlW, gc_grid, x2, y1, x2, y2)



/* event mask relating to display control events */
#define CONTROL_EVENTS (ExposureMask|LeaveWindowMask| \
                        StructureNotifyMask)


/* event mask relating to Gantt chart display events */
#define DISPLAY_EVENTS \
(ExposureMask| ButtonReleaseMask | ButtonPressMask | KeyPressMask | \
 Button2MotionMask | LeaveWindowMask | StructureNotifyMask)

#define MARKER_EVENTS \
(ExposureMask | ButtonPressMask | ButtonReleaseMask | \
 Button1MotionMask | Button3MotionMask | Button2MotionMask)

#define ALL_EVENTS \
(ExposureMask | ButtonReleaseMask | KeyPressMask | \
 StructureNotifyMask |\
 PointerMotionMask | LeaveWindowMask | ButtonPressMask )


/* in ASSIGN, the value of the second argument is assigned
   to the first, provided that it falls between the lo and hi
   bounds, otherwise the value of the violated bound is 
   assigned to the first argument.
*/
#define ASSIGN(x,y,lo,hi) \
        x = (y<lo) ? lo : y; \
        x = (x>hi) ? hi : x 

#define MIN(x, y)	((x) <= (y) ? (x) : (y))
#define MAX(x, y)	((x) >= (y) ? (x) : (y))


/* allocate space for and copy s into a new string */
#define STRING_COPY(s) (strcpy(malloc((unsigned) (strlen(s)+1)), (s)))


/* a boolean function to test for the end of a list */
#define NULLSTAR(star) (star->start == -1)


/* the name of the Gabriel man page that gets printed when there's
   a help request : */
#define MAN_PAGE_NAME "parallel_sched"

#define DEBUG 0

/* The following variable determines whether or not a window
   pops up on startup prompting the user to create
   the gantt chart windows. */
#define CONSOLE 0

/* The following determines what mode will be used
   for draw the vertical "current_time" bar. 
   If it is 0, then the bar will be implemented
   with the GXxor GC function, otherwise a pixmap
   will be used to store the stuff under the bar,
   and the bar will be drawn with GXcopy.a

   Note -- if the display is monochrome, the
   SIMPLEBAR flag is ignored, and bars are drawn
   in the XOR mode.
 */
#define SIMPLEBAR 0

/*
 * name conflict for "err()", so do it this way
 */
extern void gantt_chart_error();
#define err(msg) gantt_chart_error(msg)
