/**************************************************************************
Version identification: @(#)streamCompat.h	1.3 11/25/92

Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY
//
// Programmer:  J. T. Buck
// Date of creation: 3/12/92
//
// This file is designed to allow for use of streams to access files
// and string buffers with either the old libg++, the new one, or
// the "cfront" version.
//
// Include this file when creating new streams that access files or
// buffers.  It attempts to make the old stream library in libg++1.39
// look like iostreams, and sets IOSTREAMS when the difference must
// be known.
//
// Don't include this file if the module merely accesses previously
// existing streams (cin,cout,cerr,or arguments).
*************************************************************************/

#ifndef _streamCompat_h
#define _streamCompat_h 1
#include <stream.h>

// note that the distinction is NOT whether __GNUG__ is 2, but which
// version of libg++ is used.

#if defined(__GNUG__) && !defined(_COMPAT_STREAM_H)
#define ifstream istream
#define ofstream ostream
// we do not include fcntl.h because of conflicts on Suns between old libg++
// and that file.
#define O_RDONLY 0
#define O_WRONLY 1
#define O_RDWR 2
// skip whitespace in an istream.
inline istream& ws(istream& arg) { eatwhite(arg); return arg;}
#else
// new streams (iostreams)
#include <fcntl.h>
#include <fstream.h>
#include <strstream.h>
#define IOSTREAMS 1
#endif

#endif
