static const char file_id[] = "XXXDomain.cc";
/**********************************************************************
Version identification:
@(#)XDomain.ccP	1.9	10/14/92 (XXXDomain.cc)

 Copyright (c) 1990 The Regents of the University of California.
                       All Rights Reserved.

 Programmer:  J. T. Buck
 Date of creation: 7/2/90

 WARNING -- XDomain.ccP is a template file that is used to generate
 domain description modules.  If the name of this file is not XDomain.ccP,
 DO NOT EDIT IT!!!

 A device to produce the correct portholes, wormholes, event horizons,
 etc, for the XXX domain so the interpreter can generate them dynamically.

***********************************************************************/

#include "Domain.h"
#include "Target.h"
#include "KnownTarget.h"
#include "XXXScheduler.h"
#include "XXXWormhole.h"
#include "XXXGeodesic.h"

extern const char XXXdomainName[] = "XXX";

class XXXDomain : public Domain {
public:
	// new wormhole
	Star& newWorm(Galaxy& innerGal,Target* innerTarget)  {
		LOG_NEW; return *new XXXWormhole(innerGal,innerTarget);
	}

	// new fromUniversal EventHorizon
	EventHorizon& newFrom() { LOG_NEW; return *new XXXfromUniversal;}

	// new toUniversal EventHorizon
	EventHorizon& newTo() { LOG_NEW; return *new XXXtoUniversal;}

	// new node (geodesic)
	Geodesic& newNode() { LOG_NEW; return *new XXXGeodesic;}

	// constructor
	XXXDomain() : Domain("XXX") {}
};

// declare a prototype
static XXXDomain proto;

// declare the default Target object

class XXXTarget : public Target {
public:
	XXXTarget() : Target("default-XXX","XXXStar","default XXX target"){}
	void setup()
	{
		if (!scheduler()) { LOG_NEW; setSched(new XXXScheduler); }
		scheduler()->setGalaxy(*galaxy());
		Target::setup();
	}
	Block* makeNew() const { LOG_NEW; return new XXXTarget;}
	~XXXTarget() { delSched();}
};

static XXXTarget defaultXXXtarget;
static KnownTarget entry(defaultXXXtarget,"default-XXX");
