static const char file_id[] = "Thorxx73.cc";

////////////////////////////////////////////////////////////////////////
// @(#)Thorxx73.cc	1.3 11/26/92
// Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
// All rights reserved.
// See the file ~ptolemy/copyright for copyright notice,
// limitation of liability, and disclaimer of warranty provisions.
//
////////////////////////////////////////////////////////////////////////

////

//  Conversion done 1992/11/06, 11:53:59 by pepp version 2.6.
//  Input is coming from file "Thorxx73.chdl".

#include "ThorStar.h"
#include "ThorState.h"
#include "libarp.h"
#include "KnownBlock.h"
/*
#include "ThorPrintOverl.h"
#include "ThorErrHandler.h"

static ThorErrHandler* StatErrHandler = 0;

#ifdef EXITMOD
#undef EXITMOD
#endif
#define EXITMOD(x) StatErrHandler->status = x; return;
#define exit(x) StatErrHandler->status = x; StatErrHandler->flush(); return;
*/

/*	xx73()
 *	J-K positive-edge-triggered Flip-flop w/ preset & clear
 *
 *	4 inputs	2 outputs	2 internal states
 *
 *								EJF 1/27/83
 */

const char *star_nm_Thorxx73 = "Thorxx73";

class Thorxx73 : public ThorStar
{
private:

//	    Inport list: (between lines 12 and 17)
    InThorPort		Clk;
    InThorPort		K;
    InThorPort		J;
    InThorPort		Clr_b;

//	    Outport list: (between lines 19 and 22)
    OutThorPort		Q_b;
    OutThorPort		Q;

//	    State list: (between lines 24 and 27)
    int			SavQ;
    ThorState		_SavQ_;
    int			LastClk;
    ThorState		_LastClk_;

public:
    int			isItModel() { return TRUE; }
    Thorxx73();		// Constructor
    void		go();
    void		setup();
    Block*		makeNew() const { LOG_NEW; return new Thorxx73; }
int flag;
};

Thorxx73 :: Thorxx73 ()	// Constructor
{
    setDescriptor("\n"
"** This star's code has been changed after pepp. **\n""\n"

"/*	xx73()\n"
" *	J-K positive-edge-triggered Flip-flop w/ preset & clear\n"
" *\n"
" *	4 inputs	2 outputs	2 internal states\n"
" *\n"
" *								EJF 1/27/83\n"
" */\n");

//	Ports:

    addPort(Clk.setPort("Clk",this));
    addPort(K.setPort("K",this));
    addPort(J.setPort("J",this));
    addPort(Clr_b.setPort("Clr_b",this));

    addPort(Q_b.setPort("Q_b",this));
    addPort(Q.setPort("Q",this));

//	States:

    addState(_SavQ_.setThorState("SavQ",this,"0",&SavQ));
    addState(_LastClk_.setThorState("LastClk",this,"0",&LastClk));
}

void Thorxx73 :: setup()
{
//    ThorErrHandler errHandler(this,ThorPrint::getErrMsgBuf(),&StatErrHandler);
//    StatErrHandler = &errHandler;

// line 30 "Thorxx73.chdl"
        SavQ = ONE;
        flag=0;
}

static Thorxx73 proto;
static KnownBlock entry(proto,"xx73");

void Thorxx73 :: go()
{
#define index  strchr
#define new   _new_

//   ThorErrHandler errHandler(this,ThorPrint::getErrMsgBuf(),&StatErrHandler);
//    StatErrHandler = &errHandler;

// line 10 "Thorxx73.chdl"

// line 18 "Thorxx73.chdl"

// line 23 "Thorxx73.chdl"

// line 28 "Thorxx73.chdl"

// line 33 "Thorxx73.chdl"

/*	IOStest(4,2,2,xx73); */

	if ( Clr_b >= UNDEF )
	{
		SavQ = Q = Q_b = UNDEF;
	}
	else if ( Clr_b == ZERO )
	{			/* one of them active */
		SavQ = ZERO;	/* clear dominant in state */
		Q_b = ONE;
		Q  = ZERO;
	}
	else	/* Clr_b not active */
	{
		if (Clk >= UNDEF) {
			SavQ = UNDEF;
		} else if ( vrise[LastClk][Clk] == 1 )
		{
        	        if(flag==0)
			{
               			 flag=1;
               			 SavQ=1;
                       	 }
                	else
			{
				switch (J)
				{
				case ZERO:	/* Hold or clear */
					SavQ = vand[ SavQ ][ vinv[K] ];
					break;
				case ONE:	/* toggle or set */
					SavQ = vor[ vinv[SavQ] ][ vinv[K] ];
					break;
				default:
					SavQ = UNDEF;
					break;
				}
			}
		}
		Q_b = vinv[Q = SavQ];
	}

	LastClk = Clk;			/* store last CK input		*/

	EXITMOD(0);
}

