static const char file_id[] = "ThorPar2Ser.cc";

////////////////////////////////////////////////////////////////////////
// @(#)ThorPar2Ser.cc	1.3 11/26/92
// Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
// All rights reserved.
// See the file ~ptolemy/copyright for copyright notice,
// limitation of liability, and disclaimer of warranty provisions.
//
////////////////////////////////////////////////////////////////////////

////

//  Conversion done 1992/11/06, 10:36:26 by pepp version 2.6.
//  Input is coming from file "ThorPar2Ser.chdl".

#include "ThorStar.h"
#include "ThorState.h"
#include "IntState.h"
#include "libarp.h"
#include "KnownBlock.h"
/*
#include "ThorPrintOverl.h"
#include "ThorErrHandler.h"

static ThorErrHandler* StatErrHandler = 0;

#ifdef EXITMOD
#undef EXITMOD
#endif
#define EXITMOD(x) StatErrHandler->status = x; return;
#define exit(x) StatErrHandler->status = x; StatErrHandler->flush(); return;
*/

/*	Par2Ser()
Receives parallel bits and outputs "busWidth" bits one at a time at 
"busWidth" consecutive clock cycles.
*/

const char *star_nm_ThorPar2Ser = "ThorPar2Ser";

class ThorPar2Ser : public ThorStar
{
private:

//	    Inport list: (between lines 9 and 12)
    MultiInThorPort	bus;
    InThorPort		clock;

//	    Outport list: (between lines 14 and 16)
    OutThorPort		bit_stream;

//	    State list: (between lines 18 and 22)
    MultiThorState	ev;
    IntState		busWidth;
    IntState		codesDemo;

public:
    int			isItModel() { return TRUE; }
    ThorPar2Ser();		// Constructor
    void		go();
    void		setup();
    Block*		makeNew() const { LOG_NEW; return new ThorPar2Ser; }

const char* mname() {return name();}
const char* instance_name;
int length;
int value[16];

};

ThorPar2Ser :: ThorPar2Ser ()	// Constructor
{
    setDescriptor("\n"
"** This star's code is changed after running pepp **\n""\n"

"/*	Par2Ser()\n"
"Receives parallel bits and outputs \"busWidth\" bits one at a time at \n"
"\"busWidth\" consecutive clock cycles.\n"
"*/\n");

//	Ports:

    addPort(bus.setPort("bus",this));
    addPort(clock.setPort("clock",this));

    addPort(bit_stream.setPort("bit_stream",this));

//	States:

    addState(ev.setThorState("ev",this,32));
    addState(busWidth.setState("busWidth",this,"8","Width of input bus"));
    addState(codesDemo.setState("codesDemo",this,"0","parameter to identify the particular demo to avoid false triggering" ));
}

void ThorPar2Ser :: setup()
{
//    ThorErrHandler errHandler(this,ThorPrint::getErrMsgBuf(),&StatErrHandler);
//    StatErrHandler = &errHandler;

// line 29 "ThorPar2Ser.chdl"
	instance_name = mname();
	length=0;
}

static ThorPar2Ser proto;
static KnownBlock entry(proto,"Par2Ser");

void ThorPar2Ser :: go()
{
#define index  strchr
#define new   _new_

//   ThorErrHandler errHandler(this,ThorPrint::getErrMsgBuf(),&StatErrHandler);
//   StatErrHandler = &errHandler;

// line 32 "ThorPar2Ser.chdl"

// this is to avoid false triggering of this block in codes demos
	if(codesDemo==1)		/* Serial Comm. */
	{
		if(current_time < 2666) EXITMOD(0);
		//if(current_time < 2676) EXITMOD(0);
	}

	if(codesDemo==2)		/* Shared Memory */
	{
                if(current_time < 4000) EXITMOD(0);
                if((strcmp(instance_name,"Par2Ser.bus=82")==0) &&
                        (current_time<5000))    EXITMOD(0);
                if(((current_time-fpack(ev,31,0))<=20) &&
                        (length==int(busWidth))) EXITMOD(0);
                if(((current_time-fpack(ev,31,0))<=20) ||
                        ((current_time-fpack(ev,31,0))>1500)) ;
                else EXITMOD(0);
	}

	if(codesDemo==3)		/* Single DSP models */
	{
		if(current_time < 1550) EXITMOD(0);
		if((strcmp(instance_name,"Par2Ser.bus=82")==0) &&
			(current_time==1551))	 EXITMOD(0);
                if(((current_time-fpack(ev,31,0))<=20) &&
                        (length==int(busWidth))) EXITMOD(0);
		if(((current_time-fpack(ev,31,0))<=20) ||
			((current_time-fpack(ev,31,0))>1500));
		else EXITMOD(0);
	}

//prevent multiple evaluations
 	if (fpack(ev,31,0)==current_time)  EXITMOD(0);
	funpack(ev,31,0,current_time);

	if(length==int(busWidth))  length=0;

	if(length==0)
	{
	//then latch
       		for( int i=0; i< (int(busWidth)); i++)
		{
               		value[i]= bus[i];
               	}
	}

	// output msb first
                bit_stream = value[int(busWidth-1)-length];
                length++;

        EXITMOD(0);
}

